import java.awt.*;
import java.awt.event.*;
import java.awt.image.BufferedImage;
import java.io.*;
import java.util.regex.*;


/**
 * <!-- Comment -->
 * @author 		Eike Decker
 * @version     0-15.02.2005
 * @since       0
 * 
 */

class Map {
	String name;
	char field[][];
	int w,h,maxPlayer;
	
	Map (int w, int h) {
		this.w = w;
		this.h = h;
		this.maxPlayer = 4;
		this.name = "unnamed";
		this.field = new char[h][w];
		clear();
	}
	
	Map (String file) throws Exception {
		file = file.replaceAll("(%.*)","");
		//System.out.println(file.subSequence(0,20));
		Matcher nameMatch = Pattern.compile(".*<name>:\\s*(.+?)$.*",Pattern.DOTALL|Pattern.MULTILINE).matcher(file);
		if (nameMatch.matches()) {
			name = nameMatch.group(1);
			System.out.println(name);
		} else name ="unnamed";
		
		Matcher sizeMatch = Pattern.compile(".*<size>:\\s*(\\d+)x(\\d+).*",Pattern.DOTALL).matcher(file);
		if (sizeMatch.matches()) {
			w = Integer.parseInt(sizeMatch.group(2));
			h = Integer.parseInt(sizeMatch.group(1));
			System.out.println("w = "+w+" h = "+h);
		} else {
			throw new Exception("invalid Size type");
		}
		
		Matcher maxPlayer = Pattern.compile(".*<maxPlayer>:.*(\\d).*",Pattern.DOTALL).matcher(file);
		if (maxPlayer.matches()) {
			this.maxPlayer = Integer.parseInt(maxPlayer.group(1));
			System.out.println("maxplayers: "+this.maxPlayer);
		} else 
			throw new Exception("no maxplayer count");
		
		Matcher playField = Pattern.compile(".*<playField>(.*)<end.*",Pattern.DOTALL|Pattern.MULTILINE).matcher(file);
		if (playField.matches()) {
			String field[] = playField.group(1).split("\\n");
			this.field = new char[h][];
			for (int i= 1; i<field.length;i++)
			{
				this.field[i-1] = field[i].substring(0,w).toCharArray();
			}
		} else {
			throw new Exception("no gamefieldinformation?");
		}
	}
	
	public String toString () {
		int pCount = 0;
		String out = "<name>: "+name+"\r\n";
		out+= "<size>: "+h+"x"+w+"\r\n";
		String f = "";
		
		for (int y = 0; y<h;y++) {
			for (int x = 0; x<w; x++) {
				if (!(field[y][x]>'9'||field[y][x]<'0')) 
					field[y][x] = (char) (pCount++ + '0'); 
			}		
			f+=new String(field[y])+"\r\n";
		}
		out+="<maxPlayer>: "+pCount+"\r\n";
		out+="\r\n<playField>\r\n";
		out+=f;
		out+="<endPlayfield>\r\n";
		return out;
	}

	
	public void clear() {
		for (int y = 0; y<h;y++) for (int x = 0; x<w; x++) 
			field[y][x] = '.';
	}
}

class MapViewer extends Panel {
	Map map;
	BufferedImage bi;
	int mX,mY;
	boolean mouseOver,mouseDrag, symmetryX, symmetryY;
	int tool;
	
	public MapViewer() {
		setLayout(null);
		setSize(500,500);
		
		addMouseMotionListener(new MouseMotionListener() {
			public void mouseDragged(MouseEvent e) {
				mX = (e.getX()-1)/5;
				mY = (e.getY()-1)/5;
				if (mX<0) mX*=-1;
				if (mY<0) mY*=-1;
				if (tool!=2) setPixel(mX,mY);
				repaint();
			}
			public void mouseMoved(MouseEvent e) {
				mX = (e.getX()-1)/5;
				mY = (e.getY()-1)/5;
				if (mX<0) mX*=-1;
				if (mY<0) mY*=-1;
				repaint();
				mouseDrag = true;
			}
		});
		
		addMouseListener(new MouseListener() {

			public void mouseClicked(MouseEvent e) {		
			}

			public void mouseEntered(MouseEvent e) {
				mouseOver = true;
			}

			public void mouseExited(MouseEvent e) {
				mouseOver = false;
			}

			public void mousePressed(MouseEvent e) {
				mX = (e.getX()-1)/5;
				mY = (e.getY()-1)/5;
				if (mX<0) mX*=-1;
				if (mY<0) mY*=-1;
				if (tool <= 1)
					if (map.field[mY][mX] != '.') tool = 1;
					else tool = 0;
				setPixel(mX,mY);
				mouseDrag = true;
				repaint();	
			}

			public void mouseReleased(MouseEvent e) {
				mouseDrag = false;
			}});
	}
	
	public int getWidth () {
		if (map == null) return 500;
		return map.w*5+1;
	}
	
	public int getHeight () {
		if (map == null) return 500;
		return map.h*5+1+20;
	}	
	
	public void setPixel2(int x, int y) {
		if (map == null || x<0 || x>=map.w || y<0 || y>=map.h) return;
		switch  (tool) {
			default: map.field[y][x] = '#'; break;
			case 1: map.field[y][x] = '.'; break;
			case 2: map.field[y][x] = '0'; break;
			case 3: map.field[y][x] = 'A'; break;
		}
	}
	public void setPixel(int x, int y) {
		if (map == null) return;
		setPixel2(x,y);
		//int cx = (map.w-1)/2,cy = (map.h-1)/2;
		if (symmetryX) setPixel2(map.w-x,y);
		if (symmetryY) setPixel2(x,map.h-y);
		if (symmetryY && symmetryX) setPixel2(map.w-x,map.h-y);
		
	}
	public Dimension getPreferredSize() {
		return new Dimension(getWidth(),getHeight());
	}

	public void load(String filename) {
		try {
			FileReader f = new FileReader(filename);

			long len = new File(filename).length();
			if (len>0x2ffff) { System.out.println("file is too large");return;} 
			char file[] = new char [(int)len];			
			for (int i=0;i<len;i++) file[i] = (char) f.read();
			f.close();
			
			map = new Map(new String(file));
			bi = new BufferedImage(getWidth(),getHeight(),BufferedImage.TYPE_INT_RGB);
			repaint();
		} catch (FileNotFoundException e) {
			System.out.println("File was not found");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void newMap (String name, int x, int y) {
		map = new Map(x,y);
		map.name = name;
		bi = new BufferedImage(getWidth(),getHeight(),BufferedImage.TYPE_INT_RGB);
		getParent().invalidate();
		getParent().validate();
		repaint();
	}
	
	public void save(String filename) {
		try {
			FileWriter f = new FileWriter(filename);
			
			f.write(map.toString());
			
			f.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		//System.out.println("save:");
		//System.out.println(map.toString());
	}
	
	public void update (Graphics g) {
		//g.setClip(0,0,getWidth(),getHeight());
		if (bi == null) super.update(g);
		else {
			paint(bi.getGraphics());
			g.drawImage(bi,0,0,this); 
		}
	}
	
	public void paint(Graphics g) {
		if (map == null) return;
		g.setColor(Color.GRAY);
		g.fillRect(0,0,map.w*5+1,map.h*5+1);
		for (int y = 0; y<map.h;y++) for (int x = 0; x<map.w; x++) {
			switch (map.field[y][x]) {
				default : g.setColor(Color.GREEN.darker()); break;
				case '#': g.setColor(Color.BLACK); break;
				case 'A': g.setColor(Color.RED); break;
				case '.': g.setColor(Color.LIGHT_GRAY.brighter()); break;
			}
			g.fillRect(x*5+1,y*5+1,4,4);
		}
		if (mouseOver) {
			g.setColor(new Color(255,128,0));
			g.drawRect(mX*5,0,5,getHeight()-20);
			g.drawRect(0,mY*5,getWidth(),5);
			g.drawRect(mX*5+1,mY*5+1,3,3);
		}
		g.setColor(Color.LIGHT_GRAY);
		g.fillRect(0,getHeight()-20,getWidth(),20);
		g.setColor(Color.BLACK);
		
		String status = "X: "+mX+"("+(mX*100/(map.w-1))+"%)";
		g.drawString(status,10,getHeight()-20+g.getFontMetrics().getHeight());
		
		status = "Y:"+mY+" ("+(mY*100/(map.h-1))+"%)";
		g.drawString(status,80,getHeight()-20+g.getFontMetrics().getHeight());
		
		int x,y;
		status = "to Center X: "+(x=(mX-(map.w-1)/2));
		g.drawString(status,150,getHeight()-20+g.getFontMetrics().getHeight());
		status = "Y: "+(y=(mY-(map.h-1)/2));
		g.drawString(status,240,getHeight()-20+g.getFontMetrics().getHeight());
		status = "Distance: "+(int)Math.sqrt(x*x+y*y);
		g.drawString(status,280,getHeight()-20+g.getFontMetrics().getHeight());
	}

	protected void clear() {
		if (map == null) return;
		map.clear();
		repaint();
	}
}

public class SneadyEditor {
	public static abstract class AnonymItem extends MenuItem implements ActionListener {
		public AnonymItem(String string) {super(string); addActionListener(this);}
	}
	
	public static abstract class AnonymButton extends Button implements ActionListener {
		public AnonymButton(String s) {
			super(s);
			addActionListener(this);
		}
	}
	
	public static void main (String args[]) {
		final Frame frame = new Frame("Sneady Editor");
		final MapViewer map = new MapViewer();
		final MenuBar bar = new MenuBar();
		final Menu file = new Menu("File");
		final Panel p = new Panel();
		final Panel lowerBar = new Panel();
		
		p.setBackground(Color.LIGHT_GRAY);
		lowerBar.setBackground(Color.LIGHT_GRAY);
		
		bar.add(file);
		
		file.add(new AnonymItem("New") {
			public void actionPerformed(ActionEvent e) {
				class NewMap extends Dialog {
					NewMap (Frame owner) {
						super(owner);
						final TextField name,w,h;
						addWindowListener	(new WindowAdapter(){
							public void windowClosing(WindowEvent e){
								dispose();
							}
						});
						this.setTitle("New Map");
						setLayout(new GridLayout(4,1));
						
						Panel p = new Panel();
						p.add(new Label("Name of Level: "));
						p.add(name = new TextField("unnamed",20));
						add(p);
						
						p = new Panel();
						p.add(new Label("Width: "));
						p.add(w = new TextField("75",10));
						add(p);

						p = new Panel();
						p.add(new Label("Height: "));
						p.add(h = new TextField("75",10));
						add(p);
						
						p = new Panel();
						p.add(new AnonymButton("OK") {
							public void actionPerformed(ActionEvent e) {
								map.newMap(name.getText(),Integer.parseInt(w.getText()),Integer.parseInt(h.getText()));
								dispose();
							}
						});
						add(p);
						pack();
					}
				}
				new NewMap(frame).show();
				
			}}
		);
		file.add(new MenuItem("-"));
		file.add(new AnonymItem("Load") {
			public void actionPerformed(ActionEvent e) {
				FileDialog fi = new FileDialog(frame,"Load Sneady Mapfile",FileDialog.LOAD);
				fi.show();
				if (fi.getFile() == null) return;
				map.load(fi.getDirectory()+fi.getFile());
				p.invalidate();
				frame.validate();
			}}
		);
		file.add(new AnonymItem("Save") {
			public void actionPerformed(ActionEvent e) {
				FileDialog fi = new FileDialog(frame,"Load Sneady Mapfile",FileDialog.SAVE);
				fi.show();
				if (fi.getFile() == null) return;
				map.save(fi.getDirectory()+fi.getFile());
			}}
		);
		file.add(new MenuItem("-"));
		file.add(new AnonymItem("Quit") {
			public void actionPerformed(ActionEvent e) {
				frame.dispose();
				System.exit(0);
			}}
		);
		
		frame.setLayout(new BorderLayout());
		frame.setMenuBar(bar);
		
		p.add(map);
		frame.add(p,BorderLayout.CENTER);
		frame.addWindowListener	(new WindowAdapter(){
			public void windowClosing(WindowEvent e){
				frame.dispose();
				System.exit(0);
			}
		});
		frame.add(lowerBar,BorderLayout.SOUTH);
		

		lowerBar.add(new AnonymButton("Set Player"){
			public void actionPerformed(ActionEvent e) {
				map.tool = 2;
			}});		
		lowerBar.add(new AnonymButton("Set Exit"){
			public void actionPerformed(ActionEvent e) {
				map.tool = 3;
			}});
		lowerBar.add(new AnonymButton("Set Wall / Free"){
			public void actionPerformed(ActionEvent e) {
				map.tool = 0;
			}});
		lowerBar.add(new AnonymButton("Symmetry X on"){
			public void actionPerformed(ActionEvent e) {
				map.symmetryY = !map.symmetryY;
				if (map.symmetryY) setLabel ("Symmetry X off");
				else setLabel ("Symmetry X on");
			}});

		lowerBar.add(new AnonymButton("Symmetry Y on"){
			public void actionPerformed(ActionEvent e) {
				map.symmetryX = !map.symmetryX;
				if (map.symmetryX) setLabel ("Symmetry Y off");
				else setLabel ("Symmetry Y on");
			}});

		lowerBar.add(new AnonymButton("Clear"){
			public void actionPerformed(ActionEvent e) {
				map.clear();
			}});


		frame.show();
		frame.setSize(500,500);
		frame.pack();

	}

}
