/*
 * Created on 22.11.2004
 *
 */
package de.farafin.snEADy.world;

import de.farafin.snEADy.communication.D_GameInfo;
import de.farafin.snEADy.communication.D_Level;
import de.farafin.snEADy.communication.D_PlayerData;

/**
 * @author roland, lars
 * 
 *  
 * @version $Revision: 1.7 $
 */

public interface I_World_interface
{
	//	pDataClone ist Kopie von pData aus M_GameEngine, wird ge?ndert und in
	// M_GameEngine zur?ck aktualisiert auf pData!
	/**
	 * calculate the new playfield with the informations in gameInfo stores the
	 * changed data in gameInfo
	 * 
	 * @param gameInfo 
	 */
	public void update(D_GameInfo gameInfo);
	
	/**
	 * @return a copy of the contained Level
	 */
	public D_Level generateLevel();
	
	/**
	 * @param gameInfo a instance the informations should be filled in
	 */
	public void updateInfos(D_GameInfo gameInfo);
	
	
	/** computes the record of a game cycle (level + player => recordFile)
	 * WARNING there are no control routines if the numbers fit to its range because
	 * we do not expact that this could happen in teh game. If there are later modifications,
	 * we strongly recommand to analyse the new game and maybe change the replay/record functions!!
	 * 
	 * reads a record file: <br> 
	 *  <br>
	 * file scheme: <br> 
	 * for each gameCycle: <br>
	 * what is stored (consumtion) <br>
	 * - Number bytes (2Byte) (number range: 0x0000 to 0xFFFF) <br> 
	 * - Player Nr and status changes (1 Byte) <br>
	 *    = Data: (first 4 bit) (number range: 0x10 to 0xF0) <br>
	 * 		case: 0 - 9 : representation of player number <br>
	 *			+ speed changed?  (5. bit) <br>
	 *			+ length changed? (6. bit) <br>
	 *			+ Points changed? (7. bit) <br>
	 *			+ Status changed? (8. bit) <br>
	 * 		case: A: play field changes
	 * 		case: B: gameTime and SDTime changes
	 * 		case: C - F: not used
	 * - Nnumber of playfield changes (2Byte) (number range: 0x0000 to 0xFFFF) <br>
	 * - relative Playfield changes (3 Byte each) <br>
	 *   y-value (number range: 0x00 to 0xFF)<br>
	 *   x-value (number range: 0x00 to 0xFF)<br>
	 *  relative char changes: excample: 'a' - '.' (number range: -0x80 to +0x7F)<br>
	 * - playerdata (max 7 Byte) <br>
	 * 	  = speed changes (1 Byte) [only if change bit is 1] (number range: -0x80 to +0x7F) <br>
	 * 	  + Length changes (2 Byte) [only if change bit is 1] (number range: -0x8000 to +0x7FFF) <br>
	 *    + points changes (2 Byte) [only if change bit is 1] (number range: -0x8000 to +0x7FFF) <br>
	 *    + Status changes (1 Byte) [only if change bit is 1] (number range: -0x80 to +0x7F)<br>
	 * 	  + head move direction (1 Byte) (number range: 0x00 to 0xFF) <br>
	 * - if player Nr == 11: Exit Time changes (4 Byte) (number range: -0x80000000 to +0x7FFFFFFF) + SDTime changes (4 Byte) (number range: -0x80000000 to +0x7FFFFFFF) = 17 Byte <br>
	 * - Number bytes again (2Byte) (number range: 0x0000 to 0xFFFF)  <br>
	 * 
	 * @param gameInfo
	 */
	public void recordGameCycle(D_GameInfo gameInfo);
	
	/** computes the replay of a game cycle (replayFile => level + player)
	 * @param gameInfo
	 * @param playerData
	 * @return returns true if EOF has reached.
	 * 
	 * @see I_World_interface#updateInfos
	 */
	public boolean replayGameCycle(D_GameInfo gameInfo, D_PlayerData[] playerData);
}