/*
 * Created on 23.11.2004
 *
 */
package de.farafin.snEADy.world;


import java.util.Random;
import java.lang.*;

import de.farafin.snEADy.communication.D_GameInfo;
import de.farafin.snEADy.communication.D_Level;
import de.farafin.snEADy.communication.D_PlayerData;
import de.farafin.snEADy.communication.I_Constants;
import de.farafin.snEADy.communication.I_PlayFieldConstants;
import de.farafin.snEADy.communication.D_Vec2D;
import de.farafin.snEADy.GameParameter;
import de.farafin.snEADy.inOut.C_RecordFileReader;
import de.farafin.snEADy.inOut.C_RecordFileWriter;
import de.farafin.snEADy.inOut.C_SneadyFileInteractor;
import de.farafin.snEADy.inOut.I_RecordConstants;


//import GameParameter.D_ModuleCom.D_InitData;

/**
 * this class contains all calculations of the play field. If something moves or runns against a wall,
 * in world its the place where its calculated.
 * 
 * @author roland, lars
 * 
 * @version $Revision: 1.44 $
 */
public final class C_World implements I_World_interface, I_Constants, I_PlayFieldConstants, I_RecordConstants
{
	//-------------------------------------------------------------------------------------
	//- attributes ------------------------------------------------------------------------
	//-------------------------------------------------------------------------------------

	// game variables
	/** arena of the game */
	private final C_Arena arena;
	
	/** next time a goody occures */
	private long nextGoodyTime = 0;
	
	/** computes the next time a goody occures */
	private Random randNextGoodyTime;
	
	/** computes the kind of goody than should placed */
	private Random randGoody;

	/** parameter set of GameParameter */
	private final GameParameter parameter;
	
//	/** optimizion for SD */
//	private D_Vec2D lastSDPos = null;
//	/** optimizion for SD */
//	private int lastSDQuadrant=0;
//	/** optimizion for SD */
//	private int lastSDCounter=0;
	/** only one segment per cycle */
	private long lastSDTime = 0;

//	/** a logfile to safe the players moves */
//	private C_LogFileWriter logFile;
	
	/** comparing player data for records:
	 * 
	 * @see de.farafin.snEADy.inOut.C_LogFileWriter
	 * @see de.farafin.snEADy.inOut.C_LogFileReader
	 * @see de.farafin.snEADy.communication.D_PlayerData */
	private D_PlayerData[] recPlayerData = null;
	
	/** comparing level for records */
	private D_Level recLevel = null;

	/** comparing exit time for records */
	private long recExitTime = 0;
	/** comparing sd time for records */
	private long recSDTime = 0;
	
	/** the computed bytes for the record */
	private byte[] recBuffer = null;
	
	
	//-------------------------------------------------------------------------------------
	//- constructor -----------------------------------------------------------------------
	//-------------------------------------------------------------------------------------

	
	/** constructor
	 * @param gameInfo
	 * @param parameter
	 */
	public C_World(D_GameInfo gameInfo, GameParameter parameter)
	{
		int i;
		
		this.parameter = parameter;
		this.arena = new C_Arena(gameInfo, parameter);
		this.randNextGoodyTime = new Random();
		this.randGoody = new Random((long)(System.currentTimeMillis() * this.randNextGoodyTime.nextDouble()));
		
		this.nextGoodyTime = gameInfo.gameTime + this.randNextGoodyTime.nextInt(parameter.getMax_goody_occ_delay());

		this.recBuffer = new byte[0x10000]; // 64kByte.... nur zur sicherheit!

				
		if(parameter.getRecord() == 1)
		{
			this.recPlayerData = new D_PlayerData[gameInfo.playerData.length];
			for(i=0; i<this.recPlayerData.length; i++)
			{
				this.recPlayerData[i] = (D_PlayerData)gameInfo.playerData[i].clone();
			}
		}
		else
		{
			this.recPlayerData = null;
			this.recLevel = null;
		}

		this.recLevel = this.generateLevel(); //(D_Level)gameInfo.level.clone();
		
		this.recExitTime = this.parameter.getExit_time();
		this.recSDTime = this.parameter.getSuddend_time();
	}
	
	//-------------------------------------------------------------------------------------
	//- private methods -------------------------------------------------------------------
	//-------------------------------------------------------------------------------------
	
	/** sets a new goody and estimates the next goody time
	 * @param gameInfo
	 */
	private void placeGoody(D_GameInfo gameInfo)
	{
		D_Vec2D vec = new D_Vec2D();
		//D_Vec2D vec;
		int trys = 0;
		int radnomNumber = 0;
		int range;
		int i = 0;

		C_Goody goody = null;
		/* Added by Lars!!! Gegen Fehler bei alle occ=0*/
		int tmpNextIntVal=	 this.parameter.getGoody_speed_occ()
							+this.parameter.getGoody_slowdown_occ()
							+this.parameter.getGoody_length_occ()
							+this.parameter.getGoody_points_occ()
							+this.parameter.getGoody_shorter_occ();

		// find a new field where to set the new goody
		
		trys = 0;
		while(trys < 5)
		{
			vec.y = this.randGoody.nextInt(this.arena.getHeight());
			vec.x = this.randGoody.nextInt(this.arena.getWidth());
			if(this.arena.isFree(vec)) break;
			trys++;
		}
		
		// Gegen Fehler bei alle occ=0
		if(tmpNextIntVal > 0 && (trys < 5 || this.arena.updateFreeFieldVec(false) > 0))
		{
			if(trys >= 5) vec = this.arena.randFreeField();
			
			// estimate the kind of goody
			radnomNumber = this.randGoody.nextInt(tmpNextIntVal);
	
			// intervall test for the goody
			range = 0;
			// need this to have "break".. easier to implement that with a check of each intervall by hand..
			for(i=0; i<1 ;i++)
			{
				range += this.parameter.getGoody_speed_occ();
				if(radnomNumber < range)
				{
					goody = new C_GSpeed(vec, -1, this.parameter);
					break;
				}
				range += this.parameter.getGoody_slowdown_occ();
				if(radnomNumber < range)
				{
					goody = new C_GSpeed(vec, 1, this.parameter);
					break;
				}
				range += this.parameter.getGoody_length_occ();
				if(radnomNumber < range)
				{
					goody = new C_GLength(vec, this.parameter.getGoody_length_value(), this.parameter);
					break;
				}
				range += this.parameter.getGoody_points_occ();
				if(radnomNumber < range)
				{
					goody = new C_GPoints(vec, this.parameter.getGoody_points_value(), this.parameter);
					break;
				}
				range += this.parameter.getGoody_shorter_occ();
				if(radnomNumber < range)
				{
					goody = new C_GLength(vec, -this.parameter.getGoody_shorter_value(), this.parameter);
					break;
				}
			}
			
			// place the goody
			this.arena.objectAdd(goody);
		}
		
		this.nextGoodyTime = gameInfo.gameTime + this.randNextGoodyTime.nextInt(this.parameter.getMax_goody_occ_delay());
	}

	/* (non-Javadoc)
	 * @see de.farafin.snEADy.world.I_World_interface#recordGameCycle(de.farafin.snEADy.communication.D_GameInfo)
	 */
	public void recordGameCycle(D_GameInfo gameInfo)
	{
		int cycleBytes = 0;
		int tmpCycleBytes = 0;
		int fieldChangeCounter = 0;
		byte tmpByte = 0;
		byte direction = 0;
		D_Vec2D[] sur;
		int i, j;
		int tmpInt = 0;
		boolean changed = false;

		// recBuffer[0, 1] = game cycle length
		cycleBytes = 2;
		
		// no playfields at moment
		fieldChangeCounter = 0;		
		
		// store playfield changes ----------------------------------------------------
			changed = false;
			// recBuffer[3] = 0xA0
			// recBuffer[3, 4] = play field changes
			tmpCycleBytes = cycleBytes + 3;
			for(i=0; i<gameInfo.level.height; i++)
			{
				for(j=0; j<gameInfo.level.width; j++)
				{
					if(this.recLevel.playField[i][j] != gameInfo.level.playField[i][j])
					{
						changed = true;
						// line
						this.recBuffer[tmpCycleBytes++] = (byte)i;
						// row
						this.recBuffer[tmpCycleBytes++] = (byte)j;
						// char
						this.recBuffer[tmpCycleBytes++] = (byte)(gameInfo.level.playField[i][j] - this.recLevel.playField[i][j]);
						//System.out.println("new = " + (int)gameInfo.level.playField[i][j] + "\t\told = " + (int)this.recLevel.playField[i][j] + "\t\tdiff = " + (byte)(gameInfo.level.playField[i][j] - this.recLevel.playField[i][j]));
						// store fact of change
						fieldChangeCounter++;
					}
				}
			}
			// because before the test it is not known if there are any changes
			// the recognision that they are stored comes here.
			if(changed)
			{
				// store the fact that there were changes 
				this.recBuffer[cycleBytes++] = byte_PF;
				// store the number of changes
				this.recBuffer[cycleBytes++] = (byte)(fieldChangeCounter>>8);
				this.recBuffer[cycleBytes++] = (byte)fieldChangeCounter;
				
				// store the new buffer position
				cycleBytes = tmpCycleBytes;
			}
			
		// store palyer changes ----------------------------------------------------
			for(i=0; i< gameInfo.playerData.length; i++)
			{
				// if there were changes, 
				changed = false;
				// store the leading byte
				tmpByte = (byte)(i<<4);
				// store the beginning of the player changed block
				tmpCycleBytes = cycleBytes;
				// set actual counter to the beginning of the player data block
				cycleBytes++;
				// tests if the speed has changed (1 byte)
				if(this.recPlayerData[i].waitCycles != gameInfo.playerData[i].waitCycles || this.parameter.getGameTime() == 0)
				{
					changed = true;
					tmpByte = (byte)(tmpByte | byte_SP);
					this.recBuffer[cycleBytes++] = (byte)(gameInfo.playerData[i].waitCycles - this.recPlayerData[i].waitCycles);
				}
				// tests if the length has changed (2 byte)
				if(this.recPlayerData[i].length != gameInfo.playerData[i].length || this.parameter.getGameTime() == 0)
				{
					changed = true;
					tmpByte = (byte)(tmpByte | byte_LE);
					tmpInt = gameInfo.playerData[i].length - this.recPlayerData[i].length;
					this.recBuffer[cycleBytes++] = (byte)(tmpInt>>8);
					this.recBuffer[cycleBytes++] = (byte)tmpInt;
				}
				// tests if the points has changed (2 byte)
				if(this.recPlayerData[i].killPoints != gameInfo.playerData[i].killPoints || this.parameter.getGameTime() == 0)
				{
					changed = true;
					tmpByte = (byte)(tmpByte | byte_PO);
					tmpInt = gameInfo.playerData[i].killPoints - this.recPlayerData[i].killPoints;
					this.recBuffer[cycleBytes++] = (byte)(tmpInt>>8);
					this.recBuffer[cycleBytes++] = (byte)tmpInt;
				}
				// tests if the status has changed (1 byte)
				if(this.recPlayerData[i].snakeStatus != gameInfo.playerData[i].snakeStatus || this.parameter.getGameTime() == 0)
				{
					changed = true;
					tmpByte = (byte)(tmpByte | byte_ST);
					tmpInt = gameInfo.playerData[i].snakeStatus - this.recPlayerData[i].snakeStatus;
					this.recBuffer[cycleBytes++] = (byte)tmpInt;
				}
				
				// stores the head position if there was a change before or the head pos was changed.
				if(changed || !this.recPlayerData[i].headPos.equals(gameInfo.playerData[i].headPos) || this.parameter.getGameTime() == 0)
				{
					// in case only the head changed
					changed = true;
					if(this.recPlayerData[i].headPos.equals(gameInfo.playerData[i].headPos)) direction = byte_H;
					else
					{
						sur = this.arena.getSourounding(this.recPlayerData[i].headPos, 1);
						if	   (sur[0].equals(gameInfo.playerData[i].headPos))  direction = byte_W;
						else if(sur[1].equals(gameInfo.playerData[i].headPos))  direction = byte_S;
						else if(sur[2].equals(gameInfo.playerData[i].headPos))  direction = byte_E;
						else if(sur[3].equals(gameInfo.playerData[i].headPos))  direction = byte_N;
					}
					
					this.recBuffer[cycleBytes++] = direction;
				}
				
				
				if(changed)
				{
					this.recBuffer[tmpCycleBytes] = tmpByte;
				}
				else
				{
					cycleBytes--;
				}
			}
			
		// store game changes ----------------------------------------------------
			if(this.recExitTime != this.parameter.getExit_time() || this.recSDTime != this.parameter.getSuddend_time() || this.parameter.getGameTime() == 0)
			{
				this.recBuffer[cycleBytes++] = byte_EX;
				tmpInt = (int)(this.parameter.getExit_time() - this.recExitTime);
				this.recBuffer[cycleBytes++] = (byte)(tmpInt>>24);
				this.recBuffer[cycleBytes++] = (byte)(tmpInt>>16);
				this.recBuffer[cycleBytes++] = (byte)(tmpInt>>8);
				this.recBuffer[cycleBytes++] = (byte) tmpInt;
				
				tmpInt = (int)(this.parameter.getSuddend_time() - this.recSDTime);
				this.recBuffer[cycleBytes++] = (byte)(tmpInt>>24);
				this.recBuffer[cycleBytes++] = (byte)(tmpInt>>16);
				this.recBuffer[cycleBytes++] = (byte)(tmpInt>>8);
				this.recBuffer[cycleBytes++] = (byte) tmpInt;
				
				this.recExitTime = this.parameter.getExit_time();
				this.recSDTime = this.parameter.getSuddend_time();
			}
			
			
		cycleBytes += 2;
			
		// safe the number of stored bytes at the beginning
		this.recBuffer[0] = (byte)(cycleBytes>>8);
		this.recBuffer[1] = (byte)cycleBytes;

//		 safe the number of stored bytes at the end
		this.recBuffer[cycleBytes - 2] = (byte)(cycleBytes>>8);
		this.recBuffer[cycleBytes - 1] = (byte)cycleBytes;
		
		// safe the vomputed changes
		gameInfo.recordWriter.addGameCycle(this.recBuffer);
		
		// actualisate the stored level and player
		this.recLevel.copyOnMe(gameInfo.level);
		for(i=0; i<this.recPlayerData.length; i++)
		{
			this.recPlayerData[i].copyOnMe(gameInfo.playerData[i]);
		}
	}

	/* (non-Javadoc)
	 * @see de.farafin.snEADy.world.I_World_interface#replayGameCycle(de.farafin.snEADy.communication.D_GameInfo)
	 */
	public boolean replayGameCycle(D_GameInfo gameInfo, D_PlayerData[] playerData)
	{
		if(this.parameter.getReplay_sneay_version() <= 1011) return replayGameCycle1011(gameInfo, playerData);
		else if(this.parameter.getReplay_sneay_version() >= 1012) return replayGameCycle1012(gameInfo, playerData);
		return true;
	}

	/**  replay vis snEADy version 1.011
	 * 
	 * @param gameInfo
	 * @param playerData
	 * @return
	 */
	public boolean replayGameCycle1011(D_GameInfo gameInfo, D_PlayerData[] playerData)
	{
		int cycleBytes = 0;
		int cycleBytesCounter = 0;
		int fieldChanges = 0;
		//int tmpPlayer = 0;
		int l, r, i;
		int x = 0;
		char c = 0;
		int number = 0, left = 0, right = 0;
		int anothernumber = 0;
					
		if(gameInfo.recordReader.isFinished()) return true;
		
		this.recBuffer = gameInfo.recordReader.readGameCycle(this.recBuffer, false);
		
		cycleBytes = 0;
		x = this.recBuffer[0]; if(x<0) x += 256; x = (x << 8); cycleBytes += x;
		x = this.recBuffer[1]; if(x<0) x += 256; cycleBytes += x;
		
		x = byte_P0; if(x<0) x += 256; left = x;
		x = byte_P9; if(x<0) x += 256; right = x;
		
		cycleBytesCounter = 2;
		
		while(cycleBytesCounter < cycleBytes)
		{
			x = this.recBuffer[cycleBytesCounter++];
			if(x<0) x += 256;
			number = x;
			
			switch((byte)(number & 0xf0))
			{
				case byte_PF:

					fieldChanges = 0;
					
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 8); fieldChanges += x;					
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; fieldChanges += x;
					
					for(i=0; i<fieldChanges; i++)
					{
						l = this.recBuffer[cycleBytesCounter++]; if(l<0) l += 256;
						r = this.recBuffer[cycleBytesCounter++]; if(l<0) r += 256;
						c = (char)this.recBuffer[cycleBytesCounter++]; if(c<0) c += 256;
						
						//gameInfo.level.playField[i][j] = c;
						this.arena.setCharOnPosition(l, r, c);
					}
					break;
				case byte_EX:
					gameInfo.exitTime = 0;
					gameInfo.suddenDeath = 0;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 56); gameInfo.exitTime  += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 48); gameInfo.exitTime  += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 40); gameInfo.exitTime  += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 32); gameInfo.exitTime  += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 24); gameInfo.exitTime  += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 16); gameInfo.exitTime  += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 8); gameInfo.exitTime  += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; gameInfo.exitTime += x;

					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 56); gameInfo.suddenDeath  += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 48); gameInfo.suddenDeath  += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 40); gameInfo.suddenDeath  += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 32); gameInfo.suddenDeath  += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 24); gameInfo.suddenDeath  += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 16); gameInfo.suddenDeath  += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 8); gameInfo.suddenDeath  += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; gameInfo.suddenDeath += x;
					
					break;
				default:
					if(left <= (number & 0xf0) && (number & 0xf0) <= right)
					{
						x = number;
						if(x<0) x += 256;
						i = (x >> 4);
						
						// if the speed was changed
						if((number & byte_SP) > 0)
						{
							anothernumber = this.recBuffer[cycleBytesCounter++];
							
							if(anothernumber > playerData[i].waitCycles) playerData[i].delayChanged = 1;
							else playerData[i].delayChanged = -1;
							
							playerData[i].waitCycles = anothernumber;
						}
						else
						{
							playerData[i].delayChanged = 0;
						}
						// if the length was changed
						if((number & byte_LE) > 0)
						{
							 
							anothernumber = 0;
							x = this.recBuffer[cycleBytesCounter++];
							if(x<0) x += 256;
							x = (x << 8);
							anothernumber += x;
							
							x = this.recBuffer[cycleBytesCounter++];
							if(x<0) x += 256;
							anothernumber += x;
							
							if(anothernumber > playerData[i].length) playerData[i].lengthChanged = 1;
							else playerData[i].lengthChanged = -1;
							
							playerData[i].length = anothernumber;
						}
						else
						{
							playerData[i].lengthChanged = 0;
						}
						// if the points was changed
						if((number & byte_PO) > 0)
						{
							anothernumber = 0;
							
							x = this.recBuffer[cycleBytesCounter++];
							if(x<0) x += 256;
							x = (x << 8);
							anothernumber += x;
							
							x = this.recBuffer[cycleBytesCounter++];
							if(x<0) x += 256;
							anothernumber += x;
														
							playerData[i].killPoints = anothernumber;
						}
						
						// if the status was changed
						if((number & byte_ST) > 0)
						{
							playerData[i].snakeStatus = this.recBuffer[cycleBytesCounter++];
						}
						
						// get new head position
						switch(this.recBuffer[cycleBytesCounter++])
						{
							case byte_H:
								break;
							case byte_N:
								playerData[i].headPos.y = (playerData[i].headPos.y - 1 + gameInfo.level.height)%gameInfo.level.height;
								break;
							case byte_E:
								playerData[i].headPos.x = (playerData[i].headPos.x+1)%gameInfo.level.width;
								break;
							case byte_S:
								playerData[i].headPos.y = (playerData[i].headPos.y+1)%gameInfo.level.height;
								break;
							case byte_W:
								playerData[i].headPos.x = (playerData[i].headPos.x-1 + gameInfo.level.width)%gameInfo.level.width;
								break;
							default:;
						}
					}
			}
		}
		
		this.updateInfos(gameInfo);
		
		return false;
	}
	

	/**  replay vis snEADy version 1.012
	 * 
	 * @param gameInfo
	 * @param playerData
	 * @return
	 */
	public boolean replayGameCycle1012(D_GameInfo gameInfo, D_PlayerData[] playerData)
	{
		int cycleBytes = 0;
		int cycleBytesCounter = 0;
		int fieldChanges = 0;
		//int tmpPlayer = 0;
		int l, r, c, i;
		int x = 0;
		int number = 0, left = 0, right = 0;
		int tmpInt;
		boolean n = this.parameter.getReplay_reverse() == 0; // n = normal
				
		if(n && gameInfo.recordReader.isFinished()) return true;
		if(!n && gameInfo.recordReader.isStart()) return true;
		
		this.recBuffer = gameInfo.recordReader.readGameCycle(this.recBuffer, this.parameter.getReplay_reverse() == 1);
		
		cycleBytes = 0;
		x = this.recBuffer[0]; if(x<0) x += 256; x = (x << 8); cycleBytes += x;
		x = this.recBuffer[1]; if(x<0) x += 256; cycleBytes += x;
		
		// playerconstant verticies
		x = byte_P0; if(x<0) x += 256; left = x;
		x = byte_P9 + 0x0f; if(x<0) x += 256; right = x;
		
		cycleBytesCounter = 2;
		
		// -2 because of the 2 bytes for the length at the end
		while(cycleBytesCounter < cycleBytes - 2)
		{
			x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; number = x;
			
			switch((byte)(number & 0xf0))
			{
				case byte_PF: // playfieldchanges

					fieldChanges = 0;
					
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 8); fieldChanges += x;					
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; fieldChanges += x;
					
					for(i=0; i<fieldChanges; i++)
					{
						l = this.recBuffer[cycleBytesCounter++]; if(l<0) l += 256; // line
						r = this.recBuffer[cycleBytesCounter++]; if(l<0) r += 256; // row
						c = this.recBuffer[cycleBytesCounter++]; // char
						
						//System.out.println("diff = " + c + "\t\told = " + (int)this.arena.getCharOf(l, r) + "\t\tnew = " + (char)(this.arena.getCharOf(l, r) + c));
						
						// relative new char
						if(n)  this.arena.setCharOnPosition(l, r, (char)(this.arena.getCharOf(l, r) + c));
						if(!n) this.arena.setCharOnPosition(l, r, (char)(this.arena.getCharOf(l, r) - c));
					}
					break;
				case byte_EX: // exitTime or SDTime changes
					tmpInt = 0;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 24); tmpInt += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 16); tmpInt += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x <<  8); tmpInt += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256;                tmpInt += x;
					if(tmpInt > 0x7FFFFFF) tmpInt -= 0x10000000;
					if(n)  gameInfo.exitTime += tmpInt;
					if(!n) gameInfo.exitTime -= tmpInt;

					tmpInt = 0;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 24); tmpInt += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x << 16); tmpInt += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256; x = (x <<  8); tmpInt += x;
					x = this.recBuffer[cycleBytesCounter++]; if(x<0) x += 256;                tmpInt += x;
					if(tmpInt > 0x7FFFFFF) tmpInt -= 0x10000000;
					if(n)  gameInfo.suddenDeath += tmpInt;
					if(!n) gameInfo.suddenDeath -= tmpInt;
					
					break;
				default:
					if(left <= (number & 0xf0) && (number & 0xf0) <= right)
					{
						x = number; if(x<0) x += 256; i = (x >> 4);
						
						// if the speed was changed
						if((number & byte_SP) > 0)
						{
							tmpInt = this.recBuffer[cycleBytesCounter++];
							
							// for the green and red paint of the 
							playerData[i].delayChanged = (tmpInt >= 0)? 1 : -1;
							
							if(n)  playerData[i].waitCycles += tmpInt;
							if(!n) playerData[i].waitCycles -= tmpInt;
						}
						else
						{
							playerData[i].delayChanged = 0;
						}
						// if the length was changed
						if((number & byte_LE) > 0)
						{
							tmpInt = 0;
							x = this.recBuffer[cycleBytesCounter++]; if(x<0) x+=256; x=(x<<8); tmpInt += x;
							x = this.recBuffer[cycleBytesCounter++]; if(x<0) x+=256;           tmpInt += x;
							if(tmpInt > 0x7FFF) tmpInt -= 0x10000;
							
							playerData[i].lengthChanged = (tmpInt > 0)? 1 : -1;
							
							if(n)playerData[i].length += tmpInt;
							else playerData[i].length -= tmpInt;
						}
						else
						{
							playerData[i].lengthChanged = 0;
						}
						// if the points was changed
						if((number & byte_PO) > 0)
						{
							tmpInt = 0;
							
							x = this.recBuffer[cycleBytesCounter++]; if(x<0) x+=256; x=(x<<8); tmpInt += x;
							x = this.recBuffer[cycleBytesCounter++]; if(x<0) x+=256;           tmpInt += x;
							if(tmpInt > 0x7FFF) tmpInt -= 0x10000; 							
																					
							if(n)  playerData[i].killPoints += tmpInt;					
							if(!n) playerData[i].killPoints -= tmpInt;
						}
						
						// if the status was changed
						if((number & byte_ST) > 0)
						{
							if(n)  playerData[i].snakeStatus += this.recBuffer[cycleBytesCounter++];
							if(!n) playerData[i].snakeStatus -= this.recBuffer[cycleBytesCounter++];

						}
						
						// get new head position
						if(n)
						{
							switch(this.recBuffer[cycleBytesCounter++])
							{
								case byte_H:
									break;
								case byte_N:
									playerData[i].headPos.y = (playerData[i].headPos.y - 1 + gameInfo.level.height)%gameInfo.level.height;
									break;
								case byte_E:
									playerData[i].headPos.x = (playerData[i].headPos.x+1)%gameInfo.level.width;
									break;
								case byte_S:
									playerData[i].headPos.y = (playerData[i].headPos.y+1)%gameInfo.level.height;
									break;
								case byte_W:
									playerData[i].headPos.x = (playerData[i].headPos.x-1 + gameInfo.level.width)%gameInfo.level.width;
									break;
								default:;
							}
						}
						else
						{
							switch(this.recBuffer[cycleBytesCounter++])
							{
								case byte_H:
									break;
								case byte_N:
									playerData[i].headPos.y = (playerData[i].headPos.y+1)%gameInfo.level.height;
									break;
								case byte_E:
									playerData[i].headPos.x = (playerData[i].headPos.x-1 + gameInfo.level.width)%gameInfo.level.width;
									break;
								case byte_S:
									playerData[i].headPos.y = (playerData[i].headPos.y - 1 + gameInfo.level.height)%gameInfo.level.height;
									break;
								case byte_W:
									playerData[i].headPos.x = (playerData[i].headPos.x+1)%gameInfo.level.width;
									break;
								default:;
							}
						}
					}
			}
		}
		
		this.updateInfos(gameInfo);
		
		return false;
	}
	
	//-------------------------------------------------------------------------------------
	//- public methods --------------------------------------------------------------------
	//-------------------------------------------------------------------------------------
	
	/* (non-Javadoc)
	 * @see de.farafin.GameParameter.world.I_World_interface#update(de.farafin.GameParameter.communication.D_GameInfo)
	 */
	public void update(D_GameInfo gameInfo)
	{
		int i;
		D_Vec2D vec = null;
//		int counter = 0, maxCounter =0;;
//		int height = 0;
//		int width = 0;
//		int quadrant = 0;
		//int trys = 0;
		
		C_GameObject gObj;
		 
		if(this.parameter.getReplay() == 0)
		{
			for(i = 0; i < this.arena.getNumberOfObjects(); i++)
			{ 
				gObj = this.arena.getGameObject(i);
				if(gObj.getNextUpdateTime() >= 0 && gObj.getNextUpdateTime() <= gameInfo.gameTime)
				{
					this.arena.objectUpdate(gObj);
				}
			}
	
			if(this.parameter.getGameTime() < this.parameter.getSuddend_time())
			{
				if(this.nextGoodyTime <= gameInfo.gameTime)
				{
					placeGoody(gameInfo);
				}
			}
			// sudden Death
			//if(DEBUG) System.out.println("DEBUG C_World.update: suddenDeath " + gameInfo.suddenDeath);
			if(gameInfo.gameTime >= gameInfo.suddenDeath && gameInfo.gameTime > this.lastSDTime)
			{
				this.lastSDTime = gameInfo.gameTime;
	
				if(this.arena.updateFreeFieldVec(false)>0)
				{
					vec = this.arena.randFreeField();
					this.arena.objectAdd(new C_GLength(vec, -this.parameter.getGoody_shorter_value(), this.parameter));
				}
			}
			
		}
		
		updateInfos(gameInfo);
	}

	/* (non-Javadoc)
	 * @see de.farafin.GameParameter.world.I_World_interface#generateLevel()
	 */
	public D_Level generateLevel(){return this.arena.generateLevel();}

	/* (non-Javadoc)
	 * @see de.farafin.GameParameter.world.I_World_interface#updateLevel(de.farafin.GameParameter.communication.D_Level)
	 */
	public void updateInfos(D_GameInfo gameInfo)
	{
		this.arena.updateLevel(gameInfo.level);		
	}
	
	//-------------------------------------------------------------------------------------
	//- public static methods -------------------------------------------------------------
	//-------------------------------------------------------------------------------------
}