/*
 * Created on 07.02.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.farafin.snEADy.player;

import java.io.Serializable;

/** This is just a class for storing informations. It doesnt contain methods because it doesnt need
 * to calculate anything. Its just a set of informations for the player. 
 * 
 * Additional to all snakes, the player have more informations about his own snake.
 * 
 * Diese Klasse ist zum Speichern von Informationen gedacht. Sie enthllt keine Methoden weil
 * sie nichts berechnen muss. Es ist nur eine Menge von Informationen fr den Spieler.
 * 
 * Zustzlich zu den anderen Schlangen hat spieler mehr Informationen ber die eigene Schlange.
 * 
 * @author roland, lars
 */
public class OwnSnakeInfo extends SnakeInfo implements Serializable
{
	
	/** nextMoveTime is the gameTime cycle the snake will move next time. It moves directly
	 * after the player finished his thinking method and before the next player starts his
	 * calculation. <br>
	 * <br>
	 * nextMoveTime ist der gameTime Zyklus wenn die Schlange das nchste mal ziehen wird. Sie zieht
	 * direkt nach dem der spieler seine calculate-methode beendet hat, noch bevor der nchste spieler
	 * seine berlegung startet.
	 *
	 * @see GameInfo#gameTime
	 */
	public long nextMoveTime = 0;

	/** lastCalculatedMemUsage is how the name sais, the memory usage of the player at
	 * it was calculated last time. The calculation of this is very time consumting, thats
	 * why it is not done every gameCycle.
	 * 
	 * lastCalculatedMemUsage ist wie der Name sagt, der Speicherplatz, den der Spieler belegt
	 * hat, als das letzte mal kontrolliert wurde. Die Berechnung ist sehr Zeitaufwendig
	 * und erfolgt deswegen nicht in jedem game Zyklus.
	 * 
	 * */
	public long lastCalculatedMemUsage = 0;
	
	/** This is the directon in which the head of the snake points. This is important because
	 * the player decided if the head should turn left, right or doesn't turn at all. So the move
	 * direction depends on the turn of the player and the direction the snakes head pointed before.
	 * 
	 * Dies ist die Richtung in die der Kopf der Schlange schaut. Das ist wichtig, weil der Spieler
	 * entscheiden muss ob sich der Kopf nach links, rechts oder gar nicht drehen soll. Also hngt
	 * die Richtung in die die Schlange sich als nchstes bewegt von der aktuellen richtung des Kopfes
	 * und der richtung ab in die der spieler lenkt.
	 * 
	 * @see PubConstants#NORTH
	 * @see PubConstants#EAST
	 * @see PubConstants#SOUTH
	 * @see PubConstants#WEST
	 *  */
	public int headDirection = NORTH;
	
 }
