/*
 * Created on 07.02.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.farafin.snEADy.player;

import java.io.Serializable;


/** This is just a class for storing informations. It doesnt contain methods because it doesnt need
 * to calculate anything. Its just a set of informations for the player.<br> 
 * <br>
 * GameInfo contains global informations about the game.<br>
 * <br>
 * Diese Klasse ist zum Speichern von Informationen gedacht. Sie enthllt keine Methoden weil
 * sie nichts berechnen muss. Es ist nur eine Menge von Informationen fr den Spieler.<br>
 * <br>
 * GameInfo enthllt allgemeinte Informationen ber das Spiel.
 * 
 * @author roland, lars
 */
public class GameInfo implements Serializable
{
	/** snEADy is a round based game. That means in snEADy is the time no continoue, but discrete
	 * value. So you can image the game as a sequence of stats. We can count this states and the
	 * counter is gameTime. Like in a party game, thinks each player each round about what he
	 * does next. gameTime exists tp mesure the snEADy-time.<br>
	 * <br>
	 * snEADy ist ein Runden basierendes Spiel. Das bedeutet, in snEADy ist die Zeit keine
	 * kontinuierliche, sondern eine diskrete Gre. Das Spiel besteht also aus einer
	 * Folge von Zustnden. Diese Zustnde knnen wir zhlen und der Zhler ist gameTime.
	 * Wie in einem Gesellschaftsspiel ist jeder Spieler in jeder Runde ein mal dran und kann
	 * darber nachdenken was er als nchstes macht. Damit die snEADy-Zeit messbar wird,
	 * gibt es gameTime.
	 */
	public long gameTime = 0;

	/** exitTime is the game cycle in which the exit is opened. If gameTime is less then
	 * exitTime, the exit fields in the game field will work like a normal wall. If gameTime
	 * is greater equal than exitTime, the exit is opened and the snakes are able to
	 * leave the arena. <br>
	 * <br>
	 * exitTime ist die Spiel-Runde, in der der Ausgang geffnet wird. Wenn gameTime kleiner ist als
	 * exitTime, dann werden die Exit-Felder wie eine normale Wand behandelt. Ist gameTime grer gleich
	 * exitTime, dann is der Ausgang geffnet und die Schlangen knnen die Arena verlassen.
	 */
	public long exitTime = 0;
	
	/** To force an final decision for each game, there is a sudden death phasis. This is made for
	 * forcing the snakes to leave the arena. suddenDeathTime is the like exitTime a gameTime cycle
	 * in which the sudden death starts. The sudden death usually starts some game cycles after
	 * the exit was opended.<br>
	 * <br>
	 * Um eine endgltige Entscheidung bei einem Spiel zu erzwingen, gibt es die Sudden Death Phase.
	 * Sie ist dazu da, die Schlangen zum Verlassen der Arena zu zwingen. suddenDeathTime ist so
	 * hnlich wie exitTime die gameTime in der der Sudden Death beginnen soll.
	 */
	public long suddenDeathTime = 0;
	
	/** thinkingMS is the (real) time in milliseconds a player is allowed to think about his move.
	 * After this time he is supposed to finish his calculation.<br>
	 * <br>
	 * thinkingMS ist die (reale) Zeit in Millisekunden die ein spieler Zeit hat ber seinen
	 * Zug nachzudenken. Nach dieser Zeit muss er mit der Berechnung fertig sein. 
	 *  */
	public long thinkingMS = 0;
	
	/** To allow the player an analyse of the playfield, he gets more milliseconds at gameTime == 0.
	 * So the first time his calculate method is called, he gets additional analyseMS to thinkingMS.<br>
	 * <br>
	 * Um dem spieler eine Analyse des Spielfeldes zu erlauben, bekommt er bei gameTime == 0
	 * mehr millisekunden. Das bedeutet, wenn seine calculate-methode zum ersten mal aufgerufen wird,
	 * bekomt er zuszlich zu seinen thinkingMS noch die analyseMS.
	 * */
	public long analyseMS = 0;
	

	/** This is the maximal size in kB, a player is allowed to allocate.
	 * If the player needs more, his snake will die.
	 *  
	 * Dies ist die maximal erlaubte Menge von Speicher in kB, die ein Spieler belegen darf.
	 * Wenn er mehr benutzt, wird seine schlange gettet.  
	 * 
	 * @see OwnSnakeInfo#lastCalculatedMemUsage
	 * */
	public long maxMem = 0;
	
	/** The Distance in which snakes gain points if an other snake looses a segment.
	 * The number of points is damage_points_radius - (dist = deltaRow + deltaLine)
	 */
	public int damage_points_radius = 0;

	/** The Distance in which snakes gain points if an other snake dies.
	 * The number of points is kill_points_radius - (dist = deltaRow + deltaLine)
	 */
	public int kill_points_radius = 0;
	
	/** The number of goodies which spread out when a snake dies. The
	 * Radius where they occure is the same as kill_points_radius
	 * Sometimes it may happen, that there is very little space where goodies could
	 * be placed. Because the placing rutine is random, it may happen, that there is
	 * after 100 trys no free place found. Than this goody is not placed.
	 * So dont wonder of there are less than kill_point_goodies
	 * goodies around sometimes. 
	 * */
	public int kill_point_goodies = 0;
	
	/** The amount of segments (part of a segment) that a snake grows if
	 * an other snake runns into it. */
	public float damage_length_grow = 0.0f;

	/** The minimum delay for snakes to move */
	public  long min_move_delay = 0;
	
	/** The maximum delay for snakes to move */	
	public long max_move_delay = 0;

	/** each auto_grow_delay number of world cycles, the snake grows by one segment */
	public int auto_grow_delay = 0;
	
	/** each auto_slowdown_delay number of world cycles, the snakes waitCycles increase by one.
	 * If the snake eats a speed up or a slw down goodie, the time starts new.  */
	public int auto_slowdown_delay = 0;

	/** the maximal time between two goody occurances. The time is equal distributed. */
	public int max_goody_occ_delay = 0;
	
	/** estimation that a new goody is a speed goody. propability: goody_speed_occ/Sum(goody_..._occ) */
	public int goody_speed_occ = 0;

	/** estimation that a new goody is a slowdown goody. propability: goody_slowdown_occ/Sum(goody_..._occ) */
	public int goody_slowdown_occ = 0;
	
	/** estimation that a new goody is a length goody. propability: goody_length_occ/Sum(goody_..._occ) */
	public int goody_length_occ = 0;
	
	/** estimation that a new goody is a points goody. propability: goody_points_occ/Sum(goody_..._occ) */
	public int goody_points_occ = 0;

	/** estimation that a new goody is a shorter goody. propability: goody_points_occ/Sum(goody_..._occ) */
	public int goody_shorter_occ = 0;

	/** the number of segments a snake gets longer, if it eats a length goody */
	public int goody_length_value = 0;
	
	/** the number of points a snake gets, if it eats a points goody */
	public int goody_points_value = 0;

	/** the number of segments a snake looses, if it eats a shorter goody */
	public int goody_shorter_value = 0;
				
	/** the number of points a player gets if he reaches the exit.
	 * the later a player goes into the exit, the more points are made. */
	public int survival_points = 0;
	
	/** if a snake bites it self, this number of points are given
	 * all snakes, that touches the biting snake at at least one segments.
	 * that meens the bodys touches each other.
	 *  */
	public int easy_points = 0;	
}
