/*
 * Created on 20.03.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.farafin.snEADy.inOut;

import java.io.FileNotFoundException;
import java.lang.String;
import java.lang.reflect.InvocationTargetException;

import de.farafin.snEADy.M_Main;


import de.farafin.snEADy.communication.D_Level;

/**
 * @author roland, lars
 *
 * TODO what does that class do?
 * 
 */
public final class C_SneadyFileInteractor
{	
	/**
	 * @param className the name of the class that should be loaded
	 * @return an instance of the loaded class or null if the load failed
	 */
	public static Class loadPlayerClass(String className)
	{
		try
		{
			// Dadurch, dass jedesmal ein neuer ClassLoader angelegt
			// wird, werden die Klassen stets neu geladen.

			Class c = new C_FileClassLoader("player").loadClass(className, true);
			return c;
		}
		catch(Exception e)
		{
			System.out.println("WARNING: player wasnt loaded \n\t" + e);
			
			return null;
		}
	}

	
	/** gets the static player name
	 * @param playerName
	 * @return the player name
	 */
	public static String getPlayerName(String playerName)
	{
		String s = null;
		Class c = loadPlayerClass(playerName);
		if(c == null) return "";
		
		try
		{
			s = (String)c.getField("name").get(null);
			if(s.length() > 0 /*&& !s.equals("static name")*/) return s;
			
			return c.getName();
		} 
		catch(IllegalArgumentException e)
		{
			e.printStackTrace();
			return "e";
		}
		catch(SecurityException e)
		{
			e.printStackTrace();
			return "e";
		}
		catch(IllegalAccessException e)
		{
			e.printStackTrace();
			return "e";
		}
		catch(NoSuchFieldException e)
		{
			e.printStackTrace();
			return "n";
		}
	}
	
	/**
	 * @param playerName the class of which the comment should be red from
	 * @return the comment
	 * 
	 * @see de.farafin.snEADy.player.Player#comment
	 */
	public static String getPlayerComment(String playerName)
	{
		String s = null;
		Class c = loadPlayerClass(playerName);
		if(c == null) return "e";
		
		try
		{
			s = (String)c.getField("comment").get(null);
		}
		catch(IllegalArgumentException e)
		{
			//e.printStackTrace();
			return "e";
		}
		catch(SecurityException e)
		{
			//e.printStackTrace();
			return "e";
		}
		catch(IllegalAccessException e)
		{
			//e.printStackTrace();
			return "e";
		}
		catch(NoSuchFieldException e)
		{
			//e.printStackTrace();
			return "n";
		}
		
		return "j" + s;
	}


	/** loads a level without the playfield
	 * @param levelName the name of the level that should be loaded
	 * @return the loaded level, but without the playfield
	 * 
	 * @see de.farafin.snEADy.inOut.C_LevelLoader
	 */
	public static D_Level getLevelHeader(String levelName)
	{
		C_LevelLoader levelLoader = new C_LevelLoader();
		D_Level level = null; 
		try	{level = levelLoader.loadLevelHeader(levelName);}
		catch(FileNotFoundException e)
		{
			// this happends when a file is not found
			
			System.out.println("WARNING: " + e);
			return null;
		}
		catch(E_LevelFileException e)
		{
			// this happends if somewhere in the level file, the format is not interpretable by
			// the level loader because of wrong characters or wrong formation
			
			System.out.println("WARNING: " + e);
			return null;
		}
	
		return level;
	}


	/**
	 * Loads a level of a specified file. Also computes errors of the file and the case that
	 * the file is not found.
	 * 
	 * @param levelName the name of the level that should be loaded
	 * @return the level
	 */
	public static D_Level loadLevel(String levelName)
	{
		C_LevelLoader levelLoader = new C_LevelLoader();
		D_Level level = null; 
		try	{level = levelLoader.loadLevel(levelName);}
		catch(FileNotFoundException e)
		{
			// this happends when a file is not found
			
			System.out.println("WARNING: " + e);
			return null;
		}
		catch(E_LevelFileException e)
		{
			// this happends if somewhere in the level file, the format is not interpretable by
			// the level loader because of wrong characters or wrong formation

			System.out.println("WARNING: " + e);
			return null;
		}

		return level;
	}
	
	/** gets the replay header as string array
	 * return[0]: levelname
	 * return[1]: player count
	 * return[2]: gamelength
	 * return[3 - 12]: playernames
	 * 
	 * @param replayName the replay from which the header should be read from.
	 * 
	 * @return the header as string array
	 */
	public static String[] getReplayHeader(String replayName)
	{
		String[] head = null;
		String[] line = null;
		String[] str = null;
		String[] tmp = null;
		
		int test;
		int playerNumber;
		int i, counter;
		C_RecordFileReader reader = null;
		
		try
		{
			reader = new C_RecordFileReader("replays", replayName);
		}
		catch(FileNotFoundException e)
		{
			System.out.println("WARNING: record: '" + replayName + "' not found!");
			return null;
		} 
		
		head = reader.readHeader();
		
		playerNumber = 0;
		for(i=0; i<head.length; i++)
		{
			line = head[i].split(" ");
			if(line.length > 0)
			{
				if(line[0].startsWith("loaddummy"))
				{
					playerNumber++;
				}
			}
		}
		
		str = new String[playerNumber+4];
		
		counter=0;
		for(i=0; i<head.length; i++)
		{
			line = head[i].split(" ");
			if(line.length > 0)
			{
				if(line[0].startsWith("%SnEADyVersion"))
				{
					str[0] = line[1];
				}
				else if(line[0].startsWith("loadlevel"))
				{
					str[1] = line[1];
					str[2] = "" + playerNumber;
				}
				else if(line[0].startsWith("%gameLength"))
				{
					str[3] = line[1];
				}
				else if(line[0].startsWith("loaddummy"))
				{
					tmp = head[i].split(":");
					if(tmp.length > 1)	str[counter+4] = tmp[1];
					else str[counter+4] = "name";
					counter++;
				}
			}
		}
		
		if(str[0] == null || str[0] == "") str[0] = "1011";
		
		try
		{
			test = Integer.parseInt(str[0]);
			
			if(test < 1011 || test > M_Main.getVersion()) str[0] = "1011"; 
		}
		catch(NumberFormatException e)
		{
			 str[0] = "1011";
		}
		
		return str;
	}
	
	// got it from here: http://mindprod.com/jgloss/hex.html
//	 table to convert a nibble to a hex char.
	static char[] hexChar = {
	   '0' , '1' , '2' , '3' ,
	   '4' , '5' , '6' , '7' ,
	   '8' , '9' , 'a' , 'b' ,
	   'c' , 'd' , 'e' , 'f'};
	
	public static String toHexString(byte b)
	{
		return Integer.toString( ( b & 0xff ) + 0x100, 16 /* radix */ ).substring( 1 );
	}
	
//	 Fast convert a byte array to a hex string
//	 with possible leading zero.

	public static String toHexString( byte[] b )
	{
		StringBuffer sb = new StringBuffer( b.length * 2 );
		
		for ( int i=0; i<b.length; i++ )
		{
			// look up high nibble char
			sb.append( hexChar [( b[i] & 0xf0 ) >>> 4] );
			
			// look up low nibble char
			sb.append( hexChar [b[i] & 0x0f] );
			
			sb.append(" ");
		}
		return sb.toString();
	}


}
