/*
 * Created on 19.03.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.farafin.snEADy.inOut;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.lang.Integer;

import de.farafin.snEADy.communication.I_Constants;


/** reads a record file: <br>
 *  <br>
 * file scheme: <br> 
 * for each gameCycle: <br>
 * what is stored (consumtion) <br>
 * - Number bytes (2Byte) <br>
 * - Nnumber of playfield changes (1Byte) <br>
 * - Playfield changes (3 Byte each) <br>
 * ... <br>
 * - Player Nr and status changes (1 Byte) <br>
 *    = Player Number (4 bit) <br>
 *    + speed changed? (1 bit) <br>
 * 	  + length changed? (1 bit) <br>
 * 	  + Points changed? (1 bit) <br>
 * 	  + Status changed? (1 bit) <br>
 * - playerdata (max 7 Byte) <br>
 * 	  = new speed (1 Byte) [only if change bit is 1] <br>
 * 	  + new Length (2 Byte) [only if change bit is 1] <br>
 *    + new points (2 Byte) [only if change bit is 1] <br>
 *    + new Status (1 Byte) [only if change bit is 1] <br>
 * 	  + head move direction (1 Byte) <br>
 * - if player Nr == 15: new Exit Time (8 Byte) + new SDTime (8 Byte) = 17 Byte <br>
 * 
 * @author roland, lars
 * 
 */
public class C_RecordFileWriter implements I_Constants
{

	/** Comment for <code>logFile</code> */
	private File binFile;
		
	/** the buffer of data */
	private Vector buffer;
			
	/** Comment for <code>header</code> */
	private String header;
				
	/** constructor
	 * @param fileName
	 */
	public C_RecordFileWriter(String fileName)
	{
		this("records", fileName);
	}
	
	/**
	 * @param root
	 * @param fileName
	 */
	public C_RecordFileWriter(String root, String fileName)
	{
		this.binFile = new File(root, fileName + ".sre");
		this.buffer = new Vector(8);
		
		try
		{
			this.binFile.createNewFile();
		}
		catch(IOException e)
		{
			System.out.println("WARNING: LogFile cant be opend!! " + e);
			if(DEBUG) System.out.println("DEBUG C_LogFileWriter.C_LogFileWriter: " +
					"well.. now you have a problem... better check that there is " +
					"no writing-proofed file with the same name..");
		}
	}
	
	/** stors the head
	 * 
	 * @param head
	 */
	public void storeHeader(String head)
	{
		this.header = "\n" + head;
	}
	
	/** 
	 * @param cycle
	 */
	public void addGameCycle(byte[] cycle)
	{
		int len = 0;
		byte[] store = null;
		int i = 0;
		int x = 0;
		
		len = 0;

		x = cycle[0];
		if(x<0) x += 256;
		x = (x << 8);
		len += x;
		
		x = cycle[1];
		if(x<0) x += 256;
		len += x;
		
		
		store = new byte[len];
				
		for(i=0; i<len; i++)
		{
			store[i] = cycle[i];
		}
		
		this.buffer.add(store);
	}
		
	/** safes the stored lines to the file and closes it. */
	public void saveAndCloseFile()
	{
		int i;
		FileOutputStream outStream;
		byte[] head;
		byte[] headLength;
		
		headLength = new byte[4];	
			
		// compute final header
		this.header += "%gameLength " + this.buffer.size() + "\n";

		head = this.header.getBytes();

		headLength[0] = (byte)(head.length >> 24); //(new Integer(head.length >> 24)).byteValue();
		headLength[1] = (byte)(head.length >> 16); //(new Integer(head.length >> 16)).byteValue();
		headLength[2] = (byte)(head.length >> 8); //(new Integer(head.length >> 8)).byteValue();
		headLength[3] = (byte)(head.length); //(new Integer(head.length)).byteValue();
			
		// write file
		try
		{
			outStream = new FileOutputStream(this.binFile);
			
			//write headlength
			outStream.write(headLength);
			// write header
			outStream.write(head);
			
			// write game
			for(i=0; i<this.buffer.size(); i++)
			{
				outStream.write((byte[])this.buffer.elementAt(i));	
			}
			outStream.flush();

			outStream.close();
		}
		catch(FileNotFoundException e)
		{
			e.printStackTrace();
		}
		catch(IOException e)
		{
			e.printStackTrace();
		}
	}
}
