/*
 * Created on 19.03.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.farafin.snEADy.inOut;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.String;

import de.farafin.snEADy.communication.I_Constants;


/** reads a record file: <br>
 *  <br>
 * file scheme: <br> 
 * for each gameCycle: <br>
 * what is stored (consumtion) <br>
 * - Number bytes (2Byte) <br>
 * - Nnumber of playfield changes (1Byte) <br>
 * - Playfield changes (3 Byte each) <br>
 * ... <br>
 * - Player Nr and status changes (1 Byte) <br>
 *    = Player Number (4 bit) <br>
 *    + speed changed? (1 bit) <br>
 * 	  + length changed? (1 bit) <br>
 * 	  + Points changed? (1 bit) <br>
 * 	  + Status changed? (1 bit) <br>
 * - playerdata (max 7 Byte) <br>
 * 	  = new speed (1 Byte) [only if change bit is 1] <br>
 * 	  + new Length (2 Byte) [only if change bit is 1] <br>
 *    + new points (2 Byte) [only if change bit is 1] <br>
 *    + new Status (1 Byte) [only if change bit is 1] <br>
 * 	  + head move direction (1 Byte) <br>
 * - if player Nr == 15: new Exit Time (8 Byte) + new SDTime (8 Byte) = 17 Byte <br>
 * 
 * @author roland, lars
 * 
 */
public class C_RecordFileReader implements I_Constants
{
	/** Comment for <code>logFile</code> */
	private File binFile;
		
	/** the buffer of data */
	private byte[] buffer;
	
	/** Position in the buffer */
	private int actPos;
	
	/** Comment for <code>headerLength</code> */
	private int headerLength;
	
	/** Comment for <code>startPos</code> */
	private int startPos;
	
	/** Comment for <code>header</code> */
	private String header;
	
	/**
	 * 
	 * @param root
	 * @param fileName
	 * @throws FileNotFoundException
	 */
	public C_RecordFileReader(String root, String fileName) throws FileNotFoundException
	{
		int x=0;
		FileInputStream fileStream = null;
		
		 fileName += ".sre";
						
		this.binFile = new File(root, fileName);
		if(!this.binFile.exists()) throw new FileNotFoundException("File " + fileName + " at " + root + " was not found!" );
		
		this.buffer = new byte[(int)this.binFile.length()];
		
		try
		{
			fileStream = new FileInputStream(this.binFile);
			fileStream.read(this.buffer);
		}
		catch(IOException e)
		{
			System.out.println("WARNING: File cant be opend!! " + e);
			if(DEBUG) System.out.println("DEBUG C_RecordFileReader.C_RecordFileReader: " +
					"well.. if the file is there you have a problem or i have a bug" +
					"... better check that there is " +
					"no reading-protected file with the same name..");
			
			try
			{
				this.finalize();
			}
			catch(Throwable e1)
			{
				e1.printStackTrace();
				System.out.println("Something really weired is going on. Ask the " +
						"java development team for help.. my knowlage ends here...");
			}
			return;
		}
		
		// get the header length
		this.headerLength = 0;
		
		x = this.buffer[0];	if(x<0) x += 256; this.headerLength += (x << 24);
		x = this.buffer[1];	if(x<0) x += 256; this.headerLength += (x << 16);
		x = this.buffer[2];	if(x<0) x += 256; this.headerLength += (x << 8);		
		x = this.buffer[3];	if(x<0) x += 256; this.headerLength += x;
		
		// get the header
		this.header = new String(this.buffer, 4, this.headerLength);
		this.startPos = this.headerLength + 4;
		this.actPos = this.startPos;
	}
	

	/**
	 * @param fileName
	 * @throws FileNotFoundException
	 */
	public C_RecordFileReader(String fileName) throws FileNotFoundException
	{
		this("records", fileName);
	}
		
	
	/** reeads the haader of the file 
	 * 
	 * @return the lines the header constists of
	 */
	public String[] readHeader()
	{
		return this.header.split("\n");
	}
	
	/** gets a game cycle data block
	 * 
	 * @param buf The buffer where the data should be stored in. If it is to small, there
	 * will be a new one created and given back. 
	 * @param if the game should be read reveresed or not
	 * @return the buffer. if <code>buf</code> was too small, it will be a new instance returned 
	 */
	public byte[] readGameCycle(byte[] buf, boolean reverse)
	{
		byte[] res = null;
		int len=0;
		int i=0;
		int x=0;

		len = 0;
		
		if(!reverse) // normal replay
		{
			if(this.actPos >= this.buffer.length) return null;
	
	
			x = this.buffer[this.actPos]; if(x<0) x += 256;	len += (x << 8);		
			x = this.buffer[this.actPos+1];	if(x<0) x += 256; len += x;

			// if buf is to smal, make a bigger one
			if(buf == null || buf.length < len) res = new byte[len];
			else res = buf;
			
			// copy the data
			for(i = 0; i<len; i++)
			{
				res[i] = this.buffer[this.actPos+i];
			}
			
			
			this.actPos += len;
		}
		else // reversed replay
		{

			if(this.actPos == this.startPos) return null;
	
			x = this.buffer[this.actPos-2]; if(x<0) x += 256; len += (x << 8);		
			x = this.buffer[this.actPos-1];	if(x<0) x += 256; len += x;

			// if buf is to smal, make a bigger one
			if(buf == null || buf.length < len) res = new byte[len];
			else res = buf;
			
			// copy the data
			for(i = 0; i<len; i++)
			{
				res[i] = this.buffer[this.actPos-len + i];
			}
			
			this.actPos -= len;
		}
			
			
		return res;
	}
	
	
	/**
	 * @return if all lines were read
	 */
	public boolean isFinished()
	{
		return (this.actPos >= this.buffer.length);
	}

	/**
	 * @return if all lines were read
	 */
	public boolean isStart()
	{
		return (this.actPos == this.startPos);
	}
	
	/** next line is set to 0 */
	public void restart()
	{
		this.actPos = this.startPos;
	}
	
	/**
	 * @return v
	 */
	public String getFileName()
	{
		return this.binFile.getName();
	}
}
