/*
 * Created on 13.12.2004
 *
 * 
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.farafin.snEADy.control.GaphixStuff;
 
import de.farafin.snEADy.I_Main_interface;
import de.farafin.snEADy.I_GameStats;
import de.farafin.snEADy.communication.*;
import de.farafin.snEADy.player.*;
import de.farafin.snEADy.C_DebugMonitor;
import de.farafin.snEADy.GameParameter;
import de.farafin.snEADy.control.*;


import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;

import java.text.DecimalFormat;
/* TODO @lars alles mal schn kommentieren
 *
 */  

/**
 * @author lars, roland
 *
 * 
 * 
 * @version $Revision: 1.18 $ 
 */
public class M_GraphixEngineUI implements I_Constants,I_GraphixConstants,I_GameStats{

	/*
	 * C_GraphixEngineUI.java
	 *
	 * Created on 1. Dezember 2004, 01:09
	 */
        
    /** Grafikreprsentation der Arena */
    
    private static class Gr_Arena{
        protected char [][] field;
        protected int sizeX;
        protected int sizeY;
        

        public Gr_Arena(int size_y, int size_x, char clearByte){
            this(size_y,size_x);
            for (int i=0;i<size_y;i++)
                for (int j=0;j<size_x;j++)
                    field[i][j]=clearByte;
        }
        public Gr_Arena(int size_y, int size_x){
            field=new char[size_y][size_x];
            sizeX=size_x;
            sizeY=size_y;
        }
        public Gr_Arena(char newField[][],D_GameInfo gameInfo){
            sizeX=newField[0].length;
            sizeY=newField.length;
            field=new char[sizeY][sizeX];
            convert(field,newField,gameInfo);
            
        }
        public void fill(char clearByte){
            for (int i=0;i<sizeY;i++)
                for (int j=0;j<sizeX;j++)
                    field[i][j]=clearByte;
        }
        public void update(char src[][],D_GameInfo gameInfo){
            
        	convert(field,src,gameInfo);
        }
        public void update(char src[][]){
            for (int i=0;i<sizeY;i++)
                for (int j=0;j<sizeX;j++)
                    field[i][j]=src[i][j];
        }
        private void convert(char fieldDest[][],char fieldSrc[][],D_GameInfo gameInfo){

            int succ_i,prev_i,succ_j,prev_j,i,j,lenX,lenY;
            lenY=fieldSrc.length;
            lenX=fieldSrc[0].length;
            D_PlayerData pd[]=gameInfo.playerData;
            
            for (i=0;i<lenY;i++){
                prev_i=(i-1+lenY)%lenY;
                succ_i=(i+1)%lenY;
                for (j=0;j<lenX;j++){
                    prev_j=(j-1+lenX)%lenX;
                    succ_j=(j+1)%lenX;
                    fieldDest[i][j]=0;
                    if (fieldSrc[i][j]==C_WALL){
                        if (fieldSrc[i][prev_j]!=C_WALL)
                            fieldDest[i][j]=C_WALLCORNER_W;
                        else if (fieldSrc[i][succ_j]!=C_WALL)
                            fieldDest[i][j]=C_WALLCORNER_E;
                            
                        if (fieldSrc[prev_i][j]!=C_WALL)
                            if (fieldDest[i][j]==C_WALLCORNER_W)
                                fieldDest[i][j]=C_WALLCORNER_NW_CV;
                            else if (fieldDest[i][j]==C_WALLCORNER_E)
                                fieldDest[i][j]=C_WALLCORNER_NE_CV;
                            else
                                fieldDest[i][j]=C_WALLCORNER_N;
                        else if (fieldSrc[succ_i][j]!=C_WALL)
                            if (fieldDest[i][j]==C_WALLCORNER_W)
                                fieldDest[i][j]=C_WALLCORNER_SW_CV;
                            else if (fieldDest[i][j]==C_WALLCORNER_E)
                                fieldDest[i][j]=C_WALLCORNER_SE_CV;
                            else
                                fieldDest[i][j]=C_WALLCORNER_S;
                        else
                            if (fieldDest[i][j]==0)
                                if (fieldSrc[succ_i][succ_j]!=C_WALL)
                                    fieldDest[i][j]=C_WALLCORNER_SE_CC;
                                else if (fieldSrc[succ_i][prev_j]!=C_WALL)
                                    fieldDest[i][j]=C_WALLCORNER_SW_CC;
                                else if (fieldSrc[prev_i][succ_j]!=C_WALL)
                                    fieldDest[i][j]=C_WALLCORNER_NE_CC;
                                else if (fieldSrc[prev_i][prev_j]!=C_WALL)
                                    fieldDest[i][j]=C_WALLCORNER_NW_CC;
                                else
                                    fieldDest[i][j]=C_WALL;
                    }
                    else{
                        if (fieldSrc[i][j]==C_EXIT){
                            if (fieldSrc[prev_i][j]!=C_EXIT  && fieldSrc[i][prev_j]!=C_EXIT){
                                
                            
                                if (gameInfo.gameTime>=gameInfo.exitTime)
                                    fieldDest[i][j]=C_EXITO;
                                else
                                    fieldDest[i][j]=C_EXIT;
                            }
                            else
                                fieldDest[i][j]=C_NOTHING;
                                
                        }
                        else{
                            fieldDest[i][j]=fieldSrc[i][j];
                        }
                    }
                }
               
            }
            
            for (i=0;i<pd.length;i++)
                if (pd[i].length>0 && pd[i].snakeStatus==IN_ACTION){
                    field[pd[i].headPos.y][pd[i].headPos.x]=(char)(i + C_PLAYERH_S);
                    
                }
             
            // System.out.println(this);  

        }
        public String toString(){
            StringBuffer ret=new StringBuffer(sizeY*sizeX);
            for (int i=0; i<sizeY;i++){
                for (int j=0;j<sizeX;j++){
                    ret.append((char)(field[i][j]+' '));
                }
                ret.append('\n');
            }
            return ret.toString();
            
            	
        }
    }
    private static class Gr_DiffArena extends Gr_Arena{
        public Gr_DiffArena(Gr_Arena a1,Gr_Arena a2){
            super(a1.sizeY,a1.sizeX,C_FLOOR);
            update(a1,a2);
        }
        public Gr_DiffArena(Gr_Arena a){
        	super(a.sizeY,a.sizeX);
            for (int i=0; i<a.sizeY;i++)
                for (int j=0;j<a.sizeX;j++){
                    field[i][j]= a.field[i][j];
                }
        }
        public void update(Gr_Arena a1,Gr_Arena a2){
            for (int i=a1.sizeY-1;i>=0;i--)
                for (int j=a1.sizeX-1;j>=0;j--)
                    field[i][j]=(a1.field[i][j]==a2.field[i][j])? 0 : a2.field[i][j];
        }

        
    }


    
    private static int frameC;
    private static long lastTime;
    private static float fps;
    
    protected static D_GameInfo oldGameInfo;
    
    protected static C_Human[] humans;
    protected static int humanPlayerC=1; 

    private static Gr_Arena arena[]=new Gr_Arena[2];
    private static int actArena=0;
    private static Gr_DiffArena diff;
 
    protected static int[] playerOrd;


    private static int last_killPoints[]=new int[10];
    private static int m_length[]=new int[10],m_killpoints[]=new int[10],m_cycles[]=new int[10],m_name[]=new int[10];

    protected static int lastPlayerC;
            
    protected static VolatileImage img_pTab[]=new VolatileImage[10];
    protected static VolatileImage img_tab[]=new VolatileImage[10];
    protected static Graphics2D gr_tab[]=new Graphics2D[10];
    
    protected static VolatileImage img_arena;
 
    private static Graphics actGraphics;

    
    //private D_GameInfo lastGameInfo=new D_GameInfo();


     
    
    protected static C_WindowMain menuFrame; 
    
    protected static C_WindowCommand commandFrame;

    protected static C_WindowArena arenaFS;
    protected static C_WindowPlayer playerFS;
    
    protected static C_WindowReplay replay;
    
    protected static C_WindowOptions options;
    
    protected static C_DebugMonitor debugMon;
    
    protected static GameParameter gameParam;
    
    
    /** Creates a new instance of C_GraphixEngineUI */
    public static void init(I_Main_interface calling,GameParameter p,C_DebugMonitor debMon,int version){
        C_GraphixData.version=version;
        C_GraphixData.main=calling;
    	gameParam=p;

    	C_GraphixTools.getLayout("pics/menu/skin.ini");
        if (C_GraphixTools.loadImages())
        	if(DEBUG)
        		System.out.println("Images loaded sucessfully!");

        	
	    	for (int i=0;i<10;i++){
	    	    img_pTab[i]=C_GraphixTools.createBackBufferVI(C_GraphixData.menuImages[M_TABOPEN].getWidth(null),C_GraphixData.menuImages[M_TABOPEN].getHeight(null));
	    	    img_tab[i]=C_GraphixTools.createBackBufferVI(C_GraphixData.menuImages[M_TABOPEN].getWidth(null),C_GraphixData.menuImages[M_TABOPEN].getHeight(null));
	    	    gr_tab[i]=img_tab[i].createGraphics();
	    	}
	        drawPlayerTab(new boolean[]{true,true,true,true,true,true,true,true,true,true});

        
	        menuFrame=new C_WindowMain();
	    	debugMon=debMon;
	    	arenaFS=new C_WindowArena();
	        playerFS=new C_WindowPlayer();
	        replay=new C_WindowReplay();
	        options=new C_WindowOptions();
	        commandFrame=new C_WindowCommand();
	        

	        
	        menuFrame.addWindowListener(new WindowAdapter(){
	            public void windowClosing(WindowEvent e){
	            	C_GraphixData.main.control("quit");
	            }
	        });
	
		    try{
		    menuFrame.addKeyListener(new KeyListener(){
		        public void keyTyped(KeyEvent e){}
		        public void keyPressed(KeyEvent e){
		            int key=e.getKeyCode(),i;
		
		            switch(key){
		           	case (KeyEvent.VK_ESCAPE):
		           		C_GraphixData.main.control("quit");
		           		return;
		           	case (KeyEvent.VK_F12):
		           		commandFrame.setVisible(!commandFrame.isVisible());
		            }
		           
		            for (i=0;i<humanPlayerC;i++){
		                if 			(key==humanPlayerKeyL[i]) humans[i].setNewDirection(PubConstants.MOVE_WEST);
		           	   	else if 	(key==humanPlayerKeyU[i]) humans[i].setNewDirection(PubConstants.MOVE_NORTH);
		           	   	else if 	(key==humanPlayerKeyR[i]) humans[i].setNewDirection(PubConstants.MOVE_EAST);
		           	   	else if 	(key==humanPlayerKeyD[i]) humans[i].setNewDirection(PubConstants.MOVE_SOUTH);
		            }
		        }
		        public void keyReleased(KeyEvent e){}
		    });
		    }catch(Exception e){}
	

	        
	
	        menuFrame.setVisible(true);
	        actGraphics=menuFrame.getGraphics();
    }
    private M_GraphixEngineUI(){}
    
    private static final void updateTexts(D_GameInfo gameInfo,Graphics g){
        int mode=F_NORMAL;
        final String leer6[]=new String[7];
        leer6[0]="      ";  leer6[1]="     ";leer6[2]="    ";leer6[3]="   ";leer6[4]="  ";leer6[5]=" ";leer6[6]="";

        StringBuffer tmpStrB=new StringBuffer(6);

        tmpStrB.append(gameInfo.gameTime);
        tmpStrB.insert(0,leer6[tmpStrB.length()]);
        C_GraphixTools.drawBitmapString(tmpStrB.toString(),C_GraphixData.intCoords[GAMETIME][0],C_GraphixData.intCoords[GAMETIME][1],M_FONTSERP8X14,g,ALLIG_RIGHT,mode);

        if (gameInfo.exitTime<=gameInfo.gameTime)
            mode=F_GREEN;
        else
            mode=F_NORMAL;
        
        tmpStrB.delete(0,6);
        tmpStrB.append(gameInfo.exitTime);
        tmpStrB.insert(0,leer6[tmpStrB.length()]);
        C_GraphixTools.drawBitmapString(tmpStrB.toString(),C_GraphixData.intCoords[EXITTIME][0],C_GraphixData.intCoords[EXITTIME][1],M_FONTSERP8X14,g,ALLIG_RIGHT,mode);
        
        if (gameInfo.suddenDeath<=gameInfo.gameTime)
            mode=F_RED;
        else
            mode=F_NORMAL;
        tmpStrB.delete(0,6);
        tmpStrB.append(gameInfo.suddenDeath);
        tmpStrB.insert(0,leer6[tmpStrB.length()]);
        C_GraphixTools.drawBitmapString(tmpStrB.toString(),C_GraphixData.intCoords[SUDDENDTIME][0],C_GraphixData.intCoords[SUDDENDTIME][1],M_FONTSERP8X14,g,ALLIG_RIGHT,mode);
        
        
    }
    
    private static final void updatePlayer(D_GameInfo gameInfo){
        D_PlayerData pd[]=gameInfo.playerData;
        int delta;
        if (gameInfo.gameRunning){
	        for (int i=0;i<pd.length;i++){
	        	delta=pd[i].killPoints-last_killPoints[i];
 	            if (delta<0){
 	                m_killpoints[i]=F_RED;
 	                last_killPoints[i]=pd[i].killPoints;
 	            }
	            else if (delta>0){
	                m_killpoints[i]=F_GREEN;
	                if (delta>100)
	                	last_killPoints[i]+=100;
	                else if (delta>10)
	                	last_killPoints[i]+=10;
	                else
	                	last_killPoints[i]++;
	            }

	        	if (pd[i].snakeStatus==IN_ACTION){
	                if (pd[i].delayChanged>0) m_cycles[i]=F_RED;
		            else if (pd[i].delayChanged<0)m_cycles[i]=F_GREEN;
		            else m_cycles[i]=F_NORMAL;
	             
		            if (pd[i].lengthChanged<0)m_length[i]=F_RED;
		            else if (pd[i].lengthChanged>0)m_length[i]=F_GREEN;
		            else m_length[i]=F_NORMAL;
		            
	 	            if (delta==0)m_killpoints[i]=F_NORMAL;
	
	 	            m_name[i]=F_NORMAL;
	          	
	        	}
	        	else{
	        		
	                if (delta==0){
		        		m_name[i]=F_INACTIVE;
		        		m_length[i]=F_INACTIVE;
		        		m_cycles[i]=F_INACTIVE;
		        		m_killpoints[i]=F_INACTIVE;
	                }
	                else{
	            		m_name[i]=F_NORMAL;
	            		m_length[i]=F_NORMAL;
	            		m_cycles[i]=F_NORMAL;
	                }
	        	}
	            //if gameInfo.gameTime
	        }
        }
        else{
	        for (int i=0;i<pd.length;i++){
	        	last_killPoints[i]=pd[i].killPoints;
	    		m_name[i]=F_NORMAL;
	    		m_length[i]=F_NORMAL;
	    		m_cycles[i]=F_NORMAL;
	    		m_killpoints[i]=F_NORMAL;
	        }
        }
    }





    
  /*  
    private void drawRanks(D_GameInfo gameInfo,Graphics g){
        for (int i=gameInfo.playerData.length-1;i>=0;i--){
            g.drawImage(menuImages[M_TABR],9,i*26+317,null);
            drawBitmapString(String.valueOf(i+1),30,323+i*26,M_FONTSERP8X14,g,ALLIG_RIGHT,F_NORMAL);
        }
    }
    //*/
    
    private static final void drawPlayerTab(boolean drawArray[]){
        int i;
        final int psX=40,psY=2;
        int valid;
//int n=0;
        Graphics2D g;



        for (i=0;i<10;i++){
        	if (drawArray[i]){
        		do{
        			//n=0;
	        		valid=img_pTab[i].validate(C_GraphixData.gc);
	        		
	        		if (valid!=VolatileImage.IMAGE_OK){
	        			//if (valid==VolatileImage.IMAGE_INCOMPATIBLE)
	        				img_pTab[i]=C_GraphixTools.createBackBufferVI(C_GraphixData.menuImages[M_TABOPEN].getWidth(null),C_GraphixData.menuImages[M_TABOPEN].getHeight(null));
	        		}
	                g=img_pTab[i].createGraphics();
	                C_GraphixTools.wantReadMenuImage(M_TABOPEN);
		            g.drawImage(C_GraphixData.menuImages[M_TABOPEN],0,0,null);
		            C_GraphixTools.wantReadGameImage(C_PLAYER_S);
		            g.drawImage(C_GraphixData.gameImages[C_PLAYER_S],psX,psY,psX+FIELDELEMSIZE,psY+FIELDELEMSIZE,FIELDELEMSIZE*i,0,FIELDELEMSIZE*(i+1),FIELDELEMSIZE,null,null);
		            g.drawImage(C_GraphixData.gameImages[C_PLAYER_S],psX,psY+FIELDELEMSIZE,psX+FIELDELEMSIZE,psY+2*FIELDELEMSIZE,FIELDELEMSIZE*i,FIELDELEMSIZE,FIELDELEMSIZE*(i+1),2*FIELDELEMSIZE,null,null);
		            g.drawImage(C_GraphixData.gameImages[C_PLAYER_S],psX-FIELDELEMSIZE,psY+FIELDELEMSIZE,psX,psY+2*FIELDELEMSIZE,FIELDELEMSIZE*i,FIELDELEMSIZE,FIELDELEMSIZE*(i+1),2*FIELDELEMSIZE,null,null);
		            g.drawImage(C_GraphixData.gameImages[C_PLAYER_S],psX-FIELDELEMSIZE,psY+2*FIELDELEMSIZE,psX,psY+3*FIELDELEMSIZE,FIELDELEMSIZE*i,FIELDELEMSIZE,FIELDELEMSIZE*(i+1),2*FIELDELEMSIZE,null,null);
		            g.dispose();
		            //if (n>0)System.out.println("drawPlayerTab 1 " + n);
		    	    //n++;
        		}while (img_pTab[i].contentsLost());
        	}
        	
        }
        
    }
    private static final void updatePlayerTab(D_GameInfo gameInfo){
        int i,j,r=1;
        
        int valid;
        boolean array[]=new boolean[10];
        
        D_PlayerData pd[]=new D_PlayerData[gameInfo.playerData.length];
        D_PlayerData tmpP;
        StringBuffer strB=new StringBuffer(13);
        
        //int n=0;
        //D_PlayerData tmp;
        int tmp;

        if (playerOrd==null || gameInfo.playerData.length!=playerOrd.length)
        	playerOrd=new int[gameInfo.playerData.length];
        //for (i=0;i<ord.length;i++)ord[i]=i;
        
        if (gameInfo.playerData.length>0){
	        pd[0]=gameInfo.playerData[0];
	        playerOrd[0]=0;
	        for (i=1;i<playerOrd.length;i++){
	            j=i;
	            playerOrd[i]=i;
	            //pd[i]=gameInfo.playerData[i];
	            pd[i]=gameInfo.playerData[i];
	            
	            while (j>0 && pd[playerOrd[j]].killPoints>(pd[playerOrd[j-1]]).killPoints){
	                //tmp=pd[j];pd[j]=pd[j-1];
	                tmp=playerOrd[j];playerOrd[j]=playerOrd[j-1];
	                playerOrd[--j]=tmp;
	            }
	        }
	
	        for (i=0;i<playerOrd.length;i++){
	        	//n=0;
	        	do{
		        	valid=img_tab[i].validate(C_GraphixData.gc);
		
		    		if (valid==VolatileImage.IMAGE_INCOMPATIBLE){
				    	img_tab[i]=C_GraphixTools.createBackBufferVI(C_GraphixData.menuImages[M_TABOPEN].getWidth(null),C_GraphixData.menuImages[M_TABOPEN].getHeight(null));
				    	gr_tab[i].dispose();
				    	gr_tab[i]=img_tab[i].createGraphics();
		    		}
		    		//do{
			        	if (img_pTab[playerOrd[i]].validate(C_GraphixData.gc)!=VolatileImage.IMAGE_OK){
			        		for (int k=0;k<10;k++)array[k]=false;
			        		array[i]=true;
			        		drawPlayerTab(array);
			        	}
		    		//}while(img_pTab[ord[i]].contentsLost());
		        		
		        		
		        		
		            gr_tab[i].drawImage(img_pTab[playerOrd[i]],0,0,null);
		
		            tmpP=pd[playerOrd[i]];
		            if (tmpP.name.length()>16){
		                strB.delete(0,13);
		                strB.append(tmpP.name.substring(0,12));
		                strB.append('.');
		                tmpP.name=strB.toString();
		            }
		            if (i>=1 && tmpP.killPoints!=pd[playerOrd[i-1]].killPoints) r++;
		            C_GraphixTools.drawBitmapString(String.valueOf(r),18,4,M_FONTSERP8X14,gr_tab[i],ALLIG_RIGHT,m_cycles[playerOrd[i]]);
		            
		            C_GraphixTools.drawBitmapString(tmpP.name,58,4,M_FONTSERP8X14,gr_tab[i],ALLIG_LEFT,m_name[playerOrd[i]]);
		            
		            if (tmpP.length<1000)
		            	C_GraphixTools.drawBitmapString(String.valueOf(tmpP.length),218,4,M_FONTSERP8X14,gr_tab[i],ALLIG_RIGHT,m_length[playerOrd[i]]);
		            else
		            	C_GraphixTools.drawBitmapString("WOW",218,4,M_FONTSERP8X14,gr_tab[i],ALLIG_RIGHT,m_length[playerOrd[i]]);
		            
		            C_GraphixTools.drawBitmapString(String.valueOf(tmpP.waitCycles),235,4,M_FONTSERP8X14,gr_tab[i],ALLIG_RIGHT,m_cycles[playerOrd[i]]);
		
		            C_GraphixTools.drawBitmapString(String.valueOf(last_killPoints[playerOrd[i]]),276,4,M_FONTSERP8X14,gr_tab[i],ALLIG_RIGHT,m_killpoints[playerOrd[i]]);
		            
		            //if (n>0)System.out.println("updatePlayerTab 1 " + n);
		    	    //n++;
	        	}while(img_tab[i].contentsLost());            
	        }
        }
        for (i=pd.length;i<10;i++){
        	
//n=0;
        	do{
        		valid=img_tab[i].validate(C_GraphixData.gc);
	    		if (valid==VolatileImage.IMAGE_INCOMPATIBLE){
			    	img_tab[i]=C_GraphixTools.createBackBufferVI(C_GraphixData.menuImages[M_TABOPEN].getWidth(null),C_GraphixData.menuImages[M_TABOPEN].getHeight(null));
			    	gr_tab[i].dispose();
			    	gr_tab[i]=img_tab[i].createGraphics();	    		}
	    		
	    		C_GraphixTools.wantReadMenuImage(M_TABCLOSE);
	    		gr_tab[i].drawImage(C_GraphixData.menuImages[M_TABCLOSE],0,0,null);
	    		
	    		//if (n>0)System.out.println("updatePlayerTab 2 " + n);
	    	    //n++;
        	}while (img_tab[i].contentsLost());
        }
        
    }

    
    protected static final void drawMenuElements(Graphics g,D_GameInfo gameInfo){
    	//int n=0;
    	for (int i=0;i<10;i++){
    		//n=0;
    		do{
	    		if (img_tab[i].validate(C_GraphixData.gc)!=VolatileImage.IMAGE_OK)
	    			updatePlayerTab(gameInfo);
	    		
	    		//if (n>0)System.out.println("drawMenuElements 1 " + n);
	    	    //n++;
    		}while (img_tab[i].contentsLost());
    		g.drawImage(img_tab[i],C_GraphixData.intCoords[PLAYERTAB01+i][0],C_GraphixData.intCoords[PLAYERTAB01+i][1],null);
    	}
    	updateTexts(gameInfo,g);
    	
    }
    protected static final void updateGraphics(){
        char actC;
        int i,j;
        int x,y=0,
        srcStartX=0,srcStartY=0,
        srcEndX=0,srcEndY=0,
        destEndX=FIELDELEMSIZE,destEndY=FIELDELEMSIZE,
        sy=diff.sizeY,sx=diff.sizeX;
        int imgID=0;
        Gr_Arena a=diff;
        boolean stillOK;
        
        int n=0;
        do{
        	stillOK=true;
        	
        	if (img_arena.validate(C_GraphixData.gc)!=VolatileImage.IMAGE_OK){
        		if (img_arena.validate(C_GraphixData.gc)==VolatileImage.IMAGE_INCOMPATIBLE){
        			if (img_arena!=null){
        				img_arena.flush();
        				img_arena=null;
        			}
        			img_arena=C_GraphixTools.createBackBufferVI(sx*FIELDELEMSIZE,sx*FIELDELEMSIZE);
        		}
        		a=arena[actArena];
        	}
	         
	        // System.out.println(diff);
	         i=0;
	         while (stillOK && i<sy){
	         	j=0;
	            x=0;
	            while (stillOK && j<sx){
	                actC=a.field[i][j];
	                if (actC>0){
	                    
	                    if (actC==C_FLOOR){
	                    	
	                        srcStartX=x%(C_GraphixData.gameImages[C_FLOOR].getWidth(null));
	                        srcStartY=y%(C_GraphixData.gameImages[C_FLOOR].getHeight(null));
	                        srcEndX=srcStartX+FIELDELEMSIZE;
	                        srcEndY=srcStartY+FIELDELEMSIZE;
	                        destEndX=x+FIELDELEMSIZE;
	                        destEndY=y+FIELDELEMSIZE;
	                        imgID=C_FLOOR;
	                    }
	                    else if	(actC>= C_WALL_S && actC<= C_WALL_E){
	                        srcStartX=(actC-C_WALL_S)*FIELDELEMSIZE;
	                        srcStartY=0;
	                        srcEndX=srcStartX+FIELDELEMSIZE;
	                        srcEndY=FIELDELEMSIZE;
	                        destEndX=x+FIELDELEMSIZE;
	                        destEndY=y+FIELDELEMSIZE;
	                        imgID=C_WALL_S;
	                    }
	                    else if (actC>= C_PLAYERH_S && actC<= C_PLAYERH_E){
	                        srcStartX=(actC-C_PLAYERH_S)*FIELDELEMSIZE;
	                        srcStartY=0;
	                        srcEndX=srcStartX+FIELDELEMSIZE;
	                        srcEndY=FIELDELEMSIZE;
	                        destEndX=x+FIELDELEMSIZE;
	                        destEndY=y+FIELDELEMSIZE;
	                        imgID=C_PLAYER_S;
	                    }
	                    else if (actC>= C_PLAYER_S && actC<= C_PLAYER_E){
	                        srcStartX=(actC-C_PLAYER_S)*FIELDELEMSIZE;
	                        srcStartY=FIELDELEMSIZE;
	                        srcEndX=srcStartX+FIELDELEMSIZE;
	                        srcEndY=srcStartY+FIELDELEMSIZE;
	                        destEndX=x+FIELDELEMSIZE;
	                        destEndY=y+FIELDELEMSIZE;
	                        imgID=C_PLAYER_S;
	                    }
	                    else if (actC>= C_GOODY_S && actC<= C_GOODY_E){
	                        srcStartX=(actC-C_GOODY_S)*FIELDELEMSIZE;
	                        srcStartY=0;
	                        srcEndX=srcStartX+FIELDELEMSIZE;
	                        srcEndY=FIELDELEMSIZE;
	                        destEndX=x+FIELDELEMSIZE;
	                        destEndY=y+FIELDELEMSIZE;
	                        imgID=C_GOODY_S;
	                    }
	                    else if (actC==C_EXIT){
	                        srcStartX=0;
	                        srcStartY=0;
	                        srcEndX=C_GraphixData.gameImages[C_EXIT].getWidth(null)/2;
	                        srcEndY=C_GraphixData.gameImages[C_EXIT].getHeight(null);
	                        destEndX=x+srcEndX;
	                        destEndY=y+srcEndY;
	
	                        imgID=C_EXIT;
	                        
	                    }
	                    else if (actC==C_EXITO){
	                        srcStartX=C_GraphixData.gameImages[C_EXIT].getWidth(null)/2;
	                        srcStartY=0;
	                        srcEndX=C_GraphixData.gameImages[C_EXIT].getWidth(null);
	                        srcEndY=C_GraphixData.gameImages[C_EXIT].getHeight(null);
	                        imgID=C_EXIT;
	                        destEndX=x+srcEndY;
	                        destEndY=y+srcEndY;
	
	                    }
	                    else{
	                        
	                        srcStartX=0;
	                        srcStartY=0;
	                        srcEndX=FIELDELEMSIZE;
	                        srcEndY=FIELDELEMSIZE;
	                        destEndX=x+FIELDELEMSIZE;
	                        destEndY=y+FIELDELEMSIZE;
	                        imgID=actC;
	                        if (C_GraphixData.gameImages[imgID]==null) imgID=C_UNKNOWN;
	                        
	                    }
	
	
	                    stillOK=C_GraphixTools.drawGameImageToBackbuffer(img_arena,imgID,x,y,destEndX,destEndY,srcStartX,srcStartY,srcEndX,srcEndY);
	                    //gr_arena.drawImage(img,x,y,destEndX,destEndY,srcStartX,srcStartY,srcEndX,srcEndY,null,null);
	                    //if (!complete)actGraphics.drawImage(img,monPosX+x,monPosY+y,monPosX+destEndX,monPosY+destEndY,srcStartX,srcStartY,srcEndX,srcEndY,null,null);
	                    //actGraphics.drawImage(gameImages[imgID],monPosX+x,monPosY+y,monPosX+destEndX,monPosY+destEndY,srcStartX,srcStartY,srcEndX,srcEndY,null,null);
	                }
	                j++;
	                x+=FIELDELEMSIZE;      
	            }
	            i++;
	            y+=FIELDELEMSIZE;
	         }
	         if (n>0)System.out.println("updateGraphics 1 " + n);
	    	    n++;
        }while (img_arena.contentsLost());
   }

    protected static final void checkActivations(D_GameInfo gameInfo){
    	int i;
    	
    	if (gameParam.getReplay()>0){
	    	menuFrame.butt_arena.setEnabled(false);
	    	menuFrame.butt_player.setEnabled(false);
	    	menuFrame.butt_options.setEnabled(false);
	    	replay.tgl_record.setEnabled(false);
	    	if (options.isVisible())options.setVisible(false);
	    	if (arenaFS.isVisible())arenaFS.setVisible(false);
	    	if (playerFS.isVisible())playerFS.setVisible(false);
    		for (i=0;i<MAX_PLAYERS;i++)
    		    menuFrame.butt_rmPlayer[i].setEnabled(false);

    		menuFrame.butt_run.setEnabled(true);
	    	if (gameInfo.gameRunning){
	    		if (gameInfo.gameState!=GAME_RUNNING)
	    			menuFrame.butt_run.setToggle(false,true);
	    		menuFrame.butt_stop.setEnabled(true);
	    		replay.butt_ejectReplay.setEnabled(false);
	    		replay.butt_loadReplay.setEnabled(false);
	    	}
	    	else{
	    	    menuFrame.butt_stop.setEnabled(false);
	    		replay.butt_ejectReplay.setEnabled(true);
	    		replay.butt_loadReplay.setEnabled(true);
	    	}
    	}
    	else{
	    	if (gameInfo.gameRunning){
	    		menuFrame.butt_run.setEnabled(true);
	    		arenaFS.butt_loadArena.setEnabled(false);
	    		playerFS.butt_addCPlayer.setEnabled(false);
	    		playerFS.butt_addHPlayer.setEnabled(false);
	    		menuFrame.butt_stop.setEnabled(true);
		    	replay.tgl_record.setEnabled(false);
	    		for (i=0;i<gameInfo.playerData.length;i++)
	    		    menuFrame.butt_rmPlayer[i].setEnabled(false);
	    		replay.butt_ejectReplay.setEnabled(false);
	    		replay.butt_loadReplay.setEnabled(false);
	    		
	    	}
	    	else{
	    		arenaFS.butt_loadArena.setEnabled(true);
	    		playerFS.butt_addCPlayer.setEnabled(true);
	    		playerFS.butt_addHPlayer.setEnabled(true);
	    		if (gameInfo.playerData.length>0 && gameInfo.level!=null)
	    		    menuFrame.butt_run.setEnabled(true);
	    		else
	    		    menuFrame.butt_run.setEnabled(false);
	    		
	    		menuFrame.butt_stop.setEnabled(false);
		    	replay.tgl_record.setEnabled(true);
	    		
	    		for (i=0;i<gameInfo.playerData.length;i++)
	    		    menuFrame.butt_rmPlayer[i].setEnabled(true);
	    		for (i=gameInfo.playerData.length;i<MAX_PLAYERS;i++)
	    		    menuFrame.butt_rmPlayer[i].setEnabled(false);
	    		replay.butt_ejectReplay.setEnabled(true);
	    		replay.butt_loadReplay.setEnabled(true);
	
	    	}

	    	menuFrame.butt_arena.setEnabled(true);
	    	menuFrame.butt_player.setEnabled(true);
	    	menuFrame.butt_options.setEnabled(true);

    	}
    	
	    menuFrame.butt_replay.setEnabled(true);
    	
    }
    public static final void setActive(boolean active){
        if (active){
        	checkActivations(oldGameInfo);
	        //butt_stop.setEnabled(true);
        }
        else{
            menuFrame.butt_run.setEnabled(false);
            menuFrame.butt_stop.setEnabled(false);
    		arenaFS.butt_loadArena.setEnabled(false);
    		playerFS.butt_addCPlayer.setEnabled(false);
    		playerFS.butt_addHPlayer.setEnabled(false);
	        for (int i=0;i<10;i++)
	        	if (i<playerOrd.length)
	        	    menuFrame.butt_rmPlayer[i].setEnabled(false);
        }
		        
    }

    public static final void updateDialogs(){
    	options.update(options.isVisible());
    	replay.update(replay.isVisible());
    }
	/* (non-Javadoc)
	 * @see de.farafin.snEADy.I_Control_interface#update(de.farafin.snEADy.communication.D_GameInfo)
	 */
	public static final void update(D_GameInfo gameInfo,C_Human[] humanPlayer) {

	    long time;
	    
	    if (DEBUG) time=System.currentTimeMillis();


	    humans=humanPlayer;
	    
	    if (humans!=null)
	        humanPlayerC=humans.length;
	    else humanPlayerC=0;
	    
	    

	    if (!gameInfo.gameRunning){
		    if (gameInfo.level==null){
		    	actGraphics.fillRect(C_GraphixData.intCoords[MONITOR][0],C_GraphixData.intCoords[MONITOR][1],ARENAMAXSIZE*FIELDELEMSIZE,ARENAMAXSIZE*FIELDELEMSIZE);
		    }
		    else{
		    	if (oldGameInfo==null || oldGameInfo.level==null || gameInfo.level.fileName.compareTo(oldGameInfo.level.fileName)!=0){
	    			C_GraphixTools.loadCustomLevelGraphix(gameInfo.level.fileName);

	    			if (arena[actArena]==null || arena[actArena].sizeX!=gameInfo.level.width || arena[actArena].sizeY!=gameInfo.level.height){   
	    				arena[actArena]=new Gr_Arena(gameInfo.level.playField,gameInfo);
	    				diff=new Gr_DiffArena(arena[actArena]);
				    	img_arena=C_GraphixTools.createBackBufferVI(arena[actArena].sizeX*FIELDELEMSIZE,arena[actArena].sizeY*FIELDELEMSIZE);
				    	menuFrame.monPosX=C_GraphixData.intCoords[MONITOR][0]+(ARENAMAXSIZE*FIELDELEMSIZE-arena[actArena].sizeX*FIELDELEMSIZE)/2;
				    	menuFrame.monPosY=C_GraphixData.intCoords[MONITOR][1]+(ARENAMAXSIZE*FIELDELEMSIZE-arena[actArena].sizeY*FIELDELEMSIZE)/2;
			
				    	menuFrame.monWidth=arena[actArena].sizeX*6;
				    	menuFrame.monHeight=arena[actArena].sizeY*6;
				        //if (monWidth>45)monWidth=45;
				        //if (monHeight>45)monHeight=45;
				        actGraphics.fillRect(C_GraphixData.intCoords[MONITOR][0],C_GraphixData.intCoords[MONITOR][1],ARENAMAXSIZE*FIELDELEMSIZE,menuFrame.monPosY-C_GraphixData.intCoords[MONITOR][1]);
				        actGraphics.fillRect(C_GraphixData.intCoords[MONITOR][0],menuFrame.monPosY,menuFrame.monPosX-C_GraphixData.intCoords[MONITOR][0],menuFrame.monHeight);
				        actGraphics.fillRect(menuFrame.monPosX+menuFrame.monWidth,menuFrame.monPosY,menuFrame.monPosX-C_GraphixData.intCoords[MONITOR][0],menuFrame.monHeight);
				        actGraphics.fillRect(C_GraphixData.intCoords[MONITOR][0],menuFrame.monPosY+menuFrame.monHeight,ARENAMAXSIZE*FIELDELEMSIZE,menuFrame.monPosY-C_GraphixData.intCoords[MONITOR][1]);
	    			}
	    			else{
	    				arena[actArena].update(gameInfo.level.playField,gameInfo);
	    				diff.update(arena[actArena].field);
	    			}
		
			    	//gr_arena.GraphicsConfiguration.createCompatibleImage(arena[actArena].sizeX*FIELDELEMSIZE,arena[actArena].sizeY*FIELDELEMSIZE);
		
			        
			        updateGraphics();
		
			    }
		    }
	    }
	    else{
	        if (arena[1-actArena]==null || arena[1-actArena].sizeX!=gameInfo.level.width || arena[1-actArena].sizeY!=gameInfo.level.height)
	            arena[1-actArena]=new Gr_Arena(gameInfo.level.playField,gameInfo);
	        else
	            arena[1-actArena].update(gameInfo.level.playField,gameInfo);
	       	diff.update(arena[actArena], arena[1-actArena]);

	        actArena=1-actArena;
	        
	        
	        updateGraphics();
	    }
    

	   
	    if (gameInfo.gameState!=GAME_RUNNING){
	    	checkActivations(gameInfo);
	    }
	    else{
	    	
	    }
	    	
    
	    lastPlayerC=gameInfo.playerData.length;
	    
        updatePlayer(gameInfo);
        updatePlayerTab(gameInfo);
        
        
        drawMenuElements(actGraphics,gameInfo);
        if (img_arena!=null)
        	actGraphics.drawImage(img_arena,menuFrame.monPosX,menuFrame.monPosY,null,null);
        
        
        if (oldGameInfo==null)
        	oldGameInfo=new D_GameInfo(gameInfo);
        else
        	oldGameInfo.copyOnMe(gameInfo);

        
        
        debugMon.sayBuffered();
        if (DEBUG){
	        lastTime+=(System.currentTimeMillis()-time);
	        frameC++;
	        if (frameC>=MAXFRAMECOUNT){
	            fps=1000.0f*frameC/lastTime;
	            DecimalFormat df=new DecimalFormat(".##");
	            //DecimalFormat df =new DecimalFormat( "0.00" );
	            System.out.println("DEBUG GraphixEngine FPS: " + df.format(fps));           // 12.345,68
	            frameC=0;
	            lastTime=0;
	        }
       
        
	    }//*/
	}
/*
	public void beep(){
		System.out.println("BEEP!!!");
	}
	public void beep(String str){
		System.out.println("BEEP: " + str);
	}
	public void beep(int i){
		System.out.println("BEEP: " + i);
	}
	//*/
}
