/*
 * Created on 24.02.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.farafin.snEADy.control.GaphixStuff;

import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.VolatileImage;

/** 
 * @author larsonmars
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */ 
public class GrTextField extends GrTextArea{
	
	
	protected boolean carr;
	protected boolean numbersOnly;
	protected String comm;
	protected GrTextField troot;
	public GrTextField(int x,int y,int maxC,String initText,int allig,boolean onlyNumbers,String command){
		this(x,y,maxC,1,initText,allig,onlyNumbers,command);
	}
	public GrTextField(int x,int y,int maxC,int maxL,String initText,int allig,boolean onlyNumbers,String command){
		super(x,y,maxC,maxL,initText,allig,true);
		troot=this;
		comm=command;
		numbersOnly=onlyNumbers;
		addFocusListener(new FocusListener(){
			public void focusLost(FocusEvent e){
				carr=false;
				if (numbersOnly && text.length()==0){
					text.append('0');
					repaint();
				}
				if (comm!=null)C_GraphixData.main.control(comm + text.toString());
				action();
				redraw();
			}
			public void focusGained(FocusEvent e){
				carr=true;
				redraw();
			}
		});
		addKeyListener(new KeyListener(){
			public void keyTyped(KeyEvent e){
				int c=e.getKeyChar();

				if (text.length()<text.capacity()-1 && c>' ' && c<='~'){
					if (!numbersOnly || (c>='0' && c<='9')){
						text.append(e.getKeyChar());
						redraw();
					}
				}
			}
			public void keyPressed(KeyEvent e){
				int c=e.getKeyCode();
				switch(c){
				case KeyEvent.VK_BACK_SPACE:
					if (text.length()>0)text.deleteCharAt(text.length()-1);
					redraw();
					break;
				case KeyEvent.VK_ENTER:
					if (numbersOnly && text.length()==0){
						text.append('0');
						//redraw();
					}
					troot.getFocusCycleRootAncestor().requestFocus();
					break;
				}
			}
			public void keyReleased(KeyEvent e){
				
			}
		});

		
		
	}
	public void redraw(){
		renderText();
		paint(getGraphics());
	}
	
	private void renderText(){
		Graphics g;
		StringBuffer drawT;
		int lineC=text.length()/columns;
		
		drawT=new StringBuffer(text.length()+lines);
		for (int i=0;i<=lineC;i++){
			drawT.append(text.substring(columns*i,(columns*(i+1)<text.length())? columns*(i+1):text.length()));
			if (i<lineC)
				drawT.append('\n');
		}
		
		if (carr)
			drawT.append((char)127);
		
		do{
    		if (img_text.validate(C_GraphixData.gc)==VolatileImage.IMAGE_INCOMPATIBLE){
    			img_text=C_GraphixTools.createBackBufferVI(showW,showH);
    		}
    		g=img_text.getGraphics();
    		if (drawMode==F_MARKED)
    			g.setColor(C_GraphixData.col_textbghighlighted);
    		else
    			g.setColor(C_GraphixData.col_textbgnormal);
    		
    		g.fillRect(0,0,showW,showH);
    		if (alligment==ALLIG_LEFT)
    			C_GraphixTools.drawBitmapString(drawT.toString(),0,0,M_FONTSERP8X14,g,ALLIG_LEFT,drawMode);
    		else
    			C_GraphixTools.drawBitmapString(drawT.toString(),showW,0,M_FONTSERP8X14,g,ALLIG_RIGHT,drawMode);
		}while(img_text.contentsLost());
	
	}
	
}
