/*
 * Created on 22.11.2004
 *
 */
package de.farafin.snEADy.communication;

/**
 * 2-dimensional vector datatype for calculating on the playfield
 * @author roland, lars
 *  
 * @version $Revision: 1.9 $
 */
public final class D_Vec2D
{
	/** Comment for <code>y</code> */
	public int y;
	/** Comment for <code>x</code> */
	public int x;

	
	
	/** default - constructor */
	public D_Vec2D()
	{
		super();
		this.x = 0;
		this.y = 0;
	}
	/** create - constructor
	 * @param y
	 * @param x
	 */
	public D_Vec2D(int y, int x)
	{
		super();
		this.y = y;
		this.x = x;
	}
	/** copy - concstructor
	 * @param vec
	 */
	public D_Vec2D(D_Vec2D vec)
	{
		super();
		this.y = vec.y;
		this.x = vec.x;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 */
	public Object clone()
	{
		return new D_Vec2D(this);
	}
	 
	/**
	 * @param a Vector a
	 * @param b Vector b
	 * 
	 * @return D_Vec2D: addition of a and b
	 */
	public static D_Vec2D add(D_Vec2D a, D_Vec2D b)
	{
		return new D_Vec2D(a.x + b.x, a.y + b.y);
	}
	/** @param a non static addition to the given vector */
	public void add(D_Vec2D a)
	{
		this.add(a.y, a.x);
	}
	
	/** add the values to the vector
	 * @param y add y (line)
	 * @param x add x (row)
	 */
	public void add(int y, int x)
	{
		this.y += y;
		this.x += x;
	}

	/** copys all data to the lokal instance. there is no new Instance created
	 * @param vec
	 */
	public void copyOnMe(D_Vec2D vec)
	{
		this.y = vec.y;
		this.x = vec.x;
	}
	
	/** manhatten distance: d = dy + dx
	 * @param vec
	 * @return v
	 */
	public int dist(D_Vec2D vec)
	{
		int tmp = 0, result = 0;
		tmp = vec.y - this.y;
		result += (tmp>=0)?tmp:-tmp;
		tmp = vec.x - this.x;
		result += (tmp>=0)?tmp:-tmp;
		return result;
	}
	

	/** manhatten distance: d = dy + dx with calculating the surface of the world as sphere
	 * @param vec
	 * @param height the playfield heiths
	 * @param width the playfield width
	 * @return v
	 */
	public int distWarp(D_Vec2D vec, int height, int width)
	{
		int directY = 0, directX = 0;
		int warpY = 0, warpX = 0;
		
		int tmp = 0, result = 0;
		
		
		tmp = vec.y - this.y;
		directY = (tmp>=0)? tmp : -tmp;
		tmp = vec.x - this.x;
		directX = (tmp>=0)? tmp : -tmp;

		warpY = height - directY;
		warpX = width - directX;
		
		result = 0;
		result += (directY < warpY)? directY : warpY;
		result += (directX < warpX)? directX : warpX;
		
		return result;
	}
	
	
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(D_Vec2D vec){return (vec.x == this.x && vec.y == this.y);}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString(){return ("[" + this.y + ", " + this.x + "]");}
}