/*
 * Created on 23.11.2004
 *
 */
package de.farafin.snEADy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Random;

import de.farafin.snEADy.communication.D_GameInfo;
import de.farafin.snEADy.communication.D_PlayerData;
import de.farafin.snEADy.communication.D_RecoverData;
import de.farafin.snEADy.communication.I_Constants;
import de.farafin.snEADy.player.Player;
import de.farafin.snEADy.player.*;
import de.farafin.snEADy.inOut.C_LogFileWriter;

/**
 * M_PlayerHandler manages the player that should play the game. it is necessary to controll the threads
 * and who is next to calculate.
 *
 * @author lars, roland
 *
 * @version $Revision: 1.75 $
 */
public final class M_PlayerHandler implements I_Constants
{
	//-------------------------------------------------------------------------------------
	//- internal Classes ------------------------------------------------------------------
	//-------------------------------------------------------------------------------------

    
	/** informations for the player
	 *
	 * @author roland, lars
	 */
	private class PlayerInfo
	{
		/** */
		public GameInfo playerGameInfo = null;
		/** */
		public LevelInfo playerLevelInfo = null;
		/** */
		public SnakeInfo[] playerSnakeInfo = null;
		/** */
		public OwnSnakeInfo playerOwnSnakeInfo = null;
	}


	
	private class PlayerRun implements Runnable
	{
		/** the player that should calculate its move */
		protected Player runningPlayer;
		protected boolean waiting;

		/** is set true after the player has finished his calculation */
		public boolean calculationFinished;

		/** if the player threw an exception, its noticed and the player is deleted */
		public boolean threwException;

		/** if the player threw an exception, it is stored here fore logging. */
		public Throwable thrownException;
		public final void renew(Player player){
			this.runningPlayer = player;
			this.calculationFinished = false;
			this.threwException = false;
			this.thrownException = null;
		}
		protected synchronized void awakePlayerRun(){notify();}
		/* (non-Javadoc)
		 * @see java.lang.Runnable#run()
		 */
		public void run(){
		    while (true){
		        synchronized(this){
					try {
					//    System.out.print("-- Thread WAIT ");
					    waiting=true;
						wait();
					}
					catch (InterruptedException e) {//System.out.println(" Player los!"+e);
					}
				    waiting=false;
				  //  System.out.print("-- Thread CONT ");
		        }

		        //Thread.yield();
				playerCalculationtime = -System.currentTimeMillis();
				//Thread.yield();

				try{
					this.runningPlayer.startCalculation(playerInfo.playerGameInfo, playerInfo.playerLevelInfo, playerInfo.playerSnakeInfo, playerInfo.playerOwnSnakeInfo);
				}
				catch(ThreadDeath e)
				{throw e;}
				catch(Throwable e)
				{
					e.printStackTrace();
					this.threwException = true;
					this.thrownException = e;
				}
				playerCalculationtime += System.currentTimeMillis();

			    //System.out.print("  -- calc fertig!" + playerCalculationtime);
				synchronized (this){
				    this.calculationFinished = true;
				}

			   // synchronized(M_GameEngine.getInstance()){
				//M_GameEngine.getInstance().interrupt();
			    awakePlayerHandler();
//				}
		    }
		}
	}
	
	//-------------------------------------------------------------------------------------
	//- attributes ------------------------------------------------------------------------
	//-------------------------------------------------------------------------------------

	// player attributes
	/** Instances of the Player-Classes. Its a reference copy from GameEngine. */
	private Player[] playerInstances;

	/** Index of the last player who was calculated. */
	private int lastPlayer;

	/** the thread of the player who is actually calculated */
	private PlayerRun playerRun;

	/** the thread of the player who is actually calculated */
	protected Thread playerThread;

	// others
	/** Comment for <code>inst</code> */
	protected static M_PlayerHandler instance;

	/** flag if game was imergency paused */
	private boolean imergencyPaused = false;

	/** a prototype of playerInfo, so it doesnt need to be a new instance constructed every time. */
	protected final PlayerInfo playerInfo;

	/** mesures the time a player needs to calculate its moove. */
	protected long playerCalculationtime = 0;

	/** a logfile to safe the players moves */
	private C_LogFileWriter playerLog;

	/** random number generator for controll time */
	private Random randNumber = null;

	/** the gameTime when the next time the size of player should be checked */
	private long nextSizeControllTime = 0;

	/** for storing the information of which player should be controlled the space nextMemCheck */
	private int nextMemCheck = 0;

	/** parameter set of GameParameter */
	private final GameParameter parameter;
	//-------------------------------------------------------------------------------------
	//- constructor -----------------------------------------------------------------------
	//-------------------------------------------------------------------------------------

	/** default constructor
	 */
	private M_PlayerHandler()
	{
		this.playerInstances = null;
		this.parameter = M_Main.getInstance().getParameter();
		this.imergencyPaused = false;
		this.lastPlayer = -1;
		this.playerInfo = new PlayerInfo();
		this.playerLog = null;
		this.playerRun=new PlayerRun();
		this.playerThread = new Thread(this.playerRun);
		this.playerThread.start();
	}

	//-------------------------------------------------------------------------------------
	//- private methods -------------------------------------------------------------------
	//-------------------------------------------------------------------------------------


	/** regenerate Player Info. it is no new instance build, but if the length some
	 * arrays doesnt fit, it will be renewed.
	 *
	 * @param playerIndex
	 * @param gameInfo
	 */
	private void reGenPlayerInfo(int playerIndex, D_GameInfo gameInfo)
	{
		int j = 0;

		if(this.playerInfo.playerSnakeInfo == null || this.playerInfo.playerSnakeInfo.length != gameInfo.playerData.length-1)
		{
			this.playerInfo.playerSnakeInfo = new SnakeInfo[this.playerInstances.length-1];
			for(int i=0; i < this.playerInfo.playerSnakeInfo.length; i++)
			{
				this.playerInfo.playerSnakeInfo[i] = new SnakeInfo();
			}
		}
		for(int i = 0; i < this.playerInfo.playerSnakeInfo.length+1; i++)
		{
			if(i==playerIndex)
			{
				j = 1;
				continue;
			}
			//if(DEBUG) System.out.println("DEBUG M_PlayerHandler: \n\ti:" + i + "\n\tj:" + j + "\n\tp:" + this.playerInfo.otherSnakes[i-j] + "\n\tg:" + gameInfo.playerData[i]);
			this.playerInfo.playerSnakeInfo[i-j].playerName = gameInfo.playerData[i].name;
			this.playerInfo.playerSnakeInfo[i-j].snakeChar = gameInfo.playerData[i].ownChar;
			this.playerInfo.playerSnakeInfo[i-j].headPosLine = gameInfo.playerData[i].headPos.y;
			this.playerInfo.playerSnakeInfo[i-j].headPosRow = gameInfo.playerData[i].headPos.x;
			this.playerInfo.playerSnakeInfo[i-j].points = gameInfo.playerData[i].killPoints;
			this.playerInfo.playerSnakeInfo[i-j].snakeLength = gameInfo.playerData[i].length;
			this.playerInfo.playerSnakeInfo[i-j].snakeStatus = gameInfo.playerData[i].snakeStatus;
			switch(gameInfo.playerData[playerIndex].snakeStatus)
			{
				case IN_ACTION:
				case IN_HEAVEN:
				case IN_EXIT:
					this.playerInfo.playerSnakeInfo[i-j].snakeStatus = gameInfo.playerData[i].snakeStatus;
					break;
				default:
					this.playerInfo.playerSnakeInfo[i-j].snakeStatus = IN_HEAVEN;
			}
			this.playerInfo.playerSnakeInfo[i-j].waitCycles = gameInfo.playerData[i].waitCycles;
		}

		if(this.playerInfo.playerOwnSnakeInfo == null) this.playerInfo.playerOwnSnakeInfo = new OwnSnakeInfo();
		this.playerInfo.playerOwnSnakeInfo.playerName = gameInfo.playerData[playerIndex].name;
		this.playerInfo.playerOwnSnakeInfo.snakeChar = gameInfo.playerData[playerIndex].ownChar;
		this.playerInfo.playerOwnSnakeInfo.headPosLine = gameInfo.playerData[playerIndex].headPos.y;
		this.playerInfo.playerOwnSnakeInfo.headPosRow = gameInfo.playerData[playerIndex].headPos.x;
		this.playerInfo.playerOwnSnakeInfo.points = gameInfo.playerData[playerIndex].killPoints;
		this.playerInfo.playerOwnSnakeInfo.snakeLength = gameInfo.playerData[playerIndex].length;
		this.playerInfo.playerOwnSnakeInfo.waitCycles = gameInfo.playerData[playerIndex].waitCycles;
		this.playerInfo.playerOwnSnakeInfo.nextMoveTime = gameInfo.playerData[playerIndex].nextUpdateTime;
		this.playerInfo.playerOwnSnakeInfo.lastCalculatedMemUsage = gameInfo.playerData[playerIndex].lastCalculatedMemUsage ;
		switch(gameInfo.playerData[playerIndex].snakeStatus)
		{
			case IN_ACTION:
			case IN_HEAVEN:
			case IN_EXIT:
				this.playerInfo.playerOwnSnakeInfo.snakeStatus = gameInfo.playerData[playerIndex].snakeStatus;
				break;
			default:
				this.playerInfo.playerOwnSnakeInfo.snakeStatus = IN_HEAVEN;
		}
		this.playerInfo.playerOwnSnakeInfo.headDirection = gameInfo.playerData[playerIndex].watchDirection;

		this.playerInfo.playerLevelInfo.levelName = gameInfo.level.name;
		this.playerInfo.playerLevelInfo.height = gameInfo.level.height;
		this.playerInfo.playerLevelInfo.width = gameInfo.level.width;
		this.playerInfo.playerLevelInfo.playField = gameInfo.level.playField;

		this.playerInfo.playerGameInfo.gameTime = this.parameter.getGameTime();
		this.playerInfo.playerGameInfo.exitTime = this.parameter.getExit_time();
		this.playerInfo.playerGameInfo.suddenDeathTime = this.parameter.getSuddend_time();
		this.playerInfo.playerGameInfo.thinkingMS = this.parameter.getMax_thinking_ms();
		this.playerInfo.playerGameInfo.analyseMS = this.parameter.getAnalyse_ms();
		this.playerInfo.playerGameInfo.maxMem = this.parameter.getMax_player_mem();
		this.playerInfo.playerGameInfo.damage_points_radius = this.parameter.getDamage_points_radius();
		this.playerInfo.playerGameInfo.kill_points_radius = this.parameter.getKill_points_radius();
		this.playerInfo.playerGameInfo.kill_point_goodies = this.parameter.getKill_point_goodies();
		this.playerInfo.playerGameInfo.damage_length_grow = this.parameter.getDamage_length_grow();
		this.playerInfo.playerGameInfo.min_move_delay = this.parameter.getMin_move_delay();
		this.playerInfo.playerGameInfo.max_move_delay = this.parameter.getMax_move_delay();
		this.playerInfo.playerGameInfo.auto_grow_delay = this.parameter.getAuto_grow_delay();
		this.playerInfo.playerGameInfo.auto_slowdown_delay = this.parameter.getAuto_slowdown_delay();
		this.playerInfo.playerGameInfo.max_goody_occ_delay = this.parameter.getMax_goody_occ_delay();
		this.playerInfo.playerGameInfo.goody_speed_occ = this.parameter.getGoody_speed_occ();
		this.playerInfo.playerGameInfo.goody_slowdown_occ = this.parameter.getGoody_slowdown_occ();
		this.playerInfo.playerGameInfo.goody_length_occ = this.parameter.getGoody_length_occ();
		this.playerInfo.playerGameInfo.goody_points_occ = this.parameter.getGoody_points_occ();
		this.playerInfo.playerGameInfo.goody_shorter_occ = this.parameter.getGoody_shorter_occ();
		this.playerInfo.playerGameInfo.goody_length_value = this.parameter.getGoody_length_value();
		this.playerInfo.playerGameInfo.goody_points_value = this.parameter.getGoody_points_value();
		this.playerInfo.playerGameInfo.goody_shorter_value = this.parameter.getGoody_shorter_value();
		this.playerInfo.playerGameInfo.survival_points = this.parameter.getSurvival_points();
		this.playerInfo.playerGameInfo.easy_points = this.parameter.getEasy_points();
	}

	//-------------------------------------------------------------------------------------
	//- public methods --------------------------------------------------------------------
	//-------------------------------------------------------------------------------------

	/**
	 * @param players
	 */
	protected void initGame(Player[] players, C_LogFileWriter playerLog)
	{
		this.playerInstances = players;
		this.playerLog = playerLog;
		this.playerLog.storeLine( "start Game\n" +
								"Player:");

		this.playerInfo.playerGameInfo = new GameInfo();
		this.playerInfo.playerLevelInfo = new LevelInfo();
		this.playerInfo.playerSnakeInfo = new SnakeInfo[players.length];
		this.playerInfo.playerOwnSnakeInfo = new OwnSnakeInfo();

		for(int i= 0; i<players.length; i++)
		{
			if(players[i] != null) this.playerLog.storeLine(i+": " + players[i].getName());
			this.playerInfo.playerSnakeInfo[i] = new SnakeInfo();
		}
		this.playerLog.storeLine("-----------------------------------------------------------------------\n");

		this.randNumber = new Random();
		this.nextSizeControllTime = (long)(this.randNumber.nextDouble()*this.parameter.getMax_mem_check_delay());
		if(DEBUG) System.out.println("DEBUG M_GameEngine.M_GameEngine: nextSizeControllTime = " + this.nextSizeControllTime);


	}

	/**
	 * @param recoverData
	 */
	protected void recover(D_RecoverData recoverData)
	{
	// TODO Auto-generated method stub
	}
	protected synchronized void awakePlayerHandler(){
	    //System.out.print("-- ! ");
	    notify();
	}

	/** This methods organizes the player calculation.
	 * @param gameInfo
	 * @param playerData
	 */
	protected synchronized void runPlayer(D_GameInfo gameInfo, D_PlayerData[] playerData)
	{

		//if(this.ownGameTime >= 100) System.out.println("WARNING: 100 holdPlayer!" + lastPlayer);

		long thinkingTime, totalTime,avgTime;
		boolean exident = false;
		

		ByteArrayOutputStream baos = null;
		String logString1 = "";
		String logString2 = "";

		ObjectOutputStream oos = null;

		if(gameInfo.playerData.length <= 0)return;
		this.lastPlayer = (this.lastPlayer+1) % gameInfo.playerData.length;

		if(gameInfo.playerData[this.lastPlayer].snakeStatus != IN_ACTION)
		{
			if(this.lastPlayer == this.nextMemCheck) this.nextMemCheck = (this.nextMemCheck+1)%this.playerInstances.length;

			return;
		}

		// if the snake is still in action on the playfield
		if(this.parameter.getPlayer_controlling() == 0)
		{
			logString1 += "gameTime:  " + this.parameter.getGameTime() + "\tPlayer " + this.lastPlayer;

			this.reGenPlayerInfo(this.lastPlayer, gameInfo);
			this.playerCalculationtime=-System.currentTimeMillis();
			try
			{
				this.playerInstances[this.lastPlayer].startCalculation(this.playerInfo.playerGameInfo, this.playerInfo.playerLevelInfo, this.playerInfo.playerSnakeInfo, this.playerInfo.playerOwnSnakeInfo);
			}
			catch(ThreadDeath e)
			{throw e;}
			catch(Throwable e)
			{
				e.printStackTrace();
			}
			this.playerCalculationtime+=System.currentTimeMillis();
			playerData[this.lastPlayer].turnDirection = this.playerInstances[this.lastPlayer].getTurnDirection();
			if(this.parameter.getGameTime() == 0 || playerData[this.lastPlayer].nextUpdateTime <= this.parameter.getGameTime()) playerData[this.lastPlayer].move = true;


			logString1 += "\t needed  ms: " + this.playerCalculationtime + "\tturn direction: " + playerData[this.lastPlayer].turnDirection;
			this.playerLog.storeLine(logString1);
			return;
		}


		logString1 += "gameTime:  " + this.parameter.getGameTime() + "\tPlayer " + this.lastPlayer;
		//System.out.println("calculate!!");
		this.reGenPlayerInfo(this.lastPlayer, gameInfo);
		//if(DEBUG) System.out.println("DEBUG M_PlayerHandler: overHere!! ("+ gameInfo.gameTime +")");

	    this.playerRun.renew(this.playerInstances[this.lastPlayer]);
		thinkingTime = this.parameter.getMax_thinking_ms() + ((this.parameter.getGameTime() == 0)? this.parameter.getAnalyse_ms() : 0);
		totalTime=thinkingTime+this.parameter.getTolerance_ms();
		try{
	//		System.out.print("-- HandlerWait for "+ 10*totalTime);
	        playerRun.awakePlayerRun();
			//playerThread.interrupt();
			//	synchronized(this){
			wait(100*totalTime);
		}
		catch(InterruptedException e){
//			System.out.print("-- HandlerInterrupt ");
		}

		//if(this.ownGameTime >= 100) System.out.println("WARNING: run finished" + lastPlayer);


	
		// if the player has finsished his moove
		if(this.playerRun.calculationFinished){
		    //Wait for the playerThread to go in its wait state
			while(!playerRun.waiting){
			  //  System.out.print('*');
			    try{wait(10);}catch(InterruptedException e){}
			}
			if (this.parameter.getGameTime() > 0){
			    avgTime=(this.playerCalculationtime+playerData[this.lastPlayer].lastCalculatedTime)>>1;
			    playerData[this.lastPlayer].lastCalculatedTime=avgTime;
			}
			else
			    avgTime=this.playerCalculationtime;
			
			
			
		    // Check if he is totally outa time.
			if(avgTime>totalTime){
			    if ((this.parameter.getTimekill() == 1)){
					playerData[this.lastPlayer].snakeStatus = IN_ERROR_TIME;
					exident = true;
					System.out.println("WARNING: gameTime " + this.parameter.getGameTime() + "Player " + this.lastPlayer + " did not finish calculation in time and was deleted!! \t Calculation needed " +  this.playerCalculationtime + " ms --> average: "+ avgTime + " ms");
					logString2 += "\t- Player did not finish calculation in time and was deleted!! \t Calculation needed " + this.playerCalculationtime + " ms --> average: "+ avgTime + " ms\n";
			    }
			    else{
			        logString2 += "\t- Player did not finish calculation in time!\n";
			    }
			}
		    //Player needed the tolerance?
			else if(avgTime>thinkingTime){
				logString2 += "\t- Player finished calculations in the nick of time! (Tolerance: " + totalTime + " ms)\n";
			}
			
		}
		else{
		    if (playerRun.waiting){
		        System.out.println("--- snEADy Thread Error!!! ---");
		        System.exit(1);
		    }
		    if(this.parameter.getTimekill() == 1){
				// sais that the player guilted an error
				playerData[this.lastPlayer].snakeStatus = IN_ERROR_TIME;
				exident = true;
				// kills the Thread. (unfortunatelly its depricated)
				this.playerThread.stop();
				this.playerCalculationtime = System.currentTimeMillis() - this.playerCalculationtime;
				// set the player instance to null.. a case for the garbage collector!

				System.out.println("WARNING: gameTime " + this.parameter.getGameTime() + "Player " + this.lastPlayer + " did not finish calculation in time and was deleted!! \t Calculation stopped at " +  this.playerCalculationtime + " ms");

				logString2 += "\t- Player did not finish calculation in time and was deleted!! \t Calculation stopped after " + this.playerCalculationtime + " ms\n";

				this.playerThread=null;
				this.playerRun=null;
				this.playerInstances[this.lastPlayer] = null;

				this.playerRun=new PlayerRun();
				this.playerThread=new Thread(this.playerRun);

				this.playerThread.start();
			}
		    else{
			    /* Wait for Player */
			    try{
			        while(!this.playerRun.calculationFinished)
			            this.wait();
				}
		        catch(InterruptedException e){}
	        }
		}
		if(!exident){//No Timekill
		   // System.out.println("HandlerDone!");
			logString1 += "\t needed  ms: " + this.playerCalculationtime + "\tavg: " + playerData[this.lastPlayer].lastCalculatedTime + "\tturn direction: " + playerData[this.lastPlayer].turnDirection;
			if(this.parameter.getPrint_calc_ms() == 1)  System.out.println(logString1 + "\n");

			// tell the snake which direction to move.
			if(this.playerInstances[this.lastPlayer] != null) playerData[this.lastPlayer].turnDirection = this.playerInstances[this.lastPlayer].getTurnDirection();
			// tell the snake that it can move
			if(this.parameter.getGameTime() == 0 || playerData[this.lastPlayer].nextUpdateTime <= this.parameter.getGameTime()) playerData[this.lastPlayer].move = true;

			
		    if (this.playerRun.threwException){
				playerData[this.lastPlayer].snakeStatus = IN_ERROR_EXC;
		
				exident = true;
				System.out.println("WARNING: gameTime " + this.parameter.getGameTime() + "Player " + this.lastPlayer + " threw an exception. he was deleted!!");
		
				logString2 += "\t- Player threw an exception. he was deleted!!\n";
				logString2 += "\t- " + this.playerRun.thrownException.toString() + "\n";
		
				this.playerInstances[this.lastPlayer] = null;
				//this.playerThread = null;
				//this.playerRun = null;
			}
		// check players Space
		    if(this.parameter.getMemkill() == 1){
				if(this.parameter.getMax_player_mem() > 0 && (this.parameter.getGameTime() >= this.nextSizeControllTime && this.lastPlayer == this.nextMemCheck))
				{
					this.nextMemCheck = (this.nextMemCheck+1)%this.playerInstances.length;
					baos = new ByteArrayOutputStream();
	
					if(playerData[this.lastPlayer].snakeStatus == IN_ACTION && !this.playerInstances[this.lastPlayer].getClass().getName().endsWith("C_Human"))
					{
						//time = -System.currentTimeMillis();
						this.nextSizeControllTime = this.parameter.getGameTime() + (long)(this.randNumber.nextDouble()*this.parameter.getMax_mem_check_delay());
	
						try
						{
							oos = new ObjectOutputStream(baos);
							oos.writeObject(this.playerInstances[this.lastPlayer]);
							oos.close();
							oos = null;
	
							logString2 += "\t-needed kB: " + baos.size()/1024 + "\n";
	
							if(baos.size() > (this.parameter.getMax_player_mem() << 10))
							{
								System.out.println("WARNING: gameTime " + this.parameter.getGameTime() + " Player " + this.lastPlayer + " needed too much space and was deleted!!\n");
	
								logString2 += "Player needed too much space and was deleted!!\n";
	
								playerData[this.lastPlayer].snakeStatus = IN_ERROR_SPACE;
								exident = true;
								this.playerInstances[this.lastPlayer] = null;
	
	
							}
							else
							{
								playerData[this.lastPlayer].lastCalculatedMemUsage = baos.size();
							}
							baos.reset();
	
							if(this.parameter.getPrint_player_mem() == 1)  System.out.println(logString1 + "\n" + logString2 + "\n");
						}
						catch(IOException e)
						{
							e.printStackTrace();
						}
	
						/*
						// run the GC
						System.runFinalization();
						try{Thread.sleep(100);}
						catch (InterruptedException e){}
						System.gc();
	
						 */
					}
				}
		    }
		}


		this.playerLog.storeLine(logString1);
		this.playerLog.storeLine(logString2);
	}



	/** abborts the game */
	protected void abbort()
	{
		this.playerLog.storeLine("end Game");
		this.playerInfo.playerGameInfo = null;
		this.playerInfo.playerLevelInfo = null;
		this.playerInfo.playerOwnSnakeInfo = null;
		this.playerInfo.playerSnakeInfo = null;
		this.playerInstances = null;
		this.playerThread = null;
		if(this.parameter.getLogging() == 1) this.playerLog.saveAndCloseFile();
	}

	/** */
	protected void imergencyPause()
	{
		if(!this.imergencyPaused)
		{
			this.imergencyPaused = true;
			if(this.playerThread != null && this.playerThread.isAlive())
			{
				this.playerLog.storeLine("SUSPEND!! SystemTime: " + System.currentTimeMillis());
				this.playerThread.suspend();
			}
		}
		else
		{
			this.imergencyPaused = false;
			if(this.playerThread != null && this.playerThread.isAlive())
			{
				this.playerLog.storeLine("RESUME!! SystemTime: " + System.currentTimeMillis());
				this.playerThread.resume();
			}
		}
	}

	/** */
	protected void kill()
	{
		if(this.playerThread != null && this.playerThread.isAlive())
		{
			this.playerThread.stop();
		}
	}
	//-------------------------------------------------------------------------------------
	//- public static methods -------------------------------------------------------------
	//-------------------------------------------------------------------------------------

	/**
	 * prevents that more than one instance of the class exists in the program
	 *
	 * @return a new instance if it doesnt already exist, if so, it returns the old one
	 */
	protected static M_PlayerHandler getInstance()
	{
		if(instance == null) instance = new M_PlayerHandler();
		return instance;
	}


	/**
	 * @param playerHandler
	 */
	protected static void destroyInstance(M_PlayerHandler playerHandler)
	{
		playerHandler.imergencyPaused = false;
		playerHandler.lastPlayer = -1;
		playerHandler.playerInstances = null;
		playerHandler.nextSizeControllTime = -1;
		playerHandler.randNumber = null;
		if(playerHandler.playerThread != null && playerHandler.playerThread.isAlive())
		    playerHandler.playerThread.stop();
		playerHandler.playerThread = null;
		instance = null;

	}

}