/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.world;

import de.farafin.snEADy.GameParameter;
import de.farafin.snEADy.communication.D_GameInfo;
import de.farafin.snEADy.communication.D_Level;
import de.farafin.snEADy.communication.D_PlayerData;
import de.farafin.snEADy.communication.D_Vec2D;
import de.farafin.snEADy.communication.I_Constants;
import de.farafin.snEADy.communication.I_PlayFieldConstants;
import de.farafin.snEADy.inOut.I_RecordConstants;
import de.farafin.snEADy.world.C_Arena;
import de.farafin.snEADy.world.C_GLength;
import de.farafin.snEADy.world.C_GPoints;
import de.farafin.snEADy.world.C_GSpeed;
import de.farafin.snEADy.world.C_GameObject;
import de.farafin.snEADy.world.C_Goody;
import de.farafin.snEADy.world.I_World_interface;
import java.util.Random;

public final class C_World
implements I_World_interface,
I_Constants,
I_PlayFieldConstants,
I_RecordConstants {
    private final C_Arena arena;
    private long nextGoodyTime = 0L;
    private Random randNextGoodyTime;
    private Random randGoody;
    private final GameParameter parameter;
    private long lastSDTime = 0L;
    private D_PlayerData[] recPlayerData = null;
    private D_Level recLevel = null;
    private long recExitTime = 0L;
    private long recSDTime = 0L;
    private byte[] recBuffer = null;

    public C_World(D_GameInfo gameInfo, GameParameter parameter) {
        this.parameter = parameter;
        this.arena = new C_Arena(gameInfo, parameter);
        this.randNextGoodyTime = new Random();
        this.randGoody = new Random((long)((double)System.currentTimeMillis() * this.randNextGoodyTime.nextDouble()));
        this.nextGoodyTime = gameInfo.gameTime + (long)this.randNextGoodyTime.nextInt(parameter.getMax_goody_occ_delay());
        this.recBuffer = new byte[65536];
        if (parameter.getRecord() == 1) {
            this.recPlayerData = new D_PlayerData[gameInfo.playerData.length];
            int i = 0;
            while (i < this.recPlayerData.length) {
                this.recPlayerData[i] = (D_PlayerData)gameInfo.playerData[i].clone();
                ++i;
            }
        } else {
            this.recPlayerData = null;
            this.recLevel = null;
        }
        this.recLevel = this.generateLevel();
        this.recExitTime = this.parameter.getExit_time();
        this.recSDTime = this.parameter.getSuddend_time();
    }

    private void placeGoody(D_GameInfo gameInfo) {
        D_Vec2D vec = new D_Vec2D();
        int trys = 0;
        int radnomNumber = 0;
        int i = 0;
        C_Goody goody = null;
        int tmpNextIntVal = this.parameter.getGoody_speed_occ() + this.parameter.getGoody_slowdown_occ() + this.parameter.getGoody_length_occ() + this.parameter.getGoody_points_occ() + this.parameter.getGoody_shorter_occ();
        trys = 0;
        while (trys < 5) {
            vec.y = this.randGoody.nextInt(this.arena.getHeight());
            vec.x = this.randGoody.nextInt(this.arena.getWidth());
            if (this.arena.isFree(vec)) break;
            ++trys;
        }
        if (tmpNextIntVal > 0 && (trys < 5 || this.arena.updateFreeFieldVec(false) > 0)) {
            if (trys >= 5) {
                vec = this.arena.randFreeField();
            }
            radnomNumber = this.randGoody.nextInt(tmpNextIntVal);
            int range = 0;
            i = 0;
            while (i < 1) {
                if (radnomNumber < (range += this.parameter.getGoody_speed_occ())) {
                    goody = new C_GSpeed(vec, -1, this.parameter);
                    break;
                }
                if (radnomNumber < (range += this.parameter.getGoody_slowdown_occ())) {
                    goody = new C_GSpeed(vec, 1, this.parameter);
                    break;
                }
                if (radnomNumber < (range += this.parameter.getGoody_length_occ())) {
                    goody = new C_GLength(vec, this.parameter.getGoody_length_value(), this.parameter);
                    break;
                }
                if (radnomNumber < (range += this.parameter.getGoody_points_occ())) {
                    goody = new C_GPoints(vec, this.parameter.getGoody_points_value(), this.parameter);
                    break;
                }
                if (radnomNumber < (range += this.parameter.getGoody_shorter_occ())) {
                    goody = new C_GLength(vec, -this.parameter.getGoody_shorter_value(), this.parameter);
                    break;
                }
                ++i;
            }
            this.arena.objectAdd(goody);
        }
        this.nextGoodyTime = gameInfo.gameTime + (long)this.randNextGoodyTime.nextInt(this.parameter.getMax_goody_occ_delay());
    }

    public void recordGameCycle(D_GameInfo gameInfo) {
        int cycleBytes = 0;
        int tmpCycleBytes = 0;
        int fieldChangeCounter = 0;
        byte tmpByte = 0;
        int direction = 0;
        int tmpInt = 0;
        boolean changed = false;
        cycleBytes = 2;
        fieldChangeCounter = 0;
        changed = false;
        tmpCycleBytes = cycleBytes + 3;
        int i = 0;
        while (i < gameInfo.level.height) {
            int j = 0;
            while (j < gameInfo.level.width) {
                if (this.recLevel.playField[i][j] != gameInfo.level.playField[i][j]) {
                    changed = true;
                    this.recBuffer[tmpCycleBytes++] = (byte)i;
                    this.recBuffer[tmpCycleBytes++] = (byte)j;
                    this.recBuffer[tmpCycleBytes++] = (byte)(gameInfo.level.playField[i][j] - this.recLevel.playField[i][j]);
                    ++fieldChangeCounter;
                }
                ++j;
            }
            ++i;
        }
        if (changed) {
            this.recBuffer[cycleBytes++] = -96;
            this.recBuffer[cycleBytes++] = (byte)(fieldChangeCounter >> 8);
            this.recBuffer[cycleBytes++] = (byte)fieldChangeCounter;
            cycleBytes = tmpCycleBytes;
        }
        i = 0;
        while (i < gameInfo.playerData.length) {
            changed = false;
            tmpByte = (byte)(i << 4);
            tmpCycleBytes = cycleBytes++;
            if (this.recPlayerData[i].waitCycles != gameInfo.playerData[i].waitCycles || this.parameter.getGameTime() == 0L) {
                changed = true;
                tmpByte = (byte)(tmpByte | 8);
                this.recBuffer[cycleBytes++] = (byte)(gameInfo.playerData[i].waitCycles - this.recPlayerData[i].waitCycles);
            }
            if (this.recPlayerData[i].length != gameInfo.playerData[i].length || this.parameter.getGameTime() == 0L) {
                changed = true;
                tmpByte = (byte)(tmpByte | 4);
                tmpInt = gameInfo.playerData[i].length - this.recPlayerData[i].length;
                this.recBuffer[cycleBytes++] = (byte)(tmpInt >> 8);
                this.recBuffer[cycleBytes++] = (byte)tmpInt;
            }
            if (this.recPlayerData[i].killPoints != gameInfo.playerData[i].killPoints || this.parameter.getGameTime() == 0L) {
                changed = true;
                tmpByte = (byte)(tmpByte | 2);
                tmpInt = gameInfo.playerData[i].killPoints - this.recPlayerData[i].killPoints;
                this.recBuffer[cycleBytes++] = (byte)(tmpInt >> 8);
                this.recBuffer[cycleBytes++] = (byte)tmpInt;
            }
            if (this.recPlayerData[i].snakeStatus != gameInfo.playerData[i].snakeStatus || this.parameter.getGameTime() == 0L) {
                changed = true;
                tmpByte = (byte)(tmpByte | 1);
                tmpInt = gameInfo.playerData[i].snakeStatus - this.recPlayerData[i].snakeStatus;
                this.recBuffer[cycleBytes++] = (byte)tmpInt;
            }
            if (changed || !this.recPlayerData[i].headPos.equals(gameInfo.playerData[i].headPos) || this.parameter.getGameTime() == 0L) {
                changed = true;
                if (this.recPlayerData[i].headPos.equals(gameInfo.playerData[i].headPos)) {
                    direction = 0;
                } else {
                    D_Vec2D[] sur = this.arena.getSourounding(this.recPlayerData[i].headPos, 1);
                    if (sur[0].equals(gameInfo.playerData[i].headPos)) {
                        direction = 4;
                    } else if (sur[1].equals(gameInfo.playerData[i].headPos)) {
                        direction = 3;
                    } else if (sur[2].equals(gameInfo.playerData[i].headPos)) {
                        direction = 2;
                    } else if (sur[3].equals(gameInfo.playerData[i].headPos)) {
                        direction = 1;
                    }
                }
                this.recBuffer[cycleBytes++] = direction;
            }
            if (changed) {
                this.recBuffer[tmpCycleBytes] = tmpByte;
            } else {
                --cycleBytes;
            }
            ++i;
        }
        if (this.recExitTime != this.parameter.getExit_time() || this.recSDTime != this.parameter.getSuddend_time() || this.parameter.getGameTime() == 0L) {
            this.recBuffer[cycleBytes++] = -80;
            tmpInt = (int)(this.parameter.getExit_time() - this.recExitTime);
            this.recBuffer[cycleBytes++] = (byte)(tmpInt >> 24);
            this.recBuffer[cycleBytes++] = (byte)(tmpInt >> 16);
            this.recBuffer[cycleBytes++] = (byte)(tmpInt >> 8);
            this.recBuffer[cycleBytes++] = (byte)tmpInt;
            tmpInt = (int)(this.parameter.getSuddend_time() - this.recSDTime);
            this.recBuffer[cycleBytes++] = (byte)(tmpInt >> 24);
            this.recBuffer[cycleBytes++] = (byte)(tmpInt >> 16);
            this.recBuffer[cycleBytes++] = (byte)(tmpInt >> 8);
            this.recBuffer[cycleBytes++] = (byte)tmpInt;
            this.recExitTime = this.parameter.getExit_time();
            this.recSDTime = this.parameter.getSuddend_time();
        }
        this.recBuffer[0] = (byte)((cycleBytes += 2) >> 8);
        this.recBuffer[1] = (byte)cycleBytes;
        this.recBuffer[cycleBytes - 2] = (byte)(cycleBytes >> 8);
        this.recBuffer[cycleBytes - 1] = (byte)cycleBytes;
        gameInfo.recordWriter.addGameCycle(this.recBuffer);
        this.recLevel.copyOnMe(gameInfo.level);
        i = 0;
        while (i < this.recPlayerData.length) {
            this.recPlayerData[i].copyOnMe(gameInfo.playerData[i]);
            ++i;
        }
    }

    public boolean replayGameCycle(D_GameInfo gameInfo, D_PlayerData[] playerData) {
        if (this.parameter.getReplay_sneay_version() <= 1011) {
            return this.replayGameCycle1011(gameInfo, playerData);
        }
        if (this.parameter.getReplay_sneay_version() >= 1012) {
            return this.replayGameCycle1012(gameInfo, playerData);
        }
        return true;
    }

    public boolean replayGameCycle1011(D_GameInfo gameInfo, D_PlayerData[] playerData) {
        int cycleBytes = 0;
        int cycleBytesCounter = 0;
        int fieldChanges = 0;
        int x = 0;
        char c = '\u0000';
        int number = 0;
        int left = 0;
        int right = 0;
        int anothernumber = 0;
        if (gameInfo.recordReader.isFinished()) {
            return true;
        }
        this.recBuffer = gameInfo.recordReader.readGameCycle(this.recBuffer, false);
        cycleBytes = 0;
        x = this.recBuffer[0];
        if (x < 0) {
            x += 256;
        }
        cycleBytes += (x <<= 8);
        x = this.recBuffer[1];
        if (x < 0) {
            x += 256;
        }
        cycleBytes += x;
        x = 0;
        if (x < 0) {
            x += 256;
        }
        left = x;
        x = -112;
        if (x < 0) {
            x += 256;
        }
        right = x;
        cycleBytesCounter = 2;
        block11: while (cycleBytesCounter < cycleBytes) {
            if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                x += 256;
            }
            number = x;
            block0 : switch ((byte)(number & 0xF0)) {
                case -96: {
                    fieldChanges = 0;
                    x = this.recBuffer[cycleBytesCounter++];
                    if (x < 0) {
                        x += 256;
                    }
                    fieldChanges += (x <<= 8);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    fieldChanges += x;
                    int i = 0;
                    while (i < fieldChanges) {
                        int l;
                        if ((l = this.recBuffer[cycleBytesCounter++]) < 0) {
                            l += 256;
                        }
                        int r = this.recBuffer[cycleBytesCounter++];
                        if (l < 0) {
                            r += 256;
                        }
                        if ((c = (char)this.recBuffer[cycleBytesCounter++]) < '\u0000') {
                            c = (char)(c + 256);
                        }
                        this.arena.setCharOnPosition(l, r, c);
                        ++i;
                    }
                    continue block11;
                }
                case -80: {
                    gameInfo.exitTime = 0L;
                    gameInfo.suddenDeath = 0L;
                    x = this.recBuffer[cycleBytesCounter++];
                    if (x < 0) {
                        x += 256;
                    }
                    gameInfo.exitTime += (long)(x <<= 56);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    gameInfo.exitTime += (long)(x <<= 48);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    gameInfo.exitTime += (long)(x <<= 40);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    gameInfo.exitTime += (long)(x <<= 32);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    gameInfo.exitTime += (long)(x <<= 24);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    gameInfo.exitTime += (long)(x <<= 16);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    gameInfo.exitTime += (long)(x <<= 8);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    gameInfo.exitTime += (long)x;
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    gameInfo.suddenDeath += (long)(x <<= 56);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    gameInfo.suddenDeath += (long)(x <<= 48);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    gameInfo.suddenDeath += (long)(x <<= 40);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    gameInfo.suddenDeath += (long)(x <<= 32);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    gameInfo.suddenDeath += (long)(x <<= 24);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    gameInfo.suddenDeath += (long)(x <<= 16);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    gameInfo.suddenDeath += (long)(x <<= 8);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    gameInfo.suddenDeath += (long)x;
                    break;
                }
                default: {
                    if (left > (number & 0xF0) || (number & 0xF0) > right) continue block11;
                    x = number;
                    if (x < 0) {
                        x += 256;
                    }
                    int i = x >> 4;
                    if ((number & 8) > 0) {
                        playerData[i].delayChanged = (long)(anothernumber = this.recBuffer[cycleBytesCounter++]) > playerData[i].waitCycles ? 1 : -1;
                        playerData[i].waitCycles = anothernumber;
                    } else {
                        playerData[i].delayChanged = 0;
                    }
                    if ((number & 4) > 0) {
                        anothernumber = 0;
                        if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                            x += 256;
                        }
                        anothernumber += (x <<= 8);
                        if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                            x += 256;
                        }
                        playerData[i].lengthChanged = (anothernumber += x) > playerData[i].length ? 1 : -1;
                        playerData[i].length = anothernumber;
                    } else {
                        playerData[i].lengthChanged = 0;
                    }
                    if ((number & 2) > 0) {
                        anothernumber = 0;
                        if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                            x += 256;
                        }
                        anothernumber += (x <<= 8);
                        if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                            x += 256;
                        }
                        playerData[i].killPoints = anothernumber += x;
                    }
                    if ((number & 1) > 0) {
                        playerData[i].snakeStatus = this.recBuffer[cycleBytesCounter++];
                    }
                    switch (this.recBuffer[cycleBytesCounter++]) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            playerData[i].headPos.y = (playerData[i].headPos.y - 1 + gameInfo.level.height) % gameInfo.level.height;
                            break block0;
                        }
                        case 2: {
                            playerData[i].headPos.x = (playerData[i].headPos.x + 1) % gameInfo.level.width;
                            break block0;
                        }
                        case 3: {
                            playerData[i].headPos.y = (playerData[i].headPos.y + 1) % gameInfo.level.height;
                            break block0;
                        }
                        case 4: {
                            playerData[i].headPos.x = (playerData[i].headPos.x - 1 + gameInfo.level.width) % gameInfo.level.width;
                        }
                    }
                }
            }
        }
        this.updateInfos(gameInfo);
        return false;
    }

    public boolean replayGameCycle1012(D_GameInfo gameInfo, D_PlayerData[] playerData) {
        boolean n;
        int cycleBytes = 0;
        int cycleBytesCounter = 0;
        int fieldChanges = 0;
        int x = 0;
        int number = 0;
        int left = 0;
        int right = 0;
        boolean bl = n = this.parameter.getReplay_reverse() == 0;
        if (n && gameInfo.recordReader.isFinished()) {
            return true;
        }
        if (!n && gameInfo.recordReader.isStart()) {
            return true;
        }
        this.recBuffer = gameInfo.recordReader.readGameCycle(this.recBuffer, this.parameter.getReplay_reverse() == 1);
        cycleBytes = 0;
        x = this.recBuffer[0];
        if (x < 0) {
            x += 256;
        }
        cycleBytes += (x <<= 8);
        x = this.recBuffer[1];
        if (x < 0) {
            x += 256;
        }
        cycleBytes += x;
        x = 0;
        if (x < 0) {
            x += 256;
        }
        left = x;
        x = -97;
        if (x < 0) {
            x += 256;
        }
        right = x;
        cycleBytesCounter = 2;
        block18: while (cycleBytesCounter < cycleBytes - 2) {
            if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                x += 256;
            }
            number = x;
            block0 : switch ((byte)(number & 0xF0)) {
                case -96: {
                    fieldChanges = 0;
                    x = this.recBuffer[cycleBytesCounter++];
                    if (x < 0) {
                        x += 256;
                    }
                    fieldChanges += (x <<= 8);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    fieldChanges += x;
                    int i = 0;
                    while (i < fieldChanges) {
                        int l;
                        if ((l = this.recBuffer[cycleBytesCounter++]) < 0) {
                            l += 256;
                        }
                        int r = this.recBuffer[cycleBytesCounter++];
                        if (l < 0) {
                            r += 256;
                        }
                        byte c = this.recBuffer[cycleBytesCounter++];
                        if (n) {
                            this.arena.setCharOnPosition(l, r, (char)(this.arena.getCharOf(l, r) + c));
                        }
                        if (!n) {
                            this.arena.setCharOnPosition(l, r, (char)(this.arena.getCharOf(l, r) - c));
                        }
                        ++i;
                    }
                    continue block18;
                }
                case -80: {
                    int tmpInt = 0;
                    x = this.recBuffer[cycleBytesCounter++];
                    if (x < 0) {
                        x += 256;
                    }
                    tmpInt += (x <<= 24);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    tmpInt += (x <<= 16);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    tmpInt += (x <<= 8);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    if ((tmpInt += x) > 0x7FFFFFF) {
                        tmpInt -= 0x10000000;
                    }
                    if (n) {
                        gameInfo.exitTime += (long)tmpInt;
                    }
                    if (!n) {
                        gameInfo.exitTime -= (long)tmpInt;
                    }
                    tmpInt = 0;
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    tmpInt += (x <<= 24);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    tmpInt += (x <<= 16);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    tmpInt += (x <<= 8);
                    if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                        x += 256;
                    }
                    if ((tmpInt += x) > 0x7FFFFFF) {
                        tmpInt -= 0x10000000;
                    }
                    if (n) {
                        gameInfo.suddenDeath += (long)tmpInt;
                    }
                    if (n) continue block18;
                    gameInfo.suddenDeath -= (long)tmpInt;
                    break;
                }
                default: {
                    int tmpInt;
                    if (left > (number & 0xF0) || (number & 0xF0) > right) continue block18;
                    x = number;
                    if (x < 0) {
                        x += 256;
                    }
                    int i = x >> 4;
                    if ((number & 8) > 0) {
                        tmpInt = this.recBuffer[cycleBytesCounter++];
                        int n2 = playerData[i].delayChanged = tmpInt >= 0 ? 1 : -1;
                        if (n) {
                            playerData[i].waitCycles += (long)tmpInt;
                        }
                        if (!n) {
                            playerData[i].waitCycles -= (long)tmpInt;
                        }
                    } else {
                        playerData[i].delayChanged = 0;
                    }
                    if ((number & 4) > 0) {
                        tmpInt = 0;
                        if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                            x += 256;
                        }
                        tmpInt += (x <<= 8);
                        if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                            x += 256;
                        }
                        if ((tmpInt += x) > Short.MAX_VALUE) {
                            tmpInt -= 65536;
                        }
                        int n3 = playerData[i].lengthChanged = tmpInt > 0 ? 1 : -1;
                        playerData[i].length = n ? (playerData[i].length += tmpInt) : (playerData[i].length -= tmpInt);
                    } else {
                        playerData[i].lengthChanged = 0;
                    }
                    if ((number & 2) > 0) {
                        tmpInt = 0;
                        if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                            x += 256;
                        }
                        tmpInt += (x <<= 8);
                        if ((x = this.recBuffer[cycleBytesCounter++]) < 0) {
                            x += 256;
                        }
                        if ((tmpInt += x) > Short.MAX_VALUE) {
                            tmpInt -= 65536;
                        }
                        if (n) {
                            playerData[i].killPoints += tmpInt;
                        }
                        if (!n) {
                            playerData[i].killPoints -= tmpInt;
                        }
                    }
                    if ((number & 1) > 0) {
                        if (n) {
                            playerData[i].snakeStatus += this.recBuffer[cycleBytesCounter++];
                        }
                        if (!n) {
                            playerData[i].snakeStatus -= this.recBuffer[cycleBytesCounter++];
                        }
                    }
                    if (n) {
                        switch (this.recBuffer[cycleBytesCounter++]) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                playerData[i].headPos.y = (playerData[i].headPos.y - 1 + gameInfo.level.height) % gameInfo.level.height;
                                break;
                            }
                            case 2: {
                                playerData[i].headPos.x = (playerData[i].headPos.x + 1) % gameInfo.level.width;
                                break;
                            }
                            case 3: {
                                playerData[i].headPos.y = (playerData[i].headPos.y + 1) % gameInfo.level.height;
                                break;
                            }
                            case 4: {
                                playerData[i].headPos.x = (playerData[i].headPos.x - 1 + gameInfo.level.width) % gameInfo.level.width;
                            }
                        }
                        continue block18;
                    }
                    switch (this.recBuffer[cycleBytesCounter++]) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            playerData[i].headPos.y = (playerData[i].headPos.y + 1) % gameInfo.level.height;
                            break block0;
                        }
                        case 2: {
                            playerData[i].headPos.x = (playerData[i].headPos.x - 1 + gameInfo.level.width) % gameInfo.level.width;
                            break block0;
                        }
                        case 3: {
                            playerData[i].headPos.y = (playerData[i].headPos.y - 1 + gameInfo.level.height) % gameInfo.level.height;
                            break block0;
                        }
                        case 4: {
                            playerData[i].headPos.x = (playerData[i].headPos.x + 1) % gameInfo.level.width;
                        }
                    }
                }
            }
        }
        this.updateInfos(gameInfo);
        return false;
    }

    public void update(D_GameInfo gameInfo) {
        D_Vec2D vec = null;
        if (this.parameter.getReplay() == 0) {
            int i = 0;
            while (i < this.arena.getNumberOfObjects()) {
                C_GameObject gObj = this.arena.getGameObject(i);
                if (gObj.getNextUpdateTime() >= 0L && gObj.getNextUpdateTime() <= gameInfo.gameTime) {
                    this.arena.objectUpdate(gObj);
                }
                ++i;
            }
            if (this.parameter.getGameTime() < this.parameter.getSuddend_time() && this.nextGoodyTime <= gameInfo.gameTime) {
                this.placeGoody(gameInfo);
            }
            if (gameInfo.gameTime >= gameInfo.suddenDeath && gameInfo.gameTime > this.lastSDTime) {
                this.lastSDTime = gameInfo.gameTime;
                if (this.arena.updateFreeFieldVec(false) > 0) {
                    vec = this.arena.randFreeField();
                    this.arena.objectAdd(new C_GLength(vec, -this.parameter.getGoody_shorter_value(), this.parameter));
                }
            }
        }
        this.updateInfos(gameInfo);
    }

    public D_Level generateLevel() {
        return this.arena.generateLevel();
    }

    public void updateInfos(D_GameInfo gameInfo) {
        this.arena.updateLevel(gameInfo.level);
    }
}

