/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.world;

import de.farafin.snEADy.GameParameter;
import de.farafin.snEADy.communication.D_Vec2D;
import de.farafin.snEADy.communication.I_Constants;
import de.farafin.snEADy.communication.I_PlayFieldConstants;
import de.farafin.snEADy.communication.RingVector;
import de.farafin.snEADy.world.C_Arena;
import java.util.LinkedList;

public abstract class C_GameObject
implements I_Constants,
I_PlayFieldConstants {
    protected D_Vec2D headPosition = null;
    protected int faceDirection = 0;
    protected RingVector objPositions = null;
    protected char ownChar = '\u0000';
    protected long nextUpdateTime = 0L;
    protected long waitCycles = 1L;
    protected final GameParameter parameter;

    protected C_GameObject() {
        this.parameter = null;
        this.headPosition = null;
        this.faceDirection = 0;
        this.objPositions = null;
        this.ownChar = '\u0000';
        this.waitCycles = 1L;
        this.nextUpdateTime = 0L;
    }

    protected C_GameObject(GameParameter parameter) {
        this.parameter = parameter;
        this.headPosition = null;
        this.faceDirection = 0;
        this.objPositions = null;
        this.ownChar = '\u0000';
        this.waitCycles = 1L;
        this.nextUpdateTime = 0L;
    }

    protected C_GameObject(D_Vec2D headPosition, int faceDirection, RingVector objPositions, char ownChar, long waitCycles, GameParameter parameter) {
        this.parameter = parameter;
        this.headPosition = (D_Vec2D)headPosition.clone();
        this.faceDirection = faceDirection;
        this.objPositions = (RingVector)objPositions.clone();
        this.ownChar = ownChar;
        this.waitCycles = waitCycles;
        this.nextUpdateTime = 0L;
    }

    protected C_GameObject(C_GameObject obj) {
        this.parameter = obj.parameter;
        this.headPosition = (D_Vec2D)obj.headPosition.clone();
        this.faceDirection = obj.faceDirection;
        this.objPositions = obj.objPositions;
        this.ownChar = obj.ownChar;
        this.waitCycles = obj.waitCycles;
        this.nextUpdateTime = 0L;
    }

    protected C_GameObject(D_Vec2D headPosition, int faceDirection, char ownChar, long waitCycles, GameParameter parameter) {
        this.parameter = parameter;
        this.headPosition = (D_Vec2D)headPosition.clone();
        this.faceDirection = faceDirection;
        this.objPositions = new RingVector();
        this.objPositions.addLast(headPosition.clone());
        this.ownChar = ownChar;
        this.waitCycles = waitCycles;
        this.nextUpdateTime = 0L;
    }

    protected abstract void jumpTo(D_Vec2D var1, C_Arena var2);

    protected D_Vec2D[] getAllPosArray() {
        D_Vec2D[] vecArray = new D_Vec2D[this.objPositions.size()];
        int i = 0;
        while (i < this.objPositions.size()) {
            vecArray[i] = (D_Vec2D)this.objPositions.getElementAt(i);
            ++i;
        }
        return vecArray;
    }

    protected LinkedList getAllPosList() {
        return (LinkedList)this.objPositions.clone();
    }

    protected char getOwnChar() {
        return this.ownChar;
    }

    protected abstract D_Vec2D[] getAllPosSorted(int var1);

    protected int getFaceDirection() {
        return this.faceDirection;
    }

    protected void setFaceDirection(int faceDirection) {
        this.faceDirection = faceDirection;
    }

    protected D_Vec2D getHeadPosition() {
        return (D_Vec2D)this.headPosition.clone();
    }

    protected void setHeadPosition(D_Vec2D headPosition) {
        this.headPosition = (D_Vec2D)headPosition.clone();
    }

    protected D_Vec2D getNextPosInFaceDirection(C_Arena arena) {
        D_Vec2D pos = this.getHeadPosition();
        switch (this.getFaceDirection()) {
            case 0: {
                --pos.y;
                if (pos.y >= 0) break;
                pos.y = arena.getHeight() - 1;
                break;
            }
            case 1: {
                ++pos.x;
                if (pos.x < arena.getWidth()) break;
                pos.x = 0;
                break;
            }
            case 2: {
                ++pos.y;
                if (pos.y < arena.getHeight()) break;
                pos.y = 0;
                break;
            }
            case 3: {
                --pos.x;
                if (pos.x >= 0) break;
                pos.x = arena.getWidth() - 1;
            }
        }
        return pos;
    }

    protected long getNextUpdateTime() {
        return this.nextUpdateTime;
    }

    protected abstract void update(C_Arena var1);

    protected void jumpHeadPos(D_Vec2D dest) {
        this.headPosition.copyOnMe(dest);
        ((D_Vec2D)this.objPositions.getFirst()).copyOnMe(dest);
    }

    public abstract String toString();

    protected abstract Object clone();
}

