/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.inOut;

import de.farafin.snEADy.M_Main;
import de.farafin.snEADy.communication.D_Level;
import de.farafin.snEADy.inOut.C_FileClassLoader;
import de.farafin.snEADy.inOut.C_LevelLoader;
import de.farafin.snEADy.inOut.C_RecordFileReader;
import de.farafin.snEADy.inOut.E_LevelFileException;
import java.io.FileNotFoundException;

public final class C_SneadyFileInteractor {
    static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static Class loadPlayerClass(String className) {
        try {
            Class c = new C_FileClassLoader("player").loadClass(className, true);
            return c;
        }
        catch (Exception e) {
            System.out.println("WARNING: player wasnt loaded \n\t" + e);
            return null;
        }
    }

    public static String getPlayerName(String playerName) {
        String s = null;
        Class c = C_SneadyFileInteractor.loadPlayerClass(playerName);
        if (c == null) {
            return "";
        }
        try {
            s = (String)c.getField("name").get(null);
            if (s.length() > 0) {
                return s;
            }
            return c.getName();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return "e";
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return "e";
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return "e";
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return "n";
        }
    }

    public static String getPlayerComment(String playerName) {
        String s = null;
        Class c = C_SneadyFileInteractor.loadPlayerClass(playerName);
        if (c == null) {
            return "e";
        }
        try {
            s = (String)c.getField("comment").get(null);
        }
        catch (IllegalArgumentException e) {
            return "e";
        }
        catch (SecurityException e) {
            return "e";
        }
        catch (IllegalAccessException e) {
            return "e";
        }
        catch (NoSuchFieldException e) {
            return "n";
        }
        return "j" + s;
    }

    public static D_Level getLevelHeader(String levelName) {
        C_LevelLoader levelLoader = new C_LevelLoader();
        D_Level level = null;
        try {
            level = levelLoader.loadLevelHeader(levelName);
        }
        catch (FileNotFoundException e) {
            System.out.println("WARNING: " + e);
            return null;
        }
        catch (E_LevelFileException e) {
            System.out.println("WARNING: " + e);
            return null;
        }
        return level;
    }

    public static D_Level loadLevel(String levelName) {
        C_LevelLoader levelLoader = new C_LevelLoader();
        D_Level level = null;
        try {
            level = levelLoader.loadLevel(levelName);
        }
        catch (FileNotFoundException e) {
            System.out.println("WARNING: " + e);
            return null;
        }
        catch (E_LevelFileException e) {
            System.out.println("WARNING: " + e);
            return null;
        }
        return level;
    }

    public static String[] getReplayHeader(String replayName) {
        String[] head = null;
        String[] line = null;
        String[] str = null;
        String[] tmp = null;
        C_RecordFileReader reader = null;
        try {
            reader = new C_RecordFileReader("replays", replayName);
        }
        catch (FileNotFoundException e) {
            System.out.println("WARNING: record: '" + replayName + "' not found!");
            return null;
        }
        head = reader.readHeader();
        int playerNumber = 0;
        int i = 0;
        while (i < head.length) {
            line = head[i].split(" ");
            if (line.length > 0 && line[0].startsWith("loaddummy")) {
                ++playerNumber;
            }
            ++i;
        }
        str = new String[playerNumber + 4];
        int counter = 0;
        i = 0;
        while (i < head.length) {
            line = head[i].split(" ");
            if (line.length > 0) {
                if (line[0].startsWith("%SnEADyVersion")) {
                    str[0] = line[1];
                } else if (line[0].startsWith("loadlevel")) {
                    str[1] = line[1];
                    str[2] = "" + playerNumber;
                } else if (line[0].startsWith("%gameLength")) {
                    str[3] = line[1];
                } else if (line[0].startsWith("loaddummy")) {
                    tmp = head[i].split(":");
                    str[counter + 4] = tmp.length > 1 ? tmp[1] : "name";
                    ++counter;
                }
            }
            ++i;
        }
        if (str[0] == null || str[0] == "") {
            str[0] = "1011";
        }
        try {
            int test = Integer.parseInt(str[0]);
            if (test < 1011 || test > M_Main.getVersion()) {
                str[0] = "1011";
            }
        }
        catch (NumberFormatException e) {
            str[0] = "1011";
        }
        return str;
    }

    public static String toHexString(byte b) {
        return Integer.toString((b & 0xFF) + 256, 16).substring(1);
    }

    public static String toHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        int i = 0;
        while (i < b.length) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }
}

