/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.inOut;

import de.farafin.snEADy.communication.I_Constants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class C_RecordFileReader
implements I_Constants {
    private File binFile;
    private byte[] buffer;
    private int actPos;
    private int headerLength;
    private int startPos;
    private String header;

    public C_RecordFileReader(String root, String fileName) throws FileNotFoundException {
        int x = 0;
        FileInputStream fileStream = null;
        fileName = String.valueOf(fileName) + ".sre";
        this.binFile = new File(root, fileName);
        if (!this.binFile.exists()) {
            throw new FileNotFoundException("File " + fileName + " at " + root + " was not found!");
        }
        this.buffer = new byte[(int)this.binFile.length()];
        try {
            fileStream = new FileInputStream(this.binFile);
            fileStream.read(this.buffer);
        }
        catch (IOException e) {
            System.out.println("WARNING: File cant be opend!! " + e);
            try {
                this.finalize();
            }
            catch (Throwable e1) {
                e1.printStackTrace();
                System.out.println("Something really weired is going on. Ask the java development team for help.. my knowlage ends here...");
            }
            return;
        }
        this.headerLength = 0;
        x = this.buffer[0];
        if (x < 0) {
            x += 256;
        }
        this.headerLength += x << 24;
        x = this.buffer[1];
        if (x < 0) {
            x += 256;
        }
        this.headerLength += x << 16;
        x = this.buffer[2];
        if (x < 0) {
            x += 256;
        }
        this.headerLength += x << 8;
        x = this.buffer[3];
        if (x < 0) {
            x += 256;
        }
        this.headerLength += x;
        this.header = new String(this.buffer, 4, this.headerLength);
        this.actPos = this.startPos = this.headerLength + 4;
    }

    public C_RecordFileReader(String fileName) throws FileNotFoundException {
        this("records", fileName);
    }

    public String[] readHeader() {
        return this.header.split("\n");
    }

    public byte[] readGameCycle(byte[] buf, boolean reverse) {
        byte[] res = null;
        int len = 0;
        int i = 0;
        int x = 0;
        len = 0;
        if (!reverse) {
            if (this.actPos >= this.buffer.length) {
                return null;
            }
            x = this.buffer[this.actPos];
            if (x < 0) {
                x += 256;
            }
            len += x << 8;
            x = this.buffer[this.actPos + 1];
            if (x < 0) {
                x += 256;
            }
            res = buf == null || buf.length < len ? new byte[len += x] : buf;
            i = 0;
            while (i < len) {
                res[i] = this.buffer[this.actPos + i];
                ++i;
            }
            this.actPos += len;
        } else {
            if (this.actPos == this.startPos) {
                return null;
            }
            x = this.buffer[this.actPos - 2];
            if (x < 0) {
                x += 256;
            }
            len += x << 8;
            x = this.buffer[this.actPos - 1];
            if (x < 0) {
                x += 256;
            }
            res = buf == null || buf.length < len ? new byte[len += x] : buf;
            i = 0;
            while (i < len) {
                res[i] = this.buffer[this.actPos - len + i];
                ++i;
            }
            this.actPos -= len;
        }
        return res;
    }

    public boolean isFinished() {
        return this.actPos >= this.buffer.length;
    }

    public boolean isStart() {
        return this.actPos == this.startPos;
    }

    public void restart() {
        this.actPos = this.startPos;
    }

    public String getFileName() {
        return this.binFile.getName();
    }
}

