/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.inOut;

import de.farafin.snEADy.communication.D_Level;
import de.farafin.snEADy.communication.I_Constants;
import de.farafin.snEADy.inOut.E_LevelFileException;
import de.farafin.snEADy.inOut.I_LevelLoader_interface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public final class C_LevelLoader
implements I_Constants,
I_LevelLoader_interface {
    private String removeComents(String str) {
        String[] result = null;
        result = str.split("%");
        return result[0];
    }

    private String removeSpaces(String str) {
        String result = null;
        if (str == null) {
            return null;
        }
        if (str.length() < 1) {
            return str;
        }
        result = str;
        if (result.length() > 0) {
            result = result.replaceAll("\t", " ");
        }
        while (result.charAt(0) == ' ') {
            result = result.substring(1);
        }
        while (result.charAt(result.length() - 1) == ' ') {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private D_Level load(String root, String levName, boolean loadPlayfield) throws FileNotFoundException, E_LevelFileException {
        D_Level level = null;
        String filePath = null;
        String filename = null;
        File file = null;
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        String argument = null;
        String str1 = null;
        String[] strArray = null;
        boolean sizeAccured = false;
        filePath = root.replace('.', File.separatorChar);
        filename = String.valueOf(levName) + ".smp";
        try {
            file = new File(filePath, filename);
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        level = new D_Level();
        level.height = 0;
        level.width = 0;
        level.fileName = levName;
        try {
            while (bufferedReader.ready()) {
                str1 = bufferedReader.readLine();
                if (str1.startsWith("<name>")) {
                    argument = str1.substring(6);
                    argument = this.removeComents(argument);
                    level.name = argument = this.removeSpaces(argument);
                }
                if (str1.startsWith("<comment>")) {
                    level.comment = "";
                    argument = str1.substring(9);
                    argument = this.removeComents(argument);
                    argument = this.removeSpaces(argument);
                    level.comment = String.valueOf(level.comment) + argument;
                    while (bufferedReader.ready()) {
                        argument = bufferedReader.readLine();
                        if (argument.startsWith("<endcomment>")) break;
                        if (argument.length() > 0) {
                            level.comment = String.valueOf(level.comment) + '\n';
                        }
                        argument = this.removeComents(argument);
                        argument = this.removeSpaces(argument);
                        level.comment = String.valueOf(level.comment) + argument;
                    }
                }
                if (str1.startsWith("<autor>") || str1.startsWith("<author>")) {
                    argument = str1.substring(8);
                    argument = this.removeComents(argument);
                    level.author = argument = this.removeSpaces(argument);
                    continue;
                }
                if (str1.startsWith("<size>")) {
                    argument = str1.substring(6);
                    argument = this.removeComents(argument);
                    if (!(argument = this.removeSpaces(argument)).matches("[[0-9][x]]*")) {
                        try {
                            bufferedReader.close();
                            fileReader.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw new E_LevelFileException("The size-tag \"" + argument + "\" of the file " + file + " is wrong formated!\n");
                    }
                    strArray = argument.split("x");
                    if (strArray.length != 2) {
                        try {
                            bufferedReader.close();
                            fileReader.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw new E_LevelFileException("The size-tag \"" + argument + "\" of the file " + file + " has too many subparameters!\n");
                    }
                    level.height = Integer.parseInt(strArray[0]);
                    level.width = Integer.parseInt(strArray[1]);
                    sizeAccured = true;
                    continue;
                }
                if (str1.startsWith("<maxPlayer>")) {
                    argument = str1.substring(11);
                    argument = this.removeComents(argument);
                    argument = this.removeSpaces(argument);
                    level.maxPlayer = Integer.decode(argument);
                    continue;
                }
                if (!str1.startsWith("<playField>")) continue;
                if (!loadPlayfield) break;
                if (!sizeAccured) {
                    try {
                        bufferedReader.close();
                        fileReader.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw new E_LevelFileException("The playField-tag was written before the size-tag!\n");
                }
                level.playField = new char[level.height][];
                int i = 0;
                while (bufferedReader.ready()) {
                    str1 = bufferedReader.readLine();
                    if (str1.startsWith("<endPlayfield>")) break;
                    str1 = this.removeComents(str1);
                    str1 = this.removeSpaces(str1);
                    if (i >= level.height) {
                        try {
                            bufferedReader.close();
                            fileReader.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw new E_LevelFileException("There are too many lines in the playfield. It must be the same as it is defined in size: " + level.height + "\n");
                    }
                    if (str1.length() != level.width) {
                        try {
                            bufferedReader.close();
                            fileReader.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw new E_LevelFileException("The playField-repesentation of line " + i + " is wrong. Its length(" + str1.length() + ") must be the same as width: " + level.width + "!\n");
                    }
                    if (!str1.matches("[[0-9][a-z][A-Z][.#]]*")) {
                        try {
                            bufferedReader.close();
                            fileReader.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw new E_LevelFileException("The playfild-line " + i + " of the file " + file + " contains unexpected characters!\n");
                    }
                    level.playField[i] = str1.toCharArray();
                    ++i;
                }
                if (i >= level.height) continue;
                try {
                    bufferedReader.close();
                    fileReader.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw new E_LevelFileException("There are too less lines in the playfield: " + i + 1 + ". It must be the same as it is defined in size: " + level.height + "\n");
            }
            bufferedReader.close();
            fileReader.close();
            if (level.name == null) {
                throw new E_LevelFileException("The name-tag of the file " + file + " is missing!\n");
            }
            if (level.width == 0) {
                throw new E_LevelFileException("The size-tag of the file " + file + " is missing or height is set to 0!\n");
            }
            if (level.height == 0) {
                throw new E_LevelFileException("The size-tag of the file " + file + " is missing or width is set to 0!\n");
            }
            if (level.maxPlayer == 0) {
                throw new E_LevelFileException("The maxPlayer-tag of the file " + file + " is missing or set to 0!\n");
            }
            if (level.playField == null && loadPlayfield) {
                throw new E_LevelFileException("The playField-tag of the file " + file + " is missing!\n");
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (E_LevelFileException e) {
            throw e;
        }
        catch (IOException e) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        return level;
    }

    public D_Level loadLevelHeader(String root, String levName) throws E_LevelFileException, FileNotFoundException {
        return this.load(root, levName, false);
    }

    public D_Level loadLevelHeader(String levName) throws E_LevelFileException, FileNotFoundException {
        return this.load("levels", levName, false);
    }

    public D_Level loadLevel(String root, String levName) throws E_LevelFileException, FileNotFoundException {
        return this.load(root, levName, true);
    }

    public D_Level loadLevel(String levName) throws E_LevelFileException, FileNotFoundException {
        return this.load("levels", levName, true);
    }
}

