/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.control.GaphixStuff;

import de.farafin.snEADy.C_DebugMonitor;
import de.farafin.snEADy.GameParameter;
import de.farafin.snEADy.I_GameStats;
import de.farafin.snEADy.I_Main_interface;
import de.farafin.snEADy.communication.D_GameInfo;
import de.farafin.snEADy.communication.D_PlayerData;
import de.farafin.snEADy.communication.I_Constants;
import de.farafin.snEADy.control.C_Human;
import de.farafin.snEADy.control.GaphixStuff.C_GraphixData;
import de.farafin.snEADy.control.GaphixStuff.C_GraphixTools;
import de.farafin.snEADy.control.GaphixStuff.C_WindowArena;
import de.farafin.snEADy.control.GaphixStuff.C_WindowCommand;
import de.farafin.snEADy.control.GaphixStuff.C_WindowMain;
import de.farafin.snEADy.control.GaphixStuff.C_WindowOptions;
import de.farafin.snEADy.control.GaphixStuff.C_WindowPlayer;
import de.farafin.snEADy.control.GaphixStuff.C_WindowReplay;
import de.farafin.snEADy.control.GaphixStuff.I_GraphixConstants;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.VolatileImage;

public class M_GraphixEngineUI
implements I_Constants,
I_GraphixConstants,
I_GameStats {
    private static int frameC;
    private static long lastTime;
    private static float fps;
    protected static D_GameInfo oldGameInfo;
    protected static C_Human[] humans;
    protected static int humanPlayerC;
    private static Gr_Arena[] arena;
    private static int actArena;
    private static Gr_DiffArena diff;
    protected static int[] playerOrd;
    private static int[] last_killPoints;
    private static int[] m_length;
    private static int[] m_killpoints;
    private static int[] m_cycles;
    private static int[] m_name;
    protected static int lastPlayerC;
    protected static VolatileImage[] img_pTab;
    protected static VolatileImage[] img_tab;
    protected static Graphics2D[] gr_tab;
    protected static VolatileImage img_arena;
    private static Graphics actGraphics;
    protected static C_WindowMain menuFrame;
    protected static C_WindowCommand commandFrame;
    protected static C_WindowArena arenaFS;
    protected static C_WindowPlayer playerFS;
    protected static C_WindowReplay replay;
    protected static C_WindowOptions options;
    protected static C_DebugMonitor debugMon;
    protected static GameParameter gameParam;

    static {
        humanPlayerC = 1;
        arena = new Gr_Arena[2];
        actArena = 0;
        last_killPoints = new int[10];
        m_length = new int[10];
        m_killpoints = new int[10];
        m_cycles = new int[10];
        m_name = new int[10];
        img_pTab = new VolatileImage[10];
        img_tab = new VolatileImage[10];
        gr_tab = new Graphics2D[10];
    }

    public static void init(I_Main_interface calling, GameParameter p, C_DebugMonitor debMon, int version) {
        C_GraphixData.version = version;
        C_GraphixData.main = calling;
        gameParam = p;
        C_GraphixTools.getLayout("pics/menu/skin.ini");
        if (C_GraphixTools.loadImages()) {
            // empty if block
        }
        int i = 0;
        while (i < 10) {
            M_GraphixEngineUI.img_pTab[i] = C_GraphixTools.createBackBufferVI(C_GraphixData.menuImages[2].getWidth(null), C_GraphixData.menuImages[2].getHeight(null));
            M_GraphixEngineUI.img_tab[i] = C_GraphixTools.createBackBufferVI(C_GraphixData.menuImages[2].getWidth(null), C_GraphixData.menuImages[2].getHeight(null));
            M_GraphixEngineUI.gr_tab[i] = img_tab[i].createGraphics();
            ++i;
        }
        M_GraphixEngineUI.drawPlayerTab(new boolean[]{true, true, true, true, true, true, true, true, true, true});
        menuFrame = new C_WindowMain();
        debugMon = debMon;
        arenaFS = new C_WindowArena();
        playerFS = new C_WindowPlayer();
        replay = new C_WindowReplay();
        options = new C_WindowOptions();
        commandFrame = new C_WindowCommand();
        menuFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                C_GraphixData.main.control("quit");
            }
        });
        try {
            menuFrame.addKeyListener(new KeyListener(){

                public void keyTyped(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    int key = e.getKeyCode();
                    switch (key) {
                        case 27: {
                            C_GraphixData.main.control("quit");
                            return;
                        }
                        case 123: {
                            commandFrame.setVisible(!commandFrame.isVisible());
                        }
                    }
                    int i = 0;
                    while (i < humanPlayerC) {
                        if (key == I_GraphixConstants.humanPlayerKeyL[i]) {
                            humans[i].setNewDirection(13);
                        } else if (key == I_GraphixConstants.humanPlayerKeyU[i]) {
                            humans[i].setNewDirection(10);
                        } else if (key == I_GraphixConstants.humanPlayerKeyR[i]) {
                            humans[i].setNewDirection(11);
                        } else if (key == I_GraphixConstants.humanPlayerKeyD[i]) {
                            humans[i].setNewDirection(12);
                        }
                        ++i;
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        menuFrame.setVisible(true);
        actGraphics = menuFrame.getGraphics();
    }

    private M_GraphixEngineUI() {
    }

    private static final void updateTexts(D_GameInfo gameInfo, Graphics g) {
        int mode = 0;
        String[] leer6 = new String[]{"      ", "     ", "    ", "   ", "  ", " ", ""};
        StringBuffer tmpStrB = new StringBuffer(6);
        tmpStrB.append(gameInfo.gameTime);
        tmpStrB.insert(0, leer6[tmpStrB.length()]);
        C_GraphixTools.drawBitmapString(tmpStrB.toString(), C_GraphixData.intCoords[12][0], C_GraphixData.intCoords[12][1], 4, g, 1, mode);
        mode = gameInfo.exitTime <= gameInfo.gameTime ? 3 : 0;
        tmpStrB.delete(0, 6);
        tmpStrB.append(gameInfo.exitTime);
        tmpStrB.insert(0, leer6[tmpStrB.length()]);
        C_GraphixTools.drawBitmapString(tmpStrB.toString(), C_GraphixData.intCoords[13][0], C_GraphixData.intCoords[13][1], 4, g, 1, mode);
        mode = gameInfo.suddenDeath <= gameInfo.gameTime ? 2 : 0;
        tmpStrB.delete(0, 6);
        tmpStrB.append(gameInfo.suddenDeath);
        tmpStrB.insert(0, leer6[tmpStrB.length()]);
        C_GraphixTools.drawBitmapString(tmpStrB.toString(), C_GraphixData.intCoords[14][0], C_GraphixData.intCoords[14][1], 4, g, 1, mode);
    }

    private static final void updatePlayer(D_GameInfo gameInfo) {
        D_PlayerData[] pd = gameInfo.playerData;
        if (gameInfo.gameRunning) {
            int i = 0;
            while (i < pd.length) {
                int delta = pd[i].killPoints - last_killPoints[i];
                if (delta < 0) {
                    M_GraphixEngineUI.m_killpoints[i] = 2;
                    M_GraphixEngineUI.last_killPoints[i] = pd[i].killPoints;
                } else if (delta > 0) {
                    M_GraphixEngineUI.m_killpoints[i] = 3;
                    if (delta > 100) {
                        int n = i;
                        last_killPoints[n] = last_killPoints[n] + 100;
                    } else if (delta > 10) {
                        int n = i;
                        last_killPoints[n] = last_killPoints[n] + 10;
                    } else {
                        int n = i;
                        last_killPoints[n] = last_killPoints[n] + 1;
                    }
                }
                if (pd[i].snakeStatus == 0) {
                    M_GraphixEngineUI.m_cycles[i] = pd[i].delayChanged > 0 ? 2 : (pd[i].delayChanged < 0 ? 3 : 0);
                    M_GraphixEngineUI.m_length[i] = pd[i].lengthChanged < 0 ? 2 : (pd[i].lengthChanged > 0 ? 3 : 0);
                    if (delta == 0) {
                        M_GraphixEngineUI.m_killpoints[i] = 0;
                    }
                    M_GraphixEngineUI.m_name[i] = 0;
                } else if (delta == 0) {
                    M_GraphixEngineUI.m_name[i] = 1;
                    M_GraphixEngineUI.m_length[i] = 1;
                    M_GraphixEngineUI.m_cycles[i] = 1;
                    M_GraphixEngineUI.m_killpoints[i] = 1;
                } else {
                    M_GraphixEngineUI.m_name[i] = 0;
                    M_GraphixEngineUI.m_length[i] = 0;
                    M_GraphixEngineUI.m_cycles[i] = 0;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < pd.length) {
                M_GraphixEngineUI.last_killPoints[i] = pd[i].killPoints;
                M_GraphixEngineUI.m_name[i] = 0;
                M_GraphixEngineUI.m_length[i] = 0;
                M_GraphixEngineUI.m_cycles[i] = 0;
                M_GraphixEngineUI.m_killpoints[i] = 0;
                ++i;
            }
        }
    }

    private static final void drawPlayerTab(boolean[] drawArray) {
        int psX = 40;
        int psY = 2;
        int i = 0;
        while (i < 10) {
            if (drawArray[i]) {
                do {
                    int valid;
                    if ((valid = img_pTab[i].validate(C_GraphixData.gc)) != 0) {
                        M_GraphixEngineUI.img_pTab[i] = C_GraphixTools.createBackBufferVI(C_GraphixData.menuImages[2].getWidth(null), C_GraphixData.menuImages[2].getHeight(null));
                    }
                    Graphics2D g = img_pTab[i].createGraphics();
                    C_GraphixTools.wantReadMenuImage(2);
                    g.drawImage(C_GraphixData.menuImages[2], 0, 0, null);
                    C_GraphixTools.wantReadGameImage(48);
                    g.drawImage(C_GraphixData.gameImages[48], 40, 2, 46, 8, 6 * i, 0, 6 * (i + 1), 6, null, null);
                    g.drawImage(C_GraphixData.gameImages[48], 40, 8, 46, 14, 6 * i, 6, 6 * (i + 1), 12, null, null);
                    g.drawImage(C_GraphixData.gameImages[48], 34, 8, 40, 14, 6 * i, 6, 6 * (i + 1), 12, null, null);
                    g.drawImage(C_GraphixData.gameImages[48], 34, 14, 40, 20, 6 * i, 6, 6 * (i + 1), 12, null, null);
                    g.dispose();
                } while (img_pTab[i].contentsLost());
            }
            ++i;
        }
    }

    private static final void updatePlayerTab(D_GameInfo gameInfo) {
        int valid;
        int i;
        int r = 1;
        boolean[] array = new boolean[10];
        D_PlayerData[] pd = new D_PlayerData[gameInfo.playerData.length];
        StringBuffer strB = new StringBuffer(13);
        if (playerOrd == null || gameInfo.playerData.length != playerOrd.length) {
            playerOrd = new int[gameInfo.playerData.length];
        }
        if (gameInfo.playerData.length > 0) {
            pd[0] = gameInfo.playerData[0];
            M_GraphixEngineUI.playerOrd[0] = 0;
            i = 1;
            while (i < playerOrd.length) {
                int j = i;
                M_GraphixEngineUI.playerOrd[i] = i;
                pd[i] = gameInfo.playerData[i];
                while (j > 0 && pd[M_GraphixEngineUI.playerOrd[j]].killPoints > pd[M_GraphixEngineUI.playerOrd[j - 1]].killPoints) {
                    int tmp = playerOrd[j];
                    M_GraphixEngineUI.playerOrd[j] = playerOrd[j - 1];
                    M_GraphixEngineUI.playerOrd[--j] = tmp;
                }
                ++i;
            }
            i = 0;
            while (i < playerOrd.length) {
                do {
                    if ((valid = img_tab[i].validate(C_GraphixData.gc)) == 2) {
                        M_GraphixEngineUI.img_tab[i] = C_GraphixTools.createBackBufferVI(C_GraphixData.menuImages[2].getWidth(null), C_GraphixData.menuImages[2].getHeight(null));
                        gr_tab[i].dispose();
                        M_GraphixEngineUI.gr_tab[i] = img_tab[i].createGraphics();
                    }
                    if (img_pTab[playerOrd[i]].validate(C_GraphixData.gc) != 0) {
                        int k = 0;
                        while (k < 10) {
                            array[k] = false;
                            ++k;
                        }
                        array[i] = true;
                        M_GraphixEngineUI.drawPlayerTab(array);
                    }
                    gr_tab[i].drawImage(img_pTab[playerOrd[i]], 0, 0, null);
                    D_PlayerData tmpP = pd[playerOrd[i]];
                    if (tmpP.name.length() > 16) {
                        strB.delete(0, 13);
                        strB.append(tmpP.name.substring(0, 12));
                        strB.append('.');
                        tmpP.name = strB.toString();
                    }
                    if (i >= 1 && tmpP.killPoints != pd[M_GraphixEngineUI.playerOrd[i - 1]].killPoints) {
                        ++r;
                    }
                    C_GraphixTools.drawBitmapString(String.valueOf(r), 18, 4, 4, gr_tab[i], 1, m_cycles[playerOrd[i]]);
                    C_GraphixTools.drawBitmapString(tmpP.name, 58, 4, 4, gr_tab[i], 0, m_name[playerOrd[i]]);
                    if (tmpP.length < 1000) {
                        C_GraphixTools.drawBitmapString(String.valueOf(tmpP.length), 218, 4, 4, gr_tab[i], 1, m_length[playerOrd[i]]);
                    } else {
                        C_GraphixTools.drawBitmapString("WOW", 218, 4, 4, gr_tab[i], 1, m_length[playerOrd[i]]);
                    }
                    C_GraphixTools.drawBitmapString(String.valueOf(tmpP.waitCycles), 235, 4, 4, gr_tab[i], 1, m_cycles[playerOrd[i]]);
                    C_GraphixTools.drawBitmapString(String.valueOf(last_killPoints[playerOrd[i]]), 276, 4, 4, gr_tab[i], 1, m_killpoints[playerOrd[i]]);
                } while (img_tab[i].contentsLost());
                ++i;
            }
        }
        i = pd.length;
        while (i < 10) {
            do {
                if ((valid = img_tab[i].validate(C_GraphixData.gc)) == 2) {
                    M_GraphixEngineUI.img_tab[i] = C_GraphixTools.createBackBufferVI(C_GraphixData.menuImages[2].getWidth(null), C_GraphixData.menuImages[2].getHeight(null));
                    gr_tab[i].dispose();
                    M_GraphixEngineUI.gr_tab[i] = img_tab[i].createGraphics();
                }
                C_GraphixTools.wantReadMenuImage(3);
                gr_tab[i].drawImage(C_GraphixData.menuImages[3], 0, 0, null);
            } while (img_tab[i].contentsLost());
            ++i;
        }
    }

    protected static final void drawMenuElements(Graphics g, D_GameInfo gameInfo) {
        int i = 0;
        while (i < 10) {
            do {
                if (img_tab[i].validate(C_GraphixData.gc) == 0) continue;
                M_GraphixEngineUI.updatePlayerTab(gameInfo);
            } while (img_tab[i].contentsLost());
            g.drawImage(img_tab[i], C_GraphixData.intCoords[2 + i][0], C_GraphixData.intCoords[2 + i][1], null);
            ++i;
        }
        M_GraphixEngineUI.updateTexts(gameInfo, g);
    }

    protected static final void updateGraphics() {
        int y = 0;
        int srcStartX = 0;
        int srcStartY = 0;
        int srcEndX = 0;
        int srcEndY = 0;
        int destEndX = 6;
        int destEndY = 6;
        int sy = M_GraphixEngineUI.diff.sizeY;
        int sx = M_GraphixEngineUI.diff.sizeX;
        int imgID = 0;
        Gr_Arena a = diff;
        int n = 0;
        do {
            boolean stillOK = true;
            if (img_arena.validate(C_GraphixData.gc) != 0) {
                if (img_arena.validate(C_GraphixData.gc) == 2) {
                    if (img_arena != null) {
                        img_arena.flush();
                        img_arena = null;
                    }
                    img_arena = C_GraphixTools.createBackBufferVI(sx * 6, sx * 6);
                }
                a = arena[actArena];
            }
            int i = 0;
            while (stillOK && i < sy) {
                int j = 0;
                int x = 0;
                while (stillOK && j < sx) {
                    int actC = a.field[i][j];
                    if (actC > 0) {
                        if (actC == 46) {
                            srcStartX = x % C_GraphixData.gameImages[46].getWidth(null);
                            srcStartY = y % C_GraphixData.gameImages[46].getHeight(null);
                            srcEndX = srcStartX + 6;
                            srcEndY = srcStartY + 6;
                            destEndX = x + 6;
                            destEndY = y + 6;
                            imgID = 46;
                        } else if (actC >= 1 && actC <= 12) {
                            srcStartX = (actC - '\u0001') * 6;
                            srcStartY = 0;
                            srcEndX = srcStartX + 6;
                            srcEndY = 6;
                            destEndX = x + 6;
                            destEndY = y + 6;
                            imgID = 1;
                        } else if (actC >= 13 && actC <= 22) {
                            srcStartX = (actC - 13) * 6;
                            srcStartY = 0;
                            srcEndX = srcStartX + 6;
                            srcEndY = 6;
                            destEndX = x + 6;
                            destEndY = y + 6;
                            imgID = 48;
                        } else if (actC >= 48 && actC <= 57) {
                            srcStartX = (actC - 48) * 6;
                            srcStartY = 6;
                            srcEndX = srcStartX + 6;
                            srcEndY = srcStartY + 6;
                            destEndX = x + 6;
                            destEndY = y + 6;
                            imgID = 48;
                        } else if (actC >= 97 && actC <= 101) {
                            srcStartX = (actC - 97) * 6;
                            srcStartY = 0;
                            srcEndX = srcStartX + 6;
                            srcEndY = 6;
                            destEndX = x + 6;
                            destEndY = y + 6;
                            imgID = 97;
                        } else if (actC == 65) {
                            srcStartX = 0;
                            srcStartY = 0;
                            srcEndX = C_GraphixData.gameImages[65].getWidth(null) / 2;
                            srcEndY = C_GraphixData.gameImages[65].getHeight(null);
                            destEndX = x + srcEndX;
                            destEndY = y + srcEndY;
                            imgID = 65;
                        } else if (actC == 23) {
                            srcStartX = C_GraphixData.gameImages[65].getWidth(null) / 2;
                            srcStartY = 0;
                            srcEndX = C_GraphixData.gameImages[65].getWidth(null);
                            srcEndY = C_GraphixData.gameImages[65].getHeight(null);
                            imgID = 65;
                            destEndX = x + srcEndY;
                            destEndY = y + srcEndY;
                        } else {
                            srcStartX = 0;
                            srcStartY = 0;
                            srcEndX = 6;
                            srcEndY = 6;
                            destEndX = x + 6;
                            destEndY = y + 6;
                            imgID = actC;
                            if (C_GraphixData.gameImages[imgID] == null) {
                                imgID = 255;
                            }
                        }
                        stillOK = C_GraphixTools.drawGameImageToBackbuffer(img_arena, imgID, x, y, destEndX, destEndY, srcStartX, srcStartY, srcEndX, srcEndY);
                    }
                    ++j;
                    x += 6;
                }
                ++i;
                y += 6;
            }
            if (n > 0) {
                System.out.println("updateGraphics 1 " + n);
            }
            ++n;
        } while (img_arena.contentsLost());
    }

    protected static final void checkActivations(D_GameInfo gameInfo) {
        if (gameParam.getReplay() > 0) {
            M_GraphixEngineUI.menuFrame.butt_arena.setEnabled(false);
            M_GraphixEngineUI.menuFrame.butt_player.setEnabled(false);
            M_GraphixEngineUI.menuFrame.butt_options.setEnabled(false);
            M_GraphixEngineUI.replay.tgl_record.setEnabled(false);
            if (options.isVisible()) {
                options.setVisible(false);
            }
            if (arenaFS.isVisible()) {
                arenaFS.setVisible(false);
            }
            if (playerFS.isVisible()) {
                playerFS.setVisible(false);
            }
            int i = 0;
            while (i < 10) {
                M_GraphixEngineUI.menuFrame.butt_rmPlayer[i].setEnabled(false);
                ++i;
            }
            M_GraphixEngineUI.menuFrame.butt_run.setEnabled(true);
            if (gameInfo.gameRunning) {
                if (gameInfo.gameState != 3) {
                    M_GraphixEngineUI.menuFrame.butt_run.setToggle(false, true);
                }
                M_GraphixEngineUI.menuFrame.butt_stop.setEnabled(true);
                M_GraphixEngineUI.replay.butt_ejectReplay.setEnabled(false);
                M_GraphixEngineUI.replay.butt_loadReplay.setEnabled(false);
            } else {
                M_GraphixEngineUI.menuFrame.butt_stop.setEnabled(false);
                M_GraphixEngineUI.replay.butt_ejectReplay.setEnabled(true);
                M_GraphixEngineUI.replay.butt_loadReplay.setEnabled(true);
            }
        } else {
            if (gameInfo.gameRunning) {
                M_GraphixEngineUI.menuFrame.butt_run.setEnabled(true);
                M_GraphixEngineUI.arenaFS.butt_loadArena.setEnabled(false);
                M_GraphixEngineUI.playerFS.butt_addCPlayer.setEnabled(false);
                M_GraphixEngineUI.playerFS.butt_addHPlayer.setEnabled(false);
                M_GraphixEngineUI.menuFrame.butt_stop.setEnabled(true);
                M_GraphixEngineUI.replay.tgl_record.setEnabled(false);
                int i = 0;
                while (i < gameInfo.playerData.length) {
                    M_GraphixEngineUI.menuFrame.butt_rmPlayer[i].setEnabled(false);
                    ++i;
                }
                M_GraphixEngineUI.replay.butt_ejectReplay.setEnabled(false);
                M_GraphixEngineUI.replay.butt_loadReplay.setEnabled(false);
            } else {
                M_GraphixEngineUI.arenaFS.butt_loadArena.setEnabled(true);
                M_GraphixEngineUI.playerFS.butt_addCPlayer.setEnabled(true);
                M_GraphixEngineUI.playerFS.butt_addHPlayer.setEnabled(true);
                if (gameInfo.playerData.length > 0 && gameInfo.level != null) {
                    M_GraphixEngineUI.menuFrame.butt_run.setEnabled(true);
                } else {
                    M_GraphixEngineUI.menuFrame.butt_run.setEnabled(false);
                }
                M_GraphixEngineUI.menuFrame.butt_stop.setEnabled(false);
                M_GraphixEngineUI.replay.tgl_record.setEnabled(true);
                int i = 0;
                while (i < gameInfo.playerData.length) {
                    M_GraphixEngineUI.menuFrame.butt_rmPlayer[i].setEnabled(true);
                    ++i;
                }
                i = gameInfo.playerData.length;
                while (i < 10) {
                    M_GraphixEngineUI.menuFrame.butt_rmPlayer[i].setEnabled(false);
                    ++i;
                }
                M_GraphixEngineUI.replay.butt_ejectReplay.setEnabled(true);
                M_GraphixEngineUI.replay.butt_loadReplay.setEnabled(true);
            }
            M_GraphixEngineUI.menuFrame.butt_arena.setEnabled(true);
            M_GraphixEngineUI.menuFrame.butt_player.setEnabled(true);
            M_GraphixEngineUI.menuFrame.butt_options.setEnabled(true);
        }
        M_GraphixEngineUI.menuFrame.butt_replay.setEnabled(true);
    }

    public static final void setActive(boolean active) {
        if (active) {
            M_GraphixEngineUI.checkActivations(oldGameInfo);
        } else {
            M_GraphixEngineUI.menuFrame.butt_run.setEnabled(false);
            M_GraphixEngineUI.menuFrame.butt_stop.setEnabled(false);
            M_GraphixEngineUI.arenaFS.butt_loadArena.setEnabled(false);
            M_GraphixEngineUI.playerFS.butt_addCPlayer.setEnabled(false);
            M_GraphixEngineUI.playerFS.butt_addHPlayer.setEnabled(false);
            int i = 0;
            while (i < 10) {
                if (i < playerOrd.length) {
                    M_GraphixEngineUI.menuFrame.butt_rmPlayer[i].setEnabled(false);
                }
                ++i;
            }
        }
    }

    public static final void updateDialogs() {
        options.update(options.isVisible());
        replay.update(replay.isVisible());
    }

    public static final void update(D_GameInfo gameInfo, C_Human[] humanPlayer) {
        humans = humanPlayer;
        humanPlayerC = humans != null ? humans.length : 0;
        if (!gameInfo.gameRunning) {
            if (gameInfo.level == null) {
                actGraphics.fillRect(C_GraphixData.intCoords[1][0], C_GraphixData.intCoords[1][1], 450, 450);
            } else if (oldGameInfo == null || M_GraphixEngineUI.oldGameInfo.level == null || gameInfo.level.fileName.compareTo(M_GraphixEngineUI.oldGameInfo.level.fileName) != 0) {
                C_GraphixTools.loadCustomLevelGraphix(gameInfo.level.fileName);
                if (arena[actArena] == null || M_GraphixEngineUI.arena[M_GraphixEngineUI.actArena].sizeX != gameInfo.level.width || M_GraphixEngineUI.arena[M_GraphixEngineUI.actArena].sizeY != gameInfo.level.height) {
                    M_GraphixEngineUI.arena[M_GraphixEngineUI.actArena] = new Gr_Arena(gameInfo.level.playField, gameInfo);
                    diff = new Gr_DiffArena(arena[actArena]);
                    img_arena = C_GraphixTools.createBackBufferVI(M_GraphixEngineUI.arena[M_GraphixEngineUI.actArena].sizeX * 6, M_GraphixEngineUI.arena[M_GraphixEngineUI.actArena].sizeY * 6);
                    M_GraphixEngineUI.menuFrame.monPosX = C_GraphixData.intCoords[1][0] + (450 - M_GraphixEngineUI.arena[M_GraphixEngineUI.actArena].sizeX * 6) / 2;
                    M_GraphixEngineUI.menuFrame.monPosY = C_GraphixData.intCoords[1][1] + (450 - M_GraphixEngineUI.arena[M_GraphixEngineUI.actArena].sizeY * 6) / 2;
                    M_GraphixEngineUI.menuFrame.monWidth = M_GraphixEngineUI.arena[M_GraphixEngineUI.actArena].sizeX * 6;
                    M_GraphixEngineUI.menuFrame.monHeight = M_GraphixEngineUI.arena[M_GraphixEngineUI.actArena].sizeY * 6;
                    actGraphics.fillRect(C_GraphixData.intCoords[1][0], C_GraphixData.intCoords[1][1], 450, M_GraphixEngineUI.menuFrame.monPosY - C_GraphixData.intCoords[1][1]);
                    actGraphics.fillRect(C_GraphixData.intCoords[1][0], M_GraphixEngineUI.menuFrame.monPosY, M_GraphixEngineUI.menuFrame.monPosX - C_GraphixData.intCoords[1][0], M_GraphixEngineUI.menuFrame.monHeight);
                    actGraphics.fillRect(M_GraphixEngineUI.menuFrame.monPosX + M_GraphixEngineUI.menuFrame.monWidth, M_GraphixEngineUI.menuFrame.monPosY, M_GraphixEngineUI.menuFrame.monPosX - C_GraphixData.intCoords[1][0], M_GraphixEngineUI.menuFrame.monHeight);
                    actGraphics.fillRect(C_GraphixData.intCoords[1][0], M_GraphixEngineUI.menuFrame.monPosY + M_GraphixEngineUI.menuFrame.monHeight, 450, M_GraphixEngineUI.menuFrame.monPosY - C_GraphixData.intCoords[1][1]);
                } else {
                    arena[actArena].update(gameInfo.level.playField, gameInfo);
                    diff.update(M_GraphixEngineUI.arena[M_GraphixEngineUI.actArena].field);
                }
                M_GraphixEngineUI.updateGraphics();
            }
        } else {
            if (arena[1 - actArena] == null || M_GraphixEngineUI.arena[1 - M_GraphixEngineUI.actArena].sizeX != gameInfo.level.width || M_GraphixEngineUI.arena[1 - M_GraphixEngineUI.actArena].sizeY != gameInfo.level.height) {
                M_GraphixEngineUI.arena[1 - M_GraphixEngineUI.actArena] = new Gr_Arena(gameInfo.level.playField, gameInfo);
            } else {
                arena[1 - actArena].update(gameInfo.level.playField, gameInfo);
            }
            diff.update(arena[actArena], arena[1 - actArena]);
            actArena = 1 - actArena;
            M_GraphixEngineUI.updateGraphics();
        }
        if (gameInfo.gameState != 3) {
            M_GraphixEngineUI.checkActivations(gameInfo);
        }
        lastPlayerC = gameInfo.playerData.length;
        M_GraphixEngineUI.updatePlayer(gameInfo);
        M_GraphixEngineUI.updatePlayerTab(gameInfo);
        M_GraphixEngineUI.drawMenuElements(actGraphics, gameInfo);
        if (img_arena != null) {
            actGraphics.drawImage(img_arena, M_GraphixEngineUI.menuFrame.monPosX, M_GraphixEngineUI.menuFrame.monPosY, null, null);
        }
        if (oldGameInfo == null) {
            oldGameInfo = new D_GameInfo(gameInfo);
        } else {
            oldGameInfo.copyOnMe(gameInfo);
        }
        debugMon.sayBuffered();
    }

    private static class Gr_Arena {
        protected char[][] field;
        protected int sizeX;
        protected int sizeY;

        public Gr_Arena(int size_y, int size_x, char clearByte) {
            this(size_y, size_x);
            int i = 0;
            while (i < size_y) {
                int j = 0;
                while (j < size_x) {
                    this.field[i][j] = clearByte;
                    ++j;
                }
                ++i;
            }
        }

        public Gr_Arena(int size_y, int size_x) {
            this.field = new char[size_y][size_x];
            this.sizeX = size_x;
            this.sizeY = size_y;
        }

        public Gr_Arena(char[][] newField, D_GameInfo gameInfo) {
            this.sizeX = newField[0].length;
            this.sizeY = newField.length;
            this.field = new char[this.sizeY][this.sizeX];
            this.convert(this.field, newField, gameInfo);
        }

        public void fill(char clearByte) {
            int i = 0;
            while (i < this.sizeY) {
                int j = 0;
                while (j < this.sizeX) {
                    this.field[i][j] = clearByte;
                    ++j;
                }
                ++i;
            }
        }

        public void update(char[][] src, D_GameInfo gameInfo) {
            this.convert(this.field, src, gameInfo);
        }

        public void update(char[][] src) {
            int i = 0;
            while (i < this.sizeY) {
                int j = 0;
                while (j < this.sizeX) {
                    this.field[i][j] = src[i][j];
                    ++j;
                }
                ++i;
            }
        }

        private void convert(char[][] fieldDest, char[][] fieldSrc, D_GameInfo gameInfo) {
            int lenY = fieldSrc.length;
            int lenX = fieldSrc[0].length;
            D_PlayerData[] pd = gameInfo.playerData;
            int i = 0;
            while (i < lenY) {
                int prev_i = (i - 1 + lenY) % lenY;
                int succ_i = (i + 1) % lenY;
                int j = 0;
                while (j < lenX) {
                    int prev_j = (j - 1 + lenX) % lenX;
                    int succ_j = (j + 1) % lenX;
                    fieldDest[i][j] = '\u0000';
                    if (fieldSrc[i][j] == '#') {
                        if (fieldSrc[i][prev_j] != '#') {
                            fieldDest[i][j] = 12;
                        } else if (fieldSrc[i][succ_j] != '#') {
                            fieldDest[i][j] = 6;
                        }
                        if (fieldSrc[prev_i][j] != '#') {
                            fieldDest[i][j] = fieldDest[i][j] == '\f' ? 2 : (fieldDest[i][j] == '\u0006' ? 5 : 3);
                        } else if (fieldSrc[succ_i][j] != '#') {
                            fieldDest[i][j] = fieldDest[i][j] == '\f' ? 11 : (fieldDest[i][j] == '\u0006' ? 8 : 9);
                        } else if (fieldDest[i][j] == '\u0000') {
                            fieldDest[i][j] = fieldSrc[succ_i][succ_j] != '#' ? 7 : (fieldSrc[succ_i][prev_j] != '#' ? 10 : (fieldSrc[prev_i][succ_j] != '#' ? 4 : (fieldSrc[prev_i][prev_j] != '#' ? 1 : 35)));
                        }
                    } else {
                        fieldDest[i][j] = fieldSrc[i][j] == 'A' ? (fieldSrc[prev_i][j] != 'A' && fieldSrc[i][prev_j] != 'A' ? (gameInfo.gameTime >= gameInfo.exitTime ? 23 : 65) : 0) : fieldSrc[i][j];
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < pd.length) {
                if (pd[i].length > 0 && pd[i].snakeStatus == 0) {
                    this.field[pd[i].headPos.y][pd[i].headPos.x] = (char)(i + 13);
                }
                ++i;
            }
        }

        public String toString() {
            StringBuffer ret = new StringBuffer(this.sizeY * this.sizeX);
            int i = 0;
            while (i < this.sizeY) {
                int j = 0;
                while (j < this.sizeX) {
                    ret.append((char)(this.field[i][j] + 32));
                    ++j;
                }
                ret.append('\n');
                ++i;
            }
            return ret.toString();
        }
    }

    private static class Gr_DiffArena
    extends Gr_Arena {
        public Gr_DiffArena(Gr_Arena a1, Gr_Arena a2) {
            super(a1.sizeY, a1.sizeX, '.');
            this.update(a1, a2);
        }

        public Gr_DiffArena(Gr_Arena a) {
            super(a.sizeY, a.sizeX);
            int i = 0;
            while (i < a.sizeY) {
                int j = 0;
                while (j < a.sizeX) {
                    this.field[i][j] = a.field[i][j];
                    ++j;
                }
                ++i;
            }
        }

        public void update(Gr_Arena a1, Gr_Arena a2) {
            int i = a1.sizeY - 1;
            while (i >= 0) {
                int j = a1.sizeX - 1;
                while (j >= 0) {
                    this.field[i][j] = a1.field[i][j] == a2.field[i][j] ? (char)'\u0000' : a2.field[i][j];
                    --j;
                }
                --i;
            }
        }
    }
}

