/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.control.GaphixStuff;

import de.farafin.snEADy.control.GaphixStuff.C_GraphixData;
import de.farafin.snEADy.control.GaphixStuff.C_GraphixTools;
import de.farafin.snEADy.control.GaphixStuff.GrTextArea;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class GrTextField
extends GrTextArea {
    protected boolean carr;
    protected boolean numbersOnly;
    protected String comm;
    protected GrTextField troot = this;

    public GrTextField(int x, int y, int maxC, String initText, int allig, boolean onlyNumbers, String command) {
        this(x, y, maxC, 1, initText, allig, onlyNumbers, command);
    }

    public GrTextField(int x, int y, int maxC, int maxL, String initText, int allig, boolean onlyNumbers, String command) {
        super(x, y, maxC, maxL, initText, allig, true);
        this.comm = command;
        this.numbersOnly = onlyNumbers;
        this.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                GrTextField.this.carr = false;
                if (GrTextField.this.numbersOnly && GrTextField.this.text.length() == 0) {
                    GrTextField.this.text.append('0');
                    GrTextField.this.repaint();
                }
                if (GrTextField.this.comm != null) {
                    C_GraphixData.main.control(String.valueOf(GrTextField.this.comm) + GrTextField.this.text.toString());
                }
                GrTextField.this.action();
                GrTextField.this.redraw();
            }

            public void focusGained(FocusEvent e) {
                GrTextField.this.carr = true;
                GrTextField.this.redraw();
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (GrTextField.this.text.length() < GrTextField.this.text.capacity() - 1 && c > ' ' && c <= '~' && (!GrTextField.this.numbersOnly || c >= '0' && c <= '9')) {
                    GrTextField.this.text.append(e.getKeyChar());
                    GrTextField.this.redraw();
                }
            }

            public void keyPressed(KeyEvent e) {
                int c = e.getKeyCode();
                switch (c) {
                    case 8: {
                        if (GrTextField.this.text.length() > 0) {
                            GrTextField.this.text.deleteCharAt(GrTextField.this.text.length() - 1);
                        }
                        GrTextField.this.redraw();
                        break;
                    }
                    case 10: {
                        if (GrTextField.this.numbersOnly && GrTextField.this.text.length() == 0) {
                            GrTextField.this.text.append('0');
                        }
                        GrTextField.this.troot.getFocusCycleRootAncestor().requestFocus();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public void redraw() {
        this.renderText();
        this.paint(this.getGraphics());
    }

    private void renderText() {
        int lineC = this.text.length() / this.columns;
        StringBuffer drawT = new StringBuffer(this.text.length() + this.lines);
        int i = 0;
        while (i <= lineC) {
            drawT.append(this.text.substring(this.columns * i, this.columns * (i + 1) < this.text.length() ? this.columns * (i + 1) : this.text.length()));
            if (i < lineC) {
                drawT.append('\n');
            }
            ++i;
        }
        if (this.carr) {
            drawT.append('\u007f');
        }
        do {
            if (this.img_text.validate(C_GraphixData.gc) == 2) {
                this.img_text = C_GraphixTools.createBackBufferVI(this.showW, this.showH);
            }
            Graphics g = this.img_text.getGraphics();
            if (this.drawMode == 4) {
                g.setColor(C_GraphixData.col_textbghighlighted);
            } else {
                g.setColor(C_GraphixData.col_textbgnormal);
            }
            g.fillRect(0, 0, this.showW, this.showH);
            if (this.alligment == 0) {
                C_GraphixTools.drawBitmapString(drawT.toString(), 0, 0, 4, g, 0, this.drawMode);
                continue;
            }
            C_GraphixTools.drawBitmapString(drawT.toString(), this.showW, 0, 4, g, 1, this.drawMode);
        } while (this.img_text.contentsLost());
    }
}

