/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.control.GaphixStuff;

import de.farafin.snEADy.control.GaphixStuff.C_GraphixData;
import de.farafin.snEADy.control.GaphixStuff.C_GraphixTools;
import de.farafin.snEADy.control.GaphixStuff.GrTextArea;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.VolatileImage;

public class GrSelCanvas
extends GrTextArea {
    protected String[] list;
    private VolatileImage img_list;
    private VolatileImage img_listSel;
    protected int selected = -1;

    public GrSelCanvas(int x, int y, int maxC, int maxL, String[] itemList) {
        super(x, y, maxC, maxL, 'l');
        this.list = itemList;
        this.img_list = C_GraphixTools.createBackBufferVI(this.showW, this.showH);
        this.img_listSel = C_GraphixTools.createBackBufferVI(this.showW, this.showH);
        this.drawFileList(this.img_list, C_GraphixData.col_textbgnormal, 0);
        this.drawFileList(this.img_listSel, C_GraphixData.col_textbghighlighted, 4);
        this.addMouseListener(new MouseListener(){

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                if (GrSelCanvas.this.list == null) {
                    return;
                }
                int sel = (e.getY() - GrSelCanvas.this.borderW) / C_GraphixData.stdFontH;
                if (sel != GrSelCanvas.this.selected && sel < GrSelCanvas.this.list.length) {
                    GrSelCanvas.this.selected = sel;
                    GrSelCanvas.this.action();
                    GrSelCanvas.this.repaint();
                }
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                if (GrSelCanvas.this.list == null) {
                    return;
                }
                int sel = (e.getY() - GrSelCanvas.this.borderW) / C_GraphixData.stdFontH;
                if (sel != GrSelCanvas.this.selected && sel < GrSelCanvas.this.list.length) {
                    GrSelCanvas.this.selected = sel;
                    GrSelCanvas.this.repaint();
                }
            }

            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    public void updateList(String[] newL, boolean grUp) {
        this.list = null;
        this.list = newL;
        this.drawFileList(this.img_list, C_GraphixData.col_textbgnormal, 0);
        this.drawFileList(this.img_listSel, C_GraphixData.col_textbghighlighted, 4);
        if (grUp) {
            this.repaint();
        }
    }

    private String[] genListStrings() {
        int l = this.list.length;
        String[] ret = new String[l];
        int i = 0;
        while (i < l) {
            int sl = this.list[i].lastIndexOf(46);
            ret[i] = sl > this.columns ? String.valueOf(this.list[i].substring(0, this.columns - 3)) + "..." : this.list[i].substring(0, sl);
            ++i;
        }
        return ret;
    }

    private void drawFileList(VolatileImage img, Color col, int fontID) {
        Graphics g = img.getGraphics();
        String[] listStr = null;
        if (this.list != null) {
            listStr = this.genListStrings();
        }
        do {
            int i = 0;
            if (img.validate(C_GraphixData.gc) == 2) {
                img = C_GraphixTools.createBackBufferVI(this.showW, this.showH);
                g.dispose();
                g = img.getGraphics();
            }
            g.setColor(col);
            g.fillRect(0, 0, this.showW, this.showH);
            if (this.list == null) continue;
            while (!img.contentsLost() && i < this.lines && i < this.list.length) {
                C_GraphixTools.drawBitmapString(listStr[this.showedLinesStart + i], 0, i * C_GraphixData.stdFontH, 4, g, 108, fontID);
                ++i;
            }
        } while (img.contentsLost());
    }

    private void drawList(Graphics g) {
        if (this.img_list.validate(C_GraphixData.gc) != 0) {
            this.drawFileList(this.img_list, C_GraphixData.col_textbgnormal, 0);
        }
        g.drawImage(this.img_list, this.borderW, this.borderW, this.w - this.borderW, this.borderW + this.selected * C_GraphixData.stdFontH, 0, 0, this.showW, this.selected * C_GraphixData.stdFontH, null);
        if (this.img_listSel.validate(C_GraphixData.gc) != 0) {
            this.drawFileList(this.img_list, C_GraphixData.col_textbgnormal, 0);
        }
        g.drawImage(this.img_listSel, this.borderW, this.borderW + this.selected * C_GraphixData.stdFontH, this.w - this.borderW, this.borderW + (this.selected + 1) * C_GraphixData.stdFontH, 0, this.selected * C_GraphixData.stdFontH, this.showW, (this.selected + 1) * C_GraphixData.stdFontH, null);
        if (this.img_list.validate(C_GraphixData.gc) != 0) {
            this.drawFileList(this.img_list, C_GraphixData.col_textbgnormal, 0);
        }
        g.drawImage(this.img_list, this.borderW, this.borderW + (this.selected + 1) * C_GraphixData.stdFontH, this.w - this.borderW, this.h - this.borderW, 0, (this.selected + 1) * C_GraphixData.stdFontH, this.showW, this.showH, null);
    }

    public void updateDSelect(int newDSel) {
        this.selected += this.showedLinesStart - newDSel;
        this.showedLinesStart = newDSel;
        this.drawFileList(this.img_list, C_GraphixData.col_textbgnormal, 0);
        this.drawFileList(this.img_listSel, C_GraphixData.col_textbghighlighted, 4);
        this.drawList(this.getGraphics());
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.drawList(g);
    }

    public void repaint() {
        this.paint(this.getGraphics());
    }
}

