/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.communication;

import de.farafin.snEADy.communication.D_Level;
import de.farafin.snEADy.communication.D_PlayerData;
import de.farafin.snEADy.inOut.C_LogFileWriter;
import de.farafin.snEADy.inOut.C_RecordFileReader;
import de.farafin.snEADy.inOut.C_RecordFileWriter;

public final class D_GameInfo {
    public D_Level level = null;
    public D_PlayerData[] playerData = null;
    public long gameTime = 0L;
    public long suddenDeath = 0L;
    public long exitTime = 0L;
    public C_LogFileWriter playerLog = null;
    public boolean gameRunning = false;
    public C_RecordFileReader recordReader = null;
    public C_RecordFileWriter recordWriter = null;
    public int gameState = 0;

    public D_GameInfo() {
        this.level = null;
        this.playerData = new D_PlayerData[0];
        this.gameTime = 0L;
        this.exitTime = 0L;
        this.suddenDeath = 0L;
        this.gameRunning = false;
        this.recordWriter = null;
        this.recordReader = null;
        this.gameState = 0;
        this.playerLog = null;
    }

    public D_GameInfo(D_Level level, D_PlayerData[] playerData, long gameTime, long exitTime, long sdTime, boolean running, int gameState, C_LogFileWriter playerLog) {
        this.exitTime = exitTime;
        this.suddenDeath = sdTime;
        this.level = (D_Level)level.clone();
        int i = 0;
        while (i < playerData.length) {
            this.playerData[i] = (D_PlayerData)playerData[i].clone();
            ++i;
        }
        this.gameTime = gameTime;
        this.exitTime = exitTime;
        this.suddenDeath = sdTime;
        this.gameRunning = running;
        this.recordWriter = null;
        this.recordReader = null;
        this.gameState = gameState;
        this.playerLog = playerLog;
    }

    public D_GameInfo(D_GameInfo gameInfo) {
        this.level = gameInfo.level;
        this.playerData = gameInfo.playerData;
        this.gameTime = gameInfo.gameTime;
        this.exitTime = gameInfo.exitTime;
        this.suddenDeath = gameInfo.suddenDeath;
        this.gameRunning = gameInfo.gameRunning;
        this.recordWriter = gameInfo.recordWriter;
        this.recordReader = gameInfo.recordReader;
        this.gameState = gameInfo.gameState;
        this.playerLog = gameInfo.playerLog;
    }

    public void copyOnMe(D_GameInfo gameInfo) {
        this.gameTime = gameInfo.gameTime;
        this.exitTime = gameInfo.exitTime;
        this.suddenDeath = gameInfo.suddenDeath;
        this.gameRunning = gameInfo.gameRunning;
        if (gameInfo.level != null) {
            if (this.level == null) {
                this.level = new D_Level();
            }
            this.level.copyOnMe(gameInfo.level);
        } else {
            this.level = null;
        }
        if (this.playerData == null || this.playerData.length != gameInfo.playerData.length) {
            this.playerData = new D_PlayerData[gameInfo.playerData.length];
            int i = 0;
            while (i < this.playerData.length) {
                this.playerData[i] = new D_PlayerData(gameInfo.playerData[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.playerData.length) {
                this.playerData[i].copyOnMe(gameInfo.playerData[i]);
                ++i;
            }
        }
        this.recordWriter = gameInfo.recordWriter;
        this.recordReader = gameInfo.recordReader;
        this.gameState = gameInfo.gameState;
        this.playerLog = gameInfo.playerLog;
    }

    public void addPlayerData(D_PlayerData pData) {
        D_PlayerData[] tmpPData = this.playerData;
        this.playerData = new D_PlayerData[this.playerData.length + 1];
        int i = 0;
        while (i < tmpPData.length) {
            this.playerData[i] = tmpPData[i];
            ++i;
        }
        this.playerData[this.playerData.length - 1] = pData;
    }

    public Object clone() {
        D_GameInfo gameInfo = new D_GameInfo();
        gameInfo.level = (D_Level)this.level.clone();
        gameInfo.playerData = new D_PlayerData[this.playerData.length];
        int i = 0;
        while (i < gameInfo.playerData.length) {
            gameInfo.playerData[i] = (D_PlayerData)this.playerData[i].clone();
            ++i;
        }
        gameInfo.gameTime = this.gameTime;
        gameInfo.exitTime = this.exitTime;
        gameInfo.suddenDeath = this.suddenDeath;
        gameInfo.recordWriter = this.recordWriter;
        gameInfo.recordReader = this.recordReader;
        gameInfo.gameState = this.gameState;
        gameInfo.playerLog = this.playerLog;
        return gameInfo;
    }

    public String toString() {
        return super.toString();
    }
}

