/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy;

import de.farafin.snEADy.GameParameter;
import de.farafin.snEADy.M_Main;
import de.farafin.snEADy.communication.D_GameInfo;
import de.farafin.snEADy.communication.D_PlayerData;
import de.farafin.snEADy.communication.D_RecoverData;
import de.farafin.snEADy.communication.I_Constants;
import de.farafin.snEADy.inOut.C_LogFileWriter;
import de.farafin.snEADy.player.GameInfo;
import de.farafin.snEADy.player.LevelInfo;
import de.farafin.snEADy.player.OwnSnakeInfo;
import de.farafin.snEADy.player.Player;
import de.farafin.snEADy.player.SnakeInfo;
import java.util.Random;

public final class M_PlayerHandler
implements I_Constants {
    private Player[] playerInstances = null;
    private int lastPlayer = -1;
    private PlayerRun playerRun;
    protected Thread playerThread;
    protected static M_PlayerHandler instance;
    private boolean imergencyPaused = false;
    protected final PlayerInfo playerInfo;
    protected long playerCalculationtime = 0L;
    private C_LogFileWriter playerLog = null;
    private Random randNumber = null;
    private long nextSizeControllTime = 0L;
    private int nextMemCheck = 0;
    private final GameParameter parameter = M_Main.getInstance().getParameter();

    private M_PlayerHandler() {
        this.playerInfo = new PlayerInfo();
        this.playerRun = new PlayerRun();
        this.playerThread = new Thread(this.playerRun);
        this.playerThread.start();
    }

    private void reGenPlayerInfo(int playerIndex, D_GameInfo gameInfo) {
        int i;
        int j = 0;
        if (this.playerInfo.playerSnakeInfo == null || this.playerInfo.playerSnakeInfo.length != gameInfo.playerData.length - 1) {
            this.playerInfo.playerSnakeInfo = new SnakeInfo[this.playerInstances.length - 1];
            i = 0;
            while (i < this.playerInfo.playerSnakeInfo.length) {
                this.playerInfo.playerSnakeInfo[i] = new SnakeInfo();
                ++i;
            }
        }
        i = 0;
        while (i < this.playerInfo.playerSnakeInfo.length + 1) {
            if (i == playerIndex) {
                j = 1;
            } else {
                this.playerInfo.playerSnakeInfo[i - j].playerName = gameInfo.playerData[i].name;
                this.playerInfo.playerSnakeInfo[i - j].snakeChar = gameInfo.playerData[i].ownChar;
                this.playerInfo.playerSnakeInfo[i - j].headPosLine = gameInfo.playerData[i].headPos.y;
                this.playerInfo.playerSnakeInfo[i - j].headPosRow = gameInfo.playerData[i].headPos.x;
                this.playerInfo.playerSnakeInfo[i - j].points = gameInfo.playerData[i].killPoints;
                this.playerInfo.playerSnakeInfo[i - j].snakeLength = gameInfo.playerData[i].length;
                this.playerInfo.playerSnakeInfo[i - j].snakeStatus = gameInfo.playerData[i].snakeStatus;
                switch (gameInfo.playerData[playerIndex].snakeStatus) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.playerInfo.playerSnakeInfo[i - j].snakeStatus = gameInfo.playerData[i].snakeStatus;
                        break;
                    }
                    default: {
                        this.playerInfo.playerSnakeInfo[i - j].snakeStatus = 1;
                    }
                }
                this.playerInfo.playerSnakeInfo[i - j].waitCycles = gameInfo.playerData[i].waitCycles;
            }
            ++i;
        }
        if (this.playerInfo.playerOwnSnakeInfo == null) {
            this.playerInfo.playerOwnSnakeInfo = new OwnSnakeInfo();
        }
        this.playerInfo.playerOwnSnakeInfo.playerName = gameInfo.playerData[playerIndex].name;
        this.playerInfo.playerOwnSnakeInfo.snakeChar = gameInfo.playerData[playerIndex].ownChar;
        this.playerInfo.playerOwnSnakeInfo.headPosLine = gameInfo.playerData[playerIndex].headPos.y;
        this.playerInfo.playerOwnSnakeInfo.headPosRow = gameInfo.playerData[playerIndex].headPos.x;
        this.playerInfo.playerOwnSnakeInfo.points = gameInfo.playerData[playerIndex].killPoints;
        this.playerInfo.playerOwnSnakeInfo.snakeLength = gameInfo.playerData[playerIndex].length;
        this.playerInfo.playerOwnSnakeInfo.waitCycles = gameInfo.playerData[playerIndex].waitCycles;
        this.playerInfo.playerOwnSnakeInfo.nextMoveTime = gameInfo.playerData[playerIndex].nextUpdateTime;
        this.playerInfo.playerOwnSnakeInfo.lastCalculatedMemUsage = gameInfo.playerData[playerIndex].lastCalculatedMemUsage;
        switch (gameInfo.playerData[playerIndex].snakeStatus) {
            case 0: 
            case 1: 
            case 2: {
                this.playerInfo.playerOwnSnakeInfo.snakeStatus = gameInfo.playerData[playerIndex].snakeStatus;
                break;
            }
            default: {
                this.playerInfo.playerOwnSnakeInfo.snakeStatus = 1;
            }
        }
        this.playerInfo.playerOwnSnakeInfo.headDirection = gameInfo.playerData[playerIndex].watchDirection;
        this.playerInfo.playerLevelInfo.levelName = gameInfo.level.name;
        this.playerInfo.playerLevelInfo.height = gameInfo.level.height;
        this.playerInfo.playerLevelInfo.width = gameInfo.level.width;
        this.playerInfo.playerLevelInfo.playField = gameInfo.level.playField;
        this.playerInfo.playerGameInfo.gameTime = this.parameter.getGameTime();
        this.playerInfo.playerGameInfo.exitTime = this.parameter.getExit_time();
        this.playerInfo.playerGameInfo.suddenDeathTime = this.parameter.getSuddend_time();
        this.playerInfo.playerGameInfo.thinkingMS = this.parameter.getMax_thinking_ms();
        this.playerInfo.playerGameInfo.analyseMS = this.parameter.getAnalyse_ms();
        this.playerInfo.playerGameInfo.maxMem = this.parameter.getMax_player_mem();
        this.playerInfo.playerGameInfo.damage_points_radius = this.parameter.getDamage_points_radius();
        this.playerInfo.playerGameInfo.kill_points_radius = this.parameter.getKill_points_radius();
        this.playerInfo.playerGameInfo.kill_point_goodies = this.parameter.getKill_point_goodies();
        this.playerInfo.playerGameInfo.damage_length_grow = this.parameter.getDamage_length_grow();
        this.playerInfo.playerGameInfo.min_move_delay = this.parameter.getMin_move_delay();
        this.playerInfo.playerGameInfo.max_move_delay = this.parameter.getMax_move_delay();
        this.playerInfo.playerGameInfo.auto_grow_delay = this.parameter.getAuto_grow_delay();
        this.playerInfo.playerGameInfo.auto_slowdown_delay = this.parameter.getAuto_slowdown_delay();
        this.playerInfo.playerGameInfo.max_goody_occ_delay = this.parameter.getMax_goody_occ_delay();
        this.playerInfo.playerGameInfo.goody_speed_occ = this.parameter.getGoody_speed_occ();
        this.playerInfo.playerGameInfo.goody_slowdown_occ = this.parameter.getGoody_slowdown_occ();
        this.playerInfo.playerGameInfo.goody_length_occ = this.parameter.getGoody_length_occ();
        this.playerInfo.playerGameInfo.goody_points_occ = this.parameter.getGoody_points_occ();
        this.playerInfo.playerGameInfo.goody_shorter_occ = this.parameter.getGoody_shorter_occ();
        this.playerInfo.playerGameInfo.goody_length_value = this.parameter.getGoody_length_value();
        this.playerInfo.playerGameInfo.goody_points_value = this.parameter.getGoody_points_value();
        this.playerInfo.playerGameInfo.goody_shorter_value = this.parameter.getGoody_shorter_value();
        this.playerInfo.playerGameInfo.survival_points = this.parameter.getSurvival_points();
        this.playerInfo.playerGameInfo.easy_points = this.parameter.getEasy_points();
    }

    protected void initGame(Player[] players, C_LogFileWriter playerLog) {
        this.playerInstances = players;
        this.playerLog = playerLog;
        this.playerLog.storeLine("start Game\nPlayer:");
        this.playerInfo.playerGameInfo = new GameInfo();
        this.playerInfo.playerLevelInfo = new LevelInfo();
        this.playerInfo.playerSnakeInfo = new SnakeInfo[players.length];
        this.playerInfo.playerOwnSnakeInfo = new OwnSnakeInfo();
        int i = 0;
        while (i < players.length) {
            if (players[i] != null) {
                this.playerLog.storeLine(String.valueOf(i) + ": " + players[i].getName());
            }
            this.playerInfo.playerSnakeInfo[i] = new SnakeInfo();
            ++i;
        }
        this.playerLog.storeLine("-----------------------------------------------------------------------\n");
        this.randNumber = new Random();
        this.nextSizeControllTime = (long)(this.randNumber.nextDouble() * (double)this.parameter.getMax_mem_check_delay());
    }

    protected void recover(D_RecoverData recoverData) {
    }

    protected synchronized void awakePlayerHandler() {
        this.notify();
    }

    /*
     * Exception decompiling
     */
    protected synchronized void runPlayer(D_GameInfo gameInfo, D_PlayerData[] playerData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void abbort() {
        this.playerLog.storeLine("end Game");
        this.playerInfo.playerGameInfo = null;
        this.playerInfo.playerLevelInfo = null;
        this.playerInfo.playerOwnSnakeInfo = null;
        this.playerInfo.playerSnakeInfo = null;
        this.playerInstances = null;
        this.playerThread = null;
        if (this.parameter.getLogging() == 1) {
            this.playerLog.saveAndCloseFile();
        }
    }

    protected void imergencyPause() {
        if (!this.imergencyPaused) {
            this.imergencyPaused = true;
            if (this.playerThread != null && this.playerThread.isAlive()) {
                this.playerLog.storeLine("SUSPEND!! SystemTime: " + System.currentTimeMillis());
                this.playerThread.suspend();
            }
        } else {
            this.imergencyPaused = false;
            if (this.playerThread != null && this.playerThread.isAlive()) {
                this.playerLog.storeLine("RESUME!! SystemTime: " + System.currentTimeMillis());
                this.playerThread.resume();
            }
        }
    }

    protected void kill() {
        if (this.playerThread != null && this.playerThread.isAlive()) {
            this.playerThread.stop();
        }
    }

    protected static M_PlayerHandler getInstance() {
        if (instance == null) {
            instance = new M_PlayerHandler();
        }
        return instance;
    }

    protected static void destroyInstance(M_PlayerHandler playerHandler) {
        playerHandler.imergencyPaused = false;
        playerHandler.lastPlayer = -1;
        playerHandler.playerInstances = null;
        playerHandler.nextSizeControllTime = -1L;
        playerHandler.randNumber = null;
        if (playerHandler.playerThread != null && playerHandler.playerThread.isAlive()) {
            playerHandler.playerThread.stop();
        }
        playerHandler.playerThread = null;
        instance = null;
    }

    private class PlayerInfo {
        public GameInfo playerGameInfo = null;
        public LevelInfo playerLevelInfo = null;
        public SnakeInfo[] playerSnakeInfo = null;
        public OwnSnakeInfo playerOwnSnakeInfo = null;

        PlayerInfo() {
        }
    }

    private class PlayerRun
    implements Runnable {
        protected Player runningPlayer;
        protected boolean waiting;
        public boolean calculationFinished;
        public boolean threwException;
        public Throwable thrownException;

        PlayerRun() {
        }

        public final void renew(Player player) {
            this.runningPlayer = player;
            this.calculationFinished = false;
            this.threwException = false;
            this.thrownException = null;
        }

        protected synchronized void awakePlayerRun() {
            this.notify();
        }

        public void run() {
            while (true) {
                PlayerRun playerRun = this;
                synchronized (playerRun) {
                    try {
                        this.waiting = true;
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.waiting = false;
                }
                M_PlayerHandler.this.playerCalculationtime = -System.currentTimeMillis();
                try {
                    this.runningPlayer.startCalculation(M_PlayerHandler.this.playerInfo.playerGameInfo, M_PlayerHandler.this.playerInfo.playerLevelInfo, M_PlayerHandler.this.playerInfo.playerSnakeInfo, M_PlayerHandler.this.playerInfo.playerOwnSnakeInfo);
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.threwException = true;
                    this.thrownException = e;
                }
                M_PlayerHandler.this.playerCalculationtime += System.currentTimeMillis();
                playerRun = this;
                synchronized (playerRun) {
                    this.calculationFinished = true;
                }
                M_PlayerHandler.this.awakePlayerHandler();
            }
        }
    }
}

