/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy;

import de.farafin.snEADy.C_DebugMonitor;
import de.farafin.snEADy.GameParameter;
import de.farafin.snEADy.I_GameStats;
import de.farafin.snEADy.I_Main_interface;
import de.farafin.snEADy.M_GameEngine;
import de.farafin.snEADy.communication.D_GameInfo;
import de.farafin.snEADy.communication.D_Level;
import de.farafin.snEADy.communication.D_PlayerData;
import de.farafin.snEADy.communication.D_RecoverData;
import de.farafin.snEADy.communication.I_Constants;
import de.farafin.snEADy.communication.I_PlayFieldConstants;
import de.farafin.snEADy.control.C_Human;
import de.farafin.snEADy.control.GaphixStuff.M_GraphixEngineUI;
import de.farafin.snEADy.inOut.C_FileClassLoader;
import de.farafin.snEADy.inOut.C_LevelLoader;
import de.farafin.snEADy.inOut.C_LogFileReader;
import de.farafin.snEADy.inOut.C_LogFileWriter;
import de.farafin.snEADy.inOut.C_RecordFileReader;
import de.farafin.snEADy.inOut.C_RecordFileWriter;
import de.farafin.snEADy.inOut.C_SneadyFileInteractor;
import de.farafin.snEADy.inOut.E_LevelFileException;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public final class M_Main
implements I_Main_interface,
I_Constants,
I_GameStats,
I_PlayFieldConstants {
    private M_GameEngine gameEngine;
    private D_GameInfo gameInfo;
    private D_GameInfo initGameInfo;
    private D_GameInfo recGameInfo;
    private int gameState;
    private boolean lockedControl = false;
    private C_LogFileWriter controlLog = null;
    private C_LogFileWriter tableLog = null;
    private C_LogFileWriter resultLog = null;
    private C_LogFileWriter playerLog = null;
    private String logExtension = "";
    private int startCounter = 0;
    private int scriptEx = 0;
    private final GameParameter parameter;
    private GameParameter initParameter;
    private GameParameter recParameter;
    private static M_Main instance;
    private final C_DebugMonitor monitor;
    private static final int version = 1019;
    private boolean gui = true;
    private int oldCycleMS = 0;
    private long gameRunningTime = 0L;
    private String SystemStartTime = "";
    private String SystemEndTime = "";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private M_Main() {
        if (instance != null) {
            throw new InstantiationError("Only one instance of snEADy is allowed!");
        }
        this.gameState = 0;
        this.parameter = new GameParameter();
        this.initParameter = new GameParameter();
        this.recParameter = new GameParameter();
        this.monitor = new C_DebugMonitor();
        this.gameInfo = new D_GameInfo();
        this.initGameInfo = new D_GameInfo();
        this.recGameInfo = new D_GameInfo();
        this.lockedControl = false;
        this.controlLog = null;
        this.tableLog = null;
        this.resultLog = null;
        this.playerLog = null;
        this.logExtension = "";
        instance = this;
        this.oldCycleMS = 0;
        this.gui = true;
        this.scriptEx = 0;
        this.gameEngine = M_GameEngine.getInstance();
        this.gameInfo.gameState = this.gameState;
    }

    private Class loadPlayerClass(String className) {
        try {
            Class c = new C_FileClassLoader("player").loadClass(className, true);
            return c;
        }
        catch (Exception e) {
            System.out.println("WARNING: player wasnt loaded \n\t" + e);
            return null;
        }
    }

    public D_Level getLevelHeader(String levelName) {
        C_LevelLoader levelLoader = new C_LevelLoader();
        D_Level level = null;
        try {
            level = levelLoader.loadLevelHeader(levelName);
        }
        catch (FileNotFoundException e) {
            System.out.println("WARNING: " + e);
            return null;
        }
        catch (E_LevelFileException e) {
            System.out.println("WARNING: " + e);
            return null;
        }
        return level;
    }

    private D_Level loadLevel(String levelName) {
        C_LevelLoader levelLoader = new C_LevelLoader();
        D_Level level = null;
        try {
            level = levelLoader.loadLevel(levelName);
        }
        catch (FileNotFoundException e) {
            System.out.println("WARNING: " + e);
            return null;
        }
        catch (E_LevelFileException e) {
            System.out.println("WARNING: " + e);
            return null;
        }
        return level;
    }

    private void recover(D_RecoverData recoverData) {
    }

    private void startScript(String[] args) {
        String fileName = null;
        this.controlLog.storeLine("Program arguments:");
        this.controlLog.storeLine("\t");
        int i = 0;
        while (i < args.length) {
            this.controlLog.addToLastLine(String.valueOf(args[i]) + " ");
            if (args[i].startsWith("-script")) {
                fileName = String.valueOf(args[++i]) + ".script";
            }
            ++i;
        }
        if (fileName == null) {
            fileName = "default.script";
        }
        this.controlLog.storeLine("load Script: " + fileName);
        this.loadScript("scripts", fileName);
        if (this.gui) {
            M_GraphixEngineUI.update(this.gameInfo, null);
        }
        if (this.gui) {
            M_GraphixEngineUI.setActive(true);
        }
        if (this.gui) {
            M_GraphixEngineUI.updateDialogs();
        }
    }

    private void startLog() {
        String zero = "";
        if (this.startCounter < 10) {
            zero = "000";
        } else if (this.startCounter < 100) {
            zero = "00";
        } else if (this.startCounter < 1000) {
            zero = "0";
        }
        this.tableLog = new C_LogFileWriter("logs", String.valueOf(this.logExtension) + zero + this.startCounter + "_table.log");
        this.resultLog = new C_LogFileWriter("logs", String.valueOf(this.logExtension) + zero + this.startCounter + "_result.log");
        this.gameInfo.playerLog = this.playerLog = new C_LogFileWriter("logs", String.valueOf(this.logExtension) + zero + this.startCounter + "_player.log");
        ++this.startCounter;
    }

    private void computeArguments(String[] args) {
        int i = 0;
        this.logExtension = "";
        i = 0;
        while (i < args.length) {
            if (args[i].toLowerCase().startsWith("-log") && ++i < args.length && !args[i].startsWith("-")) {
                this.logExtension = String.valueOf(args[i].toLowerCase()) + "_";
            }
            ++i;
        }
        this.controlLog = new C_LogFileWriter("logs", String.valueOf(this.logExtension) + "control.log");
        this.controlLog.storeLine("check sneady-call parameter\n");
        this.gui = true;
        i = 0;
        while (i < args.length) {
            this.controlLog.storeLine(args[i]);
            if (args[i].toLowerCase().startsWith("-nogui")) {
                this.gui = false;
            }
            ++i;
        }
    }

    private boolean loadScript(String root, String fileName) {
        C_LogFileReader script = null;
        String line = null;
        ++this.scriptEx;
        try {
            script = new C_LogFileReader(root, fileName);
            while (!script.isFinished()) {
                line = script.readNextLine();
                line = line.split("%")[0];
                this.control(line);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("WARNING: Script wasn't loaded!\n" + e);
            return false;
        }
        --this.scriptEx;
        if (this.gui) {
            M_GraphixEngineUI.updateDialogs();
        }
        return true;
    }

    private boolean loadReplay(String root, String fileName) {
        this.gameInfo.recordReader = null;
        String[] header = null;
        String line = null;
        int i = 0;
        ++this.scriptEx;
        try {
            this.gameInfo.recordReader = new C_RecordFileReader(root, fileName);
            header = this.gameInfo.recordReader.readHeader();
            i = 0;
            while (i < header.length) {
                line = header[i].split("%")[0];
                this.control(line);
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            --this.scriptEx;
            System.out.println("WARNING: Replay wasn't loaded!\n" + e);
            return false;
        }
        --this.scriptEx;
        if (this.gui) {
            M_GraphixEngineUI.updateDialogs();
        }
        return true;
    }

    private boolean gameHasHuman() {
        int i = 0;
        int humans = 0;
        i = 0;
        while (i < this.gameInfo.playerData.length) {
            if (this.gameInfo.playerData[i].playerClass.getName().endsWith("C_Human")) {
                ++humans;
            }
            ++i;
        }
        return humans > 0;
    }

    private void writeResults() {
        String status = "";
        int[] points = null;
        int i = 0;
        int j = 0;
        int point = 0;
        this.gameRunningTime += System.currentTimeMillis();
        points = new int[this.gameInfo.playerData.length];
        point = this.gameInfo.playerData.length;
        i = 0;
        while (i < points.length) {
            point = 0;
            j = 0;
            while (j < points.length) {
                if (this.gameInfo.playerData[i].killPoints >= this.gameInfo.playerData[j].killPoints) {
                    ++point;
                }
                ++j;
            }
            points[i] = this.gameInfo.playerData[i].snakeStatus == 0 || this.gameInfo.playerData[i].snakeStatus == 1 || this.gameInfo.playerData[i].snakeStatus == 2 ? point : 0;
            ++i;
        }
        this.resultLog.storeLine("final Game Time:    " + this.gameInfo.gameTime);
        this.resultLog.storeLine("used Level:\n" + this.gameInfo.level + "\n");
        this.resultLog.storeLine("===============================================");
        this.tableLog.storeLine("Level: " + this.gameInfo.level.name + "\nCycles: " + this.gameInfo.gameTime);
        j = 0;
        while (j < this.gameInfo.playerData.length) {
            this.resultLog.storeLine("player " + j + ":");
            this.resultLog.storeLine("\tname:               " + this.gameInfo.playerData[j].name);
            this.resultLog.storeLine("\tlength:             " + this.gameInfo.playerData[j].length);
            this.resultLog.storeLine("\tTournament Points:  " + points[j]);
            this.resultLog.storeLine("\tin-Game Points:     " + this.gameInfo.playerData[j].killPoints);
            this.resultLog.storeLine("\tkills:              " + this.gameInfo.playerData[j].kills);
            switch (this.gameInfo.playerData[j].snakeStatus) {
                case 0: {
                    status = "IN_ACTION";
                    break;
                }
                case 1: {
                    status = "IN_HEAVEN";
                    break;
                }
                case 2: {
                    status = "IN_EXIT";
                    break;
                }
                case 4: {
                    status = "IN_ERROR_TIME";
                    break;
                }
                case 3: {
                    status = "IN_ERROR_SPACE";
                    break;
                }
                case 5: {
                    status = "IN_ERROR_INIT";
                    break;
                }
                case 6: {
                    status = "IN_ERROR_EXC";
                }
            }
            this.resultLog.storeLine("\tstate:              " + status);
            this.tableLog.storeLine("\nName: " + this.gameInfo.playerData[j].playerClass.getName() + "\nTournament Points: " + points[j] + "\nin-Game Points: " + this.gameInfo.playerData[j].killPoints + "\nKills:  " + this.gameInfo.playerData[j].kills + "\nStatus: " + status);
            this.resultLog.storeLine("-----------------------------------------------");
            ++j;
        }
        this.resultLog.storeLine("\nStarted: " + this.SystemStartTime);
        this.tableLog.storeLine("\nStarted: " + this.SystemStartTime);
        this.resultLog.storeLine("Ended: " + new SimpleDateFormat("HH:mm:ss dd.MM.yyyy").format(new GregorianCalendar().getTime()));
        this.tableLog.storeLine("Ended: " + new SimpleDateFormat("HH:mm:ss dd.MM.yyyy").format(new GregorianCalendar().getTime()));
        this.resultLog.storeLine("\nplayed MS: " + this.gameRunningTime);
        this.tableLog.storeLine("\nplayed MS: " + this.gameRunningTime);
        this.resultLog.saveAndCloseFile();
        this.tableLog.saveAndCloseFile();
        if (this.gameInfo.recordWriter != null && this.parameter.getRecord() == 1) {
            this.gameInfo.recordWriter.saveAndCloseFile();
        }
    }

    protected void update(D_GameInfo gInfo, C_Human[] humanInstances) {
        int i = 0;
        switch (M_Main.getInstance().getGameState()) {
            case 0: {
                break;
            }
            case 1: {
                this.gameInfo = gInfo;
                this.writeResults();
                this.quit(0);
                break;
            }
            case 3: {
                int snakeCount = 0;
                i = 0;
                while (i < gInfo.playerData.length) {
                    if (gInfo.playerData[i].snakeStatus == 0) {
                        ++snakeCount;
                    } else if (gInfo.playerData[i].snakeStatus == 2 && gInfo.playerData[i].length >= 2) {
                        ++snakeCount;
                    }
                    ++i;
                }
                if (snakeCount <= 0) {
                    switch (this.parameter.getGame_end()) {
                        case 0: {
                            this.gameState = 4;
                            break;
                        }
                        case 1: {
                            this.gameState = 8;
                            break;
                        }
                        case 2: {
                            this.gameState = 1;
                            break;
                        }
                        default: {
                            this.gameState = 4;
                        }
                    }
                }
                this.gameInfo = gInfo;
                if (!this.gui) break;
                M_GraphixEngineUI.update(this.gameInfo, humanInstances);
                break;
            }
            case 2: {
                this.gameInfo = gInfo;
                break;
            }
            case 4: {
                this.gameInfo = gInfo;
                if (!this.gui) break;
                M_GraphixEngineUI.update(this.gameInfo, humanInstances);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 8: {
                this.gameInfo = gInfo;
                this.writeResults();
                if (this.gui) {
                    M_GraphixEngineUI.update(this.gameInfo, humanInstances);
                }
                M_GameEngine.destroyInstance(this.gameEngine);
                this.gameEngine = null;
                this.gameInfo = null;
                System.gc();
                this.gameInfo = new D_GameInfo();
                this.gameEngine = M_GameEngine.getInstance();
                this.gameState = 2;
            }
        }
        this.gameInfo.gameState = this.gameState;
    }

    private void gameRecover(String rootPath, String fileName) {
    }

    private void gameSafe() {
    }

    private void imergencyPause() {
        this.gameEngine.imergencyPause();
    }

    private void kill() {
        if (this.gameEngine != null) {
            this.gameEngine.kill();
        }
        this.quit(0);
    }

    protected int getGameState() {
        return this.gameState;
    }

    protected GameParameter getParameter() {
        return this.parameter;
    }

    protected C_DebugMonitor getMonitor() {
        return this.monitor;
    }

    protected static M_Main getInstance() {
        return instance;
    }

    public static void main(String[] args) {
        M_Main main = new M_Main();
        main.computeArguments(args);
        if (main.gui) {
            M_GraphixEngineUI.init(main, main.parameter, main.monitor, 1019);
        }
        if (main.gui) {
            M_GraphixEngineUI.update(main.gameInfo, null);
        }
        main.gameInfo.gameState = main.gameState = 2;
        main.startScript(args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean control(String command) {
        block257: {
            String[] commandArray;
            int number;
            block313: {
                block312: {
                    block311: {
                        block310: {
                            block309: {
                                block308: {
                                    block307: {
                                        block306: {
                                            block305: {
                                                block304: {
                                                    block303: {
                                                        block302: {
                                                            block301: {
                                                                block300: {
                                                                    block299: {
                                                                        block298: {
                                                                            block297: {
                                                                                block296: {
                                                                                    block295: {
                                                                                        block294: {
                                                                                            block293: {
                                                                                                block292: {
                                                                                                    block291: {
                                                                                                        block290: {
                                                                                                            block289: {
                                                                                                                block288: {
                                                                                                                    block287: {
                                                                                                                        block286: {
                                                                                                                            block285: {
                                                                                                                                block284: {
                                                                                                                                    block283: {
                                                                                                                                        block282: {
                                                                                                                                            block281: {
                                                                                                                                                int i;
                                                                                                                                                block280: {
                                                                                                                                                    block279: {
                                                                                                                                                        block278: {
                                                                                                                                                            block277: {
                                                                                                                                                                block276: {
                                                                                                                                                                    block275: {
                                                                                                                                                                        block274: {
                                                                                                                                                                            block273: {
                                                                                                                                                                                block272: {
                                                                                                                                                                                    block271: {
                                                                                                                                                                                        block270: {
                                                                                                                                                                                            block269: {
                                                                                                                                                                                                block268: {
                                                                                                                                                                                                    block267: {
                                                                                                                                                                                                        block266: {
                                                                                                                                                                                                            block265: {
                                                                                                                                                                                                                block264: {
                                                                                                                                                                                                                    String tmp;
                                                                                                                                                                                                                    block263: {
                                                                                                                                                                                                                        int k;
                                                                                                                                                                                                                        int j;
                                                                                                                                                                                                                        block262: {
                                                                                                                                                                                                                            block258: {
                                                                                                                                                                                                                                Class newPlayerClass;
                                                                                                                                                                                                                                boolean bool;
                                                                                                                                                                                                                                String[] tmpArray;
                                                                                                                                                                                                                                block261: {
                                                                                                                                                                                                                                    int counter;
                                                                                                                                                                                                                                    block260: {
                                                                                                                                                                                                                                        block256: {
                                                                                                                                                                                                                                            number = 0;
                                                                                                                                                                                                                                            i = 0;
                                                                                                                                                                                                                                            j = 0;
                                                                                                                                                                                                                                            k = 0;
                                                                                                                                                                                                                                            counter = 0;
                                                                                                                                                                                                                                            tmp = null;
                                                                                                                                                                                                                                            tmpArray = null;
                                                                                                                                                                                                                                            bool = false;
                                                                                                                                                                                                                                            newPlayerClass = null;
                                                                                                                                                                                                                                            this.controlLog.storeLine(command);
                                                                                                                                                                                                                                            if (this.gameInfo == null) {
                                                                                                                                                                                                                                                this.gameInfo = new D_GameInfo();
                                                                                                                                                                                                                                                this.gameInfo.exitTime = this.parameter.getExit_time();
                                                                                                                                                                                                                                                this.gameInfo.suddenDeath = this.parameter.getSuddend_time();
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (this.lockedControl) {
                                                                                                                                                                                                                                                this.controlLog.addToLastLine("-locked control-\tfalse");
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (command == null) {
                                                                                                                                                                                                                                                System.out.println("WARNING: empty command string!!");
                                                                                                                                                                                                                                                this.controlLog.addToLastLine("-null command-\tfalse");
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (command.length() <= 1) {
                                                                                                                                                                                                                                                this.controlLog.addToLastLine(" ");
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            System.out.println(command);
                                                                                                                                                                                                                                            commandArray = command.split(" ");
                                                                                                                                                                                                                                            if (commandArray == null || commandArray.length < 1 || commandArray[0] == null || commandArray[0].length() <= 1) {
                                                                                                                                                                                                                                                System.out.println("WARNING: <Empty Command>");
                                                                                                                                                                                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            commandArray[0] = commandArray[0].toLowerCase();
                                                                                                                                                                                                                                            if (!commandArray[0].equals("loadplayer")) break block260;
                                                                                                                                                                                                                                            if (this.gameState != 2) {
                                                                                                                                                                                                                                                System.out.println("WARNING: Game is not in initialization context, end a possibly running game and try again.");
                                                                                                                                                                                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (this.gameInfo.level != null && this.gameInfo.level.maxPlayer <= this.gameInfo.playerData.length) {
                                                                                                                                                                                                                                                System.out.println("WARNING: can not load an other Player. Maximal number of players (" + this.gameInfo.level.maxPlayer + ") was reached.");
                                                                                                                                                                                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (this.parameter.getReplay() == 1) {
                                                                                                                                                                                                                                                System.out.println("WARNING: can not load an other Player when game is in replay mode.");
                                                                                                                                                                                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (this.gameInfo.playerData.length >= 10) {
                                                                                                                                                                                                                                                System.out.println("WARNING: can not load an other Player. Maximal number of players (10) was reached.");
                                                                                                                                                                                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (commandArray.length <= 1) {
                                                                                                                                                                                                                                                System.out.println("WARNING: Please specify the player you whish to load.");
                                                                                                                                                                                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            newPlayerClass = this.loadPlayerClass(commandArray[1]);
                                                                                                                                                                                                                                            if (newPlayerClass == null) {
                                                                                                                                                                                                                                                System.out.println("WARNING: Player couldnt be loaded.");
                                                                                                                                                                                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            D_PlayerData[] pData = this.gameInfo.playerData;
                                                                                                                                                                                                                                            this.gameInfo.playerData = new D_PlayerData[this.gameInfo.playerData.length + 1];
                                                                                                                                                                                                                                            i = 0;
                                                                                                                                                                                                                                            while (true) {
                                                                                                                                                                                                                                                if (i >= pData.length) {
                                                                                                                                                                                                                                                    this.gameInfo.playerData[this.gameInfo.playerData.length - 1] = new D_PlayerData(this.gameInfo.playerData.length - 1, newPlayerClass, newPlayerClass.getName(), this.parameter);
                                                                                                                                                                                                                                                    if (this.gameInfo.level == null || this.gameInfo.playerData.length <= this.gameInfo.level.maxPlayer) break;
                                                                                                                                                                                                                                                    System.out.println("WARNING: loading was successfull, but there are too many player loaded for this arena!\n\tmaxPlayer: " + this.gameInfo.level.maxPlayer + " actual player Number: " + this.gameInfo.playerData.length);
                                                                                                                                                                                                                                                    break block256;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                this.gameInfo.playerData[i] = pData[i];
                                                                                                                                                                                                                                                ++i;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (this.gameInfo.level != null) {
                                                                                                                                                                                                                                                i = 0;
                                                                                                                                                                                                                                                block9: while (i < this.gameInfo.level.height) {
                                                                                                                                                                                                                                                    j = 0;
                                                                                                                                                                                                                                                    while (true) {
                                                                                                                                                                                                                                                        if (j >= this.gameInfo.level.width) {
                                                                                                                                                                                                                                                            ++i;
                                                                                                                                                                                                                                                            continue block9;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        if ('0' <= this.gameInfo.level.playField[i][j] && this.gameInfo.level.playField[i][j] <= '9') {
                                                                                                                                                                                                                                                            k = 0;
                                                                                                                                                                                                                                                            while (k < this.gameInfo.playerData.length) {
                                                                                                                                                                                                                                                                if (this.gameInfo.level.playField[i][j] == this.gameInfo.playerData[k].ownChar) {
                                                                                                                                                                                                                                                                    this.gameInfo.playerData[k].headPos.y = i;
                                                                                                                                                                                                                                                                    this.gameInfo.playerData[k].headPos.x = j;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                ++k;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        ++j;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (this.parameter.getAutogamespeed() == 1) {
                                                                                                                                                                                                                                            if (this.gameHasHuman()) {
                                                                                                                                                                                                                                                this.parameter.setMin_cycle_ms(50);
                                                                                                                                                                                                                                                break block257;
                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                this.parameter.setMin_cycle_ms(0);
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        break block257;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (!commandArray[0].equals("loadhuman")) break block261;
                                                                                                                                                                                                                                    if (this.gameState != 2) {
                                                                                                                                                                                                                                        System.out.println("WARNING: Game is not in initialization context, end a possibly running game and try again.");
                                                                                                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (this.gameInfo.level != null && this.gameInfo.level.maxPlayer <= this.gameInfo.playerData.length) {
                                                                                                                                                                                                                                        System.out.println("WARNING: can not load an other Player. Maximal number of players (" + this.gameInfo.level.maxPlayer + ") was reached.");
                                                                                                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (this.gameInfo.playerData.length >= 10) {
                                                                                                                                                                                                                                        System.out.println("WARNING: can not load an other Player. Maximal number of players (10) was reached.");
                                                                                                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (this.parameter.getReplay() == 1) {
                                                                                                                                                                                                                                        System.out.println("WARNING: can not load an other Player when game is in replay mode.");
                                                                                                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    counter = 0;
                                                                                                                                                                                                                                    i = 0;
                                                                                                                                                                                                                                    while (true) {
                                                                                                                                                                                                                                        if (i >= this.gameInfo.playerData.length) {
                                                                                                                                                                                                                                            if (counter < 4) break;
                                                                                                                                                                                                                                            System.out.println("WARNING: can not load an other human Player. Maximal number of players (4) was reached.");
                                                                                                                                                                                                                                            this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (this.gameInfo.playerData[i].playerClass.getName().endsWith("C_Human")) {
                                                                                                                                                                                                                                            ++counter;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        ++i;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    Class<?> clazz = class$0;
                                                                                                                                                                                                                                    if (clazz == null) {
                                                                                                                                                                                                                                        Class<?> clazz2;
                                                                                                                                                                                                                                        try {
                                                                                                                                                                                                                                            clazz2 = Class.forName("de.farafin.snEADy.control.C_Human");
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        catch (ClassNotFoundException classNotFoundException) {
                                                                                                                                                                                                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        clazz = class$0 = clazz2;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    newPlayerClass = clazz;
                                                                                                                                                                                                                                    D_PlayerData[] pData = this.gameInfo.playerData;
                                                                                                                                                                                                                                    this.gameInfo.playerData = new D_PlayerData[this.gameInfo.playerData.length + 1];
                                                                                                                                                                                                                                    i = 0;
                                                                                                                                                                                                                                    while (true) {
                                                                                                                                                                                                                                        if (i >= pData.length) {
                                                                                                                                                                                                                                            this.gameInfo.playerData[this.gameInfo.playerData.length - 1] = commandArray.length > 1 ? new D_PlayerData(this.gameInfo.playerData.length - 1, newPlayerClass, commandArray[1], this.parameter) : new D_PlayerData(this.gameInfo.playerData.length - 1, newPlayerClass, "Nameless", this.parameter);
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        this.gameInfo.playerData[i] = pData[i];
                                                                                                                                                                                                                                        ++i;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (this.gameInfo.level != null && this.gameInfo.playerData.length > this.gameInfo.level.maxPlayer) {
                                                                                                                                                                                                                                        System.out.println("WARNING: loading was successfull, but there are too many player loaded for this arena!\n\tmaxPlayer: " + this.gameInfo.level.maxPlayer + " actual player Number: " + this.gameInfo.playerData.length);
                                                                                                                                                                                                                                    } else if (this.gameInfo.level != null) {
                                                                                                                                                                                                                                        i = 0;
                                                                                                                                                                                                                                        block14: while (i < this.gameInfo.level.height) {
                                                                                                                                                                                                                                            j = 0;
                                                                                                                                                                                                                                            while (true) {
                                                                                                                                                                                                                                                if (j >= this.gameInfo.level.width) {
                                                                                                                                                                                                                                                    ++i;
                                                                                                                                                                                                                                                    continue block14;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                if ('0' <= this.gameInfo.level.playField[i][j] && this.gameInfo.level.playField[i][j] <= '9') {
                                                                                                                                                                                                                                                    k = 0;
                                                                                                                                                                                                                                                    while (k < this.gameInfo.playerData.length) {
                                                                                                                                                                                                                                                        if (this.gameInfo.level.playField[i][j] == this.gameInfo.playerData[k].ownChar) {
                                                                                                                                                                                                                                                            this.gameInfo.playerData[k].headPos.y = i;
                                                                                                                                                                                                                                                            this.gameInfo.playerData[k].headPos.x = j;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        ++k;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                ++j;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (this.parameter.getAutogamespeed() == 1) {
                                                                                                                                                                                                                                        if (this.gameHasHuman()) {
                                                                                                                                                                                                                                            this.parameter.setMin_cycle_ms(50);
                                                                                                                                                                                                                                            break block257;
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            this.parameter.setMin_cycle_ms(0);
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    break block257;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (commandArray[0].equals("loaddummy")) {
                                                                                                                                                                                                                                    if (this.gameState != 2) {
                                                                                                                                                                                                                                        System.out.println("WARNING: Game is not in initialization context, end a possibly running game and try again.");
                                                                                                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (this.gameInfo.level != null && this.gameInfo.level.maxPlayer <= this.gameInfo.playerData.length) {
                                                                                                                                                                                                                                        System.out.println("WARNING: can not load an other Player. Maximal number of players (" + this.gameInfo.level.maxPlayer + ") was reached.");
                                                                                                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (this.gameInfo.playerData.length >= 10) {
                                                                                                                                                                                                                                        System.out.println("WARNING: can not load an other Player. Maximal number of players (10) was reached.");
                                                                                                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (this.parameter.getReplay() != 2) {
                                                                                                                                                                                                                                        System.out.println("WARNING: dummy can only be loaded from replays!");
                                                                                                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (commandArray.length <= 1) {
                                                                                                                                                                                                                                        System.out.println("WARNING: Please specify the player you whish to load.");
                                                                                                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    Class<?> clazz = class$1;
                                                                                                                                                                                                                                    if (clazz == null) {
                                                                                                                                                                                                                                        Class<?> clazz3;
                                                                                                                                                                                                                                        try {
                                                                                                                                                                                                                                            clazz3 = Class.forName("de.farafin.snEADy.control.C_Dummy");
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        catch (ClassNotFoundException classNotFoundException) {
                                                                                                                                                                                                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        clazz = class$1 = clazz3;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if ((newPlayerClass = clazz) == null) {
                                                                                                                                                                                                                                        System.out.println("WARNING: Player couldnt be loaded.");
                                                                                                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    tmpArray = command.split(":");
                                                                                                                                                                                                                                    tmp = tmpArray.length > 1 && tmpArray[1].length() > 1 ? tmpArray[1] : "unknown";
                                                                                                                                                                                                                                    D_PlayerData[] pData = this.gameInfo.playerData;
                                                                                                                                                                                                                                    this.gameInfo.playerData = new D_PlayerData[this.gameInfo.playerData.length + 1];
                                                                                                                                                                                                                                    i = 0;
                                                                                                                                                                                                                                    while (true) {
                                                                                                                                                                                                                                        if (i >= pData.length) {
                                                                                                                                                                                                                                            this.gameInfo.playerData[this.gameInfo.playerData.length - 1] = new D_PlayerData(this.gameInfo.playerData.length - 1, newPlayerClass, tmp, this.parameter);
                                                                                                                                                                                                                                            if (this.gameInfo.level != null) {
                                                                                                                                                                                                                                                if (this.gameInfo.playerData.length <= this.gameInfo.level.maxPlayer) break;
                                                                                                                                                                                                                                                System.out.println("WARNING: loading was successfull, but there are too many player loaded for this arena!\n\tmaxPlayer: " + this.gameInfo.level.maxPlayer + " actual player Number: " + this.gameInfo.playerData.length);
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            break block257;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        this.gameInfo.playerData[i] = pData[i];
                                                                                                                                                                                                                                        ++i;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    bool = false;
                                                                                                                                                                                                                                    i = 0;
                                                                                                                                                                                                                                    block18: while (true) {
                                                                                                                                                                                                                                        if (i >= this.gameInfo.level.height || bool) {
                                                                                                                                                                                                                                            bool = false;
                                                                                                                                                                                                                                            break block257;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        j = 0;
                                                                                                                                                                                                                                        while (true) {
                                                                                                                                                                                                                                            if (j >= this.gameInfo.level.width || bool) {
                                                                                                                                                                                                                                                ++i;
                                                                                                                                                                                                                                                continue block18;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (this.gameInfo.level.playField[i][j] == this.gameInfo.playerData[this.gameInfo.playerData.length - 1].ownChar) {
                                                                                                                                                                                                                                                this.gameInfo.playerData[this.gameInfo.playerData.length - 1].headPos.y = i;
                                                                                                                                                                                                                                                this.gameInfo.playerData[this.gameInfo.playerData.length - 1].headPos.x = j;
                                                                                                                                                                                                                                                bool = true;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            ++j;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (!commandArray[0].equals("delplayer")) break block262;
                                                                                                                                                                                                                                if (this.gameState != 2) {
                                                                                                                                                                                                                                    System.out.println("WARNING: Game is not in initialization context, end a possibly running game and try again.");
                                                                                                                                                                                                                                    this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (this.gameInfo.playerData == null || this.gameInfo.playerData.length == 0) {
                                                                                                                                                                                                                                    System.out.println("WARNING: no player loaded that can be deleted!");
                                                                                                                                                                                                                                    this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (this.parameter.getReplay() == 1) {
                                                                                                                                                                                                                                    System.out.println("WARNING: can not delete an other Player when game is in replay mode.");
                                                                                                                                                                                                                                    this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (commandArray.length <= 1) {
                                                                                                                                                                                                                                    System.out.println("WARNING: There was no Player specified that should be deleted.by default the last player will be deleted.");
                                                                                                                                                                                                                                    number = this.gameInfo.playerData.length - 1;
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    if (!commandArray[1].matches("[0-9]")) {
                                                                                                                                                                                                                                        System.out.println("WARNING: the parameter '" + commandArray[1] + "' is no number between 0 and 9!");
                                                                                                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    number = Integer.parseInt(commandArray[1]);
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (number >= this.gameInfo.playerData.length) {
                                                                                                                                                                                                                                    System.out.println("WARNING: Player with number '" + number + "' doesn't exists.");
                                                                                                                                                                                                                                    this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                this.gameInfo.playerData[number] = null;
                                                                                                                                                                                                                                D_PlayerData[] pData = this.gameInfo.playerData;
                                                                                                                                                                                                                                this.gameInfo.playerData = new D_PlayerData[pData.length - 1];
                                                                                                                                                                                                                                i = 0;
                                                                                                                                                                                                                                j = 0;
                                                                                                                                                                                                                                while (true) {
                                                                                                                                                                                                                                    if (j >= this.gameInfo.playerData.length) {
                                                                                                                                                                                                                                        if (this.gameInfo.level != null) {
                                                                                                                                                                                                                                            i = 0;
                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        break block258;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (j == number) {
                                                                                                                                                                                                                                        i = 1;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    this.gameInfo.playerData[j] = pData[j + i];
                                                                                                                                                                                                                                    if (i == 1) {
                                                                                                                                                                                                                                        this.gameInfo.playerData[j].ownChar = (char)(this.gameInfo.playerData[j].ownChar - '\u0001');
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    ++j;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                block21: while (i < this.gameInfo.level.height) {
                                                                                                                                                                                                                                    j = 0;
                                                                                                                                                                                                                                    while (true) {
                                                                                                                                                                                                                                        if (j >= this.gameInfo.level.width) {
                                                                                                                                                                                                                                            ++i;
                                                                                                                                                                                                                                            continue block21;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if ('0' <= this.gameInfo.level.playField[i][j] && this.gameInfo.level.playField[i][j] <= '9') {
                                                                                                                                                                                                                                            k = 0;
                                                                                                                                                                                                                                            while (k < this.gameInfo.playerData.length) {
                                                                                                                                                                                                                                                if (this.gameInfo.level.playField[i][j] == this.gameInfo.playerData[k].ownChar) {
                                                                                                                                                                                                                                                    this.gameInfo.playerData[k].headPos.y = i;
                                                                                                                                                                                                                                                    this.gameInfo.playerData[k].headPos.x = j;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                ++k;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        ++j;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (this.parameter.getAutogamespeed() == 1) {
                                                                                                                                                                                                                                if (this.gameHasHuman()) {
                                                                                                                                                                                                                                    this.parameter.setMin_cycle_ms(50);
                                                                                                                                                                                                                                    break block257;
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    this.parameter.setMin_cycle_ms(0);
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            break block257;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (!commandArray[0].equals("loadlevel")) break block263;
                                                                                                                                                                                                                        if (this.gameState != 2) {
                                                                                                                                                                                                                            System.out.println("WARNING: Game is not in initialization context,end a possibly running game and try again.");
                                                                                                                                                                                                                            this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (this.parameter.getReplay() == 1) {
                                                                                                                                                                                                                            System.out.println("WARNING: can not load Level when game is in replay mode.");
                                                                                                                                                                                                                            this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        this.gameInfo.level = this.loadLevel(commandArray[1]);
                                                                                                                                                                                                                        if (this.gameInfo.level == null) {
                                                                                                                                                                                                                            this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (this.gameInfo.level.comment.length() > 0) {
                                                                                                                                                                                                                            this.monitor.sneadySayIm(this.gameInfo.level.comment);
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (this.gameInfo.level.author.length() > 0) {
                                                                                                                                                                                                                            this.monitor.sneadySayIm("by " + this.gameInfo.level.author);
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (this.gameInfo.playerData.length > this.gameInfo.level.maxPlayer) {
                                                                                                                                                                                                                            System.out.println("WARNING: loading of level was successfull, but there are too many players loaded for this level!\n\tmaxPlayer: " + this.gameInfo.level.maxPlayer + " actual player Number: " + this.gameInfo.playerData.length + "\n" + "The last " + (this.gameInfo.playerData.length - this.gameInfo.level.maxPlayer) + " are skipped.");
                                                                                                                                                                                                                            D_PlayerData[] pData = this.gameInfo.playerData;
                                                                                                                                                                                                                            this.gameInfo.playerData = new D_PlayerData[this.gameInfo.level.maxPlayer];
                                                                                                                                                                                                                            i = 0;
                                                                                                                                                                                                                            while (i < this.gameInfo.level.maxPlayer) {
                                                                                                                                                                                                                                this.gameInfo.playerData[i] = pData[i];
                                                                                                                                                                                                                                ++i;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        i = 0;
                                                                                                                                                                                                                        block25: while (i < this.gameInfo.level.height) {
                                                                                                                                                                                                                            j = 0;
                                                                                                                                                                                                                            while (true) {
                                                                                                                                                                                                                                if (j >= this.gameInfo.level.width) {
                                                                                                                                                                                                                                    ++i;
                                                                                                                                                                                                                                    continue block25;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if ('0' <= this.gameInfo.level.playField[i][j] && this.gameInfo.level.playField[i][j] <= '9') {
                                                                                                                                                                                                                                    k = 0;
                                                                                                                                                                                                                                    while (k < this.gameInfo.playerData.length) {
                                                                                                                                                                                                                                        if (this.gameInfo.level.playField[i][j] == this.gameInfo.playerData[k].ownChar) {
                                                                                                                                                                                                                                            this.gameInfo.playerData[k].headPos.y = i;
                                                                                                                                                                                                                                            this.gameInfo.playerData[k].headPos.x = j;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        ++k;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                ++j;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        break block257;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (!commandArray[0].equals("start")) break block264;
                                                                                                                                                                                                                    if (this.gameState != 2) {
                                                                                                                                                                                                                        System.out.println("WARNING: Game is not in initialization context,end a possibly running game and try again.");
                                                                                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (this.gameInfo.playerData.length <= 0) {
                                                                                                                                                                                                                        System.out.println("WARNING: There are no players loaded!");
                                                                                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (this.gameInfo.level == null) {
                                                                                                                                                                                                                        System.out.println("WARNING: There is no level loaded!");
                                                                                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (this.gameInfo.playerData.length > this.gameInfo.level.maxPlayer) {
                                                                                                                                                                                                                        System.out.println("WARNING: There are too many players loaded.\n\t " + this.gameInfo.playerData.length + " loaded, max player for this level is " + this.gameInfo.level.maxPlayer + "\n" + "\t the last " + (this.gameInfo.level.maxPlayer - this.gameInfo.playerData.length) + " player won't be loaded.");
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    this.startLog();
                                                                                                                                                                                                                    if (this.parameter.getReplay() == 0) {
                                                                                                                                                                                                                        if (this.parameter.getAutogamespeed() == 1) {
                                                                                                                                                                                                                            if (this.gameHasHuman()) {
                                                                                                                                                                                                                                this.parameter.setMin_cycle_ms(50);
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                this.parameter.setMin_cycle_ms(0);
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (this.parameter.getRecord() == 1) {
                                                                                                                                                                                                                            this.control("set recordname " + this.logExtension + this.parameter.getRecordName() + "_" + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new GregorianCalendar().getTime()));
                                                                                                                                                                                                                            if (this.gui) {
                                                                                                                                                                                                                                M_GraphixEngineUI.updateDialogs();
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            this.gameInfo.recordWriter = new C_RecordFileWriter("replays", this.parameter.getRecordName());
                                                                                                                                                                                                                            tmp = "";
                                                                                                                                                                                                                            tmp = String.valueOf(tmp) + "%SnEADyVersion 1019\n";
                                                                                                                                                                                                                            tmp = String.valueOf(tmp) + "loadlevel " + this.gameInfo.level.fileName + "\n";
                                                                                                                                                                                                                            tmp = String.valueOf(tmp) + "set exit_time " + this.parameter.getExit_time() + "\n";
                                                                                                                                                                                                                            tmp = String.valueOf(tmp) + "set suddend_time " + this.parameter.getSuddend_time() + "\n";
                                                                                                                                                                                                                            tmp = String.valueOf(tmp) + "set init_move_delay " + this.parameter.getInit_move_delay() + "\n";
                                                                                                                                                                                                                            i = 0;
                                                                                                                                                                                                                            while (true) {
                                                                                                                                                                                                                                if (i >= this.gameInfo.playerData.length) {
                                                                                                                                                                                                                                    this.gameInfo.recordWriter.storeHeader(tmp);
                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                tmp = this.gameInfo.playerData[i].playerClass.getName().endsWith("C_Human") ? String.valueOf(tmp) + "loaddummy :" + this.gameInfo.playerData[i].name + "\n" : String.valueOf(tmp) + "loaddummy :" + C_SneadyFileInteractor.getPlayerName(this.gameInfo.playerData[i].playerClass.getName()) + "\n";
                                                                                                                                                                                                                                ++i;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        this.gameInfo.recordReader.restart();
                                                                                                                                                                                                                        if (this.gui) {
                                                                                                                                                                                                                            M_GraphixEngineUI.updateDialogs();
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    this.initGameInfo.copyOnMe(this.gameInfo);
                                                                                                                                                                                                                    this.initParameter.copyOnMe(this.parameter);
                                                                                                                                                                                                                    if (this.gui) {
                                                                                                                                                                                                                        M_GraphixEngineUI.setActive(false);
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    this.lockedControl = true;
                                                                                                                                                                                                                    if (!this.gameEngine.initGame(this.gameInfo)) {
                                                                                                                                                                                                                        System.out.println("WARNING: Initialisation of the game failed!");
                                                                                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                        this.lockedControl = false;
                                                                                                                                                                                                                        if (this.gui) {
                                                                                                                                                                                                                            M_GraphixEngineUI.setActive(true);
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    this.gameInfo.gameState = this.gameState = 4;
                                                                                                                                                                                                                    try {
                                                                                                                                                                                                                        Thread.sleep(1000L);
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    catch (InterruptedException e) {
                                                                                                                                                                                                                        e.printStackTrace();
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    this.lockedControl = false;
                                                                                                                                                                                                                    this.gameInfo.gameState = this.gameState = 3;
                                                                                                                                                                                                                    if (this.gui) {
                                                                                                                                                                                                                        M_GraphixEngineUI.setActive(true);
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (this.gui) {
                                                                                                                                                                                                                        M_GraphixEngineUI.updateDialogs();
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (this.gui) {
                                                                                                                                                                                                                        M_GraphixEngineUI.update(this.gameInfo, null);
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    this.gameRunningTime = -System.currentTimeMillis();
                                                                                                                                                                                                                    this.SystemStartTime = new SimpleDateFormat("HH:mm:ss dd.MM.yyyy").format(new GregorianCalendar().getTime());
                                                                                                                                                                                                                    this.gameEngine.start();
                                                                                                                                                                                                                    break block257;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (!commandArray[0].equals("run")) break block265;
                                                                                                                                                                                                                if (this.gameState != 3 && this.gameState != 4 && this.gameState != 2) {
                                                                                                                                                                                                                    System.out.println("WARNING: Game is not in running, pause or initialization context");
                                                                                                                                                                                                                    this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (this.gameState == 3) {
                                                                                                                                                                                                                    this.gameState = 4;
                                                                                                                                                                                                                } else if (this.gameState == 4) {
                                                                                                                                                                                                                    this.gameState = 3;
                                                                                                                                                                                                                } else if (this.gameState == 2) {
                                                                                                                                                                                                                    this.control("start");
                                                                                                                                                                                                                }
                                                                                                                                                                                                                this.gameInfo.gameState = this.gameState;
                                                                                                                                                                                                                break block257;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (!commandArray[0].equals("pause")) break block266;
                                                                                                                                                                                                            if (this.gameState != 3 && this.gameState != 4) {
                                                                                                                                                                                                                System.out.println("WARNING: Game is not in running or pause context");
                                                                                                                                                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                                return false;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (this.gameState == 3) {
                                                                                                                                                                                                                this.gameState = 4;
                                                                                                                                                                                                            } else if (this.gameState == 4) {
                                                                                                                                                                                                                this.gameState = 3;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            this.gameInfo.gameState = this.gameState;
                                                                                                                                                                                                            break block257;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (!commandArray[0].equals("stop")) break block267;
                                                                                                                                                                                                        if (this.gameState != 3 && this.gameState != 4) {
                                                                                                                                                                                                            System.out.println("WARNING: you can't stop a game thats not running ;-)");
                                                                                                                                                                                                            this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                            return false;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (this.gui) {
                                                                                                                                                                                                            M_GraphixEngineUI.setActive(false);
                                                                                                                                                                                                        }
                                                                                                                                                                                                        this.gameInfo.gameState = this.gameState = 8;
                                                                                                                                                                                                        this.lockedControl = true;
                                                                                                                                                                                                        try {
                                                                                                                                                                                                            this.gameEngine.join();
                                                                                                                                                                                                        }
                                                                                                                                                                                                        catch (InterruptedException e) {
                                                                                                                                                                                                            e.printStackTrace();
                                                                                                                                                                                                        }
                                                                                                                                                                                                        this.lockedControl = false;
                                                                                                                                                                                                        this.gameInfo.copyOnMe(this.initGameInfo);
                                                                                                                                                                                                        this.parameter.copyOnMe(this.initParameter);
                                                                                                                                                                                                        this.parameter.setRecordName("replay");
                                                                                                                                                                                                        this.gameInfo.gameRunning = false;
                                                                                                                                                                                                        if (this.gui) {
                                                                                                                                                                                                            M_GraphixEngineUI.setActive(true);
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (this.gui) {
                                                                                                                                                                                                            M_GraphixEngineUI.updateDialogs();
                                                                                                                                                                                                        }
                                                                                                                                                                                                        break block257;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (!commandArray[0].equals("loadscript")) break block268;
                                                                                                                                                                                                    if (commandArray.length <= 1) {
                                                                                                                                                                                                        System.out.println("WARNING: There was no script specified that should be loaded.");
                                                                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                        return false;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (!this.loadScript("scripts", String.valueOf(commandArray[1]) + ".script")) {
                                                                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                        return false;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (this.scriptEx <= 0 && this.gui) {
                                                                                                                                                                                                        M_GraphixEngineUI.updateDialogs();
                                                                                                                                                                                                    }
                                                                                                                                                                                                    break block257;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (!commandArray[0].equals("replay")) break block269;
                                                                                                                                                                                                if (this.gameState != 2) {
                                                                                                                                                                                                    System.out.println("WARNING: Game is not in initialization context,end a possibly running game and try again.");
                                                                                                                                                                                                    this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                    return false;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (commandArray.length <= 1) {
                                                                                                                                                                                                    System.out.println("WARNING: There was no script specified that should be loaded.");
                                                                                                                                                                                                    this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                    return false;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (this.parameter.getReplay() == 0) {
                                                                                                                                                                                                    this.recGameInfo.copyOnMe(this.gameInfo);
                                                                                                                                                                                                    this.recParameter.copyOnMe(this.parameter);
                                                                                                                                                                                                }
                                                                                                                                                                                                this.parameter.setReplay(2);
                                                                                                                                                                                                number = this.gameInfo.playerData.length;
                                                                                                                                                                                                i = 0;
                                                                                                                                                                                                while (true) {
                                                                                                                                                                                                    if (i >= number) {
                                                                                                                                                                                                        if (this.gui) {
                                                                                                                                                                                                            M_GraphixEngineUI.updateDialogs();
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (this.loadReplay("replays", commandArray[1])) break;
                                                                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                        return false;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    this.control("delplayer 0");
                                                                                                                                                                                                    ++i;
                                                                                                                                                                                                }
                                                                                                                                                                                                this.parameter.setReplayName(commandArray[1]);
                                                                                                                                                                                                this.parameter.setRecord(0);
                                                                                                                                                                                                this.parameter.setReplay(1);
                                                                                                                                                                                                this.parameter.setReplay_sneay_version(Integer.parseInt(C_SneadyFileInteractor.getReplayHeader(commandArray[1])[0]));
                                                                                                                                                                                                break block257;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (!commandArray[0].equals("ejectreplay")) break block270;
                                                                                                                                                                                            if (this.gameState != 2) {
                                                                                                                                                                                                System.out.println("WARNING: Game is not in initialization context,end a possibly running game and try again.");
                                                                                                                                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                                                return false;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (this.parameter.getReplay() == 1) {
                                                                                                                                                                                                this.parameter.setReplay(0);
                                                                                                                                                                                                number = this.gameInfo.playerData.length;
                                                                                                                                                                                                i = 0;
                                                                                                                                                                                                while (true) {
                                                                                                                                                                                                    if (i >= number) {
                                                                                                                                                                                                        this.gameInfo.copyOnMe(this.recGameInfo);
                                                                                                                                                                                                        this.parameter.copyOnMe(this.recParameter);
                                                                                                                                                                                                        break;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    this.control("delplayer 0");
                                                                                                                                                                                                    ++i;
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                            if (this.gui) {
                                                                                                                                                                                                M_GraphixEngineUI.updateDialogs();
                                                                                                                                                                                            }
                                                                                                                                                                                            break block257;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (!commandArray[0].equals("quit")) break block271;
                                                                                                                                                                                        if (this.gameState == 3 || this.gameState == 4) {
                                                                                                                                                                                            this.gameInfo.gameState = this.gameState = 1;
                                                                                                                                                                                            break block257;
                                                                                                                                                                                        } else {
                                                                                                                                                                                            this.quit(0);
                                                                                                                                                                                        }
                                                                                                                                                                                        break block257;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (commandArray[0].equals("kill")) {
                                                                                                                                                                                        System.out.println("KILL WAS PERFORMED! DEPRECATED METHODS USED TO END THE GAME!\n\tPlease only use if 'quit' doesn't work!");
                                                                                                                                                                                        this.kill();
                                                                                                                                                                                        this.controlLog.addToLastLine("\ttrue");
                                                                                                                                                                                        return true;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (!commandArray[0].equals("imergencyPause")) break block272;
                                                                                                                                                                                    System.out.println("IMERGENCY_PAUSE WAS PERFORMED! DEPRECATED METHODS USED TO HOLD THE GAME!\n\tPlease only use if 'run' or 'pause' doesn't work!");
                                                                                                                                                                                    this.imergencyPause();
                                                                                                                                                                                    break block257;
                                                                                                                                                                                }
                                                                                                                                                                                if (commandArray[0].equals("save")) {
                                                                                                                                                                                    System.out.println("WARNING: command '" + commandArray[0] + "' not implemented jet!");
                                                                                                                                                                                    this.controlLog.addToLastLine("\ttrue");
                                                                                                                                                                                    return true;
                                                                                                                                                                                }
                                                                                                                                                                                if (commandArray[0].equals("restore")) {
                                                                                                                                                                                    System.out.println("WARNING: command '" + commandArray[0] + "' not implemented jet!");
                                                                                                                                                                                    this.controlLog.addToLastLine("\ttrue");
                                                                                                                                                                                    return true;
                                                                                                                                                                                }
                                                                                                                                                                                if (commandArray[0].equals("print_playfield")) {
                                                                                                                                                                                    if (this.gameInfo.level != null) {
                                                                                                                                                                                        this.monitor.sneadySayIm(this.gameInfo.level.toString());
                                                                                                                                                                                    }
                                                                                                                                                                                    this.controlLog.addToLastLine("\ttrue");
                                                                                                                                                                                    return true;
                                                                                                                                                                                }
                                                                                                                                                                                if (commandArray[0].equals("print_parameter")) {
                                                                                                                                                                                    this.monitor.sneadySayIm(this.parameter.toString());
                                                                                                                                                                                    this.controlLog.addToLastLine("\ttrue");
                                                                                                                                                                                    return true;
                                                                                                                                                                                }
                                                                                                                                                                                if (!commandArray[0].equals("openmonitor")) break block273;
                                                                                                                                                                                this.monitor.setVisible(true);
                                                                                                                                                                                break block257;
                                                                                                                                                                            }
                                                                                                                                                                            if (!commandArray[0].equals("closemonitor")) break block274;
                                                                                                                                                                            this.monitor.setVisible(false);
                                                                                                                                                                            break block257;
                                                                                                                                                                        }
                                                                                                                                                                        if (!commandArray[0].equals("set")) {
                                                                                                                                                                            System.out.println("WARNING in M_Main.controlInterface: Unknown command '" + commandArray[0] + "' !!");
                                                                                                                                                                            this.controlLog.storeLine("false");
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        if (commandArray.length <= 2) {
                                                                                                                                                                            System.out.println("WARNING: There are too less Parameter for this command! You need to specify the variable and its value.");
                                                                                                                                                                            this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        commandArray[1] = commandArray[1].toLowerCase();
                                                                                                                                                                        if (!commandArray[1].equals("damage_points_radius")) break block275;
                                                                                                                                                                        if (!commandArray[2].matches("[0-9]*")) {
                                                                                                                                                                            System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                                                                                                            this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        this.parameter.setDamage_points_radius(Integer.parseInt(commandArray[2]));
                                                                                                                                                                        break block257;
                                                                                                                                                                    }
                                                                                                                                                                    if (!commandArray[1].equals("kill_points_radius")) break block276;
                                                                                                                                                                    if (!commandArray[2].matches("[0-9]*")) {
                                                                                                                                                                        System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    this.parameter.setKill_points_radius(Integer.parseInt(commandArray[2]));
                                                                                                                                                                    break block257;
                                                                                                                                                                }
                                                                                                                                                                if (!commandArray[1].equals("easy_points")) break block277;
                                                                                                                                                                if (!commandArray[2].matches("[0-9]*")) {
                                                                                                                                                                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                                                                                                    this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                this.parameter.setEasy_points(Integer.parseInt(commandArray[2]));
                                                                                                                                                                break block257;
                                                                                                                                                            }
                                                                                                                                                            if (!commandArray[1].equals("damage_length_grow")) break block278;
                                                                                                                                                            if (!commandArray[2].matches("[0-9]*[.][0-9]*")) {
                                                                                                                                                                System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no float-number!");
                                                                                                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            this.parameter.setDamage_length_grow(Float.parseFloat(commandArray[2]));
                                                                                                                                                            break block257;
                                                                                                                                                        }
                                                                                                                                                        if (!commandArray[1].equals("kill_point_goodies")) break block279;
                                                                                                                                                        if (!commandArray[2].matches("[0-9]*")) {
                                                                                                                                                            System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                                                                                            this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        this.parameter.setKill_point_goodies(Integer.parseInt(commandArray[2]));
                                                                                                                                                        break block257;
                                                                                                                                                    }
                                                                                                                                                    if (!commandArray[1].equals("min_move_delay")) break block280;
                                                                                                                                                    if (!commandArray[2].matches("[0-9]*")) {
                                                                                                                                                        System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    number = Integer.parseInt(commandArray[2]);
                                                                                                                                                    if (number < 1) {
                                                                                                                                                        System.out.println("WARNING: min_move_delay must be >= 1");
                                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    this.parameter.setMin_move_delay(number);
                                                                                                                                                    break block257;
                                                                                                                                                }
                                                                                                                                                if (!commandArray[1].equals("init_move_delay")) break block281;
                                                                                                                                                if (!commandArray[2].matches("[0-9]*")) {
                                                                                                                                                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                                                                                    this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                number = Integer.parseInt(commandArray[2]);
                                                                                                                                                if ((long)number < this.parameter.getMin_move_delay() || this.parameter.getMax_move_delay() < (long)number) {
                                                                                                                                                    System.out.println("WARNING: init_move_delay of '" + number + "' does not fit between " + this.parameter.getMin_move_delay() + " and " + this.parameter.getMax_move_delay() + ".");
                                                                                                                                                    this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                this.parameter.setInit_move_delay(number);
                                                                                                                                                if (this.gameInfo.playerData != null) {
                                                                                                                                                    i = 0;
                                                                                                                                                    while (i < this.gameInfo.playerData.length) {
                                                                                                                                                        this.gameInfo.playerData[i].waitCycles = this.parameter.getInit_move_delay();
                                                                                                                                                        ++i;
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                                break block257;
                                                                                                                                            }
                                                                                                                                            if (!commandArray[1].equals("max_move_delay")) break block282;
                                                                                                                                            if (!commandArray[2].matches("[0-9]*")) {
                                                                                                                                                System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            number = Integer.parseInt(commandArray[2]);
                                                                                                                                            if ((long)number <= this.parameter.getMin_move_delay()) {
                                                                                                                                                System.out.println("WARNING: MAX_SNAKE_DELAY must be > min_move_delay of " + this.parameter.getMin_move_delay());
                                                                                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            this.parameter.setMax_move_delay(number);
                                                                                                                                            break block257;
                                                                                                                                        }
                                                                                                                                        if (!commandArray[1].equals("init_length")) break block283;
                                                                                                                                        if (!commandArray[2].matches("[0-9]*")) {
                                                                                                                                            System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                                                                            this.controlLog.addToLastLine("\tfalse");
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        number = Integer.parseInt(commandArray[2]);
                                                                                                                                        if (number < 2) {
                                                                                                                                            System.out.println("WARNING: the init length of a snake must be init_length >= 2.");
                                                                                                                                            this.controlLog.addToLastLine("\tfalse");
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        this.parameter.setInit_length(number);
                                                                                                                                        break block257;
                                                                                                                                    }
                                                                                                                                    if (!commandArray[1].equals("auto_grow_delay")) break block284;
                                                                                                                                    if (!commandArray[2].matches("[0-9]*")) {
                                                                                                                                        System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    number = Integer.parseInt(commandArray[2]);
                                                                                                                                    if (number < 1) {
                                                                                                                                        System.out.println("WARNING: AUTO_GROW must be >= 1");
                                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    this.parameter.setAuto_grow_delay(number);
                                                                                                                                    break block257;
                                                                                                                                }
                                                                                                                                if (!commandArray[1].equals("auto_slowdown_delay")) break block285;
                                                                                                                                if (!commandArray[2].matches("[0-9]*")) {
                                                                                                                                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                                                                    this.controlLog.addToLastLine("\tfalse");
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                number = Integer.parseInt(commandArray[2]);
                                                                                                                                if (number < 0) {
                                                                                                                                    System.out.println("WARNING: auto_slowdown_delay must be >= 0");
                                                                                                                                    this.controlLog.addToLastLine("\tfalse");
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                this.parameter.setAuto_slowdown_delay(number);
                                                                                                                                break block257;
                                                                                                                            }
                                                                                                                            if (!commandArray[1].equals("max_goody_occ_delay")) break block286;
                                                                                                                            if (!commandArray[2].matches("[0-9]*")) {
                                                                                                                                System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            number = Integer.parseInt(commandArray[2]);
                                                                                                                            if (number < 1) {
                                                                                                                                System.out.println("WARNING: max_goody_occ_delay must be >= 1");
                                                                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            this.parameter.setMax_goody_occ_delay(number);
                                                                                                                            break block257;
                                                                                                                        }
                                                                                                                        if (!commandArray[1].equals("goody_speed_occ")) break block287;
                                                                                                                        if (!commandArray[2].matches("[0-9]*")) {
                                                                                                                            System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                                                            this.controlLog.addToLastLine("\tfalse");
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        number = Integer.parseInt(commandArray[2]);
                                                                                                                        if (number < 0) {
                                                                                                                            System.out.println("WARNING: goody_speed_occ must be >= 0");
                                                                                                                            this.controlLog.addToLastLine("\tfalse");
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        this.parameter.setGoody_speed_occ(number);
                                                                                                                        break block257;
                                                                                                                    }
                                                                                                                    if (!commandArray[1].equals("goody_slowdown_occ")) break block288;
                                                                                                                    if (!commandArray[2].matches("[0-9]*")) {
                                                                                                                        System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    number = Integer.parseInt(commandArray[2]);
                                                                                                                    if (number < 0) {
                                                                                                                        System.out.println("WARNING: goody_slowdown_occ must be >= 0");
                                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    this.parameter.setGoody_slowdown_occ(number);
                                                                                                                    break block257;
                                                                                                                }
                                                                                                                if (!commandArray[1].equals("goody_length_occ")) break block289;
                                                                                                                if (!commandArray[2].matches("[0-9]*")) {
                                                                                                                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                                                    this.controlLog.addToLastLine("\tfalse");
                                                                                                                    return false;
                                                                                                                }
                                                                                                                number = Integer.parseInt(commandArray[2]);
                                                                                                                if (number < 0) {
                                                                                                                    System.out.println("WARNING: goody_length_occ must be >= 0");
                                                                                                                    this.controlLog.addToLastLine("\tfalse");
                                                                                                                    return false;
                                                                                                                }
                                                                                                                this.parameter.setGoody_length_occ(number);
                                                                                                                break block257;
                                                                                                            }
                                                                                                            if (!commandArray[1].equals("goody_points_occ")) break block290;
                                                                                                            if (!commandArray[2].matches("[0-9]*")) {
                                                                                                                System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                                                return false;
                                                                                                            }
                                                                                                            number = Integer.parseInt(commandArray[2]);
                                                                                                            if (number < 0) {
                                                                                                                System.out.println("WARNING: goody_points_occ must be >= 0");
                                                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                                                return false;
                                                                                                            }
                                                                                                            this.parameter.setGoody_points_occ(number);
                                                                                                            break block257;
                                                                                                        }
                                                                                                        if (!commandArray[1].equals("goody_shorter_occ")) break block291;
                                                                                                        if (!commandArray[2].matches("[0-9]*")) {
                                                                                                            System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                                            this.controlLog.addToLastLine("\tfalse");
                                                                                                            return false;
                                                                                                        }
                                                                                                        number = Integer.parseInt(commandArray[2]);
                                                                                                        if (number < 0) {
                                                                                                            System.out.println("WARNING: goody_shorter_occ must be >= 0");
                                                                                                            this.controlLog.addToLastLine("\tfalse");
                                                                                                            return false;
                                                                                                        }
                                                                                                        this.parameter.setGoody_shorter_occ(number);
                                                                                                        break block257;
                                                                                                    }
                                                                                                    if (!commandArray[1].equals("goody_length_value")) break block292;
                                                                                                    if (!commandArray[2].matches("[0-9]*")) {
                                                                                                        System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                        return false;
                                                                                                    }
                                                                                                    number = Integer.parseInt(commandArray[2]);
                                                                                                    if (number < 0) {
                                                                                                        System.out.println("WARNING: goody_length_value must be >= 0");
                                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                                        return false;
                                                                                                    }
                                                                                                    this.parameter.setGoody_length_value(number);
                                                                                                    break block257;
                                                                                                }
                                                                                                if (!commandArray[1].equals("goody_points_value")) break block293;
                                                                                                if (!commandArray[2].matches("[0-9]*")) {
                                                                                                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                                    this.controlLog.addToLastLine("\tfalse");
                                                                                                    return false;
                                                                                                }
                                                                                                number = Integer.parseInt(commandArray[2]);
                                                                                                if (number < 0) {
                                                                                                    System.out.println("WARNING: goody_points_value must be >= 0");
                                                                                                    this.controlLog.addToLastLine("\tfalse");
                                                                                                    return false;
                                                                                                }
                                                                                                this.parameter.setGoody_points_value(number);
                                                                                                break block257;
                                                                                            }
                                                                                            if (!commandArray[1].equals("goody_shorter_value")) break block294;
                                                                                            if (!commandArray[2].matches("[0-9]*")) {
                                                                                                System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                                return false;
                                                                                            }
                                                                                            number = Integer.parseInt(commandArray[2]);
                                                                                            if (number < 0) {
                                                                                                System.out.println("WARNING: goody_shorter_value must be >= 0");
                                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                                return false;
                                                                                            }
                                                                                            this.parameter.setGoody_shorter_value(number);
                                                                                            break block257;
                                                                                        }
                                                                                        if (!commandArray[1].equals("min_cycle_ms")) break block295;
                                                                                        if (!commandArray[2].matches("[0-9]*")) {
                                                                                            System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                            this.controlLog.addToLastLine("\tfalse");
                                                                                            return false;
                                                                                        }
                                                                                        number = Integer.parseInt(commandArray[2]);
                                                                                        if (number < 0) {
                                                                                            System.out.println("WARNING: min_cycle_ms must be >= 0");
                                                                                            this.controlLog.addToLastLine("\tfalse");
                                                                                            return false;
                                                                                        }
                                                                                        this.parameter.setAutogamespeed(0);
                                                                                        this.parameter.setMin_cycle_ms(number);
                                                                                        if (this.parameter.getMax_thinking_ms() < number) {
                                                                                            this.control("set max_thinking_ms " + number);
                                                                                            if (this.gui) {
                                                                                                M_GraphixEngineUI.updateDialogs();
                                                                                            }
                                                                                        }
                                                                                        break block257;
                                                                                    }
                                                                                    if (!commandArray[1].equals("max_thinking_ms")) break block296;
                                                                                    if (!commandArray[2].matches("[0-9]*")) {
                                                                                        System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                        return false;
                                                                                    }
                                                                                    number = Integer.parseInt(commandArray[2]);
                                                                                    if (number < 1) {
                                                                                        System.out.println("WARNING: max_thinking_ms must be >= 1");
                                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                                        return false;
                                                                                    }
                                                                                    this.parameter.setMax_thinking_ms(number);
                                                                                    if (this.parameter.getMin_cycle_ms() > number) {
                                                                                        this.control("set min_cycle_ms " + number);
                                                                                        if (this.gui) {
                                                                                            M_GraphixEngineUI.updateDialogs();
                                                                                        }
                                                                                    }
                                                                                    break block257;
                                                                                }
                                                                                if (!commandArray[1].equals("analyse_ms")) break block297;
                                                                                if (!commandArray[2].matches("[0-9]*")) {
                                                                                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                    this.controlLog.addToLastLine("\tfalse");
                                                                                    return false;
                                                                                }
                                                                                number = Integer.parseInt(commandArray[2]);
                                                                                if (number < 1) {
                                                                                    System.out.println("WARNING: analyse_ms must be >= 1");
                                                                                    this.controlLog.addToLastLine("\tfalse");
                                                                                    return false;
                                                                                }
                                                                                this.parameter.setAnalyse_ms(number);
                                                                                break block257;
                                                                            }
                                                                            if (!commandArray[1].equals("tolerance_ms")) break block298;
                                                                            if (!commandArray[2].matches("[0-9]*")) {
                                                                                System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                return false;
                                                                            }
                                                                            number = Integer.parseInt(commandArray[2]);
                                                                            if (number < 0) {
                                                                                System.out.println("WARNING: tolerance_ms must be >= 0");
                                                                                this.controlLog.addToLastLine("\tfalse");
                                                                                return false;
                                                                            }
                                                                            this.parameter.setTolerance_ms(number);
                                                                            break block257;
                                                                        }
                                                                        if (!commandArray[1].equals("max_player_mem")) break block299;
                                                                        if (!commandArray[2].matches("[0-9]*")) {
                                                                            System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                            this.controlLog.addToLastLine("\tfalse");
                                                                            return false;
                                                                        }
                                                                        this.parameter.setMax_player_mem(Integer.parseInt(commandArray[2]));
                                                                        break block257;
                                                                    }
                                                                    if (!commandArray[1].equals("max_mem_check_delay")) break block300;
                                                                    if (!commandArray[2].matches("[0-9]*")) {
                                                                        System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                        return false;
                                                                    }
                                                                    number = Integer.parseInt(commandArray[2]);
                                                                    if (number < 0) {
                                                                        System.out.println("WARNING: max_mem_check_delay must be >= 1");
                                                                        this.controlLog.addToLastLine("\tfalse");
                                                                        return false;
                                                                    }
                                                                    this.parameter.setMax_mem_check_delay(number);
                                                                    break block257;
                                                                }
                                                                if (!commandArray[1].equals("exit_time")) break block301;
                                                                if (!commandArray[2].matches("[0-9]*")) {
                                                                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                    this.controlLog.addToLastLine("\tfalse");
                                                                    return false;
                                                                }
                                                                this.parameter.setExit_time(Integer.parseInt(commandArray[2]));
                                                                this.gameInfo.exitTime = this.parameter.getExit_time();
                                                                break block257;
                                                            }
                                                            if (!commandArray[1].equals("suddend_time")) break block302;
                                                            if (!commandArray[2].matches("[0-9]*")) {
                                                                System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                                this.controlLog.addToLastLine("\tfalse");
                                                                return false;
                                                            }
                                                            this.parameter.setSuddend_time(Integer.parseInt(commandArray[2]));
                                                            this.gameInfo.suddenDeath = this.parameter.getSuddend_time();
                                                            break block257;
                                                        }
                                                        if (!commandArray[1].equals("survival_points")) break block303;
                                                        if (!commandArray[2].matches("[0-9]*")) {
                                                            System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                                                            this.controlLog.addToLastLine("\tfalse");
                                                            return false;
                                                        }
                                                        this.parameter.setSurvival_points(Integer.parseInt(commandArray[2]));
                                                        break block257;
                                                    }
                                                    if (!commandArray[1].equals("show_subcycles")) break block304;
                                                    if (!commandArray[2].matches("[01]") || commandArray[2].length() > 1) {
                                                        System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no boolean number!");
                                                        this.controlLog.addToLastLine("\tfalse");
                                                        return false;
                                                    }
                                                    number = Integer.parseInt(commandArray[2]);
                                                    if (number != 0 && number != 1) {
                                                        System.out.println("WARNING: show_subcycles must be 0 or 1");
                                                        this.controlLog.addToLastLine("\tfalse");
                                                        return false;
                                                    }
                                                    this.parameter.setShow_subcycles(number);
                                                    break block257;
                                                }
                                                if (!commandArray[1].equals("logging")) break block305;
                                                if (!commandArray[2].matches("[01]") || commandArray[2].length() > 1) {
                                                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no boolean number!");
                                                    this.controlLog.addToLastLine("\tfalse");
                                                    return false;
                                                }
                                                number = Integer.parseInt(commandArray[2]);
                                                if (number != 0 && number != 1) {
                                                    System.out.println("WARNING: logging must be 0 or 1");
                                                    this.controlLog.addToLastLine("\tfalse");
                                                    return false;
                                                }
                                                this.parameter.setLogging(number);
                                                break block257;
                                            }
                                            if (!commandArray[1].equals("print_calc_ms")) break block306;
                                            if (!commandArray[2].matches("[01]") || commandArray[2].length() > 1) {
                                                System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no boolean number!");
                                                this.controlLog.addToLastLine("\tfalse");
                                                return false;
                                            }
                                            number = Integer.parseInt(commandArray[2]);
                                            if (number != 0 && number != 1) {
                                                System.out.println("WARNING: print_calc_ms must be 0 or 1");
                                                this.controlLog.addToLastLine("\tfalse");
                                                return false;
                                            }
                                            this.parameter.setPrint_calc_ms(number);
                                            break block257;
                                        }
                                        if (!commandArray[1].equals("print_player_mem")) break block307;
                                        if (!commandArray[2].matches("[01]") || commandArray[2].length() > 1) {
                                            System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no boolean number!");
                                            this.controlLog.addToLastLine("\tfalse");
                                            return false;
                                        }
                                        number = Integer.parseInt(commandArray[2]);
                                        if (number != 0 && number != 1) {
                                            System.out.println("WARNING: print_player_mem must be 0 or 1");
                                            this.controlLog.addToLastLine("\tfalse");
                                            return false;
                                        }
                                        this.parameter.setPrint_player_mem(number);
                                        break block257;
                                    }
                                    if (!commandArray[1].equals("player_controlling")) break block308;
                                    if (!commandArray[2].matches("[01]") || commandArray[2].length() > 1) {
                                        System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no boolean number!");
                                        this.controlLog.addToLastLine("\tfalse");
                                        return false;
                                    }
                                    number = Integer.parseInt(commandArray[2]);
                                    if (number != 0 && number != 1) {
                                        System.out.println("WARNING: player_controlling must be 0 or 1");
                                        this.controlLog.addToLastLine("\tfalse");
                                        return false;
                                    }
                                    this.parameter.setPlayer_controlling(number);
                                    break block257;
                                }
                                if (!commandArray[1].equals("timekill")) break block309;
                                if (!commandArray[2].matches("[01]") || commandArray[2].length() > 1) {
                                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no boolean number!");
                                    this.controlLog.addToLastLine("\tfalse");
                                    return false;
                                }
                                number = Integer.parseInt(commandArray[2]);
                                if (number != 0 && number != 1) {
                                    System.out.println("WARNING: timekill must be 0 or 1");
                                    this.controlLog.addToLastLine("\tfalse");
                                    return false;
                                }
                                this.parameter.setTimekill(number);
                                break block257;
                            }
                            if (!commandArray[1].equals("memkill")) break block310;
                            if (!commandArray[2].matches("[01]") || commandArray[2].length() > 1) {
                                System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no boolean number!");
                                this.controlLog.addToLastLine("\tfalse");
                                return false;
                            }
                            number = Integer.parseInt(commandArray[2]);
                            if (number != 0 && number != 1) {
                                System.out.println("WARNING: memkill must be 0 or 1");
                                this.controlLog.addToLastLine("\tfalse");
                                return false;
                            }
                            this.parameter.setMemkill(number);
                            break block257;
                        }
                        if (!commandArray[1].equals("record")) break block311;
                        if (!commandArray[2].matches("[01]") || commandArray[2].length() > 1) {
                            System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no boolean number!");
                            this.controlLog.addToLastLine("\tfalse");
                            return false;
                        }
                        if (this.parameter.getReplay() == 1) {
                            System.out.println("WARNING: no record during a replay possible.");
                            this.controlLog.addToLastLine("\tfalse");
                            return false;
                        }
                        number = Integer.parseInt(commandArray[2]);
                        if (number != 0 && number != 1) {
                            System.out.println("WARNING: record must be 0, or 1");
                            this.controlLog.addToLastLine("\tfalse");
                            return false;
                        }
                        if (number == 1 && this.parameter.getReplay() == 1) {
                            this.parameter.setRecord(0);
                            System.out.println("no recording of replays!");
                            this.controlLog.addToLastLine("\tfalse");
                            return false;
                        }
                        this.parameter.setRecord(number);
                        break block257;
                    }
                    if (!commandArray[1].equals("recordname")) break block312;
                    if (this.gameState != 2) {
                        System.out.println("WARNING: Game is not in initialization context,end a possibly running game and try again.");
                        this.controlLog.addToLastLine("\tfalse");
                        return false;
                    }
                    this.parameter.setRecordName(commandArray[2]);
                    break block257;
                }
                if (!commandArray[1].equals("autogamespeed")) break block313;
                if (!commandArray[2].matches("[01]") || commandArray[2].length() > 1) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no boolean number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number != 0 && number != 1) {
                    System.out.println("WARNING: autogamespeed must be 0 or 1");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setAutogamespeed(number);
                if (number == 1) {
                    this.oldCycleMS = this.parameter.getMin_cycle_ms();
                    if (this.gameHasHuman()) {
                        this.parameter.setMin_cycle_ms(50);
                        break block257;
                    } else {
                        this.parameter.setMin_cycle_ms(0);
                    }
                    break block257;
                } else {
                    this.parameter.setMin_cycle_ms(this.oldCycleMS);
                }
                break block257;
            }
            if (commandArray[1].equals("replay_reverse")) {
                if (!commandArray[2].matches("[01]") || commandArray[2].length() > 1) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no boolean number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number != 0 && number != 1) {
                    System.out.println("WARNING: replay_reverse must be 0 or 1");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setReplay_reverse(number);
            } else if (commandArray[1].equals("replay_stepwise")) {
                if (!commandArray[2].matches("[01]") || commandArray[2].length() > 1) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no boolean number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number != 0 && number != 1) {
                    System.out.println("WARNING: replay_stepwise must be 0 or 1");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setReplay_stepwise(number);
            } else if (commandArray[1].equals("replay_stepwidth")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setReplay_stepwidth(Integer.parseInt(commandArray[2]));
            } else {
                if (!commandArray[1].equals("game_end")) {
                    System.out.println("WARNING in M_Main.controlInterface: Unknown parameter '" + commandArray[1] + "' !!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                if (!commandArray[2].matches("[012]") || commandArray[2].length() > 1) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is not 0, 1 or 2!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number != 0 && number != 1 && number != 2) {
                    System.out.println("WARNING: quit_at_gameEnd must be 0, 1 or 2");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setGame_end(number);
            }
        }
        if (this.scriptEx <= 0 && this.gui) {
            M_GraphixEngineUI.update(this.gameInfo, null);
        }
        this.controlLog.addToLastLine("\ttrue");
        return true;
    }

    private void quit(int x) {
        this.controlLog.storeLine("end Game");
        if (this.parameter.getLogging() == 1) {
            this.controlLog.saveAndCloseFile();
        }
        System.exit(x);
    }

    public static int getVersion() {
        return 1019;
    }
}

