/*
 * Created on 07.02.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.farafin.snEADy.player;

import de.farafin.snEADy.player.PubConstants;

/** This is just a class for storing informations. It doesnt contain methods because it doesnt need
 * to calculate anything. Its just a set of informations for the player. <br> 
 * <br>
 * This class contains general data about the Snakes which are in the arena.<br>
 * <br>
 * Diese Klasse ist zum Speichern von Informationen gedacht. Sie enthllt keine Methoden weil
 * sie nichts berechnen muss. Es ist nur eine Menge von Informationen fr den Spieler. <br>
 * <br>
 * Diese Klasse enthllt allgemeine Daten ber die Schlangen in der Arena.<br>
 * 
 * @author roland, lars
 */
public class SnakeInfo implements PubConstants
{
	/** The name of the player who controls the snake. <br>
	 *  <br>
	 * Der Name des Spielers der die Schlange steuert.
	 * 
	 */
	public String playerName = "";
	
	/** The char value of the snake in the playField. <br>
	 *  <br>
	 * Der char-Wert des Spielers auf dem Spielfeld.
	 * 
	 * @see PubConstants#PLAYER_0 
	 */
	public char snakeChar = PLAYER_0;
	
	/** The line of the snakes heads position at the play field:
	 * playField[headPosLine][headPosRow].<br>
	 * <br>
	 * Die Zeile der Kopfposition der Schlange auf dem Spielfeld:
	 * playField[headPosLine][headPosRow].
	 * 
	 * @see LevelInfo#playField
	 */
	public int headPosLine = 0;

	/** The row of the snakes heads position at the play field:
	 * playField[headPosLine][headPosRow].<br>
	 * <br>
	 * Die Spalte der Kopfposition der Schlange auf dem Spielfeld:
	 * playField[headPosLine][headPosRow].
	 * 
	 * @see LevelInfo#playField
	 */
	public int headPosRow = 0;
	
	/** The points the player, which controls the snake. <br>
	 * <br>
	 * Die Punkte des Spielers, der die Schlange steuert.
	 */
	public int points = 0;
	
	/** The number of visable segments of the snake which is equal to the current
	 * length of the snake.<br>
	 * <br>
	 * Die Anzahl der sichtbaren Schlangensegmente was gleichbedeutend mit der
	 * Lnge der Schlange ist. 
	 *  */
	public int snakeLength = 0;
	

	/** Like it is described at GameInfo.gameTime, consists the game as a sequence of game cycles.
	 * To realize different velocities for the snakes, are the snakes not moving each game cycle.
	 * So the player thinks waitCycles times and than the snake moves one time. The fastest
	 * imaginable speed is that the snake moves (one field) each game cycle. For the tournament
	 * might be the value higher. visit www.snEADy.de for more informations about this.<br> 
	 * So you can imagine waitCycles as a strange kind of speed. The less waitCycles is, the more
	 * often the snake will move, but the less often the player will have time to think what he is
	 * doing next. waitCycles is the number of cycles, the snake waits between two moves.<br>
	 * <br>
	 * Wie bereits in GameInfo.gameTime beschrieben, besteht das Spiel aus einer Folge von spiel zyklen.
	 * Um verschiedene Geschwindigkeiten der Schlangen zu realisieren, ziehen sie nicht jeden Zyklus.
	 * Das bedeutet, ein Spieler denkt erst waitCycles mal nach bevor die Schlange ein mal zieht.
	 * Die hchste denkbare Geschwindigkeit ist, dass die Schlange jede Runde (ein Feld) zieht. 
	 * Fr das Turnier werden wir den Wert veilleicht erhhen, schaut einfach auf www.snEADy.de
	 * vorbei um euch da genauer zu informieren.<br>
	 * Man kann sich waitCycles also auch als eine art Geschwindigkeit vorstellen. Je kleiner waitCycles
	 * ist, desto fter bewegt sich die Schlange, aber desto weniger kann ein spieler ber den nchsten
	 * Zug nachdenken. waitCycles ist die Anzahl der zyklen die die Schlange zwischen zwei mal bewegen
	 * warten muss.
	 * 
	 * @see GameInfo#gameTime
	 */
	public long waitCycles = 0;	
	
	/** The status of the snake. Possible is: IN_ACTION, IN_HEAVAN and IN_EXIT.
	 * The status gives informations if the snake is still running around (IN_ACTION),
	 * died (IN_HEAVEN) or went out of the arena through the exit (IN_EXIT).<br>
	 * For more details see PubConstants.<br>
	 * <br>
	 * Der Status der Schlange. Mglich ist: IN_ACTION, IN_HEAVAN und IN_EXIT.
	 * Der Status gibt an, ob die Schlange noch auf dem Spielfeld aktiv ist (IN_ACTION),
	 * gestorben ist (IN_HEAVEN) oder durch den exit das Spielfeld verlassen hat (IN_EXIT).<br>
	 * Siehe PubConstants fr mehr Details.
	 * 
	 * @see PubConstants#IN_ACTION
	 * @see PubConstants#IN_HEAVEN
	 * @see PubConstants#IN_EXIT
	 *  */
	public int snakeStatus = IN_ACTION;
}
