/*
 * Created on 03.01.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.farafin.snEADy.player;

/** This Interface contains some constants which you need
 * to interpete the playfield or specify directions. Just implement it in your class you want to
 * use it in. Than you are able to use the constants as if they were local variables.
 * See Luke Wallwalker as excample.<br>
 * <br>
 * Dieses Interface enthllt einige Konstanten mit denen ihr das Spielfeld interpretieren, und
 * Richtungen spezifizieren knnt. Es reicht aus das Interface in der klasse in der ihr es nutzen
 * wollt zu implementieren, dann knnt ihr die Konstanten wie lokale Variablen benutzen.
 * Schaut euch eifnach LukeWallwalker an fr ein Beispiel.
 * 
 * @author roland, lars 
 */
public interface PubConstants
{
	// playField Constants: they discribe the interpretation of the playField.
	/** free field */			public static final char FREE		=	'.';
	/** blocked field */		public static final char WALL		=	'#';
	
	/** player 0 */				public static final char PLAYER_0	=	'0';
	/** player 1 */				public static final char PLAYER_1	=	'1';
	/** player 2 */				public static final char PLAYER_2	=	'2';
	/** player 3 */				public static final char PLAYER_3	=	'3';
	/** player 4 */				public static final char PLAYER_4	=	'4';
	/** player 5 */				public static final char PLAYER_5	=	'5';
	/** player 6 */				public static final char PLAYER_6	=	'6';
	/** player 7 */				public static final char PLAYER_7	=	'7';
	/** player 8 */				public static final char PLAYER_8	=	'8';
	/** player 9 */				public static final char PLAYER_9	=	'9';

	/** length goody: makes the snake longer<br>
	 * The snake grows slowly each time it moves. So that the head moves normal while the tail
	 * stayst at its position until the snake has reached its new length.
	 * <br>
	 * lngen goody: macht die Schlange lnger<br>
	 * Die Schlange wchst langsam jedes mal wenn sie sich bewegt. Ihr Kopf bewegit sich normal
	 * weiter, wrend ihr Krper an der ursprnglichen Position stehen bleibt bis sie ihre
	 * neue Lnge erreicht hat.
	 * 
	 * @see SnakeInfo#snakeLength
	 *  */
	public static final char LENGTH	 	=	'a';
	
	/** speed goody: decrease waitCycle by one if the minimum wasn't reached.
	 * 
	 * geschwindigkeits goody: verringert die waitCycles um 1 wenn das minimum noch nicht erreicht ist.
	 * 
	 * @see OwnSnakeInfo#waitCycles
	 * */
	public static final char SPEED   	=	'b';
	
	/** points goody: gives the player points
	 * 
	 * points goody: gibt dem Spieler Punkte
	 * 
	 * @see SnakeInfo#points
	 * */
	public static final char POINTS  	=	'c';

	/** slowdown goody: increase waitCycle by one if the maximum wasn't reached.
	 * 
	 * bremsen goody: erhht die waitCycles um 1 wenn das maximum noch nicht erreicht ist.
	 * 
	 * @see OwnSnakeInfo#waitCycles
	 * */
	public static final char SLOWDOWN	=	'd';

	/** shorter goody: makes the snake shorter<br>
	 * The snakes head moves ahead as normal, but the tail looses each time the snake
	 * moves one segment until its new length is reached.
	 * <br>
	 * verkrzen goody: macht die Schlange krzer<br>
	 * Der Kopf der Schlange bewegt sich weiter wie bisher, aber ihr Krper jedes mal wenn
	 * sich die Schlange bewegt um ein Segment krzer wird.
	 * 
	 * @see SnakeInfo#snakeLength
	 *  */
	public static final char SHORTER   	=	'e';

	/** exit fields:
	 * 
	 * This are the exit fields. Until gameTime has noch reached exitTime, exit-fields behave
	 * the same as walls does. If the exit is opened, the snake can leave the arena.
	 * By the way: the only way to survive in snEADy is to reach the exit. Snakes
	 * doesn't reach it died dureing the battle or they die during sudden death.<br>
	 * There are also survival points given for those snakes who reach the exit. The amount of
	 * points depends in which position the snake goes into the exit.<br>
	 * For detailed informations how many points a snake gets in the tournament, visit www.snEADy.de.
	 * Lets say the first snake gets n points, than the second gets 2*n, the thired 3*n usw..<br>
	 * <br>
	 * Das hier ist das Exit-Feld. Bevor gameTime noch nicht exitTime erreicht hat, verhalten sich
	 * die Exit-Felder wie Wnde. Nachdem der Exit geffnet wurde kann die Schlange die Arena verlassen.
	 * Und wo wir grad dabei sind: Der einzige Weg in snEADy zu bereben ist den Exit zu erreichen.
	 * Schlangen die das nicht schaffen sind entweder wrend des kampfes gestorben oder sterben
	 * wrend der sudden death phase.<br>
	 * Es werden aber auch Punkte fr die Schlangen verteilt, die den Ausgang erreichen. Wie viele
	 * das sind hngt davon ab an wievielter stelle die Schlange in das Exit geht.<br>
	 * Fr genauere Informationen wie viele Punkte das sind schaut bitte auf www.snEADy.de nach.
	 * Aber wenn die erste Schlange n Punkte bekommt, dann bekommt die 2. 2*n, die dritte 3*n usw... 
	 * 
	 * @see GameInfo#gameTime
	 * @see GameInfo#exitTime
	 *  */
	public static final char EXIT 		=	'A';
	
	// Snake Status
	/** head direction of the snake */
	public static final int NORTH 	= 0;

	/** head direction of the snake */
	public static final int EAST 	= 1;

	/** head direction of the snake */
	public static final int SOUTH 	= 2;

	/** head direction of the snake */
	public static final int WEST 	= 3;
	
	/** if a snake is on the field and running */
	public static final int IN_ACTION = 0;
	
	/** if the snake died in battle, rest in peace */
	public static final int IN_HEAVEN = 1;
	
	/** if the snake has left the arena throu the exit */
	public static final int IN_EXIT = 2;
	
	// Snake move directions
	/** the snake moves stright ahead */
	public static final int TURN_NONE = 0;
	
	/** the snake turns left */
	public static final int TURN_LEFT = -1;

	/** the snake turns right */
	public static final int TURN_RIGHT = 1;
}
