/*
 * Created on 16.01.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.farafin.snEADy.inOut;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

import de.farafin.snEADy.communication.I_Constants;

/** offers service to write logfiles with a buffer to be able to store local lines which can be stored later..
 * 
 * @author roland, lars
 */
public final class C_LogFileWriter implements I_Constants
{	
	/** Comment for <code>logFile</code> */
	private File logFile;
	
	/** Comment for <code>lineList</code> */
	private Vector lineList = null;
	
	/** Comment for <code>writer</code> */
	private FileWriter writer;
	
	/** constructor
	 * @param fileName
	 */
	public C_LogFileWriter(String fileName)
	{
		this("logs", fileName);
	}
	
	/**
	 * @param root
	 * @param fileName
	 */
	public C_LogFileWriter(String root, String fileName)
	{
		logFile = new File(root, fileName);
		lineList = new Vector(8);
		try
		{
			this.logFile.createNewFile();
			this.writer = new FileWriter(this.logFile);
		}
		catch(IOException e)
		{
			System.out.println("WARNING: LogFile cant be opend!! " + e);
			if(DEBUG) System.out.println("DEBUG C_LogFileWriter.C_LogFileWriter: " +
					"well.. now you have a problem... better check that there is " +
					"no writing-proofed file with the same name..");
		}
	}
	
	/** stors a line to a local list
	 * @param line
	 */
	public void storeLine(String line)
	{
		this.lineList.add(line);
	}
	
	/** concats tail to the last string in the list.
	 * if the list is empty, tail is added as a new line.
	 * @param tail
	 */
	public void addToLastLine(String tail)
	{
		int last = this.lineList.size();
		if(last <= 1)
		{
			this.lineList.add(tail);
			return;
		}
		String line = (String)this.lineList.remove(last - 1);
		line = line + tail;
		lineList.add(line);
	}
	
	/** an class to organize Log-File writings
	 * 
	 * @param line writes a line at the end of the file
	 * @return true if the line was sucessfully written
	 */
	public boolean writeLine(String line)
	{
		try
		{
			this.writer.write(line + "\n");
			writer.flush();
		}
		catch(IOException e)
		{
			System.out.println("WARNING: LogFile cant be written in!! " + e);
			if(DEBUG) System.out.println("DEBUG C_LogFileWriter.writeLine: " +
					"well.. now you have a problem... better check that there is " +
					"no writing-proofed file with the same name..");
			return false;
		}
		
		return true;
	}
	
	/** writs the local list of lines to the file
	 * @return true if the lines were sucessfully written */
	public boolean safe()
	{
		if(DEBUG) System.out.println("DEBUG C_LogFileWriter.safe: safe()");
		try
		{
			for(int i=0; i<this.lineList.size(); i++)
			{
				this.writer.write(((String)this.lineList.elementAt(i)+ "\n"));
			}
			this.lineList.clear();
			writer.flush();
		}
		catch(IOException e)
		{
			System.out.println("WARNING: LogFile cant be written in!! " + e);
			if(DEBUG) System.out.println("DEBUG C_LogFileWriter.writeLine: " +
					"well.. now you have a problem... better check that there is " +
					"no writing-proofed file with the same name..");
			return false;
		}
		
		return true;
	}
	
	/** safes the stored lines to the file and closes it. */
	public void safeAndCloseFile()
	{
		if(DEBUG) System.out.println("DEBUG C_LogFileWriter.safe: safeAndCloseFile: " + this.logFile.getName());
		try
		{
			this.safe();
			if(DEBUG) System.out.println("DEBUG C_LogFileWriter.safe: close()");
			this.writer.close();
		}
		catch(IOException e)
		{
			System.out.println("WARNING: LogFile cant be closed!! " + e);
			if(DEBUG) System.out.println("DEBUG C_LogFileWriter.closeFile");
		}
	}
}
