/*
 * Created on 17.01.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.farafin.snEADy.inOut;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.FileNotFoundException;
import java.util.Vector;

import de.farafin.snEADy.communication.I_Constants;
/**
 * @author roland, lars
 *
 * TODO what does that class do?
 * 
 */
public final class C_LogFileReader implements I_Constants
{
	/** Comment for <code>logFile</code> */
	private File logFile;
	
	/** Comment for <code>lineList</code> */
	private Vector lineList = null;
	
	/**
	 * Comment for <code>actLineCounter</code>
	 */
	private int actLineCounter = 0;
		

	/**
	 * @param root
	 * @param fileName
	 */
	public C_LogFileReader(String root, String fileName) throws FileNotFoundException
	{
		this.actLineCounter = 0;
		BufferedReader reader;
		logFile = new File(root, fileName);
		if(!logFile.exists()) throw new FileNotFoundException("File " + fileName + " at " + root + " was not found!" );
		lineList = new Vector(8);
		String tmp;
		try
		{
			//this.logFile.createNewFile();
			reader = new BufferedReader(new FileReader(this.logFile));

			while(reader.ready())
			{
				tmp = reader.readLine();
				this.lineList.addElement(tmp);
			}
			reader.close();
		}
		catch(IOException e)
		{
			System.out.println("WARNING: LogFile cant be opend!! " + e);
			if(DEBUG) System.out.println("DEBUG C_LogFileReader.C_LogFileReader: " +
					"well.. if the file is there you have a problem or i have a bug" +
					"... better check that there is " +
					"no reading-proofed file with the same name..");
		}
	}
	
	/** constructor
	 * @param fileName
	 */
	public C_LogFileReader(String fileName) throws FileNotFoundException
	{
		this("logs", fileName);
	}
	
	
	
	/**
	 * stors a line to a local list
	 * @return line
	 */
	public String readNextLine()
	{
		if(actLineCounter < this.lineList.size())
		{
			actLineCounter++;
			return (String)this.lineList.elementAt(actLineCounter-1);
		}
		
		return "";
	}
	
	/**
	 * @param number
	 * @return line of number
	 */
	public String readLine(int number)
	{
		if(number < this.lineList.size())
		{
			return (String)this.lineList.get(number);
		}
		
		return "";
	}
	
	/**
	 * @return if all lines were read
	 */
	public boolean isFinished()
	{
		return (this.actLineCounter >= this.lineList.size());
	}
	
	/** next line is set to 0 */
	public void restart()
	{
		this.actLineCounter = 0;
	}
	
	/**
	 * @return v
	 */
	public String getFileName()
	{
		return this.logFile.getName();
	}
}
