/*
 * Created on 25.02.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.farafin.snEADy.control.GaphixStuff;

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;


/**
 * @author larsonmars
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class GrScroll extends Canvas implements I_GraphixConstants{
	private final int 	SCROLL_NONE=0,
						SCROLL_UP=1,
						SCROLL_DOWN=2,
						SCROLL_BAR=3;
	
	
	private int sState=0;
	private int w,h;
	private int max,range;
	private float pos=0;
	private int dy_bar;
	private int dMover=-1;
	GrTextArea selectC;
	
	private BufferedImage img_scroll;
	
	protected GrScroll(int x, int y, int width, int height,GrSelCanvas selC){
		selectC=selC;
		dy_bar=C_GraphixData.menuImagesO[S_VSCROLLBUTT].getHeight();
		w=width;
		h=height;
		
		if (selC.list!=null)
			max=selC.list.length;
		else
			max=0;
		range=selC.lines;
		setBounds(x,y,w,h);
		img_scroll=C_GraphixData.gc.createCompatibleImage(this.w,this.h);
		drawScroll();
		addMouseListener(new MouseListener(){
			public void mouseEntered(MouseEvent e){}
   			public void mouseClicked(MouseEvent e){}
   			public void mousePressed(MouseEvent e){
   				int absY,absH;
   				int y=e.getY();
   				
   				if (y<dy_bar){
   					sState=SCROLL_UP;
   					if (pos>0) pos--;
   				}
   				else if (y>h-dy_bar){
   					sState=SCROLL_DOWN;
   					if (pos<max-range)pos++;
   				}
   				else{
   					absY=getMoverAbsPos();
   					absH=getMoverAbsHeight();
   					if (y<absY){
   						pos=pos-range;
   						if (pos<0)pos=0;
   					}
   					else if (y>absY+absH){
   						pos=pos+range;
   						if (pos>max-range)pos=max-range;
   					}
   					else{
   						dMover=(y-absY);
   					}
   					sState=SCROLL_BAR;
   				}
   				selectC.updateDSelect((int)pos);
   				drawScroll();
   				repaint();
			}
   			public void mouseReleased(MouseEvent e){
   				sState=SCROLL_NONE;
   				dMover=-1;
   				drawScroll();
   				repaint();
   			}
   			public void mouseExited(MouseEvent e){}
		});
		
		addMouseMotionListener(new MouseMotionListener(){
			public void mouseDragged(MouseEvent e){
				int absY,absH;
				int y=e.getY();
				float oneStep;
				if (dMover>=0){
					
					
   					
   					absH=getMoverAbsHeight();
   					oneStep=(float)(max-range)/(h-2*dy_bar-absH);
   					pos=(float)(y-dy_bar-dMover)*oneStep;
   					if (pos>max-range)pos=max-range;
   					if (pos<0)pos=0;
   					
	   				selectC.updateDSelect((int)pos);
	   				drawScroll();
	   				repaint();
   					
				}
			}
   			public void mouseMoved(MouseEvent e){}
		});
//*/
	}
	
	private final int getMoverAbsPos(){
		return (max==0)? dy_bar : (int)(dy_bar+pos*(float)(h-2*dy_bar)/max);
	}
	private final int getMoverAbsHeight(){
		float tmp;
		if (max==0)return h-2*dy_bar;
		tmp=(float)range/max;
		if (tmp>1)return h-2*dy_bar;
		return (int)(tmp*(h-2*dy_bar));
   	}
	private void drawScroll(){
		int upSrcX=0,downSrcX=2*w;
		int imgScrHeight=C_GraphixData.menuImagesO[S_VSCROLL].getHeight();
		int scrollSegC=(h-2*dy_bar)/imgScrHeight;
		if (sState==SCROLL_UP)
			upSrcX=w;
		else if (sState==SCROLL_DOWN)
			downSrcX=3*w;
		
		Graphics g=img_scroll.getGraphics();
		g.setColor(COL_GREY1);

		g.drawImage(C_GraphixData.menuImagesO[S_VSCROLLBUTT],0,0,w,dy_bar,upSrcX,0,upSrcX+w,dy_bar,null);
		g.drawImage(C_GraphixData.menuImagesO[S_VSCROLL],0,dy_bar,w,dy_bar+imgScrHeight,0,0,w,imgScrHeight,null);
		for (int i=1;i<scrollSegC;i++)
			g.drawImage(C_GraphixData.menuImagesO[S_VSCROLL],0,dy_bar+i*imgScrHeight,w,dy_bar+(i+1)*imgScrHeight,w,0,w*2,imgScrHeight,null);
		g.drawImage(C_GraphixData.menuImagesO[S_VSCROLL],0,h-dy_bar-imgScrHeight,w,h-dy_bar,2*w,0,3*w,imgScrHeight,null);
		g.drawImage(C_GraphixData.menuImagesO[S_VSCROLLBUTT],0,h-dy_bar,w,h,downSrcX,0,downSrcX+w,dy_bar,null);
		

		g.fillRect(4,(int)(4+getMoverAbsPos()),w-8,(int)(getMoverAbsHeight()-8));
		//g.drawImage(menuImages[M_BG],0,0,null);
	}
	public void paint(Graphics g){
		g.drawImage(img_scroll,0,0,null);
	}
	public void repaint(){
		getGraphics().drawImage(img_scroll,0,0,null);
	}
	
}