/*
 * Created on 25.02.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.farafin.snEADy.control.GaphixStuff;

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;

/**
 * @author larsonmars
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public abstract class GrButton extends Canvas{
	public static final int BUTTON_NORMAL=0,
							BUTTON_NORMALHOVERED=1,
							BUTTON_PRESSED=2,
							BUTTON_PRESSEDHOVERED=3,
							BUTTON_DISABLED=4,
							TOGGLEBUTTON=11,
							NORMALBUTTON=12;
	
	public int iData;
	public int bMode;
	protected int bState;
	private int oldBState;
	private BufferedImage bImage;
	public int w,h;
	
	public GrButton(){
		super();
	}
	public GrButton(int x,int y,int mode,int image,boolean enabled){
		this(x,y,mode,image,enabled,0);
	}
	public GrButton(int x,int y,int mode,int image,boolean enabled,int intData){
		iData=intData;
		bMode=mode;
		bImage=C_GraphixData.menuImagesO[image];
		setFocusable(false);
		if (enabled)
		    bState=BUTTON_NORMAL;
		else{
		    bState=BUTTON_DISABLED;
		    super.setEnabled(false);
		}
		
		w=bImage.getWidth(null)/5;
		h=bImage.getHeight(null);
		
		setBounds(x,y,w,h);
		
		addMouseListener(new MouseListener(){
            public void mouseEntered(MouseEvent e){
            	if (!isEnabled())return;
        		if (bMode==TOGGLEBUTTON){
        			if (bState==BUTTON_PRESSED)
        				bState=BUTTON_PRESSEDHOVERED;
        			else
        				bState=BUTTON_NORMALHOVERED;
        		}
        		else{
        			bState=BUTTON_NORMALHOVERED;
        		}
        		getGraphics().drawImage(bImage,0,0,w,h,bState*w,0,(bState+1)*w,h,null);
        		//stateChanged(bState);
        	}
            public void mousePressed(MouseEvent e){
        		if (bMode==TOGGLEBUTTON){
        			bState=(bState==BUTTON_PRESSEDHOVERED)? BUTTON_NORMALHOVERED : BUTTON_PRESSEDHOVERED;
        			getGraphics().drawImage(bImage,0,0,w,h,bState*w,0,(bState+1)*w,h,null);
        			stateChanged(bState);
        		}
        		else{
        			bState=BUTTON_PRESSEDHOVERED;
        			getGraphics().drawImage(bImage,0,0,w,h,bState*w,0,(bState+1)*w,h,null);
        		}
            }
            public void mouseClicked(MouseEvent e){
        		if (bMode==NORMALBUTTON){
        			bState=BUTTON_NORMALHOVERED;
        			getGraphics().drawImage(bImage,0,0,w,h,bState*w,0,(bState+1)*w,h,null);
        			stateChanged(BUTTON_PRESSEDHOVERED);
        		}
            }
            public void mouseExited(MouseEvent e){
            	if (!isEnabled())return;
        		if (bMode==TOGGLEBUTTON){
        			if (bState==BUTTON_PRESSEDHOVERED)
        				bState=BUTTON_PRESSED;
        			else
        				bState=BUTTON_NORMAL;
        		}
        		else{
        			bState=BUTTON_NORMAL;
        		}
        		getGraphics().drawImage(bImage,0,0,w,h,bState*w,0,(bState+1)*w,h,null);
        		//stateChanged(bState);
            }
            public void mouseReleased(MouseEvent e){}
	    });
		
	}
	public void setEnabled(boolean arg0){
		Graphics g=getGraphics();
	    if (arg0){
    	    if (this.isEnabled())return;
   	    	bState=oldBState;
   	    	if (g!=null)
   	    		g.drawImage(bImage,0,0,w,h,bState*w,0,(bState+1)*w,h,null);
	    }
	    else{
    	    if (!this.isEnabled())return;
    	    oldBState=bState;
    	    if (bMode==TOGGLEBUTTON  && bState==BUTTON_PRESSEDHOVERED)
    	    	oldBState=bState;
    	    else{
    	    	oldBState=BUTTON_NORMAL;
    	        bState=BUTTON_DISABLED;
    	    }
    	    
    	    if (g!=null)
    	    	g.drawImage(bImage,0,0,w,h,bState*w,0,(bState+1)*w,h,null);
	    }
	    super.setEnabled(arg0);
	}
	public abstract void stateChanged(int state);


	public void repaint(){
		getGraphics().drawImage(bImage,0,0,w,h,bState*w,0,(bState+1)*w,h,null);
	}
	public void paint(Graphics g){
	    g.drawImage(bImage,0,0,w,h,bState*w,0,(bState+1)*w,h,null);
	}
}

