/*
 * Created on Dec 3, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.farafin.snEADy.communication;

import de.farafin.snEADy.GameParameter;

/**
 * Information about a given player to organize the information exchange between
 * the modules of the game
 *
 * @author roland, lars
 * 
 * @version $Revision: 1.32 $
 */
public final class D_PlayerData implements I_PlayFieldConstants, I_Constants
{
	/** the name of the Player */
	public String name;
	
	/** the name of the picfile*/
	public String picFileName;
	
	/** the game time the object will be updated next time. if its negative, the object
	 * will never be updated */
	public long nextUpdateTime;
	
	/** true if the snake was updated in the playfield */
	public boolean snakeUpdated = false;

	/** if the length changed in the playfield
	 *  1: longer
	 *  0: no change
	 * -1: shorter
	 */
	public int lengthChanged = 0;

	/** if the delay changed in the playfield
	 *  1: slower
	 *  0: no change
	 * -1: faster
	 */
	public int delayChanged = 0;

	/** the freuency with what the gaObject should be updated.
	 * if its negative, the nextUpdateTime never changes */
	public long waitCycles = 1;

	/** Comment for <code>killPoints</code> */
	public int killPoints = 0;

	/** Comment for <code>turnDirection</code> */
	public int turnDirection = 0;
	
	/** when a player has finished his calculation, it will be updated, otherwise not */
	public boolean move = false; 

	/** Comment for <code>watchDirection</code> */
	public int watchDirection = FACE_NORTH;
	
	/** Comment for <code>ownChar</code> */
	public char ownChar = PLAYER_0;
	
	/** Comment for <code>length</code> */
	public int length = 1;
	
	/** Comment for <code>headPos</code> */
	public D_Vec2D headPos = null;
	
	/** Comment for <code>snakeStatus</code> */
	public int snakeStatus = IN_ACTION;
	
	/** Comment for <code>playerClass</code> */
	public Class playerClass = null;

	/** Comment for <code>lastCalculatedMemUsage</code> */
	public long lastCalculatedMemUsage = 0;
//	/** Comment for <code>pic</code> */
//	public D_SnakePic pic = null;
	
	
	
	/** default - constructor */
	public D_PlayerData()
	{
		super();
		name = "";
		picFileName = "";
		nextUpdateTime = 0;
		waitCycles = 1;
		killPoints = 0;
		turnDirection = 0;
		watchDirection = 0;
		ownChar = PLAYER_0;
		length = 1;
		headPos = new D_Vec2D();
		playerClass = null;
		snakeUpdated = false;
		lengthChanged = 0;
		delayChanged = 0;
		lastCalculatedMemUsage = 0;
//		pic = null;
	}
	
	/**
	 * @param name
	 * @param nextupdateTime
	 * @param waitCycles
	 * @param killPoints
	 * @param turnDirection
	 * @param watchDirection
	 * @param ownChar
	 * @param length
	 * @param playerClass
	 */
	public D_PlayerData(String name, String picFileName,  long nextupdateTime, long waitCycles, int killPoints, int turnDirection, int watchDirection, char ownChar, int length, D_Vec2D headPos, Class playerClass/*, D_SnakePic pic*/)
	{
		super();
		this.name = name;
		this.picFileName = picFileName;
		this.nextUpdateTime = nextupdateTime;
		this.waitCycles = waitCycles;
		this.killPoints = killPoints;
		this.turnDirection = turnDirection;
		this.watchDirection = watchDirection;
		this.ownChar = ownChar;
		this.length = length;
		this.headPos = (D_Vec2D)headPos.clone();
		this.playerClass = playerClass;
		this.snakeUpdated = false;
		this.lengthChanged = 0;
		this.delayChanged = 0;
		this.lastCalculatedMemUsage = 0;
		
//		this.pic = pic;
	}
	
	/**
	 * @param playerNo
	 * @param playerClass
	 */
	public D_PlayerData(int playerNo, Class playerClass, GameParameter params)
	{
		this(playerNo, playerClass, playerClass.getName(), params);
	}
	

	/**
	 * @param playerNo
	 * @param playerClass
	 * @param name
	 */
	public D_PlayerData(int playerNo, Class playerClass, String name, GameParameter params)
	{
		super();
		this.name = name;
		this.picFileName = playerClass.getName();
		this.nextUpdateTime = params.getInit_move_delay();
		this.waitCycles = params.getInit_move_delay();
		this.killPoints = 0;
		this.turnDirection = TURN_NONE;
		this.watchDirection = FACE_NORTH;
		this.ownChar = (char)(PLAYER_0 + playerNo);
		this.length = 1;
		this.headPos = new D_Vec2D();
		this.playerClass = playerClass;
		this.snakeUpdated = false;
		this.lengthChanged = 0;
		this.delayChanged = 0;
		this.lastCalculatedMemUsage = 0;
//		this.pic = new D_SnakePic();
	}
	
	/** copy - constructor
	 * reference-copy of attrbutes: use copy() if you need a full copy
	 * @param pData 
	 */
	public D_PlayerData(D_PlayerData pData)
	{
		super();
		this.name = pData.name;
		this.picFileName = pData.picFileName;
		this.nextUpdateTime =  pData.nextUpdateTime;
		this.waitCycles =  pData.waitCycles;
		this.killPoints =  pData.killPoints;
		this.turnDirection =  pData.turnDirection;
		this.watchDirection =  pData.watchDirection;
		this.ownChar = pData.ownChar;
		this.length = pData.length;
		this.snakeStatus = pData.snakeStatus;
		this.headPos = (D_Vec2D)pData.headPos.clone();
		this.playerClass = pData.playerClass;
		this.snakeUpdated = pData.snakeUpdated;
		this.lengthChanged = pData.lengthChanged;
		this.delayChanged = pData.delayChanged;
		this.lastCalculatedMemUsage = pData.lastCalculatedMemUsage;
//		this.pic = pData.pic;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 */
	public Object clone()
	{
		D_PlayerData playerData = new D_PlayerData(this);
//		playerData.pic = (D_SnakePic)this.pic.clone();
		return  playerData;
	}
	

	/** copyes the local data to plData. its no new instance created!
	 * @param plData
	 */
	public void copyOnMe(D_PlayerData plData)
	{
		this.name = plData.name;
		this.picFileName = plData.picFileName;
		this.nextUpdateTime = plData.nextUpdateTime;
		this.waitCycles = plData.waitCycles;
		this.killPoints = plData.killPoints;
		this.turnDirection = plData.turnDirection;
		this.watchDirection =  plData.watchDirection;
		this.ownChar = plData.ownChar;
		this.length = plData.length ;
		this.snakeStatus = plData.snakeStatus;
		this.headPos.copyOnMe(plData.headPos);
		this.playerClass = plData.playerClass;
		this.snakeUpdated = plData.snakeUpdated;
		this.lengthChanged = plData.lengthChanged;
		this.delayChanged = plData.delayChanged;
		this.lastCalculatedMemUsage = plData.lastCalculatedMemUsage;
//		this.pic = (D_SnakePic) plData.pic.clone();  // TODO #roland: ask lars if he still needs this
	}
}
