/*
 * Created on Dec 3, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.farafin.snEADy.communication;

/**
 * Thats the class all modules should use to communicate with each other
 * 
 * @author roland, lars
 * 
 * @version $Revision: 1.24 $
 */
public final class D_GameInfo
{
	/** Field arena */
	public D_Level level = null;

	/** Field playerData */
	public D_PlayerData[] playerData = null;
	
	/** the actual game time */
	public long gameTime = 0;

	/** to make a constant game time, this variable shold be dependent of the loaded player number
	 *  to make a constant thinking time, just fill here the value you like
	 *  the choice should be left by the human player, so its not decided automaticaly. */
	//public long thinkingTime = 1000;
	
	/** The beginning of the suddenDeath phasis  (if 0 than it happends never) */
	public long suddenDeath = 0;

	/** the Time the exit accures (if 0 than it happends never) */
	public long exitTime = 0;
	
	/** wether teh game runs or not */
	public boolean gameRunning = false;
	
	/** default constructor */
	public D_GameInfo()
	{
		super();
		this.level = null;
		this.playerData = new D_PlayerData[0];
		this.gameTime = 0;
		this.exitTime = 0;
		this.suddenDeath = 0;
		this.gameRunning = false;
		//this.thinkingTime = 1;
	}

	/** create constructor
	 * @param level
	 * @param playerData
	 * @param gameTime
	 * @param exitTime
	 * @param sdTime
	 * @param running
	 */
	public D_GameInfo(D_Level level, D_PlayerData[] playerData, long gameTime, long exitTime, long sdTime, boolean running)
	{
		super();
		int i;
		this.exitTime = exitTime;
		this.suddenDeath = sdTime;
		this.level = (D_Level)level.clone();
		for(i = 0; i < playerData.length; i++)
		{
			this.playerData[i] = (D_PlayerData)playerData[i].clone();	
		}
		this.gameTime = gameTime;
		this.exitTime = exitTime;
		this.suddenDeath = sdTime;
		this.gameRunning = running;
		//this.thinkingTime = thinkingTime;
	}

	/** copy constructor
	 * reference-copy of attrbutes: use copy() if you need a full copy
	 * @param gameInfo
	 */
	public D_GameInfo(D_GameInfo gameInfo)
	{
		super();

		this.level = gameInfo.level;
		this.playerData = gameInfo.playerData;
		this.gameTime = gameInfo.gameTime;
		this.exitTime = gameInfo.exitTime;
		this.suddenDeath = gameInfo.suddenDeath;
		this.gameRunning = gameInfo.gameRunning;
		//this.thinkingTime = gameInfo.thinkingTime;
	}
	
	/** copys all data to the lokal instance. there is no new Instance created if
	 * all array sizes fit to each other 
	 * @param gameInfo
	 */
	public void copyOnMe(D_GameInfo gameInfo)
	{
		this.gameTime = gameInfo.gameTime;
		this.exitTime = gameInfo.exitTime;
		this.suddenDeath = gameInfo.suddenDeath;
		this.gameRunning = gameInfo.gameRunning;
		if(gameInfo.level != null)
		{
			if(this.level == null) this.level = new D_Level(); 
			this.level.copyOnMe(gameInfo.level);
		}
		else
		{
		    this.level = null;
		}
		
		if(this.playerData == null || this.playerData.length != gameInfo.playerData.length)
		{
			this.playerData = new D_PlayerData[gameInfo.playerData.length];
			for(int i = 0; i < this.playerData.length; i++)
			{
				this.playerData[i] = new D_PlayerData(gameInfo.playerData[i]);
			}
		}
		else
		{
			for(int i = 0; i < this.playerData.length; i++)
			{
				this.playerData[i].copyOnMe(gameInfo.playerData[i]);
			}
		}
		
		//this.thinkingTime = gameInfo.thinkingTime;
	}
	
	/**
	 * @param playerData is added to the current array. its only a reference copy!
	 */
	public void addPlayerData(D_PlayerData playerData)
	{
		D_PlayerData[] tmpPData = this.playerData;
		this.playerData = new D_PlayerData[this.playerData.length + 1];
		for(int i = 0; i < tmpPData.length; i++)
		{
			this.playerData[i] = tmpPData[i];
		}
		this.playerData[this.playerData.length-1] = playerData;
	}
	
	
	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 */
	public Object clone()
	{
		int i;
		
		D_GameInfo gameInfo = new D_GameInfo();
		gameInfo.level = (D_Level)this.level.clone();
		gameInfo.playerData = new D_PlayerData[this.playerData.length];
		for(i = 0; i < gameInfo.playerData.length; i++)
		{
			gameInfo.playerData[i] = (D_PlayerData)this.playerData[i].clone();	
		}
		gameInfo.gameTime = this.gameTime;
		gameInfo.exitTime = this.exitTime;
		gameInfo.suddenDeath = this.suddenDeath;
		//this.thinkingTime = gameInfo.thinkingTime;
		return gameInfo;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		// TODO Auto-generated method stub
		return super.toString();
	}
}
