/*
 * Created on 22.11.2004
 * 
 */ 
package de.farafin.snEADy;

import de.farafin.snEADy.communication.D_Level;



/**
 * @author roland, lars
 * 
 *  @version $Revision: 1.13 $ 
 */
public interface I_Main_interface
{ 	
	/** is called from the control-Interface to interact with the Main-Engine.
	 * @param command the command that should be computed
	 * @return if the command was succassfully computed
	 */
	public boolean control(String command);


	/**
	 * @param playerName the class of which the comment should be red from
	 * @return the comment
	 * 
	 * @see de.farafin.snEADy.player.Player#comment
	 */
	public String getPlayerComment(String playerName);
	

	/** loads a level without the playfield
	 * @param levelName the name of the level that should be loaded
	 * @return the loaded level, but without the playfield
	 * 
	 * @see de.farafin.snEADy.inOut.C_LevelLoader
	 */
	public D_Level getLevelHeader(String levelName);
}