/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.world;

import de.farafin.snEADy.GameParameter;
import de.farafin.snEADy.communication.D_GameInfo;
import de.farafin.snEADy.communication.D_Level;
import de.farafin.snEADy.communication.D_Vec2D;
import de.farafin.snEADy.communication.I_Constants;
import de.farafin.snEADy.communication.I_PlayFieldConstants;
import de.farafin.snEADy.world.C_Arena;
import de.farafin.snEADy.world.C_GLength;
import de.farafin.snEADy.world.C_GPoints;
import de.farafin.snEADy.world.C_GSpeed;
import de.farafin.snEADy.world.C_GameObject;
import de.farafin.snEADy.world.C_Goody;
import de.farafin.snEADy.world.I_World_interface;
import java.util.Random;

public final class C_World
implements I_World_interface,
I_Constants,
I_PlayFieldConstants {
    private final C_Arena arena;
    private long nextGoodyTime = 0L;
    private Random randNextGoodyTime;
    private Random randGoody;
    private final GameParameter parameter;
    private long lastSDTime = 0L;

    public C_World(D_GameInfo gameInfo, GameParameter parameter) {
        this.parameter = parameter;
        this.arena = new C_Arena(gameInfo, parameter);
        this.randNextGoodyTime = new Random();
        this.randGoody = new Random((long)((double)System.currentTimeMillis() * this.randNextGoodyTime.nextDouble()));
        this.nextGoodyTime = gameInfo.gameTime + (long)this.randNextGoodyTime.nextInt(parameter.getMax_goody_occ_delay());
    }

    private void placeGoody(D_GameInfo gameInfo) {
        D_Vec2D vec = new D_Vec2D();
        int trys = 0;
        int radnomNumber = 0;
        int i = 0;
        C_Goody goody = null;
        do {
            vec.y = this.randGoody.nextInt(this.arena.getHeight());
            vec.x = this.randGoody.nextInt(this.arena.getWidth());
        } while (!this.arena.isFree(vec) && ++trys < 100);
        radnomNumber = this.randGoody.nextInt(this.parameter.getGoody_speed_occ() + this.parameter.getGoody_slowdown_occ() + this.parameter.getGoody_length_occ() + this.parameter.getGoody_points_occ() + this.parameter.getGoody_shorter_occ());
        int range = 0;
        i = 0;
        while (i < 1) {
            if (radnomNumber < (range += this.parameter.getGoody_speed_occ())) {
                goody = new C_GSpeed(vec, -1, this.parameter);
                break;
            }
            if (radnomNumber < (range += this.parameter.getGoody_slowdown_occ())) {
                goody = new C_GSpeed(vec, 1, this.parameter);
                break;
            }
            if (radnomNumber < (range += this.parameter.getGoody_length_occ())) {
                goody = new C_GLength(vec, this.parameter.getGoody_length_value(), this.parameter);
                break;
            }
            if (radnomNumber < (range += this.parameter.getGoody_points_occ())) {
                goody = new C_GPoints(vec, this.parameter.getGoody_points_value(), this.parameter);
                break;
            }
            if (radnomNumber < (range += this.parameter.getGoody_shorter_occ())) {
                goody = new C_GLength(vec, -this.parameter.getGoody_shorter_value(), this.parameter);
                break;
            }
            ++i;
        }
        this.arena.objectAdd(goody);
        this.nextGoodyTime = gameInfo.gameTime + (long)this.randNextGoodyTime.nextInt(this.parameter.getMax_goody_occ_delay());
    }

    public void update(D_GameInfo gameInfo) {
        D_Vec2D vec = null;
        int trys = 0;
        int i = 0;
        while (i < this.arena.getNumberOfObjects()) {
            C_GameObject gObj = this.arena.getGameObject(i);
            if (gObj.getNextUpdateTime() >= 0L && gObj.getNextUpdateTime() <= gameInfo.gameTime) {
                this.arena.objectUpdate(gObj);
            }
            ++i;
        }
        if (this.parameter.getGameTime() < this.parameter.getSuddend_time() && this.nextGoodyTime <= gameInfo.gameTime) {
            this.placeGoody(gameInfo);
        }
        if (gameInfo.gameTime >= gameInfo.suddenDeath && gameInfo.gameTime > this.lastSDTime) {
            gameInfo.getClass();
            gameInfo.getClass();
            this.lastSDTime = gameInfo.gameTime;
            vec = new D_Vec2D();
            trys = 0;
            do {
                vec.y = this.randGoody.nextInt(this.arena.getHeight());
                vec.x = this.randGoody.nextInt(this.arena.getWidth());
            } while (!this.arena.isFree(vec) && ++trys <= 100);
            if (trys < 100) {
                this.arena.objectAdd(new C_GLength(vec, -this.parameter.getGoody_shorter_value(), this.parameter));
            }
        }
        this.updateInfos(gameInfo);
    }

    public D_Level generateLevel() {
        return this.arena.generateLevel();
    }

    public void updateInfos(D_GameInfo gameInfo) {
        this.arena.updateLevel(gameInfo.level);
    }
}

