/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.world;

import de.farafin.snEADy.GameParameter;
import de.farafin.snEADy.communication.D_PlayerData;
import de.farafin.snEADy.communication.D_Vec2D;
import de.farafin.snEADy.communication.I_Constants;
import de.farafin.snEADy.communication.RingVector;
import de.farafin.snEADy.world.C_Arena;
import de.farafin.snEADy.world.C_GPoints;
import de.farafin.snEADy.world.C_GameObject;
import de.farafin.snEADy.world.C_Goody;
import java.util.Random;

public final class C_Snake
extends C_GameObject
implements I_Constants {
    protected int status = 0;
    protected int length = 1;
    protected float lengthRateStatus = 0.0f;
    protected long nextAutoGrow;
    protected long nextAutoSlow;
    protected D_PlayerData pilot;
    private int pilotLength = 0;
    private long pilotDelay = 0L;
    protected int survivalBonus = 0;

    protected C_Snake() {
        this.status = 0;
        this.length = 1;
        this.pilot = null;
        this.nextAutoGrow = this.parameter.getAuto_grow_delay();
        this.nextAutoSlow = this.parameter.getAuto_slowdown_delay();
        this.survivalBonus = 0;
    }

    protected C_Snake(D_Vec2D headPosition, int faceDirection, RingVector objPositions, char ownChar, int status, int length, D_PlayerData pilot, long waitCycles, GameParameter parameter) {
        super(headPosition, faceDirection, objPositions, ownChar, waitCycles, parameter);
        this.status = status;
        this.length = length;
        this.pilot = pilot;
        this.nextAutoGrow = parameter.getAuto_grow_delay();
        this.nextAutoSlow = parameter.getAuto_slowdown_delay();
        this.survivalBonus = 0;
    }

    protected C_Snake(D_Vec2D headPosition, int faceDirection, char ownChar, int length, D_PlayerData pilot, long waitCycles, GameParameter parameter) {
        super(headPosition, faceDirection, ownChar, waitCycles, parameter);
        this.status = 0;
        this.length = length;
        this.pilot = pilot;
        this.nextAutoGrow = parameter.getAuto_grow_delay();
        this.nextAutoSlow = parameter.getAuto_slowdown_delay();
        this.survivalBonus = 0;
    }

    protected C_Snake(D_Vec2D headPosition, int faceDirection, char ownChar, D_PlayerData pilot, long waitCycles, GameParameter parameter) {
        super(headPosition, faceDirection, ownChar, waitCycles, parameter);
        this.status = 0;
        this.length = 1;
        this.pilot = pilot;
        this.nextAutoGrow = parameter.getAuto_grow_delay();
        this.nextAutoSlow = parameter.getAuto_slowdown_delay();
        this.survivalBonus = 0;
    }

    protected C_Snake(D_Vec2D headPosition, int faceDirection, RingVector objPositions, char ownChar, int length, D_PlayerData pilot, long waitCycles, GameParameter parameter) {
        super(headPosition, faceDirection, objPositions, ownChar, waitCycles, parameter);
        this.status = 0;
        this.length = length;
        this.pilot = pilot;
        this.nextAutoGrow = parameter.getAuto_grow_delay();
        this.nextAutoSlow = parameter.getAuto_slowdown_delay();
        this.survivalBonus = 0;
    }

    protected C_Snake(D_PlayerData playerData, GameParameter parameter) {
        super(playerData.headPos, playerData.turnDirection, playerData.ownChar, playerData.waitCycles, parameter);
        this.status = 0;
        this.length = parameter.getInit_length();
        this.pilot = playerData;
        this.nextAutoGrow = parameter.getAuto_grow_delay();
        this.nextAutoSlow = parameter.getAuto_slowdown_delay();
        this.survivalBonus = 0;
    }

    private void computeKillPoints(C_Arena arena, C_Snake snake, boolean died) {
        int k;
        char c = '.';
        int snakeCounter = 0;
        boolean snakeUnknown = true;
        C_Snake[] snakes = new C_Snake[10];
        int[] snakesDist = new int[10];
        int distConst = 0;
        distConst = died ? this.parameter.getKill_points_radius() : this.parameter.getDamage_points_radius();
        D_Vec2D[] vecArray = arena.getSourounding(this.headPosition, distConst);
        int i = 0;
        while (i < vecArray.length) {
            c = arena.getCharOf(vecArray[i]);
            if (arena.isSnake(c) && c != this.ownChar) {
                snakeUnknown = true;
                k = 0;
                while (k < snakeCounter) {
                    if (snakes[k].ownChar == c) {
                        snakeUnknown = false;
                        if (this.headPosition.dist(vecArray[i]) < snakesDist[k]) {
                            snakesDist[k] = this.headPosition.dist(vecArray[i]);
                        }
                    }
                    ++k;
                }
                if (snakeUnknown) {
                    snakes[snakeCounter] = (C_Snake)arena.getGOofPos(vecArray[i]);
                    snakesDist[snakeCounter] = this.headPosition.dist(vecArray[i]);
                    ++snakeCounter;
                }
            }
            ++i;
        }
        k = 0;
        while (k < snakeCounter) {
            snakes[k].pilot.killPoints += 1 << distConst - snakesDist[k];
            ++k;
        }
        if (snake == null) {
            return;
        }
        if (this.ownChar != snake.ownChar) {
            if (!died) {
                snake.lengthRateStatus += this.parameter.getDamage_length_grow();
            }
            snake.pilot.killPoints += 1 << distConst - 1;
        } else if (this.parameter.getEasy_points() > 0) {
            snakeCounter = 0;
            snakes = new C_Snake[10];
            int j = 0;
            while (j < this.objPositions.size()) {
                vecArray = arena.getSourounding((D_Vec2D)this.objPositions.getElementAt(j), 1);
                i = 0;
                while (i < vecArray.length) {
                    c = arena.getCharOf(vecArray[i]);
                    if (arena.isSnake(c) && c != this.ownChar) {
                        snakeUnknown = true;
                        k = 0;
                        while (k < snakeCounter) {
                            if (snakes[k].ownChar == c) {
                                snakeUnknown = false;
                            }
                            ++k;
                        }
                        if (snakeUnknown) {
                            snakes[snakeCounter] = (C_Snake)arena.getGOofPos(vecArray[i]);
                            ++snakeCounter;
                        }
                    }
                    ++i;
                }
                ++j;
            }
            i = 0;
            while (i < snakeCounter) {
                snakes[i].pilot.killPoints += this.parameter.getEasy_points();
                ++i;
            }
        }
    }

    private D_Vec2D removeLastSegments(C_Arena arena, int n) {
        int i = 0;
        D_Vec2D vec = null;
        i = 0;
        while (i < n) {
            if (this.objPositions.size() <= 1) {
                return vec;
            }
            vec = (D_Vec2D)this.objPositions.remLast();
            arena.setFree(vec);
            --this.length;
            ++i;
        }
        return vec;
    }

    private void actualizateSnakeLength(C_Arena arena, D_Vec2D lastPos) {
        if (this.length > this.objPositions.size()) {
            this.objPositions.addLast(lastPos.clone());
            arena.setCharOnPosition(lastPos, this.ownChar);
        } else if (this.length < this.objPositions.size()) {
            arena.setFree((D_Vec2D)this.objPositions.remLast());
        }
    }

    private void die(C_Arena arena, C_Snake killer) {
        int i = 0;
        int trys = 0;
        D_Vec2D vec = new D_Vec2D();
        this.computeKillPoints(arena, killer, true);
        System.out.println("DIE");
        while (this.objPositions.size() > 0) {
            arena.setFree((D_Vec2D)this.objPositions.remFirst());
        }
        this.objPositions.clear();
        this.length = 0;
        if (this.pilot.snakeStatus == 0) {
            this.status = 1;
            this.pilot.snakeStatus = 1;
        }
        Random randGoody = new Random();
        i = 0;
        while (i < this.parameter.getKill_point_goodies()) {
            trys = 0;
            do {
                vec.y = (this.headPosition.y + randGoody.nextInt(2 * this.parameter.getKill_points_radius() + 1) - this.parameter.getKill_points_radius() + arena.getHeight()) % arena.getHeight();
                vec.x = (this.headPosition.x + randGoody.nextInt(2 * this.parameter.getKill_points_radius() + 1) - this.parameter.getKill_points_radius() + arena.getWidth()) % arena.getWidth();
            } while (!arena.isFree(vec) && ++trys <= 50);
            if (trys < 50) {
                arena.objectAdd(new C_GPoints(vec, this.parameter.getGoody_points_value(), this.parameter));
            }
            ++i;
        }
    }

    protected void moveToFace(C_Arena arena) {
        D_Vec2D lastPos = null;
        D_Vec2D nextPos = this.getNextPosInFaceDirection(arena);
        C_Snake snake = null;
        C_GameObject obj = null;
        char nextChar = arena.getCharOf(nextPos);
        if (this.status == 2) {
            lastPos = this.removeLastSegments(arena, 1);
            this.turnHeadBack();
            if (this.objPositions.size() <= 1) {
                while (this.objPositions.size() > 0) {
                    arena.setFree((D_Vec2D)this.objPositions.remFirst());
                }
                this.objPositions.clear();
                this.length = 0;
            }
            return;
        }
        if (arena.isFree(nextChar)) {
            lastPos = (D_Vec2D)((D_Vec2D)this.objPositions.moveLastToFirst()).clone();
            this.headPosition.copyOnMe(nextPos);
            ((D_Vec2D)this.objPositions.getFirst()).copyOnMe(nextPos);
            arena.setFree(lastPos);
            arena.setCharOnPosition(nextPos, this.ownChar);
        } else if (arena.isGoody(nextChar)) {
            C_Goody goody = (C_Goody)arena.getGOofPos(nextPos);
            lastPos = (D_Vec2D)((D_Vec2D)this.objPositions.moveLastToFirst()).clone();
            this.headPosition.copyOnMe(nextPos);
            ((D_Vec2D)this.objPositions.getFirst()).copyOnMe(nextPos);
            arena.setFree(lastPos);
            arena.setCharOnPosition(nextPos, this.ownChar);
            goody.wasEaten(this, arena);
        } else if (arena.isSpecialField(nextChar)) {
            switch (nextChar) {
                case 'A': {
                    if (this.parameter.getExit_time() <= this.parameter.getGameTime()) {
                        this.status = 2;
                        this.nextAutoSlow = this.parameter.getGameTime() + (long)(10 * this.length);
                        this.nextAutoGrow = this.parameter.getGameTime() + (long)(10 * this.length);
                        this.length = 0;
                        this.waitCycles = 1L;
                        this.nextUpdateTime = this.parameter.getGameTime() + 1L;
                        int i = 0;
                        while (i < arena.getNumberOfObjects()) {
                            obj = arena.getGameObject(i);
                            if (arena.isSnake(obj.ownChar)) {
                                ((C_Snake)obj).survivalBonus += this.parameter.getSurvival_points();
                            }
                            ++i;
                        }
                        this.pilot.killPoints += this.survivalBonus;
                        lastPos = this.removeLastSegments(arena, 1);
                        this.turnHeadBack();
                        return;
                    }
                    lastPos = this.removeLastSegments(arena, 1);
                    this.turnHeadBack();
                    this.computeKillPoints(arena, null, false);
                    break;
                }
                default: {
                    lastPos = (D_Vec2D)((D_Vec2D)this.objPositions.moveLastToFirst()).clone();
                    this.headPosition.copyOnMe(nextPos);
                    ((D_Vec2D)this.objPositions.getFirst()).copyOnMe(nextPos);
                    arena.setFree(lastPos);
                    arena.setCharOnPosition(nextPos, this.ownChar);
                    break;
                }
            }
        } else if (arena.isSnake(nextChar)) {
            snake = (C_Snake)arena.getGOofPos(nextPos);
            lastPos = this.removeLastSegments(arena, 2);
            this.turnHeadBack();
            this.computeKillPoints(arena, snake, false);
        } else if (arena.isWall(nextChar)) {
            lastPos = this.removeLastSegments(arena, 1);
            this.turnHeadBack();
            this.computeKillPoints(arena, null, false);
        } else {
            return;
        }
        this.actualizateSnakeLength(arena, lastPos);
        if (this.objPositions.size() <= 1) {
            if (arena.isSnake(nextChar)) {
                snake = (C_Snake)arena.getGOofPos(nextPos);
                if (snake.ownChar == this.ownChar) {
                    snake = null;
                }
            } else {
                snake = null;
            }
            this.die(arena, snake);
        }
    }

    private void updateLengthState() {
        if (this.lengthRateStatus >= 1.0f) {
            this.length += (int)this.lengthRateStatus;
            this.lengthRateStatus -= (float)((int)this.lengthRateStatus);
        }
        if (this.parameter.getGameTime() >= this.nextAutoGrow) {
            this.nextAutoGrow = this.parameter.getGameTime() + (long)this.parameter.getAuto_grow_delay();
            ++this.length;
        }
    }

    private void updateSpeedState() {
        if (this.parameter.getGameTime() >= this.nextAutoSlow) {
            this.nextAutoSlow = this.parameter.getGameTime() + (long)this.parameter.getAuto_slowdown_delay();
            ++this.waitCycles;
        }
        if (this.parameter.getMax_move_delay() <= this.waitCycles) {
            this.waitCycles = this.parameter.getMax_move_delay();
        }
        this.pilot.waitCycles = this.waitCycles;
    }

    protected void updatePilot() {
        this.pilot.nextUpdateTime = this.nextUpdateTime + this.waitCycles;
        this.pilot.waitCycles = this.waitCycles;
        this.pilot.length = this.objPositions.size();
        this.pilot.headPos.copyOnMe(this.headPosition);
        this.pilot.watchDirection = this.faceDirection;
        this.pilot.snakeStatus = this.status;
        this.pilot.turnDirection = 0;
    }

    private void turnHead(C_Arena arena) {
        int tmp = 0;
        if (this.isBlocked(this.getCharDirHead(arena, this.pilot.turnDirection))) {
            this.pilot.turnDirection = 0;
        }
        this.faceDirection = (tmp = this.faceDirection + this.pilot.turnDirection) < 0 ? 3 : (tmp > 3 ? 0 : tmp);
    }

    private void turnHeadBack() {
        int tmp = this.faceDirection - this.pilot.turnDirection;
        this.faceDirection = tmp < 0 ? 3 : (tmp > 3 ? 0 : tmp);
    }

    protected void update(C_Arena arena) {
        if (this.pilot.snakeStatus == 2 && this.objPositions.size() > 0) {
            this.pilot.move = true;
        }
        if (this.pilot.snakeStatus > 2) {
            if (this.status <= 2) {
                this.status = this.pilot.snakeStatus;
                this.die(arena, null);
            }
            return;
        }
        if (!this.pilot.move) {
            this.pilot.snakeUpdated = false;
            return;
        }
        this.pilot.move = false;
        this.pilot.snakeUpdated = true;
        this.pilotLength = this.pilot.length;
        this.pilotDelay = this.pilot.waitCycles;
        switch (this.status) {
            case 0: {
                this.updateLengthState();
                this.updateSpeedState();
                this.turnHead(arena);
                this.moveToFace(arena);
                this.updatePilot();
                break;
            }
            case 1: {
                this.updatePilot();
                break;
            }
            case 2: {
                this.moveToFace(arena);
                this.updatePilot();
            }
        }
        if (this.waitCycles > 0L) {
            this.nextUpdateTime += this.waitCycles;
        }
        this.pilot.lengthChanged = this.pilotLength < this.pilot.length ? 1 : (this.pilotLength > this.pilot.length ? -1 : 0);
        this.pilot.delayChanged = this.pilotDelay < this.pilot.waitCycles ? 1 : (this.pilotDelay > this.pilot.waitCycles ? -1 : 0);
        this.pilot.snakeUpdated = true;
    }

    private char getCharDirHead(C_Arena arena, int direction) {
        int dir = this.faceDirection + direction;
        int height = arena.getHeight();
        int width = arena.getWidth();
        int y = 0;
        int x = 0;
        if (dir < 0) {
            dir = 3;
        } else if (dir > 3) {
            dir = 0;
        }
        switch (dir) {
            case 0: {
                y = (this.headPosition.y - 1 + height) % height;
                x = this.headPosition.x;
                break;
            }
            case 1: {
                y = this.headPosition.y;
                x = (this.headPosition.x + 1) % width;
                break;
            }
            case 2: {
                y = (this.headPosition.y + 1) % height;
                x = this.headPosition.x;
                break;
            }
            case 3: {
                y = this.headPosition.y;
                x = (this.headPosition.x - 1 + width) % width;
            }
        }
        return arena.getCharOf(y, x);
    }

    private boolean isBlocked(char c) {
        if (c == '#') {
            return true;
        }
        if ('0' <= c && c <= '9') {
            return true;
        }
        return c == 'A' && this.parameter.getGameTime() < this.parameter.getExit_time();
    }

    protected void jumpTo(D_Vec2D pos, C_Arena arena) {
    }

    protected D_Vec2D[] getAllPosSorted(int sort) {
        return (D_Vec2D[])this.objPositions.toArray();
    }

    protected Object clone() {
        C_Snake snake = new C_Snake();
        snake.faceDirection = this.faceDirection;
        snake.headPosition = (D_Vec2D)this.headPosition.clone();
        snake.length = this.length;
        snake.nextUpdateTime = this.nextUpdateTime;
        snake.objPositions = (RingVector)this.objPositions.clone();
        snake.ownChar = this.ownChar;
        snake.pilot = this.pilot;
        snake.status = this.status;
        snake.waitCycles = this.waitCycles;
        return snake;
    }

    public String toString() {
        String result = "Snake:\n";
        result = String.valueOf(result) + "\tHead: " + this.headPosition.toString() + "\n";
        result = String.valueOf(result) + "\tFace: " + (this.faceDirection <= 1 ? (this.faceDirection < 1 ? "UP" : "RIGHT") : (this.faceDirection < 3 ? "DOWN" : "LEFT")) + "\n";
        result = String.valueOf(result) + "\tLength: " + this.length + "\n";
        result = String.valueOf(result) + "\tChar: " + this.ownChar + "\n";
        result = String.valueOf(result) + "\tStatus: " + this.status + "\n";
        result = String.valueOf(result) + "\tPositions: \t";
        int i = 0;
        while (i < this.objPositions.size()) {
            result = String.valueOf(result) + " " + ((D_Vec2D)this.objPositions.getElementAt(i)).toString();
            ++i;
        }
        return result;
    }

    protected D_PlayerData getPilot() {
        return this.pilot;
    }
}

