/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.world;

import de.farafin.snEADy.GameParameter;
import de.farafin.snEADy.communication.D_GameInfo;
import de.farafin.snEADy.communication.D_Level;
import de.farafin.snEADy.communication.D_Vec2D;
import de.farafin.snEADy.communication.I_Constants;
import de.farafin.snEADy.communication.I_PlayFieldConstants;
import de.farafin.snEADy.world.C_GLength;
import de.farafin.snEADy.world.C_GPoints;
import de.farafin.snEADy.world.C_GSpeed;
import de.farafin.snEADy.world.C_GameObject;
import de.farafin.snEADy.world.C_Goody;
import de.farafin.snEADy.world.C_Snake;
import java.util.Iterator;
import java.util.Vector;

public final class C_Arena
implements I_Constants,
I_PlayFieldConstants {
    private final String name;
    private final int height;
    private final int width;
    private final char[][] playField;
    private final int maxPlayer;
    private final GameParameter parameter;
    private final Vector gameObjects;

    protected C_Arena(String name, int height, int width, char[][] playField, int maxPlayer, GameParameter parameter) {
        int i = 0;
        this.name = name;
        this.height = height;
        this.width = width;
        this.playField = new char[height][width];
        i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                this.playField[i][j] = playField[i][j];
                ++j;
            }
            ++i;
        }
        this.maxPlayer = maxPlayer;
        this.gameObjects = new Vector();
        this.parameter = parameter;
    }

    protected C_Arena(String name, char[][] playField, int maxPlayer, GameParameter parameter) {
        int i = 0;
        this.name = name;
        this.height = playField.length;
        this.width = playField[0].length;
        this.playField = new char[this.height][this.width];
        i = 0;
        while (i < this.height) {
            int j = 0;
            while (j < this.width) {
                this.playField[i][j] = playField[i][j];
                ++j;
            }
            ++i;
        }
        this.maxPlayer = maxPlayer;
        this.gameObjects = new Vector();
        this.parameter = parameter;
    }

    protected C_Arena(D_GameInfo gameInfo, GameParameter parameter) {
        this(gameInfo.level.name, gameInfo.level.height, gameInfo.level.width, gameInfo.level.playField, gameInfo.level.maxPlayer, parameter);
        int i = 0;
        int j = 0;
        C_Goody gObj = null;
        i = 0;
        while (i < this.height) {
            j = 0;
            while (j < this.width) {
                if (this.isSnake(i, j)) {
                    this.setFree(i, j);
                }
                if (this.isGoody(i, j)) {
                    gObj = null;
                    switch (this.playField[i][j]) {
                        case 'b': {
                            gObj = new C_GSpeed(new D_Vec2D(i, j), -1, parameter);
                            break;
                        }
                        case 'a': {
                            gObj = new C_GLength(new D_Vec2D(i, j), parameter.getGoody_length_value(), parameter);
                            break;
                        }
                        case 'c': {
                            gObj = new C_GPoints(new D_Vec2D(i, j), parameter.getGoody_points_value(), parameter);
                            break;
                        }
                        case 'd': {
                            gObj = new C_GSpeed(new D_Vec2D(i, j), 1, parameter);
                            break;
                        }
                        case 'e': {
                            gObj = new C_GLength(new D_Vec2D(i, j), -parameter.getGoody_shorter_value(), parameter);
                            break;
                        }
                        default: {
                            gObj = null;
                        }
                    }
                    if (gObj != null) {
                        this.objectAdd(gObj);
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < gameInfo.playerData.length) {
            if (gameInfo.playerData[i].snakeStatus == 0) {
                this.objectAdd(new C_Snake(gameInfo.playerData[i], parameter));
            }
            ++i;
        }
    }

    protected C_GameObject getGOofPos(int y, int x) {
        return this.getGOofPos(new D_Vec2D(y, x));
    }

    protected C_GameObject getGOofPos(D_Vec2D vec) {
        C_GameObject gObj = null;
        D_Vec2D curPos = null;
        char c = this.getCharOf(vec);
        Iterator iter1 = null;
        int i = 0;
        if (this.isFree(c) || this.isWall(c)) {
            return null;
        }
        iter1 = this.gameObjects.iterator();
        while (iter1.hasNext()) {
            gObj = (C_GameObject)iter1.next();
            if (c != gObj.ownChar) continue;
            i = 0;
            while (i < gObj.objPositions.size()) {
                curPos = (D_Vec2D)gObj.objPositions.getElementAt(i);
                if (curPos.equals(vec)) {
                    return gObj;
                }
                ++i;
            }
        }
        return null;
    }

    public String toString() {
        String result = null;
        result = "Name: " + this.name + "\n";
        result = String.valueOf(result) + "Size: " + this.width + "x" + this.height + "\n";
        result = String.valueOf(result) + "MaxPlayer: " + this.maxPlayer + "\n";
        result = String.valueOf(result) + "PlayField:\n";
        int i = 0;
        while (i < this.height) {
            result = String.valueOf(result) + String.valueOf(this.playField[i]) + "\n";
            ++i;
        }
        result = String.valueOf(result) + "GameObjects: \n";
        i = 0;
        while (i < this.gameObjects.size()) {
            result = String.valueOf(result) + "\t" + i + ": " + ((C_GameObject)this.gameObjects.get(i)).toString() + "\n";
            ++i;
        }
        return result;
    }

    protected boolean setPlayField(char[][] field) {
        if (field == null) {
            return false;
        }
        if (field.length == 0) {
            return false;
        }
        if (field.length != this.height || field[0].length != this.width) {
            return false;
        }
        int i = 0;
        while (i < this.playField.length) {
            int j = 0;
            while (j < this.playField[0].length) {
                this.playField[i][j] = field[i][j];
                ++j;
            }
            ++i;
        }
        return true;
    }

    protected boolean setCharOnPosition(int y, int x, char c) {
        if (y < 0 || this.height < y || x < 0 || this.width < x) {
            return false;
        }
        this.playField[y][x] = c;
        return true;
    }

    protected boolean setCharOnPosition(D_Vec2D vec, char c) {
        return this.setCharOnPosition(vec.y, vec.x, c);
    }

    protected boolean setFree(int y, int x) {
        return this.setCharOnPosition(y, x, '.');
    }

    protected boolean setFree(D_Vec2D vec) {
        return this.setCharOnPosition(vec.y, vec.x, '.');
    }

    protected void objectAdd(C_GameObject gameObj) {
        this.gameObjects.add(gameObj);
        D_Vec2D[] posArray = gameObj.getAllPosArray();
        int i = 0;
        while (i < posArray.length) {
            this.setCharOnPosition(posArray[i], gameObj.getOwnChar());
            ++i;
        }
    }

    protected boolean objectDel(C_GameObject gameObj) {
        return this.gameObjects.remove(gameObj);
    }

    protected C_GameObject objectDel(int index) {
        return (C_GameObject)this.gameObjects.remove(index);
    }

    protected void objectUpdate(C_GameObject gameObj) {
        gameObj.update(this);
    }

    protected C_GameObject getGameObject(int number) {
        return (C_GameObject)this.gameObjects.get(number);
    }

    protected int getNumberOfObjects() {
        return this.gameObjects.size();
    }

    protected boolean isFieldOfArena(int y, int x) {
        return y >= 0 && this.height > y && x >= 0 && this.width > x;
    }

    protected boolean isFieldOfArena(D_Vec2D vec) {
        return this.isFieldOfArena(vec.y, vec.x);
    }

    protected char[][] getPlayFieldCopy() {
        char[][] pField = new char[this.playField.length][];
        int i = 0;
        while (i < pField.length) {
            pField[i] = new char[this.playField[i].length];
            ++i;
        }
        i = 0;
        while (i < pField.length) {
            int j = 0;
            while (j < pField[i].length) {
                pField[i][j] = this.playField[i][j];
                ++j;
            }
            ++i;
        }
        return pField;
    }

    protected char getCharOf(int y, int x) {
        if (!this.isFieldOfArena(y, x)) {
            return '?';
        }
        return this.playField[y][x];
    }

    protected char getCharOf(D_Vec2D vec) {
        return this.getCharOf(vec.y, vec.x);
    }

    protected char[] getLineCopy(int l) {
        char[] line = new char[this.height];
        if (l < 0 || l > this.height - 1) {
            return null;
        }
        int i = 0;
        while (i < this.height) {
            line[i] = this.playField[l][i];
            ++i;
        }
        return line;
    }

    protected char[] getRowCopy(int r) {
        char[] row = new char[this.width];
        if (r < 0 || r > this.width - 1) {
            return null;
        }
        int i = 0;
        while (i < this.width) {
            row[i] = this.playField[i][r];
            ++i;
        }
        return row;
    }

    protected int getHeight() {
        return this.height;
    }

    protected int getMaxPlayer() {
        return this.maxPlayer;
    }

    protected String getName() {
        return this.name;
    }

    protected int getWidth() {
        return this.width;
    }

    protected boolean isFree(char c) {
        return c == '.';
    }

    protected boolean isWall(char c) {
        return c == '#';
    }

    protected boolean isSnake(char c) {
        return c >= '0' && c <= '9';
    }

    protected boolean isGoody(char c) {
        return c >= 'a' && c <= 'z';
    }

    protected boolean isSpecialField(char c) {
        return c >= 'A' && c <= 'Z';
    }

    protected boolean isFree(int y, int x) {
        if (!this.isFieldOfArena(y, x)) {
            return false;
        }
        return this.playField[y][x] == '.';
    }

    protected boolean isWall(int y, int x) {
        if (!this.isFieldOfArena(y, x)) {
            return false;
        }
        return this.playField[y][x] == '#';
    }

    protected boolean isSnake(int y, int x) {
        if (!this.isFieldOfArena(y, x)) {
            return false;
        }
        return this.playField[y][x] >= '0' && this.playField[y][x] <= '9';
    }

    protected boolean isGoody(int y, int x) {
        if (!this.isFieldOfArena(y, x)) {
            return false;
        }
        return this.playField[y][x] >= 'a' && this.playField[y][x] <= 'z';
    }

    protected boolean isSpecialField(int y, int x) {
        if (!this.isFieldOfArena(y, x)) {
            return false;
        }
        return this.playField[y][x] >= 'A' && this.playField[y][x] <= 'Z';
    }

    protected boolean isFree(D_Vec2D vec) {
        return this.isFree(vec.y, vec.x);
    }

    protected boolean isWall(D_Vec2D vec) {
        return this.isWall(vec.y, vec.x);
    }

    protected boolean isSnake(D_Vec2D vec) {
        return this.isSnake(vec.y, vec.x);
    }

    protected boolean isGoody(D_Vec2D vec) {
        return this.isGoody(vec.y, vec.x);
    }

    protected boolean isSpecialField(D_Vec2D vec) {
        return this.isSpecialField(vec.y, vec.x);
    }

    protected D_Level generateLevel() {
        return new D_Level(this.name, this.height, this.width, this.getPlayFieldCopy(), this.maxPlayer);
    }

    protected boolean updateLevel(D_Level level) {
        if (level.height != this.height || level.width != this.width) {
            return false;
        }
        int i = 0;
        while (i < level.height) {
            int j = 0;
            while (j < level.width) {
                level.playField[i][j] = this.playField[i][j];
                ++j;
            }
            ++i;
        }
        return true;
    }

    private int fy(int i, int k) {
        if (i <= k) {
            return i;
        }
        if (i <= k + k + k) {
            return k + k - i;
        }
        return i - (k << 2);
    }

    private int fx(int j, int k) {
        return j <= k + k ? j - k : k + k + k - j;
    }

    protected D_Vec2D[] getSourounding(D_Vec2D vec, int maxDist) {
        D_Vec2D[] fields = new D_Vec2D[maxDist * (maxDist + maxDist + 2)];
        int k = 0;
        int k2 = 0;
        int i = 0;
        int index = 0;
        index = 0;
        k = 1;
        while (k <= maxDist) {
            k2 = k << 2;
            i = 0;
            while (i < k2) {
                fields[index] = new D_Vec2D((this.fy(i, k) + vec.y + this.height) % this.height, (this.fx(i, k) + vec.x + this.width) % this.width);
                ++index;
                ++i;
            }
            ++k;
        }
        return fields;
    }
}

