/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.player;

import de.farafin.snEADy.C_DebugMonitor;
import de.farafin.snEADy.player.GameInfo;
import de.farafin.snEADy.player.LevelInfo;
import de.farafin.snEADy.player.OwnSnakeInfo;
import de.farafin.snEADy.player.PubConstants;
import de.farafin.snEADy.player.SnakeInfo;
import java.io.Serializable;

public abstract class Player
implements PubConstants,
Serializable {
    private String name = this.getClass().getName();
    private int turnDirection = 0;
    private long startTime = 0L;
    private long maxTime;
    private C_DebugMonitor monitor;
    public static String comment = "";

    public void startCalculation(GameInfo gInfo, LevelInfo lInfo, SnakeInfo[] sInfo, OwnSnakeInfo oInfo) {
        this.maxTime = gInfo.thinkingMS;
        if (gInfo.gameTime == 0L) {
            this.maxTime += gInfo.analyseMS;
        }
        this.startTime = System.currentTimeMillis();
        this.calculate(gInfo, lInfo, sInfo, oInfo);
    }

    protected abstract void calculate(GameInfo var1, LevelInfo var2, SnakeInfo[] var3, OwnSnakeInfo var4);

    protected long msLeft() {
        return this.maxTime + this.startTime - System.currentTimeMillis();
    }

    protected long msDone() {
        return System.currentTimeMillis() - this.startTime;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public int getTurnDirection() {
        return this.turnDirection;
    }

    protected void setTurnDirection(int turn) {
        if (turn == -1 || turn == 0 || turn == 1) {
            this.turnDirection = turn;
        } else {
            System.out.println("WARNING: turnDirection should be set to TURN_LEFT, TURN_NONE or TURN_RIGHT. " + turn + " is none of these constants.");
            this.turnDirection = turn;
        }
    }

    protected void say(OwnSnakeInfo oInfo, String str) {
        this.monitor.say((SnakeInfo)oInfo, str);
    }

    protected void sayNow(OwnSnakeInfo oInfo, String str) {
        this.monitor.sayIm((SnakeInfo)oInfo, str);
    }

    public void setMonitor(C_DebugMonitor monitor) {
        this.monitor = monitor;
    }
}

