/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.inOut;

import de.farafin.snEADy.communication.I_Constants;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public final class C_LogFileWriter
implements I_Constants {
    private File logFile;
    private Vector lineList = null;
    private FileWriter writer;

    public C_LogFileWriter(String fileName) {
        this("logs", fileName);
    }

    public C_LogFileWriter(String root, String fileName) {
        this.logFile = new File(root, fileName);
        this.lineList = new Vector(8);
        try {
            this.logFile.createNewFile();
            this.writer = new FileWriter(this.logFile);
        }
        catch (IOException e) {
            System.out.println("WARNING: LogFile cant be opend!! " + e);
        }
    }

    public void storeLine(String line) {
        this.lineList.add(line);
    }

    public void addToLastLine(String tail) {
        int last = this.lineList.size();
        if (last <= 1) {
            this.lineList.add(tail);
            return;
        }
        String line = (String)this.lineList.remove(last - 1);
        line = String.valueOf(line) + tail;
        this.lineList.add(line);
    }

    public boolean writeLine(String line) {
        try {
            this.writer.write(String.valueOf(line) + "\n");
            this.writer.flush();
        }
        catch (IOException e) {
            System.out.println("WARNING: LogFile cant be written in!! " + e);
            return false;
        }
        return true;
    }

    public boolean safe() {
        try {
            int i = 0;
            while (i < this.lineList.size()) {
                this.writer.write(String.valueOf((String)this.lineList.elementAt(i)) + "\n");
                ++i;
            }
            this.lineList.clear();
            this.writer.flush();
        }
        catch (IOException e) {
            System.out.println("WARNING: LogFile cant be written in!! " + e);
            return false;
        }
        return true;
    }

    public void safeAndCloseFile() {
        try {
            this.safe();
            this.writer.close();
        }
        catch (IOException e) {
            System.out.println("WARNING: LogFile cant be closed!! " + e);
        }
    }
}

