/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.inOut;

import de.farafin.snEADy.communication.I_Constants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public final class C_LogFileReader
implements I_Constants {
    private File logFile;
    private Vector lineList = null;
    private int actLineCounter = 0;

    public C_LogFileReader(String root, String fileName) throws FileNotFoundException {
        this.logFile = new File(root, fileName);
        if (!this.logFile.exists()) {
            throw new FileNotFoundException("File " + fileName + " at " + root + " was not found!");
        }
        this.lineList = new Vector(8);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.logFile));
            while (reader.ready()) {
                String tmp = reader.readLine();
                this.lineList.addElement(tmp);
            }
            reader.close();
        }
        catch (IOException e) {
            System.out.println("WARNING: LogFile cant be opend!! " + e);
        }
    }

    public C_LogFileReader(String fileName) throws FileNotFoundException {
        this("logs", fileName);
    }

    public String readNextLine() {
        if (this.actLineCounter < this.lineList.size()) {
            ++this.actLineCounter;
            return (String)this.lineList.elementAt(this.actLineCounter - 1);
        }
        return "";
    }

    public String readLine(int number) {
        if (number < this.lineList.size()) {
            return (String)this.lineList.get(number);
        }
        return "";
    }

    public boolean isFinished() {
        return this.actLineCounter >= this.lineList.size();
    }

    public void restart() {
        this.actLineCounter = 0;
    }

    public String getFileName() {
        return this.logFile.getName();
    }
}

