/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.inOut;

import de.farafin.snEADy.communication.I_Constants;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public final class C_FileClassLoader
extends ClassLoader
implements I_Constants {
    private String root;

    public C_FileClassLoader(String rootDir) {
        if (rootDir == null) {
            throw new IllegalArgumentException("Null root directory");
        }
        this.root = rootDir.replace('.', File.separatorChar);
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        try {
            c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            if (c == null) {
                try {
                    c = this.findSystemClass(name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (c != null) {
                return c;
            }
            if (c == null) {
                String filename = String.valueOf(name.replace('.', File.separatorChar)) + ".class";
                try {
                    byte[] data = this.loadClassData(filename);
                    c = this.defineClass(name, data, 0, data.length);
                }
                catch (IOException iOException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
            }
            if (c == null) {
                throw new ClassNotFoundException(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
        }
        catch (Throwable ex) {
            throw new ClassNotFoundException(name);
        }
        return c;
    }

    private byte[] loadClassData(String filename) throws IOException {
        File f = new File(this.root, filename);
        int size = (int)f.length();
        byte[] buff = new byte[size];
        FileInputStream fis = new FileInputStream(f);
        DataInputStream dis = new DataInputStream(fis);
        dis.readFully(buff);
        dis.close();
        return buff;
    }
}

