/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.control.GaphixStuff;

import de.farafin.snEADy.C_DebugMonitor;
import de.farafin.snEADy.GameParameter;
import de.farafin.snEADy.I_Main_interface;
import de.farafin.snEADy.communication.D_GameInfo;
import de.farafin.snEADy.communication.D_Level;
import de.farafin.snEADy.communication.D_PlayerData;
import de.farafin.snEADy.communication.I_Constants;
import de.farafin.snEADy.control.C_Human;
import de.farafin.snEADy.control.GaphixStuff.C_GraphixData;
import de.farafin.snEADy.control.GaphixStuff.C_GraphixTools;
import de.farafin.snEADy.control.GaphixStuff.GrButton;
import de.farafin.snEADy.control.GaphixStuff.GrDlgWindow;
import de.farafin.snEADy.control.GaphixStuff.GrScroll;
import de.farafin.snEADy.control.GaphixStuff.GrSelCanvas;
import de.farafin.snEADy.control.GaphixStuff.GrTextArea;
import de.farafin.snEADy.control.GaphixStuff.GrTextField;
import de.farafin.snEADy.control.GaphixStuff.GrWindow;
import de.farafin.snEADy.control.GaphixStuff.I_GraphixConstants;
import de.farafin.snEADy.control.I_Control_interface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.VolatileImage;
import java.io.File;
import java.io.FilenameFilter;

public class M_GraphixEngineUI
extends GrWindow
implements I_Control_interface,
I_Constants,
I_GraphixConstants {
    private int frameC;
    private long lastTime;
    private float fps;
    D_GameInfo oldGameInfo;
    private C_Human[] humans;
    private int humanPlayerC = 1;
    private VolatileImage img_arena;
    private Graphics gr_arena;
    private VolatileImage[] img_pTab = new VolatileImage[10];
    private VolatileImage[] img_tab = new VolatileImage[10];
    Graphics[] gr_tab = new Graphics[10];
    private int monPosX;
    private int monPosY;
    private int monWidth = 450;
    private int monHeight = 450;
    private Gr_Arena[] arena = new Gr_Arena[2];
    private int actArena = 0;
    private Gr_DiffArena diff;
    private int[] last_killPoints = new int[10];
    private int[] m_length = new int[10];
    private int[] m_killpoints = new int[10];
    private int[] m_cycles = new int[10];
    private int[] m_name = new int[10];
    private int lastPlayerC;
    private int[] playerOrd;
    private M_GraphixEngineUI root;
    private Graphics actGraphics;
    private GrButton butt_run;
    private GrButton butt_stop;
    private GrButton butt_min;
    private GrButton butt_quit;
    private GrButton butt_arena;
    private GrButton butt_player;
    private GrButton butt_options;
    private GrButton butt_credits;
    private GrButton[] butt_rmPlayer = new GrButton[10];
    private Frame commandFrame;
    private TextField cf_text;
    private Label cf_lab;
    private GrDlgWindow arenaFS;
    private GrDlgWindow playerFS;
    private GrTextField text_hPlayerName;
    private GrButton butt_addHPlayer;
    private GrButton butt_addCPlayer;
    private GrButton butt_plOK;
    private GrSelCanvas sel_player;
    private GrTextArea area_commentsPlayer;
    private GrScroll scroll_player;
    private String[] fileList_player;
    private GrButton butt_loadArena;
    private GrButton butt_arenaOK;
    private GrSelCanvas sel_arena;
    private GrTextArea area_commentsArena;
    private GrScroll scroll_arena;
    private String[] fileList_arena;
    private GrDlgWindow options;
    private GrTextField text_exitT;
    private GrTextField text_suddenDT;
    private GrTextField text_iLength;
    private GrTextField text_iDelay;
    private GrTextField text_aGrow;
    private GrTextField text_aSlowd;
    private GrTextField text_maxDelay;
    private GrTextField text_pLength;
    private GrTextField text_pSpeed;
    private GrTextField text_pSlowd;
    private GrTextField text_pPoints;
    private GrTextField text_maxTime;
    private GrTextField text_maxMem;
    private GrButton tgl_timeKill;
    private GrButton tgl_showSC;
    private GrButton tgl_debugMon;
    private GrButton tgl_pPTime;
    private GrButton tgl_pPMem;
    private GrButton tgl_log;
    private String[] commandHist = new String[8];
    private int selectedCommand = -1;
    private int lastInserted = 7;
    private C_DebugMonitor debugMon;
    private GameParameter gameParam;

    public M_GraphixEngineUI(I_Main_interface calling, GameParameter p, C_DebugMonitor debMon, int version) {
        super("snEADy", 800, 600);
        C_GraphixData.version = version;
        C_GraphixData.main = calling;
        this.debugMon = debMon;
        this.root = this;
        this.gameParam = p;
        if (C_GraphixTools.loadImages()) {
            // empty if block
        }
        int i22 = 0;
        while (i22 < 10) {
            this.img_pTab[i22] = C_GraphixTools.createBackBufferVI(C_GraphixData.menuImages[2].getWidth(null), C_GraphixData.menuImages[2].getHeight(null));
            this.img_tab[i22] = C_GraphixTools.createBackBufferVI(C_GraphixData.menuImages[2].getWidth(null), C_GraphixData.menuImages[2].getHeight(null));
            this.gr_tab[i22] = this.img_tab[i22].getGraphics();
            ++i22;
        }
        this.drawPlayerTab(new boolean[]{true, true, true, true, true, true, true, true, true, true});
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                C_GraphixData.main.control("quit");
            }
        });
        try {
            this.addKeyListener(new KeyListener(){

                public void keyTyped(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    int key = e.getKeyCode();
                    switch (key) {
                        case 27: {
                            C_GraphixData.main.control("quit");
                            return;
                        }
                        case 123: {
                            M_GraphixEngineUI.this.commandFrame.setVisible(!M_GraphixEngineUI.this.commandFrame.isVisible());
                        }
                    }
                    int i = 0;
                    while (i < M_GraphixEngineUI.this.humanPlayerC) {
                        if (key == I_GraphixConstants.humanPlayerKeyL[i]) {
                            M_GraphixEngineUI.this.humans[i].setNewDirection(3);
                        } else if (key == I_GraphixConstants.humanPlayerKeyU[i]) {
                            M_GraphixEngineUI.this.humans[i].setNewDirection(0);
                        } else if (key == I_GraphixConstants.humanPlayerKeyR[i]) {
                            M_GraphixEngineUI.this.humans[i].setNewDirection(1);
                        } else if (key == I_GraphixConstants.humanPlayerKeyD[i]) {
                            M_GraphixEngineUI.this.humans[i].setNewDirection(2);
                        }
                        ++i;
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
        }
        catch (Exception i22) {
            // empty catch block
        }
        this.butt_run = new GrButton(212, 142, 11, 5, false){

            public void stateChanged(int state) {
                C_GraphixData.main.control("run");
            }
        };
        this.butt_stop = new GrButton(212, 187, 12, 6, false){

            public void stateChanged(int state) {
                if (state == 3) {
                    C_GraphixData.main.control("stop");
                }
            }
        };
        this.butt_quit = new GrButton(752, 14, 12, 7, true){

            public void stateChanged(int state) {
                if (state == 3) {
                    C_GraphixData.main.control("quit");
                }
            }
        };
        this.butt_min = new GrButton(715, 14, 12, 8, true){

            public void stateChanged(int state) {
                if (state == 3) {
                    M_GraphixEngineUI.this.root.setState(1);
                }
            }
        };
        this.butt_credits = new GrButton(293, 84, 12, 9, false){

            public void stateChanged(int state) {
            }
        };
        this.butt_arena = new GrButton(10, 209, 12, 10, false){

            public void stateChanged(int state) {
                if (M_GraphixEngineUI.this.arenaFS.isVisible()) {
                    M_GraphixEngineUI.this.arenaFS.requestFocus();
                } else {
                    M_GraphixEngineUI.this.arenaFS.setVisible(true);
                }
            }
        };
        this.butt_player = new GrButton(102, 213, 12, 11, false){

            public void stateChanged(int state) {
                if (M_GraphixEngineUI.this.playerFS.isVisible()) {
                    M_GraphixEngineUI.this.playerFS.requestFocus();
                } else {
                    M_GraphixEngineUI.this.playerFS.setVisible(true);
                }
                M_GraphixEngineUI.this.text_hPlayerName.setText("Player_" + (M_GraphixEngineUI.this.lastPlayerC + 1), 0, M_GraphixEngineUI.this.playerFS.isVisible());
            }
        };
        this.butt_options = new GrButton(233, 232, 12, 12, false){

            public void stateChanged(int state) {
                if (M_GraphixEngineUI.this.options.isVisible()) {
                    M_GraphixEngineUI.this.options.requestFocus();
                } else {
                    M_GraphixEngineUI.this.options.setVisible(true);
                }
                M_GraphixEngineUI.this.updateOptions(M_GraphixEngineUI.this.options.isVisible());
            }
        };
        int i = 0;
        while (i < 10) {
            this.butt_rmPlayer[i] = new GrButton(292, 316 + i * 26, 12, 13, false, i){

                public void stateChanged(int state) {
                    if (state == 3) {
                        C_GraphixData.main.control("delplayer " + M_GraphixEngineUI.this.playerOrd[this.iData]);
                    }
                }
            };
            ++i;
        }
        this.add(this.butt_run);
        this.add(this.butt_stop);
        this.add(this.butt_min);
        this.add(this.butt_credits);
        this.add(this.butt_quit);
        this.add(this.butt_arena);
        this.add(this.butt_player);
        this.add(this.butt_options);
        i = 0;
        while (i < 10) {
            this.add(this.butt_rmPlayer[i]);
            ++i;
        }
        this.setVisible(true);
        this.actGraphics = this.getGraphics();
        this.setupFileSelectorArena();
        this.setupFileSelectorPlayer();
        this.setupOptions();
        this.setupCommandFrame();
    }

    private M_GraphixEngineUI() {
    }

    private void setupOptions() {
        this.options = new GrDlgWindow("snEADy - Options", C_GraphixData.menuImagesO[23]);
        this.text_exitT = new GrTextField(60, 85, 6, String.valueOf(this.gameParam.getExit_time()), 0, true, "set exit_time ");
        this.text_suddenDT = new GrTextField(220, 85, 6, String.valueOf(this.gameParam.getSuddend_time()), 0, true, "set suddend_time ");
        this.text_iLength = new GrTextField(77, 125, 4, String.valueOf(this.gameParam.getInit_length()), 0, true, "set init_length ");
        this.text_iDelay = new GrTextField(177, 125, 2, String.valueOf(this.gameParam.getInit_move_delay()), 0, true, "set init_move_delay ");
        this.text_aGrow = new GrTextField(66, 165, 5, String.valueOf(this.gameParam.getAuto_grow_delay()), 0, true, "set auto_grow_delay ");
        this.text_aSlowd = new GrTextField(201, 165, 5, String.valueOf(this.gameParam.getAuto_slowdown_delay()), 0, true, "set auto_slowdown_delay ");
        this.text_maxDelay = new GrTextField(93, 205, 4, String.valueOf(this.gameParam.getMax_goody_occ_delay()), 0, true, "set max_goody_occ_delay ");
        this.text_pLength = new GrTextField(66, 245, 2, String.valueOf(this.gameParam.getGoody_length_occ()), 0, true, "set goody_length_occ ");
        this.text_pSpeed = new GrTextField(126, 245, 2, String.valueOf(this.gameParam.getGoody_speed_occ()), 0, true, "set goody_speed_occ ");
        this.text_pSlowd = new GrTextField(198, 245, 2, String.valueOf(this.gameParam.getGoody_slowdown_occ()), 0, true, "set goody_slowdown_occ ");
        this.text_pPoints = new GrTextField(257, 245, 2, String.valueOf(this.gameParam.getGoody_points_occ()), 0, true, "set goody_points_occ ");
        this.text_maxTime = new GrTextField(232, 325, 6, String.valueOf(this.gameParam.getMax_thinking_ms()), 0, true, "set max_thinking_ms ");
        this.text_maxMem = new GrTextField(140, 346, 8, String.valueOf(this.gameParam.getMax_player_mem()), 0, true, "set max_player_mem ");
        this.tgl_timeKill = new GrButton(76, 321, 11, 25, true){

            public void stateChanged(int state) {
                if (state == 3) {
                    C_GraphixData.main.control("set TIMEOUT_MS " + M_GraphixEngineUI.this.gameParam.getMax_thinking_ms());
                } else {
                    C_GraphixData.main.control("set TIMEOUT_MS 0");
                }
            }
        };
        if (this.gameParam.getTimeout_ms() > 0) {
            this.tgl_timeKill.bState = 2;
        }
        this.tgl_showSC = new GrButton(122, 401, 11, 25, true){

            public void stateChanged(int state) {
                if (state == 3) {
                    C_GraphixData.main.control("set SHOW_SUBCYCLES 1");
                } else {
                    C_GraphixData.main.control("set SHOW_SUBCYCLES 0");
                }
            }
        };
        if (this.gameParam.getShow_subcycles() > 0) {
            this.tgl_showSC.bState = 2;
        }
        this.tgl_debugMon = new GrButton(268, 401, 11, 25, true){

            public void stateChanged(int state) {
                M_GraphixEngineUI.this.debugMon.setVisible(state == 3);
            }
        };
        if (this.debugMon.isVisible()) {
            this.tgl_debugMon.bState = 2;
        }
        this.tgl_pPTime = new GrButton(98, 461, 11, 25, true){

            public void stateChanged(int state) {
                if (state == 3) {
                    C_GraphixData.main.control("set PRINT_CALC_MS 1");
                } else {
                    C_GraphixData.main.control("set PRINT_CALC_MS 0");
                }
            }
        };
        if (this.gameParam.getPrint_calc_ms() > 0) {
            this.tgl_pPTime.bState = 2;
        }
        this.tgl_pPMem = new GrButton(253, 461, 11, 25, true){

            public void stateChanged(int state) {
                if (state == 3) {
                    C_GraphixData.main.control("set PRINT_PLAYER_MEM 1");
                } else {
                    C_GraphixData.main.control("set PRINT_PLAYER_MEM 0");
                }
            }
        };
        if (this.gameParam.getPrint_player_mem() > 0) {
            this.tgl_pPMem.bState = 2;
        }
        this.tgl_log = new GrButton(129, 483, 11, 25, true){

            public void stateChanged(int state) {
                if (state == 3) {
                    C_GraphixData.main.control("set LOGGING 1");
                } else {
                    C_GraphixData.main.control("set LOGGING 0");
                }
            }
        };
        if (this.gameParam.getLogging() > 0) {
            this.tgl_pPMem.bState = 2;
        }
        this.options.add(this.text_exitT);
        this.options.add(this.text_suddenDT);
        this.options.add(this.text_iLength);
        this.options.add(this.text_iDelay);
        this.options.add(this.text_aGrow);
        this.options.add(this.text_aSlowd);
        this.options.add(this.text_maxDelay);
        this.options.add(this.text_pLength);
        this.options.add(this.text_pSpeed);
        this.options.add(this.text_pSlowd);
        this.options.add(this.text_pPoints);
        this.options.add(this.text_maxTime);
        this.options.add(this.text_maxMem);
        this.options.add(this.tgl_timeKill);
        this.options.add(this.tgl_showSC);
        this.options.add(this.tgl_debugMon);
        this.options.add(this.tgl_pPTime);
        this.options.add(this.tgl_pPMem);
        this.options.add(this.tgl_log);
    }

    private void updateOptions(boolean grUp) {
        this.text_exitT.setText(String.valueOf(this.gameParam.getExit_time()), 0, grUp);
        this.text_suddenDT.setText(String.valueOf(this.gameParam.getSuddend_time()), 0, grUp);
        this.text_iLength.setText(String.valueOf(this.gameParam.getInit_length()), 0, grUp);
        this.text_iDelay.setText(String.valueOf(this.gameParam.getInit_move_delay()), 0, grUp);
        this.text_aGrow.setText(String.valueOf(this.gameParam.getAuto_grow_delay()), 0, grUp);
        this.text_aSlowd.setText(String.valueOf(this.gameParam.getAuto_slowdown_delay()), 0, grUp);
        this.text_maxDelay.setText(String.valueOf(this.gameParam.getMax_goody_occ_delay()), 0, grUp);
        this.text_pLength.setText(String.valueOf(this.gameParam.getGoody_length_occ()), 0, grUp);
        this.text_pSpeed.setText(String.valueOf(this.gameParam.getGoody_speed_occ()), 0, grUp);
        this.text_pSlowd.setText(String.valueOf(this.gameParam.getGoody_slowdown_occ()), 0, grUp);
        this.text_pPoints.setText(String.valueOf(this.gameParam.getGoody_points_occ()), 0, grUp);
        this.text_maxTime.setText(String.valueOf(this.gameParam.getMax_thinking_ms()), 0, grUp);
        this.text_maxMem.setText(String.valueOf(this.gameParam.getMax_player_mem()), 0, grUp);
        if (this.gameParam.getTimeout_ms() > 0) {
            this.tgl_timeKill.bState = 2;
        }
        if (this.gameParam.getShow_subcycles() > 0) {
            this.tgl_showSC.bState = 2;
        }
        if (this.debugMon.isVisible()) {
            this.tgl_debugMon.bState = 2;
        }
        if (this.gameParam.getPrint_calc_ms() > 0) {
            this.tgl_pPTime.bState = 2;
        }
        if (this.gameParam.getPrint_player_mem() > 0) {
            this.tgl_pPMem.bState = 2;
        }
        if (this.gameParam.getLogging() > 0) {
            this.tgl_pPMem.bState = 2;
        }
        if (grUp) {
            this.tgl_timeKill.repaint();
            this.tgl_showSC.repaint();
            this.tgl_debugMon.repaint();
            this.tgl_pPTime.repaint();
            this.tgl_pPMem.repaint();
            this.tgl_pPMem.repaint();
            this.tgl_pPMem.repaint();
        }
    }

    private static final void appendCuttedString(StringBuffer dest, String src, int maxLen) {
        if (src.length() > maxLen) {
            dest.append(src.substring(0, maxLen - 3));
            dest.append("...");
        } else {
            dest.append(src);
        }
    }

    private void setupFileSelectorArena() {
        FilenameFilter filt = new FilenameFilter(){

            public boolean accept(File f, String s) {
                return s.toLowerCase().endsWith(".smp");
            }
        };
        this.fileList_arena = I_GraphixConstants.dir_arena.list(filt);
        this.arenaFS = new GrDlgWindow("snEADy - Arena Loader", C_GraphixData.menuImagesO[21]);
        this.sel_arena = new GrSelCanvas(18, 72, 256, 210, this.fileList_arena){

            public void action() {
                int maxLen = ((M_GraphixEngineUI)M_GraphixEngineUI.this).area_commentsArena.showW / 8 - 8;
                int i = ((M_GraphixEngineUI)M_GraphixEngineUI.this).sel_arena.showedLinesStart + ((M_GraphixEngineUI)M_GraphixEngineUI.this).sel_arena.selected;
                D_Level lev = C_GraphixData.main.getLevelHeader(M_GraphixEngineUI.this.fileList_arena[i].substring(0, M_GraphixEngineUI.this.fileList_arena[i].lastIndexOf(46)));
                StringBuffer str = new StringBuffer(lev.name.length() + lev.autor.length() + 42);
                str.append("NAME:   ");
                M_GraphixEngineUI.appendCuttedString(str, lev.name, maxLen);
                str.append("\nAUTHOR: ");
                M_GraphixEngineUI.appendCuttedString(str, lev.autor, maxLen);
                str.append("\nSIZE:   ");
                str.append(lev.height);
                str.append('x');
                str.append(lev.width);
                str.append("\nPLAYER: ");
                str.append(lev.maxPlayer);
                str.append("\nSKIN:   ");
                str.append(C_GraphixTools.getAvailLevelGraphix(lev.fileName));
                M_GraphixEngineUI.this.area_commentsArena.setText(str.toString(), 0, true);
            }
        };
        this.area_commentsArena = new GrTextArea(18, 314, 176, 84, "", 0, true);
        this.scroll_arena = new GrScroll(282, 68, 22, 218, this.sel_arena);
        this.butt_loadArena = new GrButton(214, 310, 12, 14, true){

            public void stateChanged(int state) {
                int i;
                if (state == 3 && (i = ((M_GraphixEngineUI)M_GraphixEngineUI.this).sel_arena.showedLinesStart + ((M_GraphixEngineUI)M_GraphixEngineUI.this).sel_arena.selected) >= 0) {
                    C_GraphixData.main.control("loadlevel " + M_GraphixEngineUI.this.fileList_arena[i].substring(0, M_GraphixEngineUI.this.fileList_arena[i].lastIndexOf(46)));
                }
            }
        };
        this.butt_arenaOK = new GrButton(129, 433, 12, 16, true){

            public void stateChanged(int state) {
                if (state == 3) {
                    M_GraphixEngineUI.this.arenaFS.setVisible(false);
                }
            }
        };
        this.arenaFS.add(this.sel_arena);
        this.arenaFS.add(this.area_commentsArena);
        this.arenaFS.add(this.scroll_arena);
        this.arenaFS.add(this.butt_loadArena);
        this.arenaFS.add(this.butt_arenaOK);
    }

    private void setupFileSelectorPlayer() {
        FilenameFilter filt = new FilenameFilter(){

            public boolean accept(File f, String s) {
                return s.toLowerCase().endsWith(".class");
            }
        };
        this.fileList_player = I_GraphixConstants.dir_player.list(filt);
        this.playerFS = new GrDlgWindow("snEADy - Player Loader", C_GraphixData.menuImagesO[22]);
        this.text_hPlayerName = new GrTextField(18, 392, 17, "Player_" + (this.lastPlayerC + 1), 0, false, null);
        this.sel_player = new GrSelCanvas(18, 72, 256, 168, this.fileList_player){

            public void action() {
                int i = ((M_GraphixEngineUI)M_GraphixEngineUI.this).sel_player.showedLinesStart + ((M_GraphixEngineUI)M_GraphixEngineUI.this).sel_player.selected;
                String str = C_GraphixData.main.getPlayerComment(M_GraphixEngineUI.this.fileList_player[i].substring(0, M_GraphixEngineUI.this.fileList_player[i].lastIndexOf(46)));
                M_GraphixEngineUI.this.area_commentsPlayer.setText(str, 0, true);
            }
        };
        this.area_commentsPlayer = new GrTextArea(18, 272, 176, 42, "", 0, true);
        this.scroll_player = new GrScroll(282, 68, 22, 176, this.sel_player);
        this.butt_addHPlayer = new GrButton(214, 384, 12, 15, true){

            public void stateChanged(int state) {
                if (state == 3) {
                    C_GraphixData.main.control("loadhuman " + ((M_GraphixEngineUI)M_GraphixEngineUI.this).text_hPlayerName.text.toString());
                    M_GraphixEngineUI.this.text_hPlayerName.setText("Player_" + (M_GraphixEngineUI.this.lastPlayerC + 1), 0, true);
                }
            }
        };
        this.butt_addCPlayer = new GrButton(214, 268, 12, 15, true){

            public void stateChanged(int state) {
                int i;
                if (state == 3 && (i = ((M_GraphixEngineUI)M_GraphixEngineUI.this).sel_player.showedLinesStart + ((M_GraphixEngineUI)M_GraphixEngineUI.this).sel_player.selected) >= 0) {
                    C_GraphixData.main.control("loadplayer " + M_GraphixEngineUI.this.fileList_player[i].substring(0, M_GraphixEngineUI.this.fileList_player[i].lastIndexOf(46)));
                }
            }
        };
        this.butt_plOK = new GrButton(129, 433, 12, 16, true){

            public void stateChanged(int state) {
                if (state == 3) {
                    M_GraphixEngineUI.this.playerFS.setVisible(false);
                }
            }
        };
        this.playerFS.add(this.sel_player);
        this.playerFS.add(this.area_commentsPlayer);
        this.playerFS.add(this.scroll_player);
        this.playerFS.add(this.text_hPlayerName);
        this.playerFS.add(this.butt_addHPlayer);
        this.playerFS.add(this.butt_addCPlayer);
        this.playerFS.add(this.butt_plOK);
    }

    private void setupCommandFrame() {
        this.commandFrame = new Frame("snEADy Command Window");
        this.commandFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                M_GraphixEngineUI.this.commandFrame.setVisible(false);
            }
        });
        this.cf_lab = new Label("Enter Commends here!");
        this.cf_lab.setBackground(Color.WHITE);
        this.cf_text = new TextField("", 64);
        this.cf_text.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                switch (key) {
                    case 27: {
                        M_GraphixEngineUI.this.commandFrame.setVisible(false);
                        break;
                    }
                    case 10: {
                        String t = M_GraphixEngineUI.this.cf_text.getText();
                        M_GraphixEngineUI.this.cf_text.setText("");
                        if (C_GraphixData.main.control(t)) {
                            M_GraphixEngineUI.this.cf_lab.setText(String.valueOf(t) + " executed!");
                        } else {
                            M_GraphixEngineUI.this.cf_lab.setText(String.valueOf(t) + " FAILED!");
                        }
                        M_GraphixEngineUI.this.lastInserted = (M_GraphixEngineUI.this.lastInserted + 1) % 8;
                        ((M_GraphixEngineUI)M_GraphixEngineUI.this).commandHist[((M_GraphixEngineUI)M_GraphixEngineUI.this).lastInserted] = t;
                        M_GraphixEngineUI.this.selectedCommand = -1;
                        M_GraphixEngineUI.this.root.requestFocusInWindow();
                        if (e.getModifiers() != 2) break;
                        M_GraphixEngineUI.this.commandFrame.setVisible(false);
                        break;
                    }
                    case 38: {
                        if (M_GraphixEngineUI.this.selectedCommand < 7 && M_GraphixEngineUI.this.commandHist[(8 + M_GraphixEngineUI.this.lastInserted - M_GraphixEngineUI.this.selectedCommand - 1) % 8] != null) {
                            M_GraphixEngineUI m_GraphixEngineUI = M_GraphixEngineUI.this;
                            m_GraphixEngineUI.selectedCommand = m_GraphixEngineUI.selectedCommand + 1;
                        }
                        M_GraphixEngineUI.this.cf_text.setText(M_GraphixEngineUI.this.commandHist[(8 + M_GraphixEngineUI.this.lastInserted - M_GraphixEngineUI.this.selectedCommand) % 8]);
                        break;
                    }
                    case 40: {
                        if (M_GraphixEngineUI.this.selectedCommand > 0) {
                            M_GraphixEngineUI m_GraphixEngineUI = M_GraphixEngineUI.this;
                            m_GraphixEngineUI.selectedCommand = m_GraphixEngineUI.selectedCommand - 1;
                            M_GraphixEngineUI.this.cf_text.setText(M_GraphixEngineUI.this.commandHist[(8 + M_GraphixEngineUI.this.lastInserted - M_GraphixEngineUI.this.selectedCommand) % 8]);
                            break;
                        }
                        M_GraphixEngineUI.this.cf_text.setText("");
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.commandFrame.setBounds(this.getX(), this.getY() + this.getHeight(), this.getWidth(), 70);
        this.commandFrame.setResizable(false);
        this.commandFrame.add((Component)this.cf_lab, "Center");
        this.commandFrame.add((Component)this.cf_text, "South");
    }

    private void updateGraphics() {
        int y = 0;
        int srcStartX = 0;
        int srcStartY = 0;
        int srcEndX = 0;
        int srcEndY = 0;
        int destEndX = 6;
        int destEndY = 6;
        int sy = this.diff.sizeY;
        int sx = this.diff.sizeX;
        int imgID = 0;
        Gr_Arena a = this.diff;
        do {
            if (this.img_arena.validate(C_GraphixData.gc) != 0) {
                if (this.img_arena.validate(C_GraphixData.gc) == 2) {
                    if (this.img_arena != null) {
                        this.img_arena.flush();
                        this.img_arena = null;
                    }
                    this.img_arena = C_GraphixTools.createBackBufferVI(sx * 6, sx * 6);
                }
                a = this.arena[this.actArena];
            }
            int i = 0;
            while (i < sy) {
                int x = 0;
                int j = 0;
                while (j < sx) {
                    int actC = a.field[i][j];
                    if (actC > 0) {
                        if (actC == 46) {
                            srcStartX = x % C_GraphixData.gameImages[46].getWidth(null);
                            srcStartY = y % C_GraphixData.gameImages[46].getHeight(null);
                            srcEndX = srcStartX + 6;
                            srcEndY = srcStartY + 6;
                            destEndX = x + 6;
                            destEndY = y + 6;
                            imgID = 46;
                        } else if (actC >= 1 && actC <= 12) {
                            srcStartX = (actC - '\u0001') * 6;
                            srcStartY = 0;
                            srcEndX = srcStartX + 6;
                            srcEndY = 6;
                            destEndX = x + 6;
                            destEndY = y + 6;
                            imgID = 1;
                        } else if (actC >= 13 && actC <= 22) {
                            srcStartX = (actC - 13) * 6;
                            srcStartY = 0;
                            srcEndX = srcStartX + 6;
                            srcEndY = 6;
                            destEndX = x + 6;
                            destEndY = y + 6;
                            imgID = 48;
                        } else if (actC >= 48 && actC <= 57) {
                            srcStartX = (actC - 48) * 6;
                            srcStartY = 6;
                            srcEndX = srcStartX + 6;
                            srcEndY = srcStartY + 6;
                            destEndX = x + 6;
                            destEndY = y + 6;
                            imgID = 48;
                        } else if (actC >= 97 && actC <= 101) {
                            srcStartX = (actC - 97) * 6;
                            srcStartY = 0;
                            srcEndX = srcStartX + 6;
                            srcEndY = 6;
                            destEndX = x + 6;
                            destEndY = y + 6;
                            imgID = 97;
                        } else if (actC == 65) {
                            srcStartX = 0;
                            srcStartY = 0;
                            srcEndX = C_GraphixData.gameImages[65].getWidth(null) / 2;
                            srcEndY = C_GraphixData.gameImages[65].getHeight(this);
                            destEndX = x + srcEndX;
                            destEndY = y + srcEndY;
                            imgID = 65;
                        } else if (actC == 23) {
                            srcStartX = C_GraphixData.gameImages[65].getWidth(null) / 2;
                            srcStartY = 0;
                            srcEndX = C_GraphixData.gameImages[65].getWidth(null);
                            srcEndY = C_GraphixData.gameImages[65].getHeight(null);
                            imgID = 65;
                            destEndX = x + srcEndY;
                            destEndY = y + srcEndY;
                        } else {
                            srcStartX = 0;
                            srcStartY = 0;
                            srcEndX = 6;
                            srcEndY = 6;
                            destEndX = x + 6;
                            destEndY = y + 6;
                            imgID = actC;
                            if (C_GraphixData.gameImages[imgID] == null) {
                                imgID = 255;
                            }
                        }
                        C_GraphixTools.drawGameImageToBackbuffer(this.img_arena, imgID, x, y, destEndX, destEndY, srcStartX, srcStartY, srcEndX, srcEndY);
                    }
                    x += 6;
                    ++j;
                }
                y += 6;
                ++i;
            }
            this.actGraphics.drawImage(this.img_arena, this.monPosX, this.monPosY, null, null);
        } while (this.img_arena.contentsLost());
    }

    private void updateTexts(D_GameInfo gameInfo, Graphics g) {
        int mode = 0;
        String[] leer6 = new String[]{"      ", "     ", "    ", "   ", "  ", " ", ""};
        StringBuffer tmpStrB = new StringBuffer(6);
        tmpStrB.append(gameInfo.gameTime);
        tmpStrB.insert(0, leer6[tmpStrB.length()]);
        C_GraphixTools.drawBitmapString(tmpStrB.toString(), 63, 179, 4, g, 1, mode);
        mode = gameInfo.exitTime <= gameInfo.gameTime ? 3 : 0;
        tmpStrB.delete(0, 6);
        tmpStrB.append(gameInfo.exitTime);
        tmpStrB.insert(0, leer6[tmpStrB.length()]);
        C_GraphixTools.drawBitmapString(tmpStrB.toString(), 127, 179, 4, g, 1, mode);
        mode = gameInfo.suddenDeath <= gameInfo.gameTime ? 2 : 0;
        tmpStrB.delete(0, 6);
        tmpStrB.append(gameInfo.suddenDeath);
        tmpStrB.insert(0, leer6[tmpStrB.length()]);
        C_GraphixTools.drawBitmapString(tmpStrB.toString(), 191, 179, 4, g, 1, mode);
    }

    private void updatePlayer(D_GameInfo gameInfo) {
        D_PlayerData[] pd = gameInfo.playerData;
        int i = 0;
        while (i < pd.length) {
            if (pd[i].snakeStatus == 0) {
                this.m_cycles[i] = pd[i].delayChanged > 0 ? 2 : (pd[i].delayChanged < 0 ? 3 : 0);
                this.m_length[i] = pd[i].lengthChanged < 0 ? 2 : (pd[i].lengthChanged > 0 ? 3 : 0);
                if (this.last_killPoints[i] > pd[i].killPoints) {
                    this.m_killpoints[i] = 2;
                    this.last_killPoints[i] = pd[i].killPoints;
                } else if (this.last_killPoints[i] < pd[i].killPoints) {
                    this.m_killpoints[i] = 3;
                    int n = i;
                    this.last_killPoints[n] = this.last_killPoints[n] + 1;
                } else {
                    this.m_killpoints[i] = 0;
                }
                if (this.m_name[i] == 1) {
                    this.m_name[i] = 0;
                    this.m_length[i] = 0;
                    this.m_cycles[i] = 0;
                    this.m_killpoints[i] = 0;
                }
            } else if (this.last_killPoints[i] > pd[i].killPoints) {
                this.last_killPoints[i] = pd[i].killPoints;
                this.m_name[i] = 0;
                this.m_length[i] = 0;
                this.m_cycles[i] = 0;
                this.m_killpoints[i] = 0;
            } else if (this.last_killPoints[i] < pd[i].killPoints) {
                this.m_killpoints[i] = 3;
                this.m_name[i] = 0;
                this.m_length[i] = 0;
                this.m_cycles[i] = 0;
                int n = i;
                this.last_killPoints[n] = this.last_killPoints[n] + 1;
            } else {
                this.m_name[i] = 1;
                this.m_length[i] = 1;
                this.m_cycles[i] = 1;
                this.m_killpoints[i] = 1;
            }
            ++i;
        }
    }

    private void updatePlayerTab(D_GameInfo gameInfo) {
        int valid;
        int i;
        int r = 1;
        boolean[] array = new boolean[10];
        D_PlayerData[] pd = new D_PlayerData[gameInfo.playerData.length];
        StringBuffer strB = new StringBuffer(13);
        this.playerOrd = new int[gameInfo.playerData.length];
        if (gameInfo.playerData.length > 0) {
            pd[0] = gameInfo.playerData[0];
            this.playerOrd[0] = 0;
            i = 1;
            while (i < this.playerOrd.length) {
                int j = i;
                this.playerOrd[i] = i;
                pd[i] = gameInfo.playerData[i];
                while (j > 0 && pd[this.playerOrd[j]].killPoints > pd[this.playerOrd[j - 1]].killPoints) {
                    int tmp = this.playerOrd[j];
                    this.playerOrd[j] = this.playerOrd[j - 1];
                    this.playerOrd[--j] = tmp;
                }
                ++i;
            }
            i = 0;
            while (i < this.playerOrd.length) {
                do {
                    if ((valid = this.img_tab[i].validate(C_GraphixData.gc)) == 2) {
                        this.img_tab[i] = C_GraphixTools.createBackBufferVI(C_GraphixData.menuImages[2].getWidth(null), C_GraphixData.menuImages[2].getHeight(null));
                        this.gr_tab[i] = this.img_tab[i].getGraphics();
                    }
                    if (this.img_pTab[this.playerOrd[i]].validate(C_GraphixData.gc) != 0) {
                        int k = 0;
                        while (k < 10) {
                            array[k] = false;
                            ++k;
                        }
                        array[i] = true;
                        this.drawPlayerTab(array);
                    }
                    this.gr_tab[i].drawImage(this.img_pTab[this.playerOrd[i]], 0, 0, null);
                    D_PlayerData tmpP = pd[this.playerOrd[i]];
                    if (pd[this.playerOrd[i]].name.length() > 16) {
                        strB.delete(0, 13);
                        strB.append(pd[i].name.substring(0, 12));
                        strB.append('.');
                        tmpP.name = strB.toString();
                    }
                    if (i >= 1 && pd[this.playerOrd[i]].killPoints != pd[this.playerOrd[i - 1]].killPoints) {
                        ++r;
                    }
                    C_GraphixTools.drawBitmapString(String.valueOf(r), 18, 4, 4, this.gr_tab[i], 1, this.m_cycles[this.playerOrd[i]]);
                    C_GraphixTools.drawBitmapString(tmpP.name, 58, 4, 4, this.gr_tab[i], 0, this.m_name[this.playerOrd[i]]);
                    if (pd[this.playerOrd[i]].length < 1000) {
                        C_GraphixTools.drawBitmapString(String.valueOf(pd[this.playerOrd[i]].length), 218, 4, 4, this.gr_tab[i], 1, this.m_length[this.playerOrd[i]]);
                    } else {
                        C_GraphixTools.drawBitmapString("WOW", 218, 4, 4, this.gr_tab[i], 1, this.m_length[this.playerOrd[i]]);
                    }
                    C_GraphixTools.drawBitmapString(String.valueOf(pd[this.playerOrd[i]].waitCycles), 235, 4, 4, this.gr_tab[i], 1, this.m_cycles[this.playerOrd[i]]);
                    C_GraphixTools.drawBitmapString(String.valueOf(this.last_killPoints[this.playerOrd[i]]), 276, 4, 4, this.gr_tab[i], 1, this.m_killpoints[this.playerOrd[i]]);
                } while (this.img_tab[i].contentsLost());
                ++i;
            }
        }
        i = pd.length;
        while (i < 10) {
            valid = this.img_tab[i].validate(C_GraphixData.gc);
            do {
                if (valid == 2) {
                    this.img_tab[i] = C_GraphixTools.createBackBufferVI(C_GraphixData.menuImages[2].getWidth(null), C_GraphixData.menuImages[2].getHeight(null));
                    this.gr_tab[i] = this.img_tab[i].getGraphics();
                }
                C_GraphixTools.wantReadMenuImage(3);
                this.gr_tab[i].drawImage(C_GraphixData.menuImages[3], 0, 0, null);
            } while (this.img_tab[i].contentsLost());
            ++i;
        }
    }

    private void drawMenuElements(Graphics g, D_GameInfo gameInfo) {
        int i = 0;
        while (i < 10) {
            do {
                if (this.img_tab[i].validate(C_GraphixData.gc) == 0) continue;
                this.updatePlayerTab(gameInfo);
            } while (this.img_tab[i].contentsLost());
            g.drawImage(this.img_tab[i], 10, i * 26 + 318, null);
            ++i;
        }
        this.updateTexts(gameInfo, g);
    }

    private void drawPlayerTab(boolean[] drawArray) {
        int psX = 40;
        int psY = 2;
        int i = 0;
        while (i < 10) {
            if (drawArray[i]) {
                do {
                    int valid;
                    if ((valid = this.img_pTab[i].validate(C_GraphixData.gc)) != 0 && valid == 2) {
                        this.img_pTab[i] = C_GraphixTools.createBackBufferVI(C_GraphixData.menuImages[2].getWidth(null), C_GraphixData.menuImages[2].getHeight(null));
                    }
                    Graphics g = this.img_pTab[i].getGraphics();
                    C_GraphixTools.wantReadMenuImage(2);
                    g.drawImage(C_GraphixData.menuImages[2], 0, 0, null);
                    g.drawImage(C_GraphixData.gameImages[48], 40, 2, 46, 8, 6 * i, 0, 6 * (i + 1), 6, null, null);
                    g.drawImage(C_GraphixData.gameImages[48], 40, 8, 46, 14, 6 * i, 6, 6 * (i + 1), 12, null, null);
                    g.drawImage(C_GraphixData.gameImages[48], 34, 8, 40, 14, 6 * i, 6, 6 * (i + 1), 12, null, null);
                    g.drawImage(C_GraphixData.gameImages[48], 34, 14, 40, 20, 6 * i, 6, 6 * (i + 1), 12, null, null);
                } while (this.img_pTab[i].contentsLost());
            }
            ++i;
        }
    }

    public void paint(Graphics g) {
        C_GraphixTools.drawVMenuImage(1, g);
        if (this.img_arena != null) {
            if (this.img_arena.validate(C_GraphixData.gc) != 0) {
                this.updateGraphics();
            } else {
                g.drawImage(this.img_arena, this.monPosX, this.monPosY, null, null);
            }
        }
        if (this.oldGameInfo != null) {
            this.drawMenuElements(g, this.oldGameInfo);
        }
    }

    private void checkActivations(D_GameInfo gameInfo) {
        if (gameInfo.gameRunning) {
            this.butt_run.setEnabled(true);
            this.butt_loadArena.setEnabled(false);
            this.butt_addCPlayer.setEnabled(false);
            this.butt_addHPlayer.setEnabled(false);
            this.butt_stop.setEnabled(true);
            int i = 0;
            while (i < gameInfo.playerData.length) {
                this.butt_rmPlayer[i].setEnabled(false);
                ++i;
            }
        } else {
            this.butt_loadArena.setEnabled(true);
            this.butt_addCPlayer.setEnabled(true);
            this.butt_addHPlayer.setEnabled(true);
            if (gameInfo.playerData.length > 0) {
                this.butt_run.setEnabled(true);
            } else {
                this.butt_run.setEnabled(false);
            }
            this.butt_stop.setEnabled(false);
            int i = 0;
            while (i < gameInfo.playerData.length) {
                this.butt_rmPlayer[i].setEnabled(true);
                ++i;
            }
            i = gameInfo.playerData.length;
            while (i < 10) {
                this.butt_rmPlayer[i].setEnabled(false);
                ++i;
            }
        }
        this.butt_arena.setEnabled(true);
        this.butt_player.setEnabled(true);
        this.butt_options.setEnabled(true);
    }

    public void setActive(boolean active) {
        if (active) {
            this.checkActivations(this.oldGameInfo);
        } else {
            this.butt_run.setEnabled(false);
            this.butt_stop.setEnabled(false);
            this.butt_loadArena.setEnabled(false);
            this.butt_addCPlayer.setEnabled(false);
            this.butt_addHPlayer.setEnabled(false);
            int i = 0;
            while (i < 10) {
                if (i < this.playerOrd.length) {
                    this.butt_rmPlayer[i].setEnabled(false);
                }
                ++i;
            }
        }
    }

    public void update(D_GameInfo gameInfo, C_Human[] humanPlayer) {
        this.humans = humanPlayer;
        this.humanPlayerC = this.humans != null ? this.humans.length : 0;
        if (!(gameInfo.gameRunning || gameInfo.level == null || this.oldGameInfo != null && this.oldGameInfo.level != null && gameInfo.level.fileName.compareTo(this.oldGameInfo.level.fileName) == 0)) {
            C_GraphixTools.loadCustomLevelGraphix(gameInfo.level.fileName);
        }
        if (gameInfo.level == null) {
            this.actGraphics.fillRect(332, 130, 450, 450);
        } else if (this.arena[this.actArena] == null || this.arena[this.actArena].sizeX != gameInfo.level.width || this.arena[this.actArena].sizeY != gameInfo.level.height) {
            this.arena[this.actArena] = new Gr_Arena(gameInfo.level.playField, gameInfo);
            this.diff = new Gr_DiffArena(this.arena[this.actArena]);
            this.img_arena = C_GraphixTools.createBackBufferVI(this.arena[this.actArena].sizeX * 6, this.arena[this.actArena].sizeY * 6);
            this.gr_arena = this.img_arena.getGraphics();
            this.monPosX = 332 + (450 - this.arena[this.actArena].sizeX * 6) / 2;
            this.monPosY = 130 + (450 - this.arena[this.actArena].sizeY * 6) / 2;
            this.monWidth = this.arena[this.actArena].sizeX * 6;
            this.monHeight = this.arena[this.actArena].sizeY * 6;
            this.actGraphics.fillRect(332, 130, 450, this.monPosY - 130);
            this.actGraphics.fillRect(332, this.monPosY, this.monPosX - 332, this.monHeight);
            this.actGraphics.fillRect(this.monPosX + this.monWidth, this.monPosY, this.monPosX - 332, this.monHeight);
            this.actGraphics.fillRect(332, this.monPosY + this.monHeight, 450, this.monPosY - 130);
            this.updateGraphics();
        } else {
            if (this.arena[1 - this.actArena] == null || this.arena[1 - this.actArena].sizeX != gameInfo.level.width || this.arena[1 - this.actArena].sizeY != gameInfo.level.height) {
                this.arena[1 - this.actArena] = new Gr_Arena(gameInfo.level.playField, gameInfo);
            } else {
                this.arena[1 - this.actArena].update(gameInfo.level.playField, gameInfo);
            }
            this.diff.update(this.arena[this.actArena], this.arena[1 - this.actArena]);
            this.actArena = 1 - this.actArena;
            this.updateGraphics();
        }
        if (this.oldGameInfo != null && (this.oldGameInfo.gameRunning != gameInfo.gameRunning || gameInfo.playerData.length != this.oldGameInfo.playerData.length)) {
            this.checkActivations(gameInfo);
        }
        this.lastPlayerC = gameInfo.playerData.length;
        this.updatePlayer(gameInfo);
        this.updatePlayerTab(gameInfo);
        this.drawMenuElements(this.actGraphics, gameInfo);
        if (this.oldGameInfo == null) {
            this.oldGameInfo = new D_GameInfo(gameInfo);
        } else {
            this.oldGameInfo.copyOnMe(gameInfo);
        }
        this.debugMon.sayBuffered();
    }

    public void beep() {
        System.out.println("BEEP!!!");
    }

    public void beep(String str) {
        System.out.println("BEEP: " + str);
    }

    public void beep(int i) {
        System.out.println("BEEP: " + i);
    }

    private class Gr_Arena {
        protected char[][] field;
        protected int sizeX;
        protected int sizeY;

        public Gr_Arena(int size_y, int size_x, char clearByte) {
            this(size_y, size_x);
            int i = 0;
            while (i < size_y) {
                int j = 0;
                while (j < size_x) {
                    this.field[i][j] = clearByte;
                    ++j;
                }
                ++i;
            }
        }

        public Gr_Arena(int size_y, int size_x) {
            this.field = new char[size_y][size_x];
            this.sizeX = size_x;
            this.sizeY = size_y;
        }

        public Gr_Arena(char[][] newField, D_GameInfo gameInfo) {
            this.sizeX = newField[0].length;
            this.sizeY = newField.length;
            this.field = new char[this.sizeY][this.sizeX];
            this.convert(this.field, newField, gameInfo);
        }

        public void fill(char clearByte) {
            int i = 0;
            while (i < this.sizeY) {
                int j = 0;
                while (j < this.sizeX) {
                    this.field[i][j] = clearByte;
                    ++j;
                }
                ++i;
            }
        }

        public void update(char[][] src, D_GameInfo gameInfo) {
            this.convert(this.field, src, gameInfo);
        }

        public void update(char[][] src) {
            int i = 0;
            while (i < this.sizeY) {
                int j = 0;
                while (j < this.sizeX) {
                    this.field[i][j] = src[i][j];
                    ++j;
                }
                ++i;
            }
        }

        private void convert(char[][] fieldDest, char[][] fieldSrc, D_GameInfo gameInfo) {
            int lenY = fieldSrc.length;
            int lenX = fieldSrc[0].length;
            D_PlayerData[] pd = gameInfo.playerData;
            int i = 0;
            while (i < lenY) {
                int prev_i = (i - 1 + lenY) % lenY;
                int succ_i = (i + 1) % lenY;
                int j = 0;
                while (j < lenX) {
                    int prev_j = (j - 1 + lenX) % lenX;
                    int succ_j = (j + 1) % lenX;
                    fieldDest[i][j] = '\u0000';
                    if (fieldSrc[i][j] == '#') {
                        if (fieldSrc[i][prev_j] != '#') {
                            fieldDest[i][j] = 12;
                        } else if (fieldSrc[i][succ_j] != '#') {
                            fieldDest[i][j] = 6;
                        }
                        if (fieldSrc[prev_i][j] != '#') {
                            fieldDest[i][j] = fieldDest[i][j] == '\f' ? 2 : (fieldDest[i][j] == '\u0006' ? 5 : 3);
                        } else if (fieldSrc[succ_i][j] != '#') {
                            fieldDest[i][j] = fieldDest[i][j] == '\f' ? 11 : (fieldDest[i][j] == '\u0006' ? 8 : 9);
                        } else if (fieldDest[i][j] == '\u0000') {
                            fieldDest[i][j] = fieldSrc[succ_i][succ_j] != '#' ? 7 : (fieldSrc[succ_i][prev_j] != '#' ? 10 : (fieldSrc[prev_i][succ_j] != '#' ? 4 : (fieldSrc[prev_i][prev_j] != '#' ? 1 : 35)));
                        }
                    } else {
                        fieldDest[i][j] = fieldSrc[i][j] == 'A' ? (fieldSrc[prev_i][j] != 'A' && fieldSrc[i][prev_j] != 'A' ? (gameInfo.gameTime >= gameInfo.exitTime ? 23 : 65) : 0) : fieldSrc[i][j];
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < pd.length) {
                if (pd[i].length > 0 && pd[i].snakeStatus == 0) {
                    this.field[pd[i].headPos.y][pd[i].headPos.x] = (char)(i + 13);
                }
                ++i;
            }
        }

        public String toString() {
            StringBuffer ret = new StringBuffer(this.sizeY * this.sizeX);
            int i = 0;
            while (i < this.sizeY) {
                int j = 0;
                while (j < this.sizeX) {
                    ret.append((char)(this.field[i][j] + 32));
                    ++j;
                }
                ret.append('\n');
                ++i;
            }
            return ret.toString();
        }
    }

    private class Gr_DiffArena
    extends Gr_Arena {
        public Gr_DiffArena(Gr_Arena a1, Gr_Arena a2) {
            super(a1.sizeY, a1.sizeX, '.');
            this.update(a1, a2);
        }

        public Gr_DiffArena(Gr_Arena a) {
            super(a.sizeY, a.sizeX);
            int i = 0;
            while (i < a.sizeY) {
                int j = 0;
                while (j < a.sizeX) {
                    this.field[i][j] = a.field[i][j];
                    ++j;
                }
                ++i;
            }
        }

        public void update(Gr_Arena a1, Gr_Arena a2) {
            int i = a1.sizeY - 1;
            while (i >= 0) {
                int j = a1.sizeX - 1;
                while (j >= 0) {
                    this.field[i][j] = a1.field[i][j] == a2.field[i][j] ? (char)'\u0000' : a2.field[i][j];
                    --j;
                }
                --i;
            }
        }
    }
}

