/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.control.GaphixStuff;

import de.farafin.snEADy.control.GaphixStuff.C_GraphixData;
import de.farafin.snEADy.control.GaphixStuff.C_GraphixTools;
import de.farafin.snEADy.control.GaphixStuff.GrTextArea;
import de.farafin.snEADy.control.GaphixStuff.I_GraphixConstants;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.VolatileImage;

public class GrSelCanvas
extends GrTextArea {
    protected String[] list;
    private VolatileImage img_list;
    private VolatileImage img_listSel;
    protected int selected = -1;

    public GrSelCanvas(int x, int y, int width, int height, String[] itemList) {
        super(x, y, width, height, 'l');
        this.list = itemList;
        this.img_list = C_GraphixTools.createBackBufferVI(this.showW, this.showH);
        this.img_listSel = C_GraphixTools.createBackBufferVI(this.showW, this.showH);
        this.lines = this.showH / 14;
        this.drawFileList(this.img_list, I_GraphixConstants.COL_BLUE1, 0);
        this.drawFileList(this.img_listSel, I_GraphixConstants.COL_BLUE2, 4);
        this.addMouseListener(new MouseListener(){

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                if (GrSelCanvas.this.list == null) {
                    return;
                }
                int sel = (e.getY() - GrSelCanvas.this.borderW) / 14;
                if (sel != GrSelCanvas.this.selected && sel < GrSelCanvas.this.list.length) {
                    GrSelCanvas.this.selected = sel;
                    GrSelCanvas.this.action();
                    GrSelCanvas.this.repaint();
                }
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                if (GrSelCanvas.this.list == null) {
                    return;
                }
                int sel = (e.getY() - GrSelCanvas.this.borderW) / 14;
                if (sel != GrSelCanvas.this.selected && sel < GrSelCanvas.this.list.length) {
                    GrSelCanvas.this.selected = sel;
                    GrSelCanvas.this.repaint();
                }
            }

            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    public void updateList(String[] newL) {
        this.list = null;
        this.list = newL;
        this.repaint();
    }

    private String[] genListStrings(String[] list) {
        int l = list.length;
        int maxL = this.w / 8;
        String[] ret = new String[l];
        int i = 0;
        while (i < l) {
            int sl = list[i].lastIndexOf(46);
            ret[i] = sl > maxL ? String.valueOf(list[i].substring(0, maxL - 3)) + "..." : list[i].substring(0, sl);
            ++i;
        }
        return ret;
    }

    private void drawFileList(VolatileImage img, Color col, int fontID) {
        Graphics g = img.getGraphics();
        String[] listStr = null;
        if (this.list != null) {
            listStr = this.genListStrings(this.list);
        }
        do {
            int i = 0;
            if (img.validate(C_GraphixData.gc) == 2) {
                img = C_GraphixTools.createBackBufferVI(this.showW, this.showH);
                g.dispose();
                g = img.getGraphics();
            }
            g.setColor(col);
            g.fillRect(0, 0, this.showW, this.showH);
            if (this.list == null) continue;
            while (!img.contentsLost() && i < this.lines && i < this.list.length) {
                C_GraphixTools.drawBitmapString(listStr[this.showedLinesStart + i], 0, i * 14, 4, g, 108, fontID);
                ++i;
            }
        } while (img.contentsLost());
    }

    private void drawList(Graphics g) {
        if (this.img_list.validate(C_GraphixData.gc) != 0) {
            this.drawFileList(this.img_list, I_GraphixConstants.COL_BLUE1, 0);
        }
        g.drawImage(this.img_list, this.borderW, this.borderW, this.w - this.borderW, this.borderW + this.selected * 14, 0, 0, this.showW, this.selected * 14, null);
        if (this.img_listSel.validate(C_GraphixData.gc) != 0) {
            this.drawFileList(this.img_list, I_GraphixConstants.COL_BLUE1, 0);
        }
        g.drawImage(this.img_listSel, this.borderW, this.borderW + this.selected * 14, this.w - this.borderW, this.borderW + (this.selected + 1) * 14, 0, this.selected * 14, this.showW, (this.selected + 1) * 14, null);
        if (this.img_list.validate(C_GraphixData.gc) != 0) {
            this.drawFileList(this.img_list, I_GraphixConstants.COL_BLUE1, 0);
        }
        g.drawImage(this.img_list, this.borderW, this.borderW + (this.selected + 1) * 14, this.w - this.borderW, this.h - this.borderW, 0, (this.selected + 1) * 14, this.showW, this.showH, null);
    }

    public void updateDSelect(int newDSel) {
        this.selected += this.showedLinesStart - newDSel;
        this.showedLinesStart = newDSel;
        this.drawFileList(this.img_list, I_GraphixConstants.COL_BLUE1, 0);
        this.drawFileList(this.img_listSel, I_GraphixConstants.COL_BLUE2, 4);
        this.drawList(this.getGraphics());
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.drawList(g);
    }

    public void repaint() {
        this.paint(this.getGraphics());
    }
}

