/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.control.GaphixStuff;

import de.farafin.snEADy.control.GaphixStuff.C_GraphixData;
import de.farafin.snEADy.control.GaphixStuff.GrSelCanvas;
import de.farafin.snEADy.control.GaphixStuff.GrTextArea;
import de.farafin.snEADy.control.GaphixStuff.I_GraphixConstants;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;

public class GrScroll
extends Canvas
implements I_GraphixConstants {
    private final int SCROLL_NONE = 0;
    private final int SCROLL_UP = 1;
    private final int SCROLL_DOWN = 2;
    private final int SCROLL_BAR = 3;
    private int sState = 0;
    private int w;
    private int h;
    private int max;
    private int range;
    private float pos = 0.0f;
    private int dy_bar;
    private int dMover = -1;
    GrTextArea selectC;
    private BufferedImage img_scroll;

    protected GrScroll(int x, int y, int width, int height, GrSelCanvas selC) {
        this.selectC = selC;
        this.dy_bar = C_GraphixData.menuImagesO[19].getHeight();
        this.w = width;
        this.h = height;
        this.max = selC.list != null ? selC.list.length : 0;
        this.range = selC.lines;
        this.setBounds(x, y, this.w, this.h);
        this.img_scroll = C_GraphixData.gc.createCompatibleImage(this.w, this.h);
        this.drawScroll();
        this.addMouseListener(new MouseListener(){

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                int y = e.getY();
                if (y < GrScroll.this.dy_bar) {
                    GrScroll.this.sState = 1;
                    if (GrScroll.this.pos > 0.0f) {
                        GrScroll grScroll = GrScroll.this;
                        grScroll.pos = grScroll.pos - 1.0f;
                    }
                } else if (y > GrScroll.this.h - GrScroll.this.dy_bar) {
                    GrScroll.this.sState = 2;
                    if (GrScroll.this.pos < (float)(GrScroll.this.max - GrScroll.this.range)) {
                        GrScroll grScroll = GrScroll.this;
                        grScroll.pos = grScroll.pos + 1.0f;
                    }
                } else {
                    int absY = GrScroll.this.getMoverAbsPos();
                    int absH = GrScroll.this.getMoverAbsHeight();
                    if (y < absY) {
                        GrScroll grScroll = GrScroll.this;
                        grScroll.pos = grScroll.pos - (float)GrScroll.this.range;
                        if (GrScroll.this.pos < 0.0f) {
                            GrScroll.this.pos = 0.0f;
                        }
                    } else if (y > absY + absH) {
                        GrScroll grScroll = GrScroll.this;
                        grScroll.pos = grScroll.pos + (float)GrScroll.this.range;
                        if (GrScroll.this.pos > (float)(GrScroll.this.max - GrScroll.this.range)) {
                            GrScroll.this.pos = GrScroll.this.max - GrScroll.this.range;
                        }
                    } else {
                        GrScroll.this.dMover = y - absY;
                    }
                    GrScroll.this.sState = 3;
                }
                GrScroll.this.selectC.updateDSelect((int)GrScroll.this.pos);
                GrScroll.this.drawScroll();
                GrScroll.this.repaint();
            }

            public void mouseReleased(MouseEvent e) {
                GrScroll.this.sState = 0;
                GrScroll.this.dMover = -1;
                GrScroll.this.drawScroll();
                GrScroll.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                int y = e.getY();
                if (GrScroll.this.dMover >= 0) {
                    int absH = GrScroll.this.getMoverAbsHeight();
                    float oneStep = (float)(GrScroll.this.max - GrScroll.this.range) / (float)(GrScroll.this.h - 2 * GrScroll.this.dy_bar - absH);
                    GrScroll.this.pos = (float)(y - GrScroll.this.dy_bar - GrScroll.this.dMover) * oneStep;
                    if (GrScroll.this.pos > (float)(GrScroll.this.max - GrScroll.this.range)) {
                        GrScroll.this.pos = GrScroll.this.max - GrScroll.this.range;
                    }
                    if (GrScroll.this.pos < 0.0f) {
                        GrScroll.this.pos = 0.0f;
                    }
                    GrScroll.this.selectC.updateDSelect((int)GrScroll.this.pos);
                    GrScroll.this.drawScroll();
                    GrScroll.this.repaint();
                }
            }

            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    private final int getMoverAbsPos() {
        return this.max == 0 ? this.dy_bar : (int)((float)this.dy_bar + this.pos * (float)(this.h - 2 * this.dy_bar) / (float)this.max);
    }

    private final int getMoverAbsHeight() {
        if (this.max == 0) {
            return this.h - 2 * this.dy_bar;
        }
        float tmp = (float)this.range / (float)this.max;
        if (tmp > 1.0f) {
            return this.h - 2 * this.dy_bar;
        }
        return (int)(tmp * (float)(this.h - 2 * this.dy_bar));
    }

    private void drawScroll() {
        int upSrcX = 0;
        int downSrcX = 2 * this.w;
        int imgScrHeight = C_GraphixData.menuImagesO[20].getHeight();
        int scrollSegC = (this.h - 2 * this.dy_bar) / imgScrHeight;
        if (this.sState == 1) {
            upSrcX = this.w;
        } else if (this.sState == 2) {
            downSrcX = 3 * this.w;
        }
        Graphics g = this.img_scroll.getGraphics();
        g.setColor(I_GraphixConstants.COL_GREY1);
        g.drawImage(C_GraphixData.menuImagesO[19], 0, 0, this.w, this.dy_bar, upSrcX, 0, upSrcX + this.w, this.dy_bar, null);
        g.drawImage(C_GraphixData.menuImagesO[20], 0, this.dy_bar, this.w, this.dy_bar + imgScrHeight, 0, 0, this.w, imgScrHeight, null);
        int i = 1;
        while (i < scrollSegC) {
            g.drawImage(C_GraphixData.menuImagesO[20], 0, this.dy_bar + i * imgScrHeight, this.w, this.dy_bar + (i + 1) * imgScrHeight, this.w, 0, this.w * 2, imgScrHeight, null);
            ++i;
        }
        g.drawImage(C_GraphixData.menuImagesO[20], 0, this.h - this.dy_bar - imgScrHeight, this.w, this.h - this.dy_bar, 2 * this.w, 0, 3 * this.w, imgScrHeight, null);
        g.drawImage(C_GraphixData.menuImagesO[19], 0, this.h - this.dy_bar, this.w, this.h, downSrcX, 0, downSrcX + this.w, this.dy_bar, null);
        g.fillRect(4, 4 + this.getMoverAbsPos(), this.w - 8, this.getMoverAbsHeight() - 8);
    }

    public void paint(Graphics g) {
        g.drawImage(this.img_scroll, 0, 0, null);
    }

    public void repaint() {
        this.getGraphics().drawImage(this.img_scroll, 0, 0, null);
    }
}

