/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.communication;

public final class RingVector {
    private int headIndex = 0;
    private int definedLength = 0;
    private Object[] dataArray = null;

    public RingVector() {
        this.dataArray = new Object[10];
    }

    public RingVector(int size) {
        this.dataArray = new Object[size];
    }

    private void doubleSize() {
        Object[] newArray = new Object[this.dataArray.length << 1];
        int i = 0;
        while (i < this.definedLength) {
            newArray[i] = this.dataArray[(i + this.headIndex) % this.definedLength];
            ++i;
        }
        this.headIndex = 0;
        this.dataArray = newArray;
    }

    public void addLast(Object obj) {
        if (this.definedLength == this.dataArray.length) {
            this.doubleSize();
        }
        this.dataArray[(this.headIndex + this.definedLength) % this.dataArray.length] = obj;
        ++this.definedLength;
    }

    public void addFirst(Object obj) {
        if (this.definedLength == this.dataArray.length) {
            this.doubleSize();
        }
        --this.headIndex;
        if (this.headIndex < 0) {
            this.headIndex += this.dataArray.length;
        }
        this.dataArray[this.headIndex] = obj;
        ++this.definedLength;
    }

    public Object remLast() {
        if (this.definedLength <= 0) {
            return null;
        }
        --this.definedLength;
        Object obj = this.dataArray[(this.headIndex + this.definedLength) % this.dataArray.length];
        this.dataArray[(this.headIndex + this.definedLength) % this.dataArray.length] = null;
        return obj;
    }

    public Object remFirst() {
        if (this.definedLength <= 0) {
            return null;
        }
        Object obj = this.dataArray[this.headIndex];
        this.dataArray[(this.headIndex + this.definedLength) % this.dataArray.length] = null;
        this.headIndex = (this.headIndex + 1) % this.dataArray.length;
        --this.definedLength;
        return obj;
    }

    public Object replaceAt(int i, Object obj) {
        if (this.definedLength <= 0) {
            return null;
        }
        Object old = this.dataArray[(this.headIndex + i) % this.dataArray.length];
        this.dataArray[(this.headIndex + i) % this.dataArray.length] = obj;
        return old;
    }

    public Object moveLastToFirst() {
        if (this.definedLength <= 0) {
            return null;
        }
        Object obj = this.remLast();
        this.addFirst(obj);
        return obj;
    }

    public Object moveFirstToLast() {
        if (this.definedLength <= 0) {
            return null;
        }
        Object obj = this.remFirst();
        this.addLast(obj);
        return obj;
    }

    public Object getElementAt(int i) {
        if (this.definedLength <= 0 || this.definedLength < i) {
            return null;
        }
        return this.dataArray[(this.headIndex + i) % this.dataArray.length];
    }

    public Object getFirst() {
        return this.getElementAt(0);
    }

    public Object getLast() {
        return this.getElementAt(this.definedLength - 1);
    }

    public int size() {
        return this.definedLength;
    }

    public void clear() {
        int i = 0;
        while (i < this.dataArray.length) {
            this.dataArray[i] = null;
            ++i;
        }
        this.definedLength = 0;
        this.headIndex = 0;
    }

    public Object[] toArray() {
        Object[] newArray = new Object[this.dataArray.length];
        int i = 0;
        while (i < this.definedLength) {
            newArray[i] = this.dataArray[(i + this.headIndex) % this.definedLength];
            ++i;
        }
        return newArray;
    }

    public Object clone() {
        RingVector ring = new RingVector(this.dataArray.length);
        int i = 0;
        while (i < this.definedLength) {
            ring.dataArray[i] = this.dataArray[(i + this.headIndex) % this.definedLength];
            ++i;
        }
        ring.definedLength = this.definedLength;
        return ring;
    }
}

