/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.communication;

import de.farafin.snEADy.GameParameter;
import de.farafin.snEADy.communication.D_Vec2D;
import de.farafin.snEADy.communication.I_Constants;
import de.farafin.snEADy.communication.I_PlayFieldConstants;

public final class D_PlayerData
implements I_PlayFieldConstants,
I_Constants {
    public String name;
    public String picFileName;
    public long nextUpdateTime;
    public boolean snakeUpdated = false;
    public int lengthChanged = 0;
    public int delayChanged = 0;
    public long waitCycles = 1L;
    public int killPoints = 0;
    public int turnDirection = 0;
    public boolean move = false;
    public int watchDirection = 0;
    public char ownChar = (char)48;
    public int length = 1;
    public D_Vec2D headPos = null;
    public int snakeStatus = 0;
    public Class playerClass = null;
    public long lastCalculatedMemUsage = 0L;

    public D_PlayerData() {
        this.name = "";
        this.picFileName = "";
        this.nextUpdateTime = 0L;
        this.waitCycles = 1L;
        this.killPoints = 0;
        this.turnDirection = 0;
        this.watchDirection = 0;
        this.ownChar = (char)48;
        this.length = 1;
        this.headPos = new D_Vec2D();
        this.playerClass = null;
        this.snakeUpdated = false;
        this.lengthChanged = 0;
        this.delayChanged = 0;
        this.lastCalculatedMemUsage = 0L;
    }

    public D_PlayerData(String name, String picFileName, long nextupdateTime, long waitCycles, int killPoints, int turnDirection, int watchDirection, char ownChar, int length, D_Vec2D headPos, Class playerClass) {
        this.name = name;
        this.picFileName = picFileName;
        this.nextUpdateTime = nextupdateTime;
        this.waitCycles = waitCycles;
        this.killPoints = killPoints;
        this.turnDirection = turnDirection;
        this.watchDirection = watchDirection;
        this.ownChar = ownChar;
        this.length = length;
        this.headPos = (D_Vec2D)headPos.clone();
        this.playerClass = playerClass;
        this.snakeUpdated = false;
        this.lengthChanged = 0;
        this.delayChanged = 0;
        this.lastCalculatedMemUsage = 0L;
    }

    public D_PlayerData(int playerNo, Class playerClass, GameParameter params) {
        this(playerNo, playerClass, playerClass.getName(), params);
    }

    public D_PlayerData(int playerNo, Class playerClass, String name, GameParameter params) {
        this.name = name;
        this.picFileName = playerClass.getName();
        this.nextUpdateTime = params.getInit_move_delay();
        this.waitCycles = params.getInit_move_delay();
        this.killPoints = 0;
        this.turnDirection = 0;
        this.watchDirection = 0;
        this.ownChar = (char)(48 + playerNo);
        this.length = 1;
        this.headPos = new D_Vec2D();
        this.playerClass = playerClass;
        this.snakeUpdated = false;
        this.lengthChanged = 0;
        this.delayChanged = 0;
        this.lastCalculatedMemUsage = 0L;
    }

    public D_PlayerData(D_PlayerData pData) {
        this.name = pData.name;
        this.picFileName = pData.picFileName;
        this.nextUpdateTime = pData.nextUpdateTime;
        this.waitCycles = pData.waitCycles;
        this.killPoints = pData.killPoints;
        this.turnDirection = pData.turnDirection;
        this.watchDirection = pData.watchDirection;
        this.ownChar = pData.ownChar;
        this.length = pData.length;
        this.snakeStatus = pData.snakeStatus;
        this.headPos = (D_Vec2D)pData.headPos.clone();
        this.playerClass = pData.playerClass;
        this.snakeUpdated = pData.snakeUpdated;
        this.lengthChanged = pData.lengthChanged;
        this.delayChanged = pData.delayChanged;
        this.lastCalculatedMemUsage = pData.lastCalculatedMemUsage;
    }

    public Object clone() {
        D_PlayerData playerData = new D_PlayerData(this);
        return playerData;
    }

    public void copyOnMe(D_PlayerData plData) {
        this.name = plData.name;
        this.picFileName = plData.picFileName;
        this.nextUpdateTime = plData.nextUpdateTime;
        this.waitCycles = plData.waitCycles;
        this.killPoints = plData.killPoints;
        this.turnDirection = plData.turnDirection;
        this.watchDirection = plData.watchDirection;
        this.ownChar = plData.ownChar;
        this.length = plData.length;
        this.snakeStatus = plData.snakeStatus;
        this.headPos.copyOnMe(plData.headPos);
        this.playerClass = plData.playerClass;
        this.snakeUpdated = plData.snakeUpdated;
        this.lengthChanged = plData.lengthChanged;
        this.delayChanged = plData.delayChanged;
        this.lastCalculatedMemUsage = plData.lastCalculatedMemUsage;
    }
}

