/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy.communication;

import de.farafin.snEADy.communication.D_Vec2D;
import de.farafin.snEADy.communication.I_PlayFieldConstants;

public final class D_Level
implements I_PlayFieldConstants {
    public String fileName = "";
    public String name = "";
    public String comment = "";
    public String autor = "";
    public int height = 0;
    public int width = 0;
    public char[][] playField = null;
    public int maxPlayer = 0;

    public D_Level() {
        this.fileName = "";
        this.name = "";
        this.height = 0;
        this.width = 0;
        this.playField = null;
        this.maxPlayer = 0;
    }

    public D_Level(String fileName, String name, String autor, int height, int width, char[][] playField, int maxPlayer) {
        int i = 0;
        this.fileName = fileName;
        this.name = name;
        this.autor = autor;
        this.height = height;
        this.width = width;
        this.playField = new char[playField.length][];
        i = 0;
        while (i < playField.length) {
            this.playField[i] = (char[])playField[i].clone();
            ++i;
        }
        this.maxPlayer = maxPlayer;
    }

    public D_Level(String fileName, String name, String autor, char[][] playField, int maxPlayer) {
        int i = 0;
        this.fileName = fileName;
        this.name = name;
        this.autor = autor;
        this.height = playField.length;
        this.width = playField[0].length;
        this.playField = new char[playField.length][];
        i = 0;
        while (i < playField.length) {
            this.playField[i] = (char[])playField[i].clone();
            ++i;
        }
        this.maxPlayer = maxPlayer;
    }

    public D_Level(D_Level level) {
        boolean i = false;
        this.fileName = level.fileName;
        this.name = level.name;
        this.autor = level.autor;
        this.height = level.height;
        this.width = level.width;
        this.playField = level.playField;
        this.maxPlayer = level.maxPlayer;
    }

    public D_Level(String name, int height, int width, char[][] playField, int maxPlayer) {
        this.fileName = "";
        this.name = name;
        this.autor = "";
        this.height = height;
        this.width = width;
        this.playField = playField;
        this.maxPlayer = maxPlayer;
    }

    public Object clone() {
        D_Level level = new D_Level();
        int i = 0;
        level.fileName = this.fileName;
        level.name = this.name;
        level.autor = this.autor;
        level.height = this.height;
        level.width = this.width;
        level.playField = new char[this.playField.length][];
        i = 0;
        while (i < this.playField.length) {
            level.playField[i] = (char[])this.playField[i].clone();
            ++i;
        }
        level.maxPlayer = this.maxPlayer;
        return level;
    }

    public String toString() {
        String result = null;
        result = "Name: " + this.name + "\n";
        result = String.valueOf(result) + "Comment: " + this.comment + "\n";
        result = String.valueOf(result) + "Autor: " + this.autor + "\n";
        result = String.valueOf(result) + "Size: " + this.height + "x" + this.width + "\n";
        result = String.valueOf(result) + "MaxPlayer: " + this.maxPlayer + "\n";
        result = String.valueOf(result) + "PlayField:\n";
        int i = 0;
        while (i < this.height) {
            result = String.valueOf(result) + String.valueOf(this.playField[i]) + "\n";
            ++i;
        }
        return result;
    }

    protected boolean isFieldOfLevel(int y, int x) {
        return y >= 0 && this.height >= y && x >= 0 && this.width >= x;
    }

    protected boolean isFieldOfLevel(D_Vec2D vec) {
        return this.isFieldOfLevel(vec.y, vec.x);
    }

    public char[][] getPlayFieldCopy() {
        char[][] pField = new char[this.playField.length][];
        int i = 0;
        while (i < pField.length) {
            pField[i] = new char[this.playField[i].length];
            ++i;
        }
        i = 0;
        while (i < pField.length) {
            int j = 0;
            while (j < pField[i].length) {
                pField[i][j] = this.playField[i][j];
                ++j;
            }
            ++i;
        }
        return pField;
    }

    public char getCharOf(int y, int x) {
        if (!this.isFieldOfLevel(y, x)) {
            return '?';
        }
        return this.playField[y][x];
    }

    public char getCharOf(D_Vec2D vec) {
        return this.getCharOf(vec.y, vec.x);
    }

    public char[] getLineCopy(int l) {
        char[] line = new char[this.height];
        if (l < 0 || l > this.height - 1) {
            return null;
        }
        int i = 0;
        while (i < this.height) {
            line[i] = this.playField[l][i];
            ++i;
        }
        return line;
    }

    public char[] getRowCopy(int r) {
        char[] row = new char[this.width];
        if (r < 0 || r > this.width - 1) {
            return null;
        }
        int i = 0;
        while (i < this.width) {
            row[i] = this.playField[i][r];
            ++i;
        }
        return row;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMaxPlayer() {
        return this.maxPlayer;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isFree(int y, int x) {
        if (!this.isFieldOfLevel(y, x)) {
            return false;
        }
        return this.playField[y][x] == '.';
    }

    public boolean isFree(D_Vec2D vec) {
        return this.isFree(vec.y, vec.x);
    }

    public boolean isWall(int y, int x) {
        if (!this.isFieldOfLevel(y, x)) {
            return false;
        }
        return this.playField[y][x] == '#';
    }

    public boolean isWall(D_Vec2D vec) {
        return this.isWall(vec.y, vec.x);
    }

    public boolean isSnake(int y, int x) {
        if (!this.isFieldOfLevel(y, x)) {
            return false;
        }
        return this.playField[y][x] >= '0' && this.playField[y][x] <= '9';
    }

    public boolean isSnake(D_Vec2D vec) {
        return this.isSnake(vec.y, vec.x);
    }

    public boolean isGoody(int y, int x) {
        if (!this.isFieldOfLevel(y, x)) {
            return false;
        }
        return this.playField[y][x] >= 'b' && this.playField[y][x] <= 'z';
    }

    public boolean isGoody(D_Vec2D vec) {
        return this.isGoody(vec.y, vec.x);
    }

    public boolean isSpecialField(int y, int x) {
        if (!this.isFieldOfLevel(y, x)) {
            return false;
        }
        return this.playField[y][x] >= 'A' && this.playField[y][x] <= 'Z';
    }

    public boolean isSpecialField(D_Vec2D vec) {
        return this.isSpecialField(vec.y, vec.x);
    }

    public void copyOnMe(D_Level level) {
        this.fileName = level.fileName;
        if (this.height != level.height || this.width != level.width) {
            this.playField = new char[level.height][level.width];
        }
        this.height = level.height;
        this.width = level.width;
        this.maxPlayer = level.maxPlayer;
        this.name = level.name;
        this.comment = level.comment;
        this.autor = level.autor;
        int i = 0;
        while (i < this.height) {
            int j = 0;
            while (j < this.width) {
                this.playField[i][j] = level.playField[i][j];
                ++j;
            }
            ++i;
        }
    }
}

