/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy;

import de.farafin.snEADy.GameParameter;
import de.farafin.snEADy.M_Main;
import de.farafin.snEADy.communication.D_GameInfo;
import de.farafin.snEADy.communication.D_PlayerData;
import de.farafin.snEADy.communication.D_RecoverData;
import de.farafin.snEADy.communication.I_Constants;
import de.farafin.snEADy.inOut.C_LogFileWriter;
import de.farafin.snEADy.player.GameInfo;
import de.farafin.snEADy.player.LevelInfo;
import de.farafin.snEADy.player.OwnSnakeInfo;
import de.farafin.snEADy.player.Player;
import de.farafin.snEADy.player.SnakeInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Random;

public final class M_PlayerHandler
implements I_Constants {
    private Player[] playerInstances = null;
    private int lastPlayer = -1;
    private PlayerRun playerRun;
    private Thread playerThread = null;
    private static M_PlayerHandler instance;
    private boolean imergencyPaused = false;
    private final PlayerInfo playerInfo;
    private long playerCalculationtime = 0L;
    private C_LogFileWriter playerLog = null;
    private Random randNumber = null;
    private long nextSizeControllTime = 0L;
    private int nextMemCheck = 0;
    private final GameParameter parameter = M_Main.getInstance().getParameter();

    private M_PlayerHandler() {
        this.playerInfo = new PlayerInfo();
    }

    private void reGenPlayerInfo(int playerIndex, D_GameInfo gameInfo) {
        int i;
        int j = 0;
        if (this.playerInfo.playerSnakeInfo == null || this.playerInfo.playerSnakeInfo.length != gameInfo.playerData.length - 1) {
            this.playerInfo.playerSnakeInfo = new SnakeInfo[this.playerInstances.length - 1];
            i = 0;
            while (i < this.playerInfo.playerSnakeInfo.length) {
                this.playerInfo.playerSnakeInfo[i] = new SnakeInfo();
                ++i;
            }
        }
        i = 0;
        while (i < this.playerInfo.playerSnakeInfo.length + 1) {
            if (i == playerIndex) {
                j = 1;
            } else {
                this.playerInfo.playerSnakeInfo[i - j].playerName = gameInfo.playerData[i].name;
                this.playerInfo.playerSnakeInfo[i - j].snakeChar = gameInfo.playerData[i].ownChar;
                this.playerInfo.playerSnakeInfo[i - j].headPosLine = gameInfo.playerData[i].headPos.y;
                this.playerInfo.playerSnakeInfo[i - j].headPosRow = gameInfo.playerData[i].headPos.x;
                this.playerInfo.playerSnakeInfo[i - j].points = gameInfo.playerData[i].killPoints;
                this.playerInfo.playerSnakeInfo[i - j].snakeLength = gameInfo.playerData[i].length;
                this.playerInfo.playerSnakeInfo[i - j].snakeStatus = gameInfo.playerData[i].snakeStatus;
                this.playerInfo.playerSnakeInfo[i - j].waitCycles = gameInfo.playerData[i].waitCycles;
            }
            ++i;
        }
        if (this.playerInfo.playerOwnSnakeInfo == null) {
            this.playerInfo.playerOwnSnakeInfo = new OwnSnakeInfo();
        }
        this.playerInfo.playerOwnSnakeInfo.playerName = gameInfo.playerData[playerIndex].name;
        this.playerInfo.playerOwnSnakeInfo.snakeChar = gameInfo.playerData[playerIndex].ownChar;
        this.playerInfo.playerOwnSnakeInfo.headPosLine = gameInfo.playerData[playerIndex].headPos.y;
        this.playerInfo.playerOwnSnakeInfo.headPosRow = gameInfo.playerData[playerIndex].headPos.x;
        this.playerInfo.playerOwnSnakeInfo.points = gameInfo.playerData[playerIndex].killPoints;
        this.playerInfo.playerOwnSnakeInfo.snakeLength = gameInfo.playerData[playerIndex].length;
        this.playerInfo.playerOwnSnakeInfo.waitCycles = gameInfo.playerData[playerIndex].waitCycles;
        this.playerInfo.playerOwnSnakeInfo.nextMoveTime = gameInfo.playerData[playerIndex].nextUpdateTime;
        this.playerInfo.playerOwnSnakeInfo.lastCalculatedMemUsage = gameInfo.playerData[this.lastPlayer].lastCalculatedMemUsage;
        switch (gameInfo.playerData[playerIndex].snakeStatus) {
            case 0: 
            case 1: 
            case 2: {
                this.playerInfo.playerOwnSnakeInfo.snakeStatus = gameInfo.playerData[playerIndex].snakeStatus;
                break;
            }
            default: {
                this.playerInfo.playerOwnSnakeInfo.snakeStatus = 1;
            }
        }
        this.playerInfo.playerOwnSnakeInfo.headDirection = gameInfo.playerData[playerIndex].watchDirection;
        this.playerInfo.playerLevelInfo.levelName = gameInfo.level.name;
        this.playerInfo.playerLevelInfo.height = gameInfo.level.height;
        this.playerInfo.playerLevelInfo.width = gameInfo.level.width;
        this.playerInfo.playerLevelInfo.playField = gameInfo.level.playField;
        this.playerInfo.playerGameInfo.gameTime = this.parameter.getGameTime();
        this.playerInfo.playerGameInfo.exitTime = this.parameter.getExit_time();
        this.playerInfo.playerGameInfo.suddenDeathTime = this.parameter.getSuddend_time();
        this.playerInfo.playerGameInfo.thinkingMS = this.parameter.getMax_thinking_ms();
        this.playerInfo.playerGameInfo.analyseMS = this.parameter.getAnalyse_ms();
        this.playerInfo.playerGameInfo.maxMem = this.parameter.getMax_player_mem();
        this.playerInfo.playerGameInfo.damage_points_radius = this.parameter.getDamage_points_radius();
        this.playerInfo.playerGameInfo.kill_points_radius = this.parameter.getKill_points_radius();
        this.playerInfo.playerGameInfo.kill_point_goodies = this.parameter.getKill_point_goodies();
        this.playerInfo.playerGameInfo.damage_length_grow = this.parameter.getDamage_length_grow();
        this.playerInfo.playerGameInfo.min_move_delay = this.parameter.getMin_move_delay();
        this.playerInfo.playerGameInfo.max_move_delay = this.parameter.getMax_move_delay();
        this.playerInfo.playerGameInfo.auto_grow_delay = this.parameter.getAuto_grow_delay();
        this.playerInfo.playerGameInfo.auto_slowdown_delay = this.parameter.getAuto_slowdown_delay();
        this.playerInfo.playerGameInfo.max_goody_occ_delay = this.parameter.getMax_goody_occ_delay();
        this.playerInfo.playerGameInfo.goody_speed_occ = this.parameter.getGoody_speed_occ();
        this.playerInfo.playerGameInfo.goody_slowdown_occ = this.parameter.getGoody_slowdown_occ();
        this.playerInfo.playerGameInfo.goody_length_occ = this.parameter.getGoody_length_occ();
        this.playerInfo.playerGameInfo.goody_points_occ = this.parameter.getGoody_points_occ();
        this.playerInfo.playerGameInfo.goody_shorter_occ = this.parameter.getGoody_shorter_occ();
        this.playerInfo.playerGameInfo.goody_length_value = this.parameter.getGoody_length_value();
        this.playerInfo.playerGameInfo.goody_points_value = this.parameter.getGoody_points_value();
        this.playerInfo.playerGameInfo.goody_shorter_value = this.parameter.getGoody_shorter_value();
        this.playerInfo.playerGameInfo.survival_points = this.parameter.getSurvival_points();
        this.playerInfo.playerGameInfo.easy_points = this.parameter.getEasy_points();
    }

    protected void initGame(Player[] players) {
        this.playerInstances = players;
        this.playerLog = new C_LogFileWriter("logs", "player.log");
        this.playerLog.storeLine("start Game\nPlayer:");
        this.playerInfo.playerGameInfo = new GameInfo();
        this.playerInfo.playerLevelInfo = new LevelInfo();
        this.playerInfo.playerSnakeInfo = new SnakeInfo[players.length];
        this.playerInfo.playerOwnSnakeInfo = new OwnSnakeInfo();
        int i = 0;
        while (i < players.length) {
            if (players[i] != null) {
                this.playerLog.storeLine(String.valueOf(i) + ": " + players[i].getName());
            }
            this.playerInfo.playerSnakeInfo[i] = new SnakeInfo();
            ++i;
        }
        this.playerLog.storeLine("-----------------------------------------------------------------------\n");
        this.randNumber = new Random();
        this.nextSizeControllTime = (long)(this.randNumber.nextDouble() * (double)this.parameter.getMax_mem_check_delay());
    }

    protected void recover(D_RecoverData recoverData) {
    }

    protected synchronized void runPlayer(D_GameInfo gameInfo, D_PlayerData[] playerData) {
        long time = 0L;
        ByteArrayOutputStream baos = null;
        String logString1 = "";
        String logString2 = "";
        ObjectOutputStream oos = null;
        if (gameInfo.playerData.length <= 0) {
            return;
        }
        this.lastPlayer = (this.lastPlayer + 1) % gameInfo.playerData.length;
        if (this.parameter.getNo_thread_calc() == 1 && gameInfo.playerData[this.lastPlayer].snakeStatus == 0) {
            this.reGenPlayerInfo(this.lastPlayer, gameInfo);
            try {
                this.playerInstances[this.lastPlayer].startCalculation(this.playerInfo.playerGameInfo, this.playerInfo.playerLevelInfo, this.playerInfo.playerSnakeInfo, this.playerInfo.playerOwnSnakeInfo);
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            playerData[this.lastPlayer].turnDirection = this.playerInstances[this.lastPlayer].getTurnDirection();
            if (this.parameter.getGameTime() == 0L || playerData[this.lastPlayer].nextUpdateTime <= this.parameter.getGameTime()) {
                playerData[this.lastPlayer].move = true;
            }
            return;
        }
        if (gameInfo.playerData[this.lastPlayer].snakeStatus != 0) {
            return;
        }
        logString1 = String.valueOf(logString1) + "gameTime:  " + this.parameter.getGameTime() + "\tPlayer " + this.lastPlayer;
        this.reGenPlayerInfo(this.lastPlayer, gameInfo);
        this.playerRun = new PlayerRun(this.playerInstances[this.lastPlayer], this.playerInfo);
        this.playerThread = new Thread(this.playerRun);
        this.playerThread.start();
        if (this.parameter.getTimeout_ms() <= 0) {
            if (!this.playerRun.calculationFinished) {
                try {
                    this.playerThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                this.playerThread.join(this.parameter.getMax_thinking_ms() + (this.parameter.getGameTime() == 0L ? this.parameter.getAnalyse_ms() : 0));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!this.playerRun.calculationFinished) {
                if (this.parameter.getTimeout_ms() > this.parameter.getMax_thinking_ms()) {
                    try {
                        time = -System.currentTimeMillis();
                        this.playerThread.join(this.parameter.getTimeout_ms() - this.parameter.getMax_thinking_ms());
                        logString2 = String.valueOf(logString2) + "\t- Wait for player to timeout! (deadline: " + (this.parameter.getTimeout_ms() - this.parameter.getMax_thinking_ms()) + " ms) ..." + (time += System.currentTimeMillis()) + "\n";
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (!this.playerRun.calculationFinished) {
                    playerData[this.lastPlayer].snakeStatus = 4;
                    this.playerThread.stop();
                    this.playerInstances[this.lastPlayer] = null;
                    System.out.println("WARNING: gameTime " + this.parameter.getGameTime() + "Player " + this.lastPlayer + " needed too much time and was deleted!!");
                    logString2 = String.valueOf(logString2) + "\t- Player needed too much time and was deleted!!\n";
                    this.playerLog.storeLine(logString1);
                    this.playerLog.storeLine(logString2);
                    return;
                }
            }
        }
        if (this.playerRun.threwException) {
            playerData[this.lastPlayer].snakeStatus = 6;
            System.out.println("WARNING: gameTime " + this.parameter.getGameTime() + "Player " + this.lastPlayer + " threw an exception. he was deleted!!");
            logString2 = String.valueOf(logString2) + "\t- Player threw an exception. he was deleted!!\n";
            logString2 = String.valueOf(logString2) + "\t- " + this.playerRun.thrownException.toString() + "\n";
            this.playerInstances[this.lastPlayer] = null;
            this.playerThread = null;
            this.playerRun = null;
            this.playerLog.storeLine(logString1);
            this.playerLog.storeLine(logString2);
            return;
        }
        if (this.parameter.getMax_player_mem() > 0L && this.parameter.getGameTime() >= this.nextSizeControllTime && this.lastPlayer == this.nextMemCheck) {
            this.nextMemCheck = (this.nextMemCheck + 1) % this.playerInstances.length;
            baos = new ByteArrayOutputStream();
            if (playerData[this.lastPlayer].snakeStatus == 0 && !this.playerInstances[this.lastPlayer].getClass().getName().endsWith("C_Human")) {
                this.nextSizeControllTime = this.parameter.getGameTime() + (long)(this.randNumber.nextDouble() * (double)this.parameter.getMax_mem_check_delay());
                try {
                    oos = new ObjectOutputStream(baos);
                    oos.writeObject(this.playerInstances[this.lastPlayer]);
                    oos.close();
                    oos = null;
                    logString2 = String.valueOf(logString2) + "\t-needed kB: " + baos.size() / 1024 + "\n";
                    if ((long)baos.size() > this.parameter.getMax_player_mem() << 10) {
                        System.out.println("WARNING: gameTime " + this.parameter.getGameTime() + " Player " + this.lastPlayer + " needed too much space and was deleted!!\n");
                        logString2 = String.valueOf(logString2) + "Player needed too much space and was deleted!!\n";
                        playerData[this.lastPlayer].snakeStatus = 3;
                        this.playerInstances[this.lastPlayer] = null;
                    } else {
                        playerData[this.lastPlayer].lastCalculatedMemUsage = baos.size();
                    }
                    baos.reset();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.gc();
            }
        }
        playerData[this.lastPlayer].turnDirection = this.playerInstances[this.lastPlayer].getTurnDirection();
        if (this.parameter.getGameTime() == 0L || playerData[this.lastPlayer].nextUpdateTime <= this.parameter.getGameTime()) {
            playerData[this.lastPlayer].move = true;
        }
        logString1 = String.valueOf(logString1) + "\t needed  ms: " + this.playerCalculationtime + "\tturn direction: " + playerData[this.lastPlayer].turnDirection;
        if (this.parameter.getPrint_calc_ms() == 1) {
            System.out.println(String.valueOf(logString1) + "\n");
        }
        this.playerLog.storeLine(logString1);
        this.playerLog.storeLine(logString2);
        this.playerThread = null;
    }

    protected void abbort() {
        this.playerLog.storeLine("end Game");
        this.playerInfo.playerGameInfo = null;
        this.playerInfo.playerLevelInfo = null;
        this.playerInfo.playerOwnSnakeInfo = null;
        this.playerInfo.playerSnakeInfo = null;
        this.playerInstances = null;
        this.playerThread = null;
        if (this.parameter.getLogging() == 1) {
            this.playerLog.safeAndCloseFile();
        }
    }

    protected void imergencyPause() {
        if (!this.imergencyPaused) {
            this.imergencyPaused = true;
            if (this.playerThread != null && this.playerThread.isAlive()) {
                this.playerLog.storeLine("SUSPEND!! SystemTime: " + System.currentTimeMillis());
                this.playerThread.suspend();
            }
        } else {
            this.imergencyPaused = false;
            if (this.playerThread != null && this.playerThread.isAlive()) {
                this.playerLog.storeLine("RESUME!! SystemTime: " + System.currentTimeMillis());
                this.playerThread.resume();
            }
        }
    }

    protected void kill() {
        if (this.playerThread != null && this.playerThread.isAlive()) {
            this.playerThread.stop();
        }
    }

    protected static M_PlayerHandler getInstance() {
        if (instance == null) {
            instance = new M_PlayerHandler();
        }
        return instance;
    }

    protected static void destroyInstance(M_PlayerHandler playerHandler) {
        playerHandler.imergencyPaused = false;
        playerHandler.lastPlayer = -1;
        playerHandler.playerInstances = null;
        playerHandler.nextSizeControllTime = -1L;
        playerHandler.randNumber = null;
        if (playerHandler.playerThread != null && playerHandler.playerThread.isAlive()) {
            playerHandler.playerThread.stop();
        }
        playerHandler.playerThread = null;
        instance = null;
    }

    private class PlayerInfo {
        public GameInfo playerGameInfo = null;
        public LevelInfo playerLevelInfo = null;
        public SnakeInfo[] playerSnakeInfo = null;
        public OwnSnakeInfo playerOwnSnakeInfo = null;

        PlayerInfo() {
        }
    }

    private class PlayerRun
    implements Runnable {
        public Player player;
        public final PlayerInfo playerInfo;
        public boolean calculationFinished = false;
        public boolean threwException = false;
        public Throwable thrownException;

        public PlayerRun(Player player, PlayerInfo playerInfo) {
            this.player = player;
            this.playerInfo = playerInfo;
            this.calculationFinished = false;
            this.threwException = false;
        }

        public void run() {
            this.calculationFinished = false;
            this.threwException = false;
            M_PlayerHandler.this.playerCalculationtime = -System.currentTimeMillis();
            try {
                this.player.startCalculation(this.playerInfo.playerGameInfo, this.playerInfo.playerLevelInfo, this.playerInfo.playerSnakeInfo, this.playerInfo.playerOwnSnakeInfo);
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.threwException = true;
                this.thrownException = e;
            }
            M_PlayerHandler m_PlayerHandler = M_PlayerHandler.this;
            m_PlayerHandler.playerCalculationtime = m_PlayerHandler.playerCalculationtime + System.currentTimeMillis();
            this.calculationFinished = true;
        }
    }
}

