/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy;

import de.farafin.snEADy.C_DebugMonitor;
import de.farafin.snEADy.GameParameter;
import de.farafin.snEADy.I_GameStats;
import de.farafin.snEADy.I_Main_interface;
import de.farafin.snEADy.M_GameEngine;
import de.farafin.snEADy.communication.D_GameInfo;
import de.farafin.snEADy.communication.D_Level;
import de.farafin.snEADy.communication.D_PlayerData;
import de.farafin.snEADy.communication.D_RecoverData;
import de.farafin.snEADy.communication.I_Constants;
import de.farafin.snEADy.communication.I_PlayFieldConstants;
import de.farafin.snEADy.control.C_Human;
import de.farafin.snEADy.control.GaphixStuff.M_GraphixEngineUI;
import de.farafin.snEADy.inOut.C_FileClassLoader;
import de.farafin.snEADy.inOut.C_LevelLoader;
import de.farafin.snEADy.inOut.C_LogFileReader;
import de.farafin.snEADy.inOut.C_LogFileWriter;
import de.farafin.snEADy.inOut.E_LevelFileException;
import java.io.FileNotFoundException;

public final class M_Main
implements I_Main_interface,
I_Constants,
I_GameStats,
I_PlayFieldConstants {
    private M_GameEngine gameEngine;
    private M_GraphixEngineUI gui;
    private D_GameInfo gameInfo;
    private D_GameInfo initGameInfo = null;
    private int gameState = 0;
    private boolean lockedControl = false;
    private C_LogFileWriter controlLog = null;
    private final GameParameter parameter = new GameParameter();
    private static M_Main instance;
    private final C_DebugMonitor monitor = new C_DebugMonitor();
    private static int version;
    static /* synthetic */ Class class$0;

    static {
        version = 1000;
    }

    private M_Main() {
        this.gameInfo = new D_GameInfo();
        this.controlLog = new C_LogFileWriter("logs", "control.log");
        instance = this;
        this.gameEngine = M_GameEngine.getInstance();
    }

    private Class loadPlayerClass(String className) {
        try {
            Class c = new C_FileClassLoader("player").loadClass(className, true);
            return c;
        }
        catch (Exception e) {
            System.out.println("WARNING: player wasnt loaded \n\t" + e);
            return null;
        }
    }

    public String getPlayerComment(String playerName) {
        String s = null;
        Class c = this.loadPlayerClass(playerName);
        if (c == null) {
            return "";
        }
        try {
            s = (String)c.getField("comment").get(null);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return "";
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return "";
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return "";
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return "";
        }
        return s;
    }

    public D_Level getLevelHeader(String levelName) {
        C_LevelLoader levelLoader = new C_LevelLoader();
        D_Level level = null;
        try {
            level = levelLoader.loadLevelHeader(levelName);
        }
        catch (FileNotFoundException e) {
            System.out.println("WARNING: " + e);
            return null;
        }
        catch (E_LevelFileException e) {
            System.out.println("WARNING: " + e);
            return null;
        }
        return level;
    }

    private D_Level loadLevel(String levelName) {
        C_LevelLoader levelLoader = new C_LevelLoader();
        D_Level level = null;
        try {
            level = levelLoader.loadLevel(levelName);
        }
        catch (FileNotFoundException e) {
            System.out.println("WARNING: " + e);
            return null;
        }
        catch (E_LevelFileException e) {
            System.out.println("WARNING: " + e);
            return null;
        }
        return level;
    }

    private void startGame(D_GameInfo initData) {
        this.gameEngine.initGame(initData);
        this.gameState = 4;
        this.gameEngine.start();
    }

    private void recover(D_RecoverData recoverData) {
    }

    private void startScript(String[] args) {
        String fileName = null;
        this.controlLog.storeLine("Program arguments:");
        this.controlLog.storeLine("\t");
        int i = 0;
        while (i < args.length) {
            this.controlLog.addToLastLine(String.valueOf(args[i]) + " ");
            if (args[i].startsWith("-script")) {
                fileName = String.valueOf(args[++i]) + ".script";
            }
            ++i;
        }
        if (fileName == null) {
            fileName = "default.script";
        }
        this.controlLog.storeLine("load Script: " + fileName);
        this.loadScript("scripts", fileName);
        this.gui.setActive(true);
    }

    private boolean loadScript(String root, String fileName) {
        C_LogFileReader script = null;
        String line = null;
        try {
            script = new C_LogFileReader(root, fileName);
            while (!script.isFinished()) {
                line = script.readNextLine();
                line = line.split("%")[0];
                this.control(line);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("WARNING: Script wasn't loaded!\n" + e);
            return false;
        }
        return true;
    }

    private void writeResults() {
        C_LogFileWriter writer = new C_LogFileWriter("logs", "result.log");
        writer.storeLine("final Game Time:    " + this.gameInfo.gameTime);
        writer.storeLine("used Level:\n" + this.gameInfo.level + "\n");
        writer.storeLine("===============================================");
        int j = 0;
        while (j < this.gameInfo.playerData.length) {
            writer.storeLine("player " + j + ":");
            writer.storeLine("\tname:               " + this.gameInfo.playerData[j].name);
            writer.storeLine("\tlength:             " + this.gameInfo.playerData[j].length);
            writer.storeLine("\tPoints:        " + this.gameInfo.playerData[j].killPoints);
            switch (this.gameInfo.playerData[j].snakeStatus) {
                case 0: {
                    writer.storeLine("\tstate:              IN_ACTION");
                    break;
                }
                case 1: {
                    writer.storeLine("\tstate:              IN_HEAVEN");
                    break;
                }
                case 2: {
                    writer.storeLine("\tstate:              IN_EXIT");
                    break;
                }
                case 4: {
                    writer.storeLine("\tstate:              IN_ERROR_TIME");
                    break;
                }
                case 3: {
                    writer.storeLine("\tstate:              IN_ERROR_SPACE");
                    break;
                }
                case 5: {
                    writer.storeLine("\tstate:              IN_ERROR_INIT");
                    break;
                }
                case 6: {
                    writer.storeLine("\tstate:              IN_ERROR_EXC");
                }
            }
            writer.storeLine("-----------------------------------------------");
            ++j;
        }
        writer.safeAndCloseFile();
    }

    protected void update(D_GameInfo gameInfo, C_Human[] humanInstances) {
        int i = 0;
        switch (M_Main.getInstance().getGameState()) {
            case 0: {
                break;
            }
            case 1: {
                this.gameInfo = gameInfo;
                this.writeResults();
                this.quit(0);
                break;
            }
            case 3: {
                int snakeCount = 0;
                i = 0;
                while (i < gameInfo.playerData.length) {
                    if (gameInfo.playerData[i].snakeStatus == 0) {
                        ++snakeCount;
                    } else if (gameInfo.playerData[i].snakeStatus == 2 && gameInfo.playerData[i].length >= 1) {
                        ++snakeCount;
                    }
                    ++i;
                }
                if (snakeCount <= 0) {
                    this.gameState = 4;
                }
                this.gameInfo = gameInfo;
                this.gui.update(this.gameInfo, humanInstances);
                break;
            }
            case 2: {
                this.gameInfo = gameInfo;
                this.gui.update(this.gameInfo, humanInstances);
                break;
            }
            case 4: {
                this.gameInfo = gameInfo;
                this.gui.update(this.gameInfo, humanInstances);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.gameInfo = gameInfo;
                this.writeResults();
                this.gui.update(this.gameInfo, humanInstances);
                M_GameEngine.destroyInstance(this.gameEngine);
                this.gameEngine = null;
                this.gameInfo = null;
                System.gc();
                this.gameInfo = new D_GameInfo();
                this.gameEngine = M_GameEngine.getInstance();
                this.gameState = 2;
            }
        }
    }

    private void gameRecover(String rootPath, String fileName) {
    }

    private void gameSafe() {
    }

    private void imergencyPause() {
        this.gameEngine.imergencyPause();
    }

    private void kill() {
        if (this.gameEngine != null) {
            this.gameEngine.kill();
        }
        this.quit(0);
    }

    protected int getGameState() {
        return this.gameState;
    }

    protected GameParameter getParameter() {
        return this.parameter;
    }

    protected C_DebugMonitor getMonitor() {
        return this.monitor;
    }

    protected static M_Main getInstance() {
        return instance;
    }

    public static void main(String[] args) {
        M_Main main = new M_Main();
        main.gui = new M_GraphixEngineUI(main, main.parameter, main.monitor, version);
        main.gameState = 2;
        main.startScript(args);
    }

    public synchronized boolean control(String command) {
        int number = 0;
        int i = 0;
        int j = 0;
        int k = 0;
        int counter = 0;
        boolean bool = false;
        this.controlLog.storeLine(command);
        if (this.gameInfo == null) {
            this.gameInfo = new D_GameInfo();
            this.gameInfo.exitTime = this.parameter.getExit_time();
            this.gameInfo.suddenDeath = this.parameter.getSuddend_time();
        }
        if (this.lockedControl) {
            this.controlLog.addToLastLine("-locked control-\tfalse");
            return false;
        }
        if (command == null) {
            System.out.println("WARNING: empty command string!!");
            this.controlLog.addToLastLine("-null command-\tfalse");
            return false;
        }
        if (command.length() <= 1) {
            this.controlLog.addToLastLine(" ");
            return false;
        }
        System.out.println(command);
        String[] commandArray = command.split(" ");
        if (commandArray == null || commandArray.length < 1 || commandArray[0] == null || commandArray[0].length() <= 1) {
            System.out.println("WARNING: <Empty Command>");
            this.controlLog.addToLastLine("\tfalse");
            return false;
        }
        commandArray[0] = commandArray[0].toLowerCase();
        if (commandArray[0].equals("loadplayer")) {
            if (this.gameState != 2) {
                System.out.println("WARNING: Game is not in initialization context, end a possibly running game and try again.");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            if (this.gameInfo.level != null && this.gameInfo.level.maxPlayer <= this.gameInfo.playerData.length) {
                System.out.println("WARNING: can not load an other Player. Maximal number of players (" + this.gameInfo.level.maxPlayer + ") was reached.");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            if (this.gameInfo.playerData.length >= 10) {
                System.out.println("WARNING: can not load an other Player. Maximal number of players (10) was reached.");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            if (commandArray.length <= 1) {
                System.out.println("WARNING: Please specify the player you whish to load.");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            Class newPlayerClass = this.loadPlayerClass(commandArray[1]);
            if (newPlayerClass == null) {
                System.out.println("WARNING: Player couldnt be loaded.");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            D_PlayerData[] pData = this.gameInfo.playerData;
            this.gameInfo.playerData = new D_PlayerData[this.gameInfo.playerData.length + 1];
            i = 0;
            while (i < pData.length) {
                this.gameInfo.playerData[i] = pData[i];
                ++i;
            }
            this.gameInfo.playerData[this.gameInfo.playerData.length - 1] = new D_PlayerData(this.gameInfo.playerData.length - 1, newPlayerClass, this.parameter);
            if (this.gameInfo.level != null) {
                if (this.gameInfo.playerData.length > this.gameInfo.level.maxPlayer) {
                    System.out.println("WARNING: loading was successfull, but there are too many player loaded for this arena!\n\tmaxPlayer: " + this.gameInfo.level.maxPlayer + " actual player Number: " + this.gameInfo.playerData.length);
                } else {
                    bool = false;
                    i = 0;
                    while (i < this.gameInfo.level.height && !bool) {
                        j = 0;
                        while (j < this.gameInfo.level.width && !bool) {
                            if (this.gameInfo.level.playField[i][j] == this.gameInfo.playerData[this.gameInfo.playerData.length - 1].ownChar) {
                                this.gameInfo.playerData[this.gameInfo.playerData.length - 1].headPos.y = i;
                                this.gameInfo.playerData[this.gameInfo.playerData.length - 1].headPos.x = j;
                                bool = true;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    bool = false;
                }
            }
            this.gui.update(this.gameInfo, null);
            this.controlLog.addToLastLine("\ttrue");
            return true;
        }
        if (commandArray[0].equals("loadhuman")) {
            if (this.gameState != 2) {
                System.out.println("WARNING: Game is not in initialization context, end a possibly running game and try again.");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            if (this.gameInfo.level != null && this.gameInfo.level.maxPlayer <= this.gameInfo.playerData.length) {
                System.out.println("WARNING: can not load an other Player. Maximal number of players (" + this.gameInfo.level.maxPlayer + ") was reached.");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            if (this.gameInfo.playerData.length >= 10) {
                System.out.println("WARNING: can not load an other Player. Maximal number of players (10) was reached.");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            counter = 0;
            i = 0;
            while (i < this.gameInfo.playerData.length) {
                if (this.gameInfo.playerData[i].playerClass.getName().endsWith("C_Human")) {
                    ++counter;
                }
                ++i;
            }
            if (counter >= 4) {
                System.out.println("WARNING: can not load an other human Player. Maximal number of players (4) was reached.");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.farafin.snEADy.control.C_Human");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> newPlayerClass = clazz;
            D_PlayerData[] pData = this.gameInfo.playerData;
            this.gameInfo.playerData = new D_PlayerData[this.gameInfo.playerData.length + 1];
            i = 0;
            while (i < pData.length) {
                this.gameInfo.playerData[i] = pData[i];
                ++i;
            }
            this.gameInfo.playerData[this.gameInfo.playerData.length - 1] = commandArray.length > 1 ? new D_PlayerData(this.gameInfo.playerData.length - 1, newPlayerClass, commandArray[1], this.parameter) : new D_PlayerData(this.gameInfo.playerData.length - 1, newPlayerClass, "Nameless", this.parameter);
            if (this.gameInfo.level != null && this.gameInfo.playerData.length > this.gameInfo.level.maxPlayer) {
                System.out.println("WARNING: loading was successfull, but there are too many player loaded for this arena!\n\tmaxPlayer: " + this.gameInfo.level.maxPlayer + " actual player Number: " + this.gameInfo.playerData.length);
            } else {
                i = 0;
                while (i < this.gameInfo.level.height) {
                    j = 0;
                    while (j < this.gameInfo.level.width) {
                        if ('0' <= this.gameInfo.level.playField[i][j] && this.gameInfo.level.playField[i][j] <= '9') {
                            k = 0;
                            while (k < this.gameInfo.playerData.length) {
                                if (this.gameInfo.level.playField[i][j] == this.gameInfo.playerData[k].ownChar) {
                                    this.gameInfo.playerData[k].headPos.y = i;
                                    this.gameInfo.playerData[k].headPos.x = j;
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            this.gui.update(this.gameInfo, null);
            this.controlLog.addToLastLine("\ttrue");
            return true;
        }
        if (commandArray[0].equals("delplayer")) {
            if (this.gameState != 2) {
                System.out.println("WARNING: Game is not in initialization context, end a possibly running game and try again.");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            if (this.gameInfo.playerData == null || this.gameInfo.playerData.length == 0) {
                System.out.println("WARNING: no player loaded that can be deleted!");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            if (commandArray.length <= 1) {
                System.out.println("WARNING: There was no Player specified that should be deleted.by default the last player will be deleted.");
                number = this.gameInfo.playerData.length - 1;
            } else {
                if (!commandArray[1].matches("[0-9]")) {
                    System.out.println("WARNING: the parameter '" + commandArray[1] + "' is no number between 0 and 9!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[1]);
            }
            if (number >= this.gameInfo.playerData.length) {
                System.out.println("WARNING: Player with number '" + number + "' doesn't exists.");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            this.gameInfo.playerData[number] = null;
            D_PlayerData[] pData = this.gameInfo.playerData;
            this.gameInfo.playerData = new D_PlayerData[pData.length - 1];
            i = 0;
            j = 0;
            while (j < this.gameInfo.playerData.length) {
                if (j == number) {
                    i = 1;
                }
                this.gameInfo.playerData[j] = pData[j + i];
                if (i == 1) {
                    this.gameInfo.playerData[j].ownChar = (char)(this.gameInfo.playerData[j].ownChar - '\u0001');
                }
                ++j;
            }
            i = 0;
            while (i < this.gameInfo.level.height) {
                j = 0;
                while (j < this.gameInfo.level.width) {
                    if ('0' <= this.gameInfo.level.playField[i][j] && this.gameInfo.level.playField[i][j] <= '9') {
                        k = 0;
                        while (k < this.gameInfo.playerData.length) {
                            if (this.gameInfo.level.playField[i][j] == this.gameInfo.playerData[k].ownChar) {
                                this.gameInfo.playerData[k].headPos.y = i;
                                this.gameInfo.playerData[k].headPos.x = j;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            this.gui.update(this.gameInfo, null);
            this.controlLog.addToLastLine("\ttrue");
            return true;
        }
        if (commandArray[0].equals("loadlevel")) {
            if (this.gameState != 2) {
                System.out.println("WARNING: Game is not in initialization context,end a possibly running game and try again.");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            this.gameInfo.level = this.loadLevel(commandArray[1]);
            if (this.gameInfo.level == null) {
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            if (this.gameInfo.level.comment.length() > 0) {
                this.monitor.sneadySayIm(this.gameInfo.level.comment);
            }
            if (this.gameInfo.level.autor.length() > 0) {
                this.monitor.sneadySayIm("by " + this.gameInfo.level.autor);
            }
            if (this.gameInfo.playerData.length > this.gameInfo.level.maxPlayer) {
                System.out.println("WARNING: loading of level was successfull, but there are too many players loaded for this level!\n\tmaxPlayer: " + this.gameInfo.level.maxPlayer + " actual player Number: " + this.gameInfo.playerData.length + "\n" + "The last " + (this.gameInfo.playerData.length - this.gameInfo.level.maxPlayer) + " are skipped.");
                D_PlayerData[] pData = this.gameInfo.playerData;
                this.gameInfo.playerData = new D_PlayerData[this.gameInfo.level.maxPlayer];
                i = 0;
                while (i < this.gameInfo.level.maxPlayer) {
                    this.gameInfo.playerData[i] = pData[i];
                    ++i;
                }
            }
            i = 0;
            while (i < this.gameInfo.level.height) {
                j = 0;
                while (j < this.gameInfo.level.width) {
                    if ('0' <= this.gameInfo.level.playField[i][j] && this.gameInfo.level.playField[i][j] <= '9') {
                        k = 0;
                        while (k < this.gameInfo.playerData.length) {
                            if (this.gameInfo.level.playField[i][j] == this.gameInfo.playerData[k].ownChar) {
                                this.gameInfo.playerData[k].headPos.y = i;
                                this.gameInfo.playerData[k].headPos.x = j;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            this.gui.update(this.gameInfo, null);
            this.controlLog.addToLastLine("\ttrue");
            return true;
        }
        if (commandArray[0].equals("start")) {
            if (this.gameState != 2) {
                System.out.println("WARNING: Game is not in initialization context,end a possibly running game and try again.");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            if (this.gameInfo.playerData.length <= 0) {
                System.out.println("WARNING: There are no players loaded!");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            if (this.gameInfo.level == null) {
                System.out.println("WARNING: There is no level loaded!");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            if (this.gameInfo.playerData.length > this.gameInfo.level.maxPlayer) {
                System.out.println("WARNING: There are too many players loaded.\n\t " + this.gameInfo.playerData.length + " loaded, max player for this level is " + this.gameInfo.level.maxPlayer + "\n" + "\t the last " + (this.gameInfo.level.maxPlayer - this.gameInfo.playerData.length) + " player won't be loaded.");
            }
            this.control("min_cycle_ms 1");
            if (this.gameInfo.playerData != null) {
                i = 0;
                while (i < this.gameInfo.playerData.length) {
                    if (this.gameInfo.playerData[i].playerClass.getName().endsWith("C_Human")) {
                        this.control("set min_cycle_ms 50");
                        break;
                    }
                    ++i;
                }
            }
            this.initGameInfo = (D_GameInfo)this.gameInfo.clone();
            this.parameter.setExit_time(this.gameInfo.exitTime);
            this.parameter.setSuddend_time(this.gameInfo.suddenDeath);
            this.gui.setActive(false);
            this.lockedControl = true;
            this.startGame(this.gameInfo);
            M_Main newPlayerClass = this;
            synchronized (newPlayerClass) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.lockedControl = false;
            this.control("pause");
            this.gui.setActive(true);
            this.gui.update(this.gameInfo, null);
            this.controlLog.addToLastLine("\ttrue");
            return true;
        }
        if (commandArray[0].equals("run")) {
            if (this.gameState != 3 && this.gameState != 4 && this.gameState != 2) {
                System.out.println("WARNING: Game is not in running, pause or initialization context");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            if (this.gameState == 3) {
                this.gameState = 4;
            } else if (this.gameState == 4) {
                this.gameState = 3;
            } else if (this.gameState == 2) {
                this.control("start");
            }
            this.gui.update(this.gameInfo, null);
            this.controlLog.addToLastLine("\ttrue");
            return true;
        }
        if (commandArray[0].equals("pause")) {
            if (this.gameState != 3 && this.gameState != 4) {
                System.out.println("WARNING: Game is not in running or pause context");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            if (this.gameState == 3) {
                this.gameState = 4;
            } else if (this.gameState == 4) {
                this.gameState = 3;
            }
            this.gui.update(this.gameInfo, null);
            this.controlLog.addToLastLine("\ttrue");
            return true;
        }
        if (commandArray[0].equals("stop")) {
            if (this.gameState != 3 && this.gameState != 4) {
                System.out.println("WARNING: you can't stop a game thats not running ;-)");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            this.gui.setActive(false);
            this.gameState = 7;
            this.lockedControl = true;
            try {
                this.gameEngine.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.lockedControl = false;
            this.gameInfo.copyOnMe(this.initGameInfo);
            this.gameInfo.gameRunning = false;
            this.gui.setActive(true);
            this.controlLog.addToLastLine("\ttrue");
            this.gui.update(this.gameInfo, null);
            this.controlLog.addToLastLine("\ttrue");
            return true;
        }
        if (commandArray[0].equals("loadscript")) {
            if (commandArray.length <= 1) {
                System.out.println("WARNING: There was no script specified that should be loaded.");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            if (!this.loadScript("scripts", String.valueOf(commandArray[1]) + ".script")) {
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            this.gui.update(this.gameInfo, null);
            this.controlLog.addToLastLine("\ttrue");
            return true;
        }
        if (commandArray[0].equals("quit")) {
            if (this.gameState == 3 || this.gameState == 4) {
                this.gameState = 1;
            } else {
                this.quit(0);
            }
            this.gui.update(this.gameInfo, null);
            this.controlLog.addToLastLine("\ttrue");
            return true;
        }
        if (commandArray[0].equals("kill")) {
            System.out.println("KILL WAS PERFORMED! DEPRECATED METHODS USED TO END THE GAME!\n\tPlease only use if 'quit' doesn't work!");
            this.kill();
            this.controlLog.addToLastLine("\ttrue");
            return true;
        }
        if (commandArray[0].equals("imergencyPause")) {
            System.out.println("IMERGENCY_PAUSE WAS PERFORMED! DEPRECATED METHODS USED TO HOLD THE GAME!\n\tPlease only use if 'run' or 'pause' doesn't work!");
            this.imergencyPause();
            this.gui.update(this.gameInfo, null);
            this.controlLog.addToLastLine("\ttrue");
            return true;
        }
        if (commandArray[0].equals("save")) {
            System.out.println("WARNING: command '" + commandArray[0] + "' not implemented jet!");
            this.controlLog.addToLastLine("\ttrue");
            return true;
        }
        if (commandArray[0].equals("restore")) {
            System.out.println("WARNING: command '" + commandArray[0] + "' not implemented jet!");
            this.controlLog.addToLastLine("\ttrue");
            return true;
        }
        if (commandArray[0].equals("print_playfield")) {
            if (this.gameInfo.level != null) {
                this.monitor.sneadySayIm(this.gameInfo.level.toString());
            }
            this.controlLog.addToLastLine("\ttrue");
            return true;
        }
        if (commandArray[0].equals("print_parameter")) {
            this.monitor.sneadySayIm(this.parameter.toString());
            this.controlLog.addToLastLine("\ttrue");
            return true;
        }
        if (commandArray[0].equals("openmonitor")) {
            this.monitor.setVisible(true);
            this.gui.update(this.gameInfo, null);
            this.controlLog.addToLastLine("\ttrue");
            return true;
        }
        if (commandArray[0].equals("closemonitor")) {
            this.monitor.setVisible(false);
            this.gui.update(this.gameInfo, null);
            this.controlLog.addToLastLine("\ttrue");
            return true;
        }
        if (commandArray[0].equals("set")) {
            if (commandArray.length <= 2) {
                System.out.println("WARNING: There are too less Parameter for this command! You need to specify the variable and its value.");
                this.controlLog.addToLastLine("\tfalse");
                return false;
            }
            commandArray[1] = commandArray[1].toLowerCase();
            if (commandArray[1].equals("damage_points_radius")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setDamage_points_radius(Integer.parseInt(commandArray[2]));
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("kill_points_radius")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setKill_points_radius(Integer.parseInt(commandArray[2]));
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("easy_points")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setEasy_points(Integer.parseInt(commandArray[2]));
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("damage_length_grow")) {
                if (!commandArray[2].matches("[0-9]*[.][0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no float-number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setDamage_length_grow(Float.parseFloat(commandArray[2]));
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("kill_point_goodies")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setKill_point_goodies(Integer.parseInt(commandArray[2]));
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("min_move_delay")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number < 1) {
                    System.out.println("WARNING: min_move_delay must be >= 1");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setMin_move_delay(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("init_move_delay")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if ((long)number < this.parameter.getMin_move_delay() || this.parameter.getMax_move_delay() < (long)number) {
                    System.out.println("WARNING: init_move_delay of '" + number + "' does not fit between " + this.parameter.getMin_move_delay() + " and " + this.parameter.getMax_move_delay() + ".");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setInit_move_delay(number);
                if (this.gameInfo.playerData != null) {
                    i = 0;
                    while (i < this.gameInfo.playerData.length) {
                        this.gameInfo.playerData[i].waitCycles = this.parameter.getInit_move_delay();
                        ++i;
                    }
                }
                if (this.gameInfo.level != null) {
                    this.gui.update(this.gameInfo, null);
                }
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("max_move_delay")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if ((long)number <= this.parameter.getMin_move_delay()) {
                    System.out.println("WARNING: MAX_SNAKE_DELAY must be > min_move_delay of " + this.parameter.getMin_move_delay());
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setMax_move_delay(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("init_length")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number < 2) {
                    System.out.println("WARNING: the init length of a snake must be init_length >= 2.");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setInit_length(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("auto_grow_delay")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number < 1) {
                    System.out.println("WARNING: AUTO_GROW must be >= 1");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setAuto_grow_delay(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("auto_slowdown_delay")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number < 0) {
                    System.out.println("WARNING: auto_slowdown_delay must be >= 0");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setAuto_slowdown_delay(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("max_goody_occ_delay")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number < 1) {
                    System.out.println("WARNING: max_goody_occ_delay must be >= 1");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setMax_goody_occ_delay(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("goody_speed_occ")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number < 0) {
                    System.out.println("WARNING: goody_speed_occ must be >= 0");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setGoody_speed_occ(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("goody_slowdown_occ")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number < 0) {
                    System.out.println("WARNING: goody_slowdown_occ must be >= 0");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setGoody_slowdown_occ(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("goody_length_occ")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number < 0) {
                    System.out.println("WARNING: goody_length_occ must be >= 0");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setGoody_length_occ(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("goody_points_occ")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number < 0) {
                    System.out.println("WARNING: goody_points_occ must be >= 0");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setGoody_points_occ(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("goody_shorter_occ")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number < 0) {
                    System.out.println("WARNING: goody_shorter_occ must be >= 0");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setGoody_shorter_occ(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("goody_length_value")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number < 0) {
                    System.out.println("WARNING: goody_length_value must be >= 0");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setGoody_length_value(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("goody_points_value")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number < 0) {
                    System.out.println("WARNING: goody_points_value must be >= 0");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setGoody_points_value(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("goody_shorter_value")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number < 0) {
                    System.out.println("WARNING: goody_shorter_value must be >= 0");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setGoody_shorter_value(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("min_cycle_ms")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number < 1) {
                    System.out.println("WARNING: min_cycle_ms must be >= 1");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setMin_cycle_ms(number);
                if (this.parameter.getMax_thinking_ms() < number) {
                    this.control("set max_thinking_ms " + number);
                }
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("max_thinking_ms")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number < 1) {
                    System.out.println("WARNING: max_thinking_ms must be >= 1");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setMax_thinking_ms(number);
                if (this.parameter.getMin_cycle_ms() > number) {
                    this.control("set min_cycle_ms " + number);
                }
                if (this.parameter.getTimeout_ms() > 0 && number > this.parameter.getTimeout_ms()) {
                    this.control("set timeout_ms " + number);
                }
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("analyse_ms")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number < 1) {
                    System.out.println("WARNING: analyse_ms must be >= 1");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setAnalyse_ms(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("timeout_ms")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number < 0) {
                    System.out.println("WARNING: timeout must be >= 0");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setTimeout_ms(number);
                if (number > 0 && number < this.parameter.getMax_thinking_ms()) {
                    this.control("set max_thinking_ms " + number);
                }
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("max_player_mem")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setMax_player_mem(Integer.parseInt(commandArray[2]));
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("max_mem_check_delay")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number < 0) {
                    System.out.println("WARNING: max_mem_check_delay must be >= 1");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setMax_mem_check_delay(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("exit_time")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setExit_time(Integer.parseInt(commandArray[2]));
                this.gameInfo.exitTime = this.parameter.getExit_time();
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("suddend_time")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setSuddend_time(Integer.parseInt(commandArray[2]));
                this.gameInfo.suddenDeath = this.parameter.getSuddend_time();
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("survival_points")) {
                if (!commandArray[2].matches("[0-9]*")) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setSurvival_points(Integer.parseInt(commandArray[2]));
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("show_subcycles")) {
                if (!commandArray[2].matches("[01]") || commandArray[2].length() > 1) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no boolean number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number != 0 && number != 1) {
                    System.out.println("WARNING: show_subcycles must be 0 or 1");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setShow_subcycles(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("logging")) {
                if (!commandArray[2].matches("[01]") || commandArray[2].length() > 1) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no boolean number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number != 0 && number != 1) {
                    System.out.println("WARNING: logging must be 0 or 1");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setLogging(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("print_calc_ms")) {
                if (!commandArray[2].matches("[01]") || commandArray[2].length() > 1) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no boolean number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number != 0 && number != 1) {
                    System.out.println("WARNING: print_calc_ms must be 0 or 1");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setPrint_calc_ms(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("print_player_mem")) {
                if (!commandArray[2].matches("[01]") || commandArray[2].length() > 1) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no boolean number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number != 0 && number != 1) {
                    System.out.println("WARNING: print_player_mem must be 0 or 1");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setPrint_player_mem(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            if (commandArray[1].equals("no_thread_calc")) {
                if (!commandArray[2].matches("[01]") || commandArray[2].length() > 1) {
                    System.out.println("WARNING: the parameter '" + commandArray[2] + "' is no boolean number!");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                number = Integer.parseInt(commandArray[2]);
                if (number != 0 && number != 1) {
                    System.out.println("WARNING: print_player_mem must be 0 or 1");
                    this.controlLog.addToLastLine("\tfalse");
                    return false;
                }
                this.parameter.setNo_thread_calc(number);
                this.gui.update(this.gameInfo, null);
                this.controlLog.addToLastLine("\ttrue");
                return true;
            }
            System.out.println("WARNING in M_Main.controlInterface: Unknown parameter '" + commandArray[1] + "' !!");
            this.controlLog.addToLastLine("\tfalse");
            return false;
        }
        System.out.println("WARNING in M_Main.controlInterface: Unknown command '" + commandArray[0] + "' !!");
        this.controlLog.storeLine("false");
        return false;
    }

    private void quit(int x) {
        this.controlLog.storeLine("end Game");
        if (this.parameter.getLogging() == 1) {
            this.controlLog.safeAndCloseFile();
        }
        System.exit(x);
    }
}

