/*
 * Decompiled with CFR 0.152.
 */
package de.farafin.snEADy;

import de.farafin.snEADy.GameParameter;
import de.farafin.snEADy.I_GameStats;
import de.farafin.snEADy.M_Main;
import de.farafin.snEADy.M_PlayerHandler;
import de.farafin.snEADy.communication.D_GameInfo;
import de.farafin.snEADy.communication.D_PlayerData;
import de.farafin.snEADy.communication.D_RecoverData;
import de.farafin.snEADy.communication.I_Constants;
import de.farafin.snEADy.communication.I_PlayFieldConstants;
import de.farafin.snEADy.control.C_Human;
import de.farafin.snEADy.inOut.C_FileClassLoader;
import de.farafin.snEADy.player.Player;
import de.farafin.snEADy.world.C_World;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public final class M_GameEngine
extends Thread
implements I_Constants,
I_GameStats,
I_PlayFieldConstants {
    private C_World world = null;
    private D_PlayerData[] playerData = null;
    private Player[] playerInstances = null;
    private C_Human[] humanInstances = null;
    private M_PlayerHandler playerHandler = null;
    private D_GameInfo gameInfo;
    private final GameParameter parameter = M_Main.getInstance().getParameter();
    private static M_GameEngine instance;
    private boolean imergencyPaused = false;

    private M_GameEngine() {
        this.playerHandler = M_PlayerHandler.getInstance();
        this.parameter.setGameTime(0L);
    }

    private D_GameInfo generateGameInfo() {
        if (this.gameInfo != null) {
            return this.reGenerateGameInfo();
        }
        this.gameInfo = new D_GameInfo();
        this.gameInfo.level = this.world.generateLevel();
        this.gameInfo.gameTime = this.parameter.getGameTime();
        this.gameInfo.exitTime = this.parameter.getExit_time();
        this.gameInfo.suddenDeath = this.parameter.getSuddend_time();
        this.gameInfo.playerData = new D_PlayerData[this.playerData.length];
        int i = 0;
        while (i < this.playerData.length) {
            this.gameInfo.playerData[i] = (D_PlayerData)this.playerData[i].clone();
            ++i;
        }
        return this.gameInfo;
    }

    private D_GameInfo reGenerateGameInfo() {
        if (this.gameInfo == null) {
            return this.generateGameInfo();
        }
        this.world.updateInfos(this.gameInfo);
        this.gameInfo.gameTime = this.parameter.getGameTime();
        this.gameInfo.exitTime = this.parameter.getExit_time();
        this.gameInfo.suddenDeath = this.parameter.getSuddend_time();
        if (this.gameInfo.playerData.length != this.playerData.length) {
            this.gameInfo.playerData = new D_PlayerData[this.playerData.length];
            int i = 0;
            while (i < this.playerData.length) {
                this.gameInfo.playerData[i] = (D_PlayerData)this.playerData.clone();
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.playerData.length) {
                this.gameInfo.playerData[i].copyOnMe(this.playerData[i]);
                ++i;
            }
        }
        return this.gameInfo;
    }

    private boolean checkGameState() {
        switch (M_Main.getInstance().getGameState()) {
            case 3: {
                break;
            }
            case 4: {
                try {
                    while (M_Main.getInstance().getGameState() == 4) {
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 1: 
            case 7: {
                this.playerHandler.abbort();
                M_Main.getInstance().update(this.reGenerateGameInfo(), this.humanInstances);
                this.gameInfo = null;
                this.parameter.setGameTime(0L);
                this.playerInstances = null;
                this.humanInstances = null;
                this.playerData = null;
                this.world = null;
                System.gc();
                M_GameEngine m_GameEngine = this;
                synchronized (m_GameEngine) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void run() {
        int i = 0;
        int j = 0;
        int snakeCount = 0;
        long time = 0L;
        while (true) {
            time = -System.currentTimeMillis();
            i = 0;
            while (i < this.playerInstances.length) {
                if (this.isInterrupted()) break;
                if (this.checkGameState()) {
                    return;
                }
                this.playerHandler.runPlayer(this.gameInfo, this.playerData);
                snakeCount = 0;
                j = 0;
                while (j < this.playerData.length) {
                    if (this.playerData[j].snakeStatus == 0) {
                        ++snakeCount;
                    }
                    ++j;
                }
                if (snakeCount <= 1 && this.parameter.getGameTime() < this.parameter.getExit_time()) {
                    this.parameter.setSuddend_time(this.parameter.getGameTime() + (this.parameter.getSuddend_time() - this.parameter.getExit_time()));
                    this.parameter.setExit_time(this.parameter.getGameTime());
                }
                if (this.checkGameState()) {
                    return;
                }
                if (this.parameter.getGameTime() > 0L) {
                    this.reGenerateGameInfo();
                    this.world.update(this.gameInfo);
                }
                if (this.parameter.getShow_subcycles() == 1) {
                    this.reGenerateGameInfo();
                    M_Main.getInstance().update(this.gameInfo, this.humanInstances);
                }
                ++i;
            }
            if (this.parameter.getGameTime() == 0L) {
                this.reGenerateGameInfo();
                this.world.update(this.gameInfo);
            }
            if (this.checkGameState()) {
                return;
            }
            if (this.parameter.getShow_subcycles() == 0) {
                this.reGenerateGameInfo();
                M_Main.getInstance().update(this.gameInfo, this.humanInstances);
            }
            if (this.parameter.getNo_thread_calc() == 0 && (time += System.currentTimeMillis()) < (long)this.parameter.getMin_cycle_ms()) {
                try {
                    Thread.sleep((long)this.parameter.getMin_cycle_ms() - time);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.parameter.setGameTime(this.parameter.getGameTime() + 1L);
        }
    }

    protected void initGame(D_GameInfo initData) {
        this.parameter.setGameTime(0L);
        long time = 0L;
        Player[] playerArray = new Player[initData.playerData.length];
        C_Human[] humanArray = new C_Human[initData.playerData.length];
        D_PlayerData[] infoArray = new D_PlayerData[initData.playerData.length];
        int playerCount = 0;
        int humanCount = 0;
        int i = 0;
        Class c = null;
        C_FileClassLoader loader = new C_FileClassLoader("player");
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        time = -System.currentTimeMillis();
        i = 0;
        while (i < initData.playerData.length) {
            block19: {
                block18: {
                    try {
                        c = loader.loadClass(initData.playerData[i].playerClass.getName(), true);
                    }
                    catch (Exception e) {
                        System.out.println("WARNING: player wasnt loaded, using the player that was loaded before starting the game. \n\t" + e);
                        c = initData.playerData[i].playerClass;
                    }
                    try {
                        playerArray[playerCount] = (Player)c.newInstance();
                        if (!c.getName().endsWith("C_Human")) break block18;
                        ((C_Human)playerArray[playerCount]).setName(initData.playerData[i].name);
                        humanArray[humanCount] = (C_Human)playerArray[playerCount];
                        ++humanCount;
                    }
                    catch (Throwable e) {
                        System.out.println("WARNING: Player couldnt be initialzed! please check your default constructor routins. \n");
                        e.printStackTrace();
                        playerArray[playerCount] = null;
                        break block19;
                    }
                }
                infoArray[playerCount] = initData.playerData[i];
                if (this.parameter.getMax_player_mem() > 0L) {
                    baos = new ByteArrayOutputStream();
                    if (!c.getName().endsWith("C_Human")) {
                        try {
                            oos = new ObjectOutputStream(baos);
                            oos.writeObject(playerArray[playerCount]);
                            oos.close();
                            oos = null;
                            if (this.parameter.getPrint_player_mem() == 1) {
                                System.out.println("startGameCheck: Player " + playerCount + " needed kB: " + baos.size() / 1024);
                            }
                            if ((long)baos.size() > this.parameter.getMax_player_mem() << 10) {
                                System.out.println("WARNING: startGameCheck: Player " + playerCount + " needed too much space and will not start the game!!\n");
                                infoArray[playerCount].snakeStatus = 3;
                                playerArray[playerCount] = null;
                            }
                            baos.reset();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (OutOfMemoryError e) {
                            System.out.println("WARNING: Player " + i + " cursed a OutOfMemoryError!!! chack your constructor!!\n" + e);
                            infoArray[playerCount].snakeStatus = 3;
                            playerArray[playerCount] = null;
                            System.gc();
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e2) {
                                System.out.println("WARNING: Error whyle sleeping!" + e2);
                            }
                        }
                    }
                }
                playerArray[playerCount].setMonitor(M_Main.getInstance().getMonitor());
                infoArray[playerCount].name = playerArray[playerCount].getName();
                ++playerCount;
            }
            ++i;
        }
        this.playerData = new D_PlayerData[playerCount];
        this.playerInstances = new Player[playerCount];
        i = 0;
        while (i < playerCount) {
            this.playerInstances[i] = playerArray[i];
            this.playerData[i] = infoArray[i];
            ++i;
        }
        this.humanInstances = new C_Human[humanCount];
        i = 0;
        while (i < humanCount) {
            this.humanInstances[i] = humanArray[i];
            ++i;
        }
        initData.playerData = this.playerData;
        this.world = new C_World(initData, this.parameter);
        this.playerHandler.initGame(this.playerInstances);
        time += System.currentTimeMillis();
        time = -System.currentTimeMillis();
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            System.out.println("WARNING: Error whyle sleeping!" + e);
        }
        time += System.currentTimeMillis();
        this.generateGameInfo();
        this.gameInfo.gameRunning = true;
        M_Main.getInstance().update(this.gameInfo, this.humanInstances);
    }

    protected void recover(D_RecoverData recoverData) {
    }

    protected void store(D_RecoverData dataStorage) {
    }

    protected D_GameInfo getGameInfo() {
        return this.reGenerateGameInfo();
    }

    protected void imergencyPause() {
        this.playerHandler.imergencyPause();
        if (!this.imergencyPaused) {
            this.imergencyPaused = true;
            this.suspend();
        } else {
            this.imergencyPaused = false;
            this.resume();
        }
    }

    protected void kill() {
        this.playerHandler.kill();
        this.stop();
    }

    protected static M_GameEngine getInstance() {
        if (instance == null) {
            instance = new M_GameEngine();
        }
        return instance;
    }

    protected static void destroyInstance(M_GameEngine engine) {
        engine.gameInfo = null;
        engine.humanInstances = null;
        engine.imergencyPaused = false;
        engine.playerData = null;
        M_PlayerHandler.destroyInstance(engine.playerHandler);
        engine.playerHandler = null;
        engine.playerInstances = null;
        engine.world = null;
        instance = null;
    }
}

